this["wp"] = this["wp"] || {}; this["wp"]["blockEditor"] =
/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "tr0p");
/******/ })
/************************************************************************/
/******/ ({

/***/ "+0ps":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "c", function() { return /* binding */ useNotifyCopy; });
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ useClipboardHandler; });

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external ["wp","blocks"]
var external_wp_blocks_ = __webpack_require__("HSyU");

// EXTERNAL MODULE: external ["wp","dom"]
var external_wp_dom_ = __webpack_require__("1CF3");

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: external ["wp","notices"]
var external_wp_notices_ = __webpack_require__("onLe");

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: external ["wp","blob"]
var external_wp_blob_ = __webpack_require__("xTGt");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/get-paste-event-data.js
/**
 * WordPress dependencies
 */


function getPasteEventData(_ref) {
  let {
    clipboardData
  } = _ref;
  let plainText = '';
  let html = ''; // IE11 only supports `Text` as an argument for `getData` and will
  // otherwise throw an invalid argument error, so we try the standard
  // arguments first, then fallback to `Text` if they fail.

  try {
    plainText = clipboardData.getData('text/plain');
    html = clipboardData.getData('text/html');
  } catch (error1) {
    try {
      html = clipboardData.getData('Text');
    } catch (error2) {
      // Some browsers like UC Browser paste plain text by default and
      // don't support clipboardData at all, so allow default
      // behaviour.
      return;
    }
  }

  const files = Object(external_wp_dom_["getFilesFromDataTransfer"])(clipboardData).filter(_ref2 => {
    let {
      type
    } = _ref2;
    return /^image\/(?:jpe?g|png|gif)$/.test(type);
  }); // Only process files if no HTML is present.
  // A pasted file may have the URL as plain text.

  if (files.length && !html) {
    html = files.map(file => `<img src="${Object(external_wp_blob_["createBlobURL"])(file)}">`).join('');
    plainText = '';
  }

  return {
    html,
    plainText
  };
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js + 4 modules
var store = __webpack_require__("BhPs");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/copy-handler/index.js


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */



function useNotifyCopy() {
  const {
    getBlockName
  } = Object(external_wp_data_["useSelect"])(store["a" /* store */]);
  const {
    getBlockType
  } = Object(external_wp_data_["useSelect"])(external_wp_blocks_["store"]);
  const {
    createSuccessNotice
  } = Object(external_wp_data_["useDispatch"])(external_wp_notices_["store"]);
  return Object(external_wp_element_["useCallback"])((eventType, selectedBlockClientIds) => {
    let notice = '';

    if (selectedBlockClientIds.length === 1) {
      var _getBlockType;

      const clientId = selectedBlockClientIds[0];
      const title = (_getBlockType = getBlockType(getBlockName(clientId))) === null || _getBlockType === void 0 ? void 0 : _getBlockType.title;
      notice = eventType === 'copy' ? Object(external_wp_i18n_["sprintf"])( // Translators: Name of the block being copied, e.g. "Paragraph".
      Object(external_wp_i18n_["__"])('Copied "%s" to clipboard.'), title) : Object(external_wp_i18n_["sprintf"])( // Translators: Name of the block being cut, e.g. "Paragraph".
      Object(external_wp_i18n_["__"])('Moved "%s" to clipboard.'), title);
    } else {
      notice = eventType === 'copy' ? Object(external_wp_i18n_["sprintf"])( // Translators: %d: Number of blocks being copied.
      Object(external_wp_i18n_["_n"])('Copied %d block to clipboard.', 'Copied %d blocks to clipboard.', selectedBlockClientIds.length), selectedBlockClientIds.length) : Object(external_wp_i18n_["sprintf"])( // Translators: %d: Number of blocks being cut.
      Object(external_wp_i18n_["_n"])('Moved %d block to clipboard.', 'Moved %d blocks to clipboard.', selectedBlockClientIds.length), selectedBlockClientIds.length);
    }

    createSuccessNotice(notice, {
      type: 'snackbar'
    });
  }, []);
}
function useClipboardHandler() {
  const {
    getBlocksByClientId,
    getSelectedBlockClientIds,
    hasMultiSelection,
    getSettings
  } = Object(external_wp_data_["useSelect"])(store["a" /* store */]);
  const {
    flashBlock,
    removeBlocks,
    replaceBlocks
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const notifyCopy = useNotifyCopy();
  return Object(external_wp_compose_["useRefEffect"])(node => {
    function handler(event) {
      const selectedBlockClientIds = getSelectedBlockClientIds();

      if (selectedBlockClientIds.length === 0) {
        return;
      } // Always handle multiple selected blocks.


      if (!hasMultiSelection()) {
        const {
          target
        } = event;
        const {
          ownerDocument
        } = target; // If copying, only consider actual text selection as selection.
        // Otherwise, any focus on an input field is considered.

        const hasSelection = event.type === 'copy' || event.type === 'cut' ? Object(external_wp_dom_["documentHasUncollapsedSelection"])(ownerDocument) : Object(external_wp_dom_["documentHasSelection"])(ownerDocument); // Let native copy behaviour take over in input fields.

        if (hasSelection) {
          return;
        }
      }

      if (!node.contains(event.target.ownerDocument.activeElement)) {
        return;
      }

      const eventDefaultPrevented = event.defaultPrevented;
      event.preventDefault();

      if (event.type === 'copy' || event.type === 'cut') {
        if (selectedBlockClientIds.length === 1) {
          flashBlock(selectedBlockClientIds[0]);
        }

        notifyCopy(event.type, selectedBlockClientIds);
        const blocks = getBlocksByClientId(selectedBlockClientIds);
        const serialized = Object(external_wp_blocks_["serialize"])(blocks);
        event.clipboardData.setData('text/plain', serialized);
        event.clipboardData.setData('text/html', serialized);
      }

      if (event.type === 'cut') {
        removeBlocks(selectedBlockClientIds);
      } else if (event.type === 'paste') {
        if (eventDefaultPrevented) {
          // This was likely already handled in rich-text/use-paste-handler.js
          return;
        }

        const {
          __experimentalCanUserUseUnfilteredHTML: canUserUseUnfilteredHTML
        } = getSettings();
        const {
          plainText,
          html
        } = getPasteEventData(event);
        const blocks = Object(external_wp_blocks_["pasteHandler"])({
          HTML: html,
          plainText,
          mode: 'BLOCKS',
          canUserUseUnfilteredHTML
        });
        replaceBlocks(selectedBlockClientIds, blocks, blocks.length - 1, -1);
      }
    }

    node.ownerDocument.addEventListener('copy', handler);
    node.ownerDocument.addEventListener('cut', handler);
    node.ownerDocument.addEventListener('paste', handler);
    return () => {
      node.ownerDocument.removeEventListener('copy', handler);
      node.ownerDocument.removeEventListener('cut', handler);
      node.ownerDocument.removeEventListener('paste', handler);
    };
  }, []);
}

function CopyHandler(_ref) {
  let {
    children
  } = _ref;
  return Object(external_wp_element_["createElement"])("div", {
    ref: useClipboardHandler()
  }, children);
}

/* harmony default export */ var copy_handler = __webpack_exports__["a"] = (CopyHandler);


/***/ }),

/***/ "+6d5":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useBlockMovingModeClassNames; });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("TSYQ");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("BhPs");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Returns the class names used for block moving mode.
 *
 * @param {string} clientId The block client ID to insert above.
 *
 * @return {string} The class names.
 */

function useBlockMovingModeClassNames(clientId) {
  return Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["useSelect"])(select => {
    const {
      hasBlockMovingClientId,
      canInsertBlockType,
      getBlockName,
      getBlockRootClientId,
      isBlockSelected
    } = select(_store__WEBPACK_IMPORTED_MODULE_2__[/* store */ "a"]); // The classes are only relevant for the selected block. Avoid
    // re-rendering all blocks!

    if (!isBlockSelected(clientId)) {
      return;
    }

    const movingClientId = hasBlockMovingClientId();

    if (!movingClientId) {
      return;
    }

    return classnames__WEBPACK_IMPORTED_MODULE_0___default()('is-block-moving-mode', {
      'can-insert-moving-block': canInsertBlockType(getBlockName(movingClientId), getBlockRootClientId(clientId))
    });
  }, [clientId]);
}


/***/ }),

/***/ "+DUQ":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export a */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "animated", function() { return animated; });
/* harmony import */ var _react_spring_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("kmrn");
/* harmony reexport (checked) */ if(__webpack_require__.o(_react_spring_core__WEBPACK_IMPORTED_MODULE_0__, "useSpring")) __webpack_require__.d(__webpack_exports__, "useSpring", function() { return _react_spring_core__WEBPACK_IMPORTED_MODULE_0__["useSpring"]; });

/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("faye");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _react_spring_shared__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("nEW0");
/* harmony import */ var _react_spring_animated__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("dfZa");






function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

const _excluded$2 = ["style", "children", "scrollTop", "scrollLeft"];
const isCustomPropRE = /^--/;

function dangerousStyleValue(name, value) {
  if (value == null || typeof value === 'boolean' || value === '') return '';
  if (typeof value === 'number' && value !== 0 && !isCustomPropRE.test(name) && !(isUnitlessNumber.hasOwnProperty(name) && isUnitlessNumber[name])) return value + 'px';
  return ('' + value).trim();
}

const attributeCache = {};
function applyAnimatedValues(instance, props) {
  if (!instance.nodeType || !instance.setAttribute) {
    return false;
  }

  const isFilterElement = instance.nodeName === 'filter' || instance.parentNode && instance.parentNode.nodeName === 'filter';

  const _ref = props,
        {
    style,
    children,
    scrollTop,
    scrollLeft
  } = _ref,
        attributes = _objectWithoutPropertiesLoose(_ref, _excluded$2);

  const values = Object.values(attributes);
  const names = Object.keys(attributes).map(name => isFilterElement || instance.hasAttribute(name) ? name : attributeCache[name] || (attributeCache[name] = name.replace(/([A-Z])/g, n => '-' + n.toLowerCase())));

  if (children !== void 0) {
    instance.textContent = children;
  }

  for (let name in style) {
    if (style.hasOwnProperty(name)) {
      const value = dangerousStyleValue(name, style[name]);

      if (isCustomPropRE.test(name)) {
        instance.style.setProperty(name, value);
      } else {
        instance.style[name] = value;
      }
    }
  }

  names.forEach((name, i) => {
    instance.setAttribute(name, values[i]);
  });

  if (scrollTop !== void 0) {
    instance.scrollTop = scrollTop;
  }

  if (scrollLeft !== void 0) {
    instance.scrollLeft = scrollLeft;
  }
}
let isUnitlessNumber = {
  animationIterationCount: true,
  borderImageOutset: true,
  borderImageSlice: true,
  borderImageWidth: true,
  boxFlex: true,
  boxFlexGroup: true,
  boxOrdinalGroup: true,
  columnCount: true,
  columns: true,
  flex: true,
  flexGrow: true,
  flexPositive: true,
  flexShrink: true,
  flexNegative: true,
  flexOrder: true,
  gridRow: true,
  gridRowEnd: true,
  gridRowSpan: true,
  gridRowStart: true,
  gridColumn: true,
  gridColumnEnd: true,
  gridColumnSpan: true,
  gridColumnStart: true,
  fontWeight: true,
  lineClamp: true,
  lineHeight: true,
  opacity: true,
  order: true,
  orphans: true,
  tabSize: true,
  widows: true,
  zIndex: true,
  zoom: true,
  fillOpacity: true,
  floodOpacity: true,
  stopOpacity: true,
  strokeDasharray: true,
  strokeDashoffset: true,
  strokeMiterlimit: true,
  strokeOpacity: true,
  strokeWidth: true
};

const prefixKey = (prefix, key) => prefix + key.charAt(0).toUpperCase() + key.substring(1);

const prefixes = ['Webkit', 'Ms', 'Moz', 'O'];
isUnitlessNumber = Object.keys(isUnitlessNumber).reduce((acc, prop) => {
  prefixes.forEach(prefix => acc[prefixKey(prefix, prop)] = acc[prop]);
  return acc;
}, isUnitlessNumber);

const _excluded$1 = ["x", "y", "z"];
const domTransforms = /^(matrix|translate|scale|rotate|skew)/;
const pxTransforms = /^(translate)/;
const degTransforms = /^(rotate|skew)/;

const addUnit = (value, unit) => _react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* is */ "s"].num(value) && value !== 0 ? value + unit : value;

const isValueIdentity = (value, id) => _react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* is */ "s"].arr(value) ? value.every(v => isValueIdentity(v, id)) : _react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* is */ "s"].num(value) ? value === id : parseFloat(value) === id;

class AnimatedStyle extends _react_spring_animated__WEBPACK_IMPORTED_MODULE_3__[/* AnimatedObject */ "a"] {
  constructor(_ref) {
    let {
      x,
      y,
      z
    } = _ref,
        style = _objectWithoutPropertiesLoose(_ref, _excluded$1);

    const inputs = [];
    const transforms = [];

    if (x || y || z) {
      inputs.push([x || 0, y || 0, z || 0]);
      transforms.push(xyz => [`translate3d(${xyz.map(v => addUnit(v, 'px')).join(',')})`, isValueIdentity(xyz, 0)]);
    }

    Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* eachProp */ "l"])(style, (value, key) => {
      if (key === 'transform') {
        inputs.push([value || '']);
        transforms.push(transform => [transform, transform === '']);
      } else if (domTransforms.test(key)) {
        delete style[key];
        if (_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* is */ "s"].und(value)) return;
        const unit = pxTransforms.test(key) ? 'px' : degTransforms.test(key) ? 'deg' : '';
        inputs.push(Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* toArray */ "y"])(value));
        transforms.push(key === 'rotate3d' ? ([x, y, z, deg]) => [`rotate3d(${x},${y},${z},${addUnit(deg, unit)})`, isValueIdentity(deg, 0)] : input => [`${key}(${input.map(v => addUnit(v, unit)).join(',')})`, isValueIdentity(input, key.startsWith('scale') ? 1 : 0)]);
      }
    });

    if (inputs.length) {
      style.transform = new FluidTransform(inputs, transforms);
    }

    super(style);
  }

}

class FluidTransform extends _react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* FluidValue */ "a"] {
  constructor(inputs, transforms) {
    super();
    this._value = null;
    this.inputs = inputs;
    this.transforms = transforms;
  }

  get() {
    return this._value || (this._value = this._get());
  }

  _get() {
    let transform = '';
    let identity = true;
    Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* each */ "k"])(this.inputs, (input, i) => {
      const arg1 = Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* getFluidValue */ "q"])(input[0]);
      const [t, id] = this.transforms[i](_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* is */ "s"].arr(arg1) ? arg1 : input.map(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* getFluidValue */ "q"]));
      transform += ' ' + t;
      identity = identity && id;
    });
    return identity ? 'none' : transform;
  }

  observerAdded(count) {
    if (count == 1) Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* each */ "k"])(this.inputs, input => Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* each */ "k"])(input, value => Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* hasFluidValue */ "r"])(value) && Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* addFluidObserver */ "c"])(value, this)));
  }

  observerRemoved(count) {
    if (count == 0) Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* each */ "k"])(this.inputs, input => Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* each */ "k"])(input, value => Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* hasFluidValue */ "r"])(value) && Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* removeFluidObserver */ "x"])(value, this)));
  }

  eventObserved(event) {
    if (event.type == 'change') {
      this._value = null;
    }

    Object(_react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* callFluidObservers */ "d"])(this, event);
  }

}

const primitives = ['a', 'abbr', 'address', 'area', 'article', 'aside', 'audio', 'b', 'base', 'bdi', 'bdo', 'big', 'blockquote', 'body', 'br', 'button', 'canvas', 'caption', 'cite', 'code', 'col', 'colgroup', 'data', 'datalist', 'dd', 'del', 'details', 'dfn', 'dialog', 'div', 'dl', 'dt', 'em', 'embed', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'head', 'header', 'hgroup', 'hr', 'html', 'i', 'iframe', 'img', 'input', 'ins', 'kbd', 'keygen', 'label', 'legend', 'li', 'link', 'main', 'map', 'mark', 'menu', 'menuitem', 'meta', 'meter', 'nav', 'noscript', 'object', 'ol', 'optgroup', 'option', 'output', 'p', 'param', 'picture', 'pre', 'progress', 'q', 'rp', 'rt', 'ruby', 's', 'samp', 'script', 'section', 'select', 'small', 'source', 'span', 'strong', 'style', 'sub', 'summary', 'sup', 'table', 'tbody', 'td', 'textarea', 'tfoot', 'th', 'thead', 'time', 'title', 'tr', 'track', 'u', 'ul', 'var', 'video', 'wbr', 'circle', 'clipPath', 'defs', 'ellipse', 'foreignObject', 'g', 'image', 'line', 'linearGradient', 'mask', 'path', 'pattern', 'polygon', 'polyline', 'radialGradient', 'rect', 'stop', 'svg', 'text', 'tspan'];

const _excluded = ["scrollTop", "scrollLeft"];
_react_spring_core__WEBPACK_IMPORTED_MODULE_0__["Globals"].assign({
  batchedUpdates: react_dom__WEBPACK_IMPORTED_MODULE_1__["unstable_batchedUpdates"],
  createStringInterpolator: _react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* createStringInterpolator */ "g"],
  colors: _react_spring_shared__WEBPACK_IMPORTED_MODULE_2__[/* colors */ "e"]
});
const host = Object(_react_spring_animated__WEBPACK_IMPORTED_MODULE_3__[/* createHost */ "d"])(primitives, {
  applyAnimatedValues,
  createAnimatedStyle: style => new AnimatedStyle(style),
  getComponentProps: _ref => {
    let props = _objectWithoutPropertiesLoose(_ref, _excluded);

    return props;
  }
});
const animated = host.animated;




/***/ }),

/***/ "+G0a":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("HSyU");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("BhPs");
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Retrieves the block types inserter state.
 *
 * @param {string=}  rootClientId Insertion's root client ID.
 * @param {Function} onInsert     function called when inserter a list of blocks.
 * @return {Array} Returns the block types state. (block types, categories, collections, onSelect handler)
 */

const useBlockTypesState = (rootClientId, onInsert) => {
  const {
    categories,
    collections,
    items
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["useSelect"])(select => {
    const {
      getInserterItems
    } = select(_store__WEBPACK_IMPORTED_MODULE_3__[/* store */ "a"]);
    const {
      getCategories,
      getCollections
    } = select(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__["store"]);
    return {
      categories: getCategories(),
      collections: getCollections(),
      items: getInserterItems(rootClientId)
    };
  }, [rootClientId]);
  const onSelectItem = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_2__["useCallback"])((_ref, shouldFocusBlock) => {
    let {
      name,
      initialAttributes,
      innerBlocks
    } = _ref;
    const insertedBlock = Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__["createBlock"])(name, initialAttributes, Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__["createBlocksFromInnerBlocksTemplate"])(innerBlocks));
    onInsert(insertedBlock, undefined, shouldFocusBlock);
  }, [onInsert]);
  return [items, categories, collections, onSelectItem];
};

/* harmony default export */ __webpack_exports__["a"] = (useBlockTypesState);


/***/ }),

/***/ "+WrK":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const symbol = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M21.3 10.8l-5.6-5.6c-.7-.7-1.8-.7-2.5 0l-5.6 5.6c-.7.7-.7 1.8 0 2.5l5.6 5.6c.3.3.8.5 1.2.5s.9-.2 1.2-.5l5.6-5.6c.8-.7.8-1.9.1-2.5zm-1 1.4l-5.6 5.6c-.1.1-.3.1-.4 0l-5.6-5.6c-.1-.1-.1-.3 0-.4l5.6-5.6s.1-.1.2-.1.1 0 .2.1l5.6 5.6c.1.1.1.3 0 .4zm-16.6-.4L10 5.5l-1-1-6.3 6.3c-.7.7-.7 1.8 0 2.5L9 19.5l1.1-1.1-6.3-6.3c-.2 0-.2-.2-.1-.3z"
}));
/* harmony default export */ __webpack_exports__["a"] = (symbol);


/***/ }),

/***/ "+gtr":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ BlockToolbar; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__("TSYQ");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: external ["wp","blocks"]
var external_wp_blocks_ = __webpack_require__("HSyU");

// EXTERNAL MODULE: external ["wp","components"]
var external_wp_components_ = __webpack_require__("tI+e");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-mover/index.js
var block_mover = __webpack_require__("JygI");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-block-display-information/index.js
var use_block_display_information = __webpack_require__("wC17");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-icon/index.js
var block_icon = __webpack_require__("7SSY");

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-toolbar/utils.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


const {
  clearTimeout: utils_clearTimeout,
  setTimeout: utils_setTimeout
} = window;
const DEBOUNCE_TIMEOUT = 200;
/**
 * Hook that creates a showMover state, as well as debounced show/hide callbacks.
 *
 * @param {Object}   props                       Component props.
 * @param {Object}   props.ref                   Element reference.
 * @param {boolean}  props.isFocused             Whether the component has current focus.
 * @param {number}   [props.debounceTimeout=250] Debounce timeout in milliseconds.
 * @param {Function} [props.onChange=noop]       Callback function.
 */

function useDebouncedShowMovers(_ref) {
  let {
    ref,
    isFocused,
    debounceTimeout = DEBOUNCE_TIMEOUT,
    onChange = external_lodash_["noop"]
  } = _ref;
  const [showMovers, setShowMovers] = Object(external_wp_element_["useState"])(false);
  const timeoutRef = Object(external_wp_element_["useRef"])();

  const handleOnChange = nextIsFocused => {
    if (ref !== null && ref !== void 0 && ref.current) {
      setShowMovers(nextIsFocused);
    }

    onChange(nextIsFocused);
  };

  const getIsHovered = () => {
    return (ref === null || ref === void 0 ? void 0 : ref.current) && ref.current.matches(':hover');
  };

  const shouldHideMovers = () => {
    const isHovered = getIsHovered();
    return !isFocused && !isHovered;
  };

  const clearTimeoutRef = () => {
    const timeout = timeoutRef.current;

    if (timeout && utils_clearTimeout) {
      utils_clearTimeout(timeout);
    }
  };

  const debouncedShowMovers = event => {
    if (event) {
      event.stopPropagation();
    }

    clearTimeoutRef();

    if (!showMovers) {
      handleOnChange(true);
    }
  };

  const debouncedHideMovers = event => {
    if (event) {
      event.stopPropagation();
    }

    clearTimeoutRef();
    timeoutRef.current = utils_setTimeout(() => {
      if (shouldHideMovers()) {
        handleOnChange(false);
      }
    }, debounceTimeout);
  };

  Object(external_wp_element_["useEffect"])(() => () => clearTimeoutRef(), []);
  return {
    showMovers,
    debouncedShowMovers,
    debouncedHideMovers
  };
}
/**
 * Hook that provides a showMovers state and gesture events for DOM elements
 * that interact with the showMovers state.
 *
 * @param {Object}   props                       Component props.
 * @param {Object}   props.ref                   Element reference.
 * @param {number}   [props.debounceTimeout=250] Debounce timeout in milliseconds.
 * @param {Function} [props.onChange=noop]       Callback function.
 */

function useShowMoversGestures(_ref2) {
  let {
    ref,
    debounceTimeout = DEBOUNCE_TIMEOUT,
    onChange = external_lodash_["noop"]
  } = _ref2;
  const [isFocused, setIsFocused] = Object(external_wp_element_["useState"])(false);
  const {
    showMovers,
    debouncedShowMovers,
    debouncedHideMovers
  } = useDebouncedShowMovers({
    ref,
    debounceTimeout,
    isFocused,
    onChange
  });
  const registerRef = Object(external_wp_element_["useRef"])(false);

  const isFocusedWithin = () => {
    return (ref === null || ref === void 0 ? void 0 : ref.current) && ref.current.contains(ref.current.ownerDocument.activeElement);
  };

  Object(external_wp_element_["useEffect"])(() => {
    const node = ref.current;

    const handleOnFocus = () => {
      if (isFocusedWithin()) {
        setIsFocused(true);
        debouncedShowMovers();
      }
    };

    const handleOnBlur = () => {
      if (!isFocusedWithin()) {
        setIsFocused(false);
        debouncedHideMovers();
      }
    };
    /**
     * Events are added via DOM events (vs. React synthetic events),
     * as the child React components swallow mouse events.
     */


    if (node && !registerRef.current) {
      node.addEventListener('focus', handleOnFocus, true);
      node.addEventListener('blur', handleOnBlur, true);
      registerRef.current = true;
    }

    return () => {
      if (node) {
        node.removeEventListener('focus', handleOnFocus);
        node.removeEventListener('blur', handleOnBlur);
      }
    };
  }, [ref, registerRef, setIsFocused, debouncedShowMovers, debouncedHideMovers]);
  return {
    showMovers,
    gestures: {
      onMouseMove: debouncedShowMovers,
      onMouseLeave: debouncedHideMovers
    }
  };
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js + 4 modules
var store = __webpack_require__("BhPs");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-parent-selector/index.js



/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */





/**
 * Block parent selector component, displaying the hierarchy of the
 * current block selection as a single icon to "go up" a level.
 *
 * @return {WPComponent} Parent block selector.
 */

function BlockParentSelector() {
  const {
    selectBlock,
    toggleBlockHighlight
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const {
    firstParentClientId,
    shouldHide,
    hasReducedUI
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      getBlockName,
      getBlockParents,
      getSelectedBlockClientId,
      getSettings
    } = select(store["a" /* store */]);
    const {
      hasBlockSupport
    } = select(external_wp_blocks_["store"]);
    const selectedBlockClientId = getSelectedBlockClientId();
    const parents = getBlockParents(selectedBlockClientId);
    const _firstParentClientId = parents[parents.length - 1];
    const parentBlockName = getBlockName(_firstParentClientId);

    const _parentBlockType = Object(external_wp_blocks_["getBlockType"])(parentBlockName);

    const settings = getSettings();
    return {
      firstParentClientId: _firstParentClientId,
      shouldHide: !hasBlockSupport(_parentBlockType, '__experimentalParentSelector', true),
      hasReducedUI: settings.hasReducedUI
    };
  }, []);
  const blockInformation = Object(use_block_display_information["a" /* default */])(firstParentClientId); // Allows highlighting the parent block outline when focusing or hovering
  // the parent block selector within the child.

  const nodeRef = Object(external_wp_element_["useRef"])();
  const {
    gestures: showMoversGestures
  } = useShowMoversGestures({
    ref: nodeRef,

    onChange(isFocused) {
      if (isFocused && hasReducedUI) {
        return;
      }

      toggleBlockHighlight(firstParentClientId, isFocused);
    }

  });

  if (shouldHide || firstParentClientId === undefined) {
    return null;
  }

  return Object(external_wp_element_["createElement"])("div", Object(esm_extends["a" /* default */])({
    className: "block-editor-block-parent-selector",
    key: firstParentClientId,
    ref: nodeRef
  }, showMoversGestures), Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
    className: "block-editor-block-parent-selector__button",
    onClick: () => selectBlock(firstParentClientId),
    label: Object(external_wp_i18n_["sprintf"])(
    /* translators: %s: Name of the block's parent. */
    Object(external_wp_i18n_["__"])('Select %s'), blockInformation.title),
    showTooltip: true,
    icon: Object(external_wp_element_["createElement"])(block_icon["a" /* default */], {
      icon: blockInformation.icon
    })
  }));
}

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/stack.js
var stack = __webpack_require__("wzfx");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-title/index.js
var block_title = __webpack_require__("f8JO");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-preview/index.js + 2 modules
var block_preview = __webpack_require__("REKd");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-switcher/preview-block-popover.js


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function PreviewBlockPopover(_ref) {
  let {
    blocks
  } = _ref;
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-switcher__popover__preview__parent"
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-switcher__popover__preview__container"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Popover"], {
    className: "block-editor-block-switcher__preview__popover",
    position: "bottom right",
    focusOnMount: false
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-switcher__preview"
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-switcher__preview-title"
  }, Object(external_wp_i18n_["__"])('Preview')), Object(external_wp_element_["createElement"])(block_preview["a" /* default */], {
    viewportWidth: 500,
    blocks: blocks
  })))));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-switcher/block-transformations-menu.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




const BlockTransformationsMenu = _ref => {
  let {
    className,
    possibleBlockTransformations,
    onSelect,
    blocks
  } = _ref;
  const [hoveredTransformItemName, setHoveredTransformItemName] = Object(external_wp_element_["useState"])();
  return Object(external_wp_element_["createElement"])(external_wp_components_["MenuGroup"], {
    label: Object(external_wp_i18n_["__"])('Transform to'),
    className: className
  }, hoveredTransformItemName && Object(external_wp_element_["createElement"])(PreviewBlockPopover, {
    blocks: Object(external_wp_blocks_["switchToBlockType"])(blocks, hoveredTransformItemName)
  }), possibleBlockTransformations.map(item => {
    const {
      name,
      icon,
      title,
      isDisabled
    } = item;
    return Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
      key: name,
      className: Object(external_wp_blocks_["getBlockMenuDefaultClassName"])(name),
      onClick: event => {
        event.preventDefault();
        onSelect(name);
      },
      disabled: isDisabled,
      onMouseLeave: () => setHoveredTransformItemName(null),
      onMouseEnter: () => setHoveredTransformItemName(name)
    }, Object(external_wp_element_["createElement"])(block_icon["a" /* default */], {
      icon: icon,
      showColors: true
    }), title);
  }));
};

/* harmony default export */ var block_transformations_menu = (BlockTransformationsMenu);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-styles/index.js + 1 modules
var block_styles = __webpack_require__("7NR9");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-switcher/block-styles-menu.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



function BlockStylesMenu(_ref) {
  let {
    hoveredBlock,
    onSwitch
  } = _ref;
  const {
    name,
    clientId
  } = hoveredBlock;
  const [hoveredClassName, setHoveredClassName] = Object(external_wp_element_["useState"])();
  const blockType = Object(external_wp_data_["useSelect"])(select => select(external_wp_blocks_["store"]).getBlockType(name), [name]);
  return Object(external_wp_element_["createElement"])(external_wp_components_["MenuGroup"], {
    label: Object(external_wp_i18n_["__"])('Styles'),
    className: "block-editor-block-switcher__styles__menugroup"
  }, hoveredClassName && Object(external_wp_element_["createElement"])(PreviewBlockPopover, {
    blocks: blockType && blockType.example ? Object(external_wp_blocks_["getBlockFromExample"])(blockType.name, {
      attributes: { ...blockType.example.attributes,
        className: hoveredClassName
      },
      innerBlocks: blockType.example.innerBlocks
    }) : Object(external_wp_blocks_["cloneBlock"])(hoveredBlock, {
      className: hoveredClassName
    })
  }), Object(external_wp_element_["createElement"])(block_styles["a" /* default */], {
    clientId: clientId,
    onSwitch: onSwitch,
    onHoverClassName: setHoveredClassName,
    itemRole: "menuitem"
  }));
}

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-right.js
var chevron_right = __webpack_require__("1iEr");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-switcher/utils.js
/**
 * WordPress dependencies
 */

/**
 * Try to find a matching block by a block's name in a provided
 * block. We recurse through InnerBlocks and return the reference
 * of the matched block (it could be an InnerBlock).
 * If no match is found return nothing.
 *
 * @param {WPBlock} block             The block to try to find a match.
 * @param {string}  selectedBlockName The block's name to use for matching condition.
 * @param {Set}     consumedBlocks    A set holding the previously matched/consumed blocks.
 *
 * @return {WPBlock?} The matched block if found or nothing(`undefined`).
 */

const getMatchingBlockByName = function (block, selectedBlockName) {
  let consumedBlocks = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new Set();
  const {
    clientId,
    name,
    innerBlocks = []
  } = block; // Check if block has been consumed already.

  if (consumedBlocks.has(clientId)) return;
  if (name === selectedBlockName) return block; // Try to find a matching block from InnerBlocks recursively.

  for (const innerBlock of innerBlocks) {
    const match = getMatchingBlockByName(innerBlock, selectedBlockName, consumedBlocks);
    if (match) return match;
  }
};
/**
 * Find and return the block attributes to retain through
 * the transformation, based on Block Type's `role:content`
 * attributes. If no `role:content` attributes exist,
 * return selected block's attributes.
 *
 * @param {string} name       Block type's namespaced name.
 * @param {Object} attributes Selected block's attributes.
 * @return {Object} The block's attributes to retain.
 */

const getRetainedBlockAttributes = (name, attributes) => {
  const contentAttributes = Object(external_wp_blocks_["__experimentalGetBlockAttributesNamesByRole"])(name, 'content');
  if (!(contentAttributes !== null && contentAttributes !== void 0 && contentAttributes.length)) return attributes;
  return contentAttributes.reduce((_accumulator, attribute) => {
    if (attributes[attribute]) _accumulator[attribute] = attributes[attribute];
    return _accumulator;
  }, {});
};

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-switcher/use-transformed-patterns.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Mutate the matched block's attributes by getting
 * which block type's attributes to retain and prioritize
 * them in the merging of the attributes.
 *
 * @param {WPBlock} match         The matched block.
 * @param {WPBlock} selectedBlock The selected block.
 * @return {void}
 */

const transformMatchingBlock = (match, selectedBlock) => {
  // Get the block attributes to retain through the transformation.
  const retainedBlockAttributes = getRetainedBlockAttributes(selectedBlock.name, selectedBlock.attributes);
  match.attributes = { ...match.attributes,
    ...retainedBlockAttributes
  };
};
/**
 * By providing the selected blocks and pattern's blocks
 * find the matching blocks, transform them and return them.
 * If not all selected blocks are matched, return nothing.
 *
 * @param {WPBlock[]} selectedBlocks The selected blocks.
 * @param {WPBlock[]} patternBlocks  The pattern's blocks.
 * @return {WPBlock[]|void} The transformed pattern's blocks or undefined if not all selected blocks have been matched.
 */

const getPatternTransformedBlocks = (selectedBlocks, patternBlocks) => {
  // Clone Pattern's blocks to produce new clientIds and be able to mutate the matches.
  const _patternBlocks = patternBlocks.map(block => Object(external_wp_blocks_["cloneBlock"])(block));
  /**
   * Keep track of the consumed pattern blocks.
   * This is needed because we loop the selected blocks
   * and for example we may have selected two paragraphs and
   * the pattern's blocks could have more `paragraphs`.
   */


  const consumedBlocks = new Set();

  for (const selectedBlock of selectedBlocks) {
    let isMatch = false;

    for (const patternBlock of _patternBlocks) {
      const match = getMatchingBlockByName(patternBlock, selectedBlock.name, consumedBlocks);
      if (!match) continue;
      isMatch = true;
      consumedBlocks.add(match.clientId); // We update (mutate) the matching pattern block.

      transformMatchingBlock(match, selectedBlock); // No need to loop through other pattern's blocks.

      break;
    } // Bail eary if a selected block has not been matched.


    if (!isMatch) return;
  }

  return _patternBlocks;
};
/**
 * @typedef {WPBlockPattern & {transformedBlocks: WPBlock[]}} TransformedBlockPattern
 */

/**
 * Custom hook that accepts patterns from state and the selected
 * blocks and tries to match these with the pattern's blocks.
 * If all selected blocks are matched with a Pattern's block,
 * we transform them by retaining block's attributes with `role:content`.
 * The transformed pattern's blocks are set to a new pattern
 * property `transformedBlocks`.
 *
 * @param {WPBlockPattern[]} patterns       Patterns from state.
 * @param {WPBlock[]}        selectedBlocks The currently selected blocks.
 * @return {TransformedBlockPattern[]} Returns the eligible matched patterns with all the selected blocks.
 */
// TODO tests

const useTransformedPatterns = (patterns, selectedBlocks) => {
  return Object(external_wp_element_["useMemo"])(() => patterns.reduce((accumulator, _pattern) => {
    const transformedBlocks = getPatternTransformedBlocks(selectedBlocks, _pattern.blocks);

    if (transformedBlocks) {
      accumulator.push({ ..._pattern,
        transformedBlocks
      });
    }

    return accumulator;
  }, []), [patterns, selectedBlocks]);
};

/* harmony default export */ var use_transformed_patterns = (useTransformedPatterns);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-switcher/pattern-transformations-menu.js



/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




function PatternTransformationsMenu(_ref) {
  let {
    blocks,
    patterns: statePatterns,
    onSelect
  } = _ref;
  const [showTransforms, setShowTransforms] = Object(external_wp_element_["useState"])(false);
  const patterns = use_transformed_patterns(statePatterns, blocks);
  if (!patterns.length) return null;
  return Object(external_wp_element_["createElement"])(external_wp_components_["MenuGroup"], {
    className: "block-editor-block-switcher__pattern__transforms__menugroup"
  }, showTransforms && Object(external_wp_element_["createElement"])(PreviewPatternsPopover, {
    patterns: patterns,
    onSelect: onSelect
  }), Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
    onClick: event => {
      event.preventDefault();
      setShowTransforms(!showTransforms);
    },
    icon: chevron_right["a" /* default */]
  }, Object(external_wp_i18n_["__"])('Patterns')));
}

function PreviewPatternsPopover(_ref2) {
  let {
    patterns,
    onSelect
  } = _ref2;
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-switcher__popover__preview__parent"
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-switcher__popover__preview__container"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Popover"], {
    className: "block-editor-block-switcher__preview__popover",
    position: "bottom right"
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-switcher__preview"
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-switcher__preview-title"
  }, Object(external_wp_i18n_["__"])('Preview')), Object(external_wp_element_["createElement"])(BlockPatternsList, {
    patterns: patterns,
    onSelect: onSelect
  })))));
}

function BlockPatternsList(_ref3) {
  let {
    patterns,
    onSelect
  } = _ref3;
  const composite = Object(external_wp_components_["__unstableUseCompositeState"])();
  return Object(external_wp_element_["createElement"])(external_wp_components_["__unstableComposite"], Object(esm_extends["a" /* default */])({}, composite, {
    role: "listbox",
    className: "block-editor-block-switcher__preview-patterns-container",
    "aria-label": Object(external_wp_i18n_["__"])('Patterns list')
  }), patterns.map(pattern => Object(external_wp_element_["createElement"])(BlockPattern, {
    key: pattern.name,
    pattern: pattern,
    onSelect: onSelect,
    composite: composite
  })));
}

function BlockPattern(_ref4) {
  let {
    pattern,
    onSelect,
    composite
  } = _ref4;
  // TODO check pattern/preview width...
  const baseClassName = 'block-editor-block-switcher__preview-patterns-container';
  const descriptionId = Object(external_wp_compose_["useInstanceId"])(BlockPattern, `${baseClassName}-list__item-description`);
  return Object(external_wp_element_["createElement"])("div", {
    className: `${baseClassName}-list__list-item`,
    "aria-label": pattern.title,
    "aria-describedby": pattern.description ? descriptionId : undefined
  }, Object(external_wp_element_["createElement"])(external_wp_components_["__unstableCompositeItem"], Object(esm_extends["a" /* default */])({
    role: "option",
    as: "div"
  }, composite, {
    className: `${baseClassName}-list__item`,
    onClick: () => onSelect(pattern.transformedBlocks)
  }), Object(external_wp_element_["createElement"])(block_preview["a" /* default */], {
    blocks: pattern.transformedBlocks,
    viewportWidth: pattern.viewportWidth || 500
  }), Object(external_wp_element_["createElement"])("div", {
    className: `${baseClassName}-list__item-title`
  }, pattern.title)), !!pattern.description && Object(external_wp_element_["createElement"])(external_wp_components_["VisuallyHidden"], {
    id: descriptionId
  }, pattern.description));
}

/* harmony default export */ var pattern_transformations_menu = (PatternTransformationsMenu);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-switcher/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */








const BlockSwitcherDropdownMenu = _ref => {
  let {
    clientIds,
    blocks
  } = _ref;
  const {
    replaceBlocks
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const blockInformation = Object(use_block_display_information["a" /* default */])(blocks[0].clientId);
  const {
    possibleBlockTransformations,
    canRemove,
    hasBlockStyles,
    icon,
    blockTitle,
    patterns
  } = Object(external_wp_data_["useSelect"])(select => {
    var _getBlockType2;

    const {
      getBlockRootClientId,
      getBlockTransformItems,
      __experimentalGetPatternTransformItems
    } = select(store["a" /* store */]);
    const {
      getBlockStyles,
      getBlockType
    } = select(external_wp_blocks_["store"]);
    const {
      canRemoveBlocks
    } = select(store["a" /* store */]);
    const rootClientId = getBlockRootClientId(Object(external_lodash_["castArray"])(clientIds)[0]);
    const [{
      name: firstBlockName
    }] = blocks;

    const _isSingleBlockSelected = blocks.length === 1;

    const styles = _isSingleBlockSelected && getBlockStyles(firstBlockName);

    let _icon;

    if (_isSingleBlockSelected) {
      _icon = blockInformation === null || blockInformation === void 0 ? void 0 : blockInformation.icon; // Take into account active block variations.
    } else {
      var _getBlockType;

      const isSelectionOfSameType = Object(external_lodash_["uniq"])(blocks.map(_ref2 => {
        let {
          name
        } = _ref2;
        return name;
      })).length === 1; // When selection consists of blocks of multiple types, display an
      // appropriate icon to communicate the non-uniformity.

      _icon = isSelectionOfSameType ? (_getBlockType = getBlockType(firstBlockName)) === null || _getBlockType === void 0 ? void 0 : _getBlockType.icon : stack["a" /* default */];
    }

    return {
      possibleBlockTransformations: getBlockTransformItems(blocks, rootClientId),
      canRemove: canRemoveBlocks(clientIds, rootClientId),
      hasBlockStyles: !!(styles !== null && styles !== void 0 && styles.length),
      icon: _icon,
      blockTitle: (_getBlockType2 = getBlockType(firstBlockName)) === null || _getBlockType2 === void 0 ? void 0 : _getBlockType2.title,
      patterns: __experimentalGetPatternTransformItems(blocks, rootClientId)
    };
  }, [clientIds, blocks, blockInformation === null || blockInformation === void 0 ? void 0 : blockInformation.icon]);
  const isReusable = blocks.length === 1 && Object(external_wp_blocks_["isReusableBlock"])(blocks[0]);
  const isTemplate = blocks.length === 1 && Object(external_wp_blocks_["isTemplatePart"])(blocks[0]); // Simple block tranformation based on the `Block Transforms` API.

  const onBlockTransform = name => replaceBlocks(clientIds, Object(external_wp_blocks_["switchToBlockType"])(blocks, name)); // Pattern transformation through the `Patterns` API.


  const onPatternTransform = transformedBlocks => replaceBlocks(clientIds, transformedBlocks);

  const hasPossibleBlockTransformations = !!possibleBlockTransformations.length && canRemove;
  const hasPatternTransformation = !!(patterns !== null && patterns !== void 0 && patterns.length) && canRemove;

  if (!hasBlockStyles && !hasPossibleBlockTransformations) {
    return Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarGroup"], null, Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
      disabled: true,
      className: "block-editor-block-switcher__no-switcher-icon",
      title: blockTitle,
      icon: Object(external_wp_element_["createElement"])(block_icon["a" /* default */], {
        icon: icon,
        showColors: true
      })
    }));
  }

  const blockSwitcherLabel = blockTitle;
  const blockSwitcherDescription = 1 === blocks.length ? Object(external_wp_i18n_["sprintf"])(
  /* translators: %s: block title. */
  Object(external_wp_i18n_["__"])('%s: Change block type or style'), blockTitle) : Object(external_wp_i18n_["sprintf"])(
  /* translators: %d: number of blocks. */
  Object(external_wp_i18n_["_n"])('Change type of %d block', 'Change type of %d blocks', blocks.length), blocks.length);
  const showDropDown = hasBlockStyles || hasPossibleBlockTransformations || hasPatternTransformation;
  return Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarGroup"], null, Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarItem"], null, toggleProps => Object(external_wp_element_["createElement"])(external_wp_components_["DropdownMenu"], {
    className: "block-editor-block-switcher",
    label: blockSwitcherLabel,
    popoverProps: {
      position: 'bottom right',
      isAlternate: true,
      className: 'block-editor-block-switcher__popover'
    },
    icon: Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(block_icon["a" /* default */], {
      icon: icon,
      className: "block-editor-block-switcher__toggle",
      showColors: true
    }), (isReusable || isTemplate) && Object(external_wp_element_["createElement"])("span", {
      className: "block-editor-block-switcher__toggle-text"
    }, Object(external_wp_element_["createElement"])(block_title["a" /* default */], {
      clientId: clientIds
    }))),
    toggleProps: {
      describedBy: blockSwitcherDescription,
      ...toggleProps
    },
    menuProps: {
      orientation: 'both'
    }
  }, _ref3 => {
    let {
      onClose
    } = _ref3;
    return showDropDown && Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-block-switcher__container"
    }, hasPatternTransformation && Object(external_wp_element_["createElement"])(pattern_transformations_menu, {
      blocks: blocks,
      patterns: patterns,
      onSelect: transformedBlocks => {
        onPatternTransform(transformedBlocks);
        onClose();
      }
    }), hasPossibleBlockTransformations && Object(external_wp_element_["createElement"])(block_transformations_menu, {
      className: "block-editor-block-switcher__transforms__menugroup",
      possibleBlockTransformations: possibleBlockTransformations,
      blocks: blocks,
      onSelect: name => {
        onBlockTransform(name);
        onClose();
      }
    }), hasBlockStyles && Object(external_wp_element_["createElement"])(BlockStylesMenu, {
      hoveredBlock: blocks[0],
      onSwitch: onClose
    }));
  })));
};
const BlockSwitcher = _ref4 => {
  let {
    clientIds
  } = _ref4;
  const blocks = Object(external_wp_data_["useSelect"])(select => select(store["a" /* store */]).getBlocksByClientId(clientIds), [clientIds]);

  if (!blocks.length || blocks.some(block => !block)) {
    return null;
  }

  return Object(external_wp_element_["createElement"])(BlockSwitcherDropdownMenu, {
    clientIds: clientIds,
    blocks: blocks
  });
};
/* harmony default export */ var block_switcher = (BlockSwitcher);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/index.js + 4 modules
var block_controls = __webpack_require__("fOYa");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu/index.js
var block_settings_menu = __webpack_require__("U1WI");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-toolbar/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */








function BlockToolbar(_ref) {
  let {
    hideDragHandle
  } = _ref;
  const {
    blockClientIds,
    blockClientId,
    blockType,
    hasFixedToolbar,
    hasReducedUI,
    isValid,
    isVisual
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      getBlockName,
      getBlockMode,
      getSelectedBlockClientIds,
      isBlockValid,
      getBlockRootClientId,
      getSettings
    } = select(store["a" /* store */]);
    const selectedBlockClientIds = getSelectedBlockClientIds();
    const selectedBlockClientId = selectedBlockClientIds[0];
    const blockRootClientId = getBlockRootClientId(selectedBlockClientId);
    const settings = getSettings();
    return {
      blockClientIds: selectedBlockClientIds,
      blockClientId: selectedBlockClientId,
      blockType: selectedBlockClientId && Object(external_wp_blocks_["getBlockType"])(getBlockName(selectedBlockClientId)),
      hasFixedToolbar: settings.hasFixedToolbar,
      hasReducedUI: settings.hasReducedUI,
      rootClientId: blockRootClientId,
      isValid: selectedBlockClientIds.every(id => isBlockValid(id)),
      isVisual: selectedBlockClientIds.every(id => getBlockMode(id) === 'visual')
    };
  }, []); // Handles highlighting the current block outline on hover or focus of the
  // block type toolbar area.

  const {
    toggleBlockHighlight
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const nodeRef = Object(external_wp_element_["useRef"])();
  const {
    showMovers,
    gestures: showMoversGestures
  } = useShowMoversGestures({
    ref: nodeRef,

    onChange(isFocused) {
      if (isFocused && hasReducedUI) {
        return;
      }

      toggleBlockHighlight(blockClientId, isFocused);
    }

  }); // Account for the cases where the block toolbar is rendered within the
  // header area and not contextually to the block.

  const displayHeaderToolbar = Object(external_wp_compose_["useViewportMatch"])('medium', '<') || hasFixedToolbar;

  if (blockType) {
    if (!Object(external_wp_blocks_["hasBlockSupport"])(blockType, '__experimentalToolbar', true)) {
      return null;
    }
  }

  const shouldShowMovers = displayHeaderToolbar || showMovers;

  if (blockClientIds.length === 0) {
    return null;
  }

  const shouldShowVisualToolbar = isValid && isVisual;
  const isMultiToolbar = blockClientIds.length > 1;
  const classes = classnames_default()('block-editor-block-toolbar', shouldShowMovers && 'is-showing-movers');
  return Object(external_wp_element_["createElement"])("div", {
    className: classes
  }, !isMultiToolbar && !displayHeaderToolbar && Object(external_wp_element_["createElement"])(BlockParentSelector, {
    clientIds: blockClientIds
  }), Object(external_wp_element_["createElement"])("div", Object(esm_extends["a" /* default */])({
    ref: nodeRef
  }, showMoversGestures), (shouldShowVisualToolbar || isMultiToolbar) && Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarGroup"], {
    className: "block-editor-block-toolbar__block-controls"
  }, Object(external_wp_element_["createElement"])(block_switcher, {
    clientIds: blockClientIds
  }), Object(external_wp_element_["createElement"])(block_mover["a" /* default */], {
    clientIds: blockClientIds,
    hideDragHandle: hideDragHandle || hasReducedUI
  }))), shouldShowVisualToolbar && Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(block_controls["b" /* default */].Slot, {
    group: "parent",
    className: "block-editor-block-toolbar__slot"
  }), Object(external_wp_element_["createElement"])(block_controls["b" /* default */].Slot, {
    group: "block",
    className: "block-editor-block-toolbar__slot"
  }), Object(external_wp_element_["createElement"])(block_controls["b" /* default */].Slot, {
    className: "block-editor-block-toolbar__slot"
  }), Object(external_wp_element_["createElement"])(block_controls["b" /* default */].Slot, {
    group: "inline",
    className: "block-editor-block-toolbar__slot"
  }), Object(external_wp_element_["createElement"])(block_controls["b" /* default */].Slot, {
    group: "other",
    className: "block-editor-block-toolbar__slot"
  })), Object(external_wp_element_["createElement"])(block_settings_menu["a" /* default */], {
    clientIds: blockClientIds
  }));
}


/***/ }),

/***/ "//Lo":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const blockDefault = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M19 8h-1V6h-5v2h-2V6H6v2H5c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-8c0-1.1-.9-2-2-2zm.5 10c0 .3-.2.5-.5.5H5c-.3 0-.5-.2-.5-.5v-8c0-.3.2-.5.5-.5h14c.3 0 .5.2.5.5v8z"
}));
/* harmony default export */ __webpack_exports__["a"] = (blockDefault);


/***/ }),

/***/ "/Hvg":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ TextTransformControl; });

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external ["wp","components"]
var external_wp_components_ = __webpack_require__("tI+e");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: external ["wp","primitives"]
var external_wp_primitives_ = __webpack_require__("Tqx9");

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-uppercase.js


/**
 * WordPress dependencies
 */

const formatUppercase = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  d: "M6.1 6.8L2.1 18h1.6l1.1-3h4.3l1.1 3h1.6l-4-11.2H6.1zm-.8 6.8L7 8.9l1.7 4.7H5.3zm15.1-.7c-.4-.5-.9-.8-1.6-1 .4-.2.7-.5.8-.9.2-.4.3-.9.3-1.4 0-.9-.3-1.6-.8-2-.6-.5-1.3-.7-2.4-.7h-3.5V18h4.2c1.1 0 2-.3 2.6-.8.6-.6 1-1.4 1-2.4-.1-.8-.3-1.4-.6-1.9zm-5.7-4.7h1.8c.6 0 1.1.1 1.4.4.3.2.5.7.5 1.3 0 .6-.2 1.1-.5 1.3-.3.2-.8.4-1.4.4h-1.8V8.2zm4 8c-.4.3-.9.5-1.5.5h-2.6v-3.8h2.6c1.4 0 2 .6 2 1.9.1.6-.1 1-.5 1.4z"
}));
/* harmony default export */ var format_uppercase = (formatUppercase);

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-lowercase.js


/**
 * WordPress dependencies
 */

const formatLowercase = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  d: "M11 16.8c-.1-.1-.2-.3-.3-.5v-2.6c0-.9-.1-1.7-.3-2.2-.2-.5-.5-.9-.9-1.2-.4-.2-.9-.3-1.6-.3-.5 0-1 .1-1.5.2s-.9.3-1.2.6l.2 1.2c.4-.3.7-.4 1.1-.5.3-.1.7-.2 1-.2.6 0 1 .1 1.3.4.3.2.4.7.4 1.4-1.2 0-2.3.2-3.3.7s-1.4 1.1-1.4 2.1c0 .7.2 1.2.7 1.6.4.4 1 .6 1.8.6.9 0 1.7-.4 2.4-1.2.1.3.2.5.4.7.1.2.3.3.6.4.3.1.6.1 1.1.1h.1l.2-1.2h-.1c-.4.1-.6 0-.7-.1zM9.2 16c-.2.3-.5.6-.9.8-.3.1-.7.2-1.1.2-.4 0-.7-.1-.9-.3-.2-.2-.3-.5-.3-.9 0-.6.2-1 .7-1.3.5-.3 1.3-.4 2.5-.5v2zm10.6-3.9c-.3-.6-.7-1.1-1.2-1.5-.6-.4-1.2-.6-1.9-.6-.5 0-.9.1-1.4.3-.4.2-.8.5-1.1.8V6h-1.4v12h1.3l.2-1c.2.4.6.6 1 .8.4.2.9.3 1.4.3.7 0 1.2-.2 1.8-.5.5-.4 1-.9 1.3-1.5.3-.6.5-1.3.5-2.1-.1-.6-.2-1.3-.5-1.9zm-1.7 4c-.4.5-.9.8-1.6.8s-1.2-.2-1.7-.7c-.4-.5-.7-1.2-.7-2.1 0-.9.2-1.6.7-2.1.4-.5 1-.7 1.7-.7s1.2.3 1.6.8c.4.5.6 1.2.6 2s-.2 1.4-.6 2z"
}));
/* harmony default export */ var format_lowercase = (formatLowercase);

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/format-capitalize.js


/**
 * WordPress dependencies
 */

const formatCapitalize = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  d: "M7.1 6.8L3.1 18h1.6l1.1-3h4.3l1.1 3h1.6l-4-11.2H7.1zm-.8 6.8L8 8.9l1.7 4.7H6.3zm14.5-1.5c-.3-.6-.7-1.1-1.2-1.5-.6-.4-1.2-.6-1.9-.6-.5 0-.9.1-1.4.3-.4.2-.8.5-1.1.8V6h-1.4v12h1.3l.2-1c.2.4.6.6 1 .8.4.2.9.3 1.4.3.7 0 1.2-.2 1.8-.5.5-.4 1-.9 1.3-1.5.3-.6.5-1.3.5-2.1-.1-.6-.2-1.3-.5-1.9zm-1.7 4c-.4.5-.9.8-1.6.8s-1.2-.2-1.7-.7c-.4-.5-.7-1.2-.7-2.1 0-.9.2-1.6.7-2.1.4-.5 1-.7 1.7-.7s1.2.3 1.6.8c.4.5.6 1.2.6 2 .1.8-.2 1.4-.6 2z"
}));
/* harmony default export */ var format_capitalize = (formatCapitalize);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/text-transform-control/index.js


/**
 * WordPress dependencies
 */



const TEXT_TRANSFORMS = [{
  name: Object(external_wp_i18n_["__"])('Uppercase'),
  value: 'uppercase',
  icon: format_uppercase
}, {
  name: Object(external_wp_i18n_["__"])('Lowercase'),
  value: 'lowercase',
  icon: format_lowercase
}, {
  name: Object(external_wp_i18n_["__"])('Capitalize'),
  value: 'capitalize',
  icon: format_capitalize
}];
/**
 * Control to facilitate text transform selections.
 *
 * @param {Object}   props          Component props.
 * @param {string}   props.value    Currently selected text transform.
 * @param {Function} props.onChange Handles change in text transform selection.
 *
 * @return {WPElement} Text transform control.
 */

function TextTransformControl(_ref) {
  let {
    value,
    onChange
  } = _ref;
  return Object(external_wp_element_["createElement"])("fieldset", {
    className: "block-editor-text-transform-control"
  }, Object(external_wp_element_["createElement"])("legend", null, Object(external_wp_i18n_["__"])('Letter case')), Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-text-transform-control__buttons"
  }, TEXT_TRANSFORMS.map(textTransform => {
    return Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
      key: textTransform.value,
      icon: textTransform.icon,
      isSmall: true,
      isPressed: value === textTransform.value,
      "aria-label": textTransform.name,
      onClick: () => onChange(value === textTransform.value ? undefined : textTransform.value)
    });
  })));
}


/***/ }),

/***/ "/QNa":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js + 4 modules
var store = __webpack_require__("BhPs");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/constants.js
var constants = __webpack_require__("AHN3");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/provider/with-registry-provider.js



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const withRegistryProvider = Object(external_wp_compose_["createHigherOrderComponent"])(WrappedComponent => {
  return Object(external_wp_data_["withRegistry"])(_ref => {
    let {
      useSubRegistry = true,
      registry,
      ...props
    } = _ref;

    if (!useSubRegistry) {
      return Object(external_wp_element_["createElement"])(WrappedComponent, Object(esm_extends["a" /* default */])({
        registry: registry
      }, props));
    }

    const [subRegistry, setSubRegistry] = Object(external_wp_element_["useState"])(null);
    Object(external_wp_element_["useEffect"])(() => {
      const newRegistry = Object(external_wp_data_["createRegistry"])({}, registry);
      newRegistry.registerStore(constants["a" /* STORE_NAME */], store["b" /* storeConfig */]);
      setSubRegistry(newRegistry);
    }, [registry]);

    if (!subRegistry) {
      return null;
    }

    return Object(external_wp_element_["createElement"])(external_wp_data_["RegistryProvider"], {
      value: subRegistry
    }, Object(external_wp_element_["createElement"])(WrappedComponent, Object(esm_extends["a" /* default */])({
      registry: subRegistry
    }, props)));
  });
}, 'withRegistryProvider');
/* harmony default export */ var with_registry_provider = (withRegistryProvider);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/provider/use-block-sync.js
var use_block_sync = __webpack_require__("JGYp");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/provider/block-refs-provider.js
var block_refs_provider = __webpack_require__("cDhi");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/provider/index.js


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */





/** @typedef {import('@wordpress/data').WPDataRegistry} WPDataRegistry */

function BlockEditorProvider(props) {
  const {
    children,
    settings
  } = props;
  const {
    updateSettings
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  Object(external_wp_element_["useEffect"])(() => {
    updateSettings(settings);
  }, [settings]); // Syncs the entity provider with changes in the block-editor store.

  Object(use_block_sync["a" /* default */])(props);
  return Object(external_wp_element_["createElement"])(block_refs_provider["b" /* BlockRefsProvider */], null, children);
}

/* harmony default export */ var provider = __webpack_exports__["a"] = (with_registry_provider(BlockEditorProvider));


/***/ }),

/***/ "/lNF":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export parseDropEvent */
/* unused harmony export onBlockDrop */
/* unused harmony export onFilesDrop */
/* unused harmony export onHTMLDrop */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useOnBlockDrop; });
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("HSyU");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("1CF3");
/* harmony import */ var _wordpress_dom__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_dom__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("BhPs");
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/** @typedef {import('@wordpress/element').WPSyntheticEvent} WPSyntheticEvent */

/**
 * Retrieve the data for a block drop event.
 *
 * @param {WPSyntheticEvent} event The drop event.
 *
 * @return {Object} An object with block drag and drop data.
 */

function parseDropEvent(event) {
  let result = {
    srcRootClientId: null,
    srcClientIds: null,
    srcIndex: null,
    type: null,
    blocks: null
  };

  if (!event.dataTransfer) {
    return result;
  }

  try {
    result = Object.assign(result, JSON.parse(event.dataTransfer.getData('wp-blocks')));
  } catch (err) {
    return result;
  }

  return result;
}
/**
 * A function that returns an event handler function for block drop events.
 *
 * @param {string}   targetRootClientId        The root client id where the block(s) will be inserted.
 * @param {number}   targetBlockIndex          The index where the block(s) will be inserted.
 * @param {Function} getBlockIndex             A function that gets the index of a block.
 * @param {Function} getClientIdsOfDescendants A function that gets the client ids of descendant blocks.
 * @param {Function} moveBlocksToPosition      A function that moves blocks.
 * @param {Function} insertBlocks              A function that inserts blocks.
 * @param {Function} clearSelectedBlock        A function that clears block selection.
 * @return {Function} The event handler for a block drop event.
 */

function onBlockDrop(targetRootClientId, targetBlockIndex, getBlockIndex, getClientIdsOfDescendants, moveBlocksToPosition, insertBlocks, clearSelectedBlock) {
  return event => {
    const {
      srcRootClientId: sourceRootClientId,
      srcClientIds: sourceClientIds,
      type: dropType,
      blocks
    } = parseDropEvent(event); // If the user is inserting a block

    if (dropType === 'inserter') {
      clearSelectedBlock();
      const blocksToInsert = blocks.map(block => Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__["cloneBlock"])(block));
      insertBlocks(blocksToInsert, targetBlockIndex, targetRootClientId, true, null);
    } // If the user is moving a block


    if (dropType === 'block') {
      const sourceBlockIndex = getBlockIndex(sourceClientIds[0]); // If the user is dropping to the same position, return early.

      if (sourceRootClientId === targetRootClientId && sourceBlockIndex === targetBlockIndex) {
        return;
      } // If the user is attempting to drop a block within its own
      // nested blocks, return early as this would create infinite
      // recursion.


      if (sourceClientIds.includes(targetRootClientId) || getClientIdsOfDescendants(sourceClientIds).some(id => id === targetRootClientId)) {
        return;
      }

      const isAtSameLevel = sourceRootClientId === targetRootClientId;
      const draggedBlockCount = sourceClientIds.length; // If the block is kept at the same level and moved downwards,
      // subtract to take into account that the blocks being dragged
      // were removed from the block list above the insertion point.

      const insertIndex = isAtSameLevel && sourceBlockIndex < targetBlockIndex ? targetBlockIndex - draggedBlockCount : targetBlockIndex;
      moveBlocksToPosition(sourceClientIds, sourceRootClientId, targetRootClientId, insertIndex);
    }
  };
}
/**
 * A function that returns an event handler function for block-related file drop events.
 *
 * @param {string}   targetRootClientId    The root client id where the block(s) will be inserted.
 * @param {number}   targetBlockIndex      The index where the block(s) will be inserted.
 * @param {boolean}  hasUploadPermissions  Whether the user has upload permissions.
 * @param {Function} updateBlockAttributes A function that updates a block's attributes.
 * @param {Function} canInsertBlockType    A function that returns checks whether a block type can be inserted.
 * @param {Function} insertBlocks          A function that inserts blocks.
 *
 * @return {Function} The event handler for a block-related file drop event.
 */

function onFilesDrop(targetRootClientId, targetBlockIndex, hasUploadPermissions, updateBlockAttributes, canInsertBlockType, insertBlocks) {
  return files => {
    if (!hasUploadPermissions) {
      return;
    }

    const transformation = Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__["findTransform"])(Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__["getBlockTransforms"])('from'), transform => transform.type === 'files' && canInsertBlockType(transform.blockName, targetRootClientId) && transform.isMatch(files));

    if (transformation) {
      const blocks = transformation.transform(files, updateBlockAttributes);
      insertBlocks(blocks, targetBlockIndex, targetRootClientId);
    }
  };
}
/**
 * A function that returns an event handler function for block-related HTML drop events.
 *
 * @param {string}   targetRootClientId The root client id where the block(s) will be inserted.
 * @param {number}   targetBlockIndex   The index where the block(s) will be inserted.
 * @param {Function} insertBlocks       A function that inserts blocks.
 *
 * @return {Function} The event handler for a block-related HTML drop event.
 */

function onHTMLDrop(targetRootClientId, targetBlockIndex, insertBlocks) {
  return HTML => {
    const blocks = Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_0__["pasteHandler"])({
      HTML,
      mode: 'BLOCKS'
    });

    if (blocks.length) {
      insertBlocks(blocks, targetBlockIndex, targetRootClientId);
    }
  };
}
/**
 * A React hook for handling block drop events.
 *
 * @param {string} targetRootClientId The root client id where the block(s) will be inserted.
 * @param {number} targetBlockIndex   The index where the block(s) will be inserted.
 *
 * @return {Object} An object that contains the event handlers `onDrop`, `onFilesDrop` and `onHTMLDrop`.
 */

function useOnBlockDrop(targetRootClientId, targetBlockIndex) {
  const hasUploadPermissions = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["useSelect"])(select => select(_store__WEBPACK_IMPORTED_MODULE_3__[/* store */ "a"]).getSettings().mediaUpload, []);
  const {
    canInsertBlockType,
    getBlockIndex,
    getClientIdsOfDescendants
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["useSelect"])(_store__WEBPACK_IMPORTED_MODULE_3__[/* store */ "a"]);
  const {
    insertBlocks,
    moveBlocksToPosition,
    updateBlockAttributes,
    clearSelectedBlock
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["useDispatch"])(_store__WEBPACK_IMPORTED_MODULE_3__[/* store */ "a"]);

  const _onDrop = onBlockDrop(targetRootClientId, targetBlockIndex, getBlockIndex, getClientIdsOfDescendants, moveBlocksToPosition, insertBlocks, clearSelectedBlock);

  const _onFilesDrop = onFilesDrop(targetRootClientId, targetBlockIndex, hasUploadPermissions, updateBlockAttributes, canInsertBlockType, insertBlocks);

  const _onHTMLDrop = onHTMLDrop(targetRootClientId, targetBlockIndex, insertBlocks);

  return event => {
    const files = Object(_wordpress_dom__WEBPACK_IMPORTED_MODULE_2__["getFilesFromDataTransfer"])(event.dataTransfer);
    const html = event.dataTransfer.getData('text/html');

    if (files.length) {
      _onFilesDrop(files);
    } else if (html) {
      _onHTMLDrop(html);
    } else {
      _onDrop(event);
    }
  };
}


/***/ }),

/***/ "0E5u":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ JustifyContentControl; });
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ JustifyToolbar; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external ["wp","components"]
var external_wp_components_ = __webpack_require__("tI+e");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-left.js
var justify_left = __webpack_require__("kWXm");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-center.js
var justify_center = __webpack_require__("DmX/");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-right.js
var justify_right = __webpack_require__("suLj");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-space-between.js
var justify_space_between = __webpack_require__("bTSr");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/justify-content-control/ui.js



/**
 * WordPress dependencies
 */



const icons = {
  left: justify_left["a" /* default */],
  center: justify_center["a" /* default */],
  right: justify_right["a" /* default */],
  'space-between': justify_space_between["a" /* default */]
};

function JustifyContentUI(_ref) {
  let {
    allowedControls = ['left', 'center', 'right', 'space-between'],
    isCollapsed = true,
    onChange,
    value,
    popoverProps,
    isToolbar
  } = _ref;

  // If the control is already selected we want a click
  // again on the control to deselect the item, so we
  // call onChange( undefined )
  const handleClick = next => {
    if (next === value) {
      onChange(undefined);
    } else {
      onChange(next);
    }
  };

  const icon = value ? icons[value] : icons.left;
  const allControls = [{
    name: 'left',
    icon: justify_left["a" /* default */],
    title: Object(external_wp_i18n_["__"])('Justify items left'),
    isActive: 'left' === value,
    onClick: () => handleClick('left')
  }, {
    name: 'center',
    icon: justify_center["a" /* default */],
    title: Object(external_wp_i18n_["__"])('Justify items center'),
    isActive: 'center' === value,
    onClick: () => handleClick('center')
  }, {
    name: 'right',
    icon: justify_right["a" /* default */],
    title: Object(external_wp_i18n_["__"])('Justify items right'),
    isActive: 'right' === value,
    onClick: () => handleClick('right')
  }, {
    name: 'space-between',
    icon: justify_space_between["a" /* default */],
    title: Object(external_wp_i18n_["__"])('Space between items'),
    isActive: 'space-between' === value,
    onClick: () => handleClick('space-between')
  }];
  const UIComponent = isToolbar ? external_wp_components_["ToolbarGroup"] : external_wp_components_["ToolbarDropdownMenu"];
  const extraProps = isToolbar ? {
    isCollapsed
  } : {};
  return Object(external_wp_element_["createElement"])(UIComponent, Object(esm_extends["a" /* default */])({
    icon: icon,
    popoverProps: popoverProps,
    label: Object(external_wp_i18n_["__"])('Change items justification'),
    controls: allControls.filter(elem => allowedControls.includes(elem.name))
  }, extraProps));
}

/* harmony default export */ var ui = (JustifyContentUI);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/justify-content-control/index.js



/**
 * Internal dependencies
 */

function JustifyContentControl(props) {
  return Object(external_wp_element_["createElement"])(ui, Object(esm_extends["a" /* default */])({}, props, {
    isToolbar: false
  }));
}
function JustifyToolbar(props) {
  return Object(external_wp_element_["createElement"])(ui, Object(esm_extends["a" /* default */])({}, props, {
    isToolbar: true
  }));
}


/***/ }),

/***/ "0LBR":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useMultipleOriginColorsAndGradients; });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _use_setting__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("v5LD");
/* harmony import */ var _use_common_single_multiple_selects__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("pY5h");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Retrieves color and gradient related settings.
 *
 * The arrays for colors and gradients are made up of color palettes from each
 * origin i.e. "Core", "Theme", and "User".
 *
 * @return {Object} Color and gradient related settings.
 */

function useMultipleOriginColorsAndGradients() {
  const colorGradientSettings = Object(_use_common_single_multiple_selects__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"])();
  const customColors = Object(_use_setting__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])('color.palette.custom');
  const themeColors = Object(_use_setting__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])('color.palette.theme');
  const defaultColors = Object(_use_setting__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])('color.palette.default');
  const shouldDisplayDefaultColors = Object(_use_setting__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])('color.defaultPalette');
  colorGradientSettings.colors = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(() => {
    const result = [];

    if (themeColors && themeColors.length) {
      result.push({
        name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__["_x"])('Theme', 'Indicates this palette comes from the theme.'),
        colors: themeColors
      });
    }

    if (shouldDisplayDefaultColors && defaultColors && defaultColors.length) {
      result.push({
        name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__["_x"])('Default', 'Indicates this palette comes from WordPress.'),
        colors: defaultColors
      });
    }

    if (customColors && customColors.length) {
      result.push({
        name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__["_x"])('Custom', 'Indicates this palette comes from the theme.'),
        colors: customColors
      });
    }

    return result;
  }, [defaultColors, themeColors, customColors]);
  const customGradients = Object(_use_setting__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])('color.gradients.custom');
  const themeGradients = Object(_use_setting__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])('color.gradients.theme');
  const defaultGradients = Object(_use_setting__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])('color.gradients.default');
  const shouldDisplayDefaultGradients = Object(_use_setting__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"])('color.defaultGradients');
  colorGradientSettings.gradients = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(() => {
    const result = [];

    if (themeGradients && themeGradients.length) {
      result.push({
        name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__["_x"])('Theme', 'Indicates this palette comes from the theme.'),
        gradients: themeGradients
      });
    }

    if (shouldDisplayDefaultGradients && defaultGradients && defaultGradients.length) {
      result.push({
        name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__["_x"])('Default', 'Indicates this palette comes from WordPress.'),
        gradients: defaultGradients
      });
    }

    if (customGradients && customGradients.length) {
      result.push({
        name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__["_x"])('Custom', 'Indicates this palette is created by the user.'),
        gradients: customGradients
      });
    }

    return result;
  }, [customGradients, themeGradients, defaultGradients]);
  return colorGradientSettings;
}


/***/ }),

/***/ "14PQ":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "ic", function() { return /* reexport */ components_colors["b" /* getColorClassName */]; });
__webpack_require__.d(__webpack_exports__, "jc", function() { return /* reexport */ components_colors["c" /* getColorObjectByAttributeValues */]; });
__webpack_require__.d(__webpack_exports__, "kc", function() { return /* reexport */ components_colors["d" /* getColorObjectByColorValue */]; });
__webpack_require__.d(__webpack_exports__, "hc", function() { return /* reexport */ components_colors["a" /* createCustomColorsHOC */]; });
__webpack_require__.d(__webpack_exports__, "wc", function() { return /* reexport */ components_colors["e" /* withColors */]; });
__webpack_require__.d(__webpack_exports__, "yb", function() { return /* reexport */ gradients["a" /* __experimentalGetGradientClass */]; });
__webpack_require__.d(__webpack_exports__, "pc", function() { return /* reexport */ gradients["e" /* getGradientValueBySlug */]; });
__webpack_require__.d(__webpack_exports__, "zb", function() { return /* reexport */ gradients["b" /* __experimentalGetGradientObjectByGradientValue */]; });
__webpack_require__.d(__webpack_exports__, "oc", function() { return /* reexport */ gradients["d" /* getGradientSlugByValue */]; });
__webpack_require__.d(__webpack_exports__, "Tb", function() { return /* reexport */ gradients["c" /* __experimentalUseGradient */]; });
__webpack_require__.d(__webpack_exports__, "lc", function() { return /* reexport */ font_sizes["b" /* getFontSize */]; });
__webpack_require__.d(__webpack_exports__, "mc", function() { return /* reexport */ font_sizes["c" /* getFontSizeClass */]; });
__webpack_require__.d(__webpack_exports__, "nc", function() { return /* reexport */ font_sizes["d" /* getFontSizeObjectByValue */]; });
__webpack_require__.d(__webpack_exports__, "I", function() { return /* reexport */ font_sizes["a" /* FontSizePicker */]; });
__webpack_require__.d(__webpack_exports__, "xc", function() { return /* reexport */ font_sizes["e" /* withFontSizes */]; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* reexport */ AlignmentControl; });
__webpack_require__.d(__webpack_exports__, "b", function() { return /* reexport */ AlignmentToolbar; });
__webpack_require__.d(__webpack_exports__, "c", function() { return /* reexport */ autocomplete; });
__webpack_require__.d(__webpack_exports__, "d", function() { return /* reexport */ block_alignment_control["a" /* BlockAlignmentControl */]; });
__webpack_require__.d(__webpack_exports__, "e", function() { return /* reexport */ block_alignment_control["b" /* BlockAlignmentToolbar */]; });
__webpack_require__.d(__webpack_exports__, "nb", function() { return /* reexport */ block_full_height_alignment_control; });
__webpack_require__.d(__webpack_exports__, "lb", function() { return /* reexport */ block_alignment_matrix_control; });
__webpack_require__.d(__webpack_exports__, "f", function() { return /* reexport */ block_breadcrumb; });
__webpack_require__.d(__webpack_exports__, "mb", function() { return /* reexport */ BlockContentOverlay; });
__webpack_require__.d(__webpack_exports__, "h", function() { return /* reexport */ block_context["a" /* BlockContextProvider */]; });
__webpack_require__.d(__webpack_exports__, "i", function() { return /* reexport */ block_controls["b" /* default */]; });
__webpack_require__.d(__webpack_exports__, "m", function() { return /* reexport */ block_controls["a" /* BlockFormatControls */]; });
__webpack_require__.d(__webpack_exports__, "g", function() { return /* reexport */ color_style_selector; });
__webpack_require__.d(__webpack_exports__, "j", function() { return /* reexport */ block_edit["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "rc", function() { return /* reexport */ context["c" /* useBlockEditContext */]; });
__webpack_require__.d(__webpack_exports__, "n", function() { return /* reexport */ block_icon["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "r", function() { return /* reexport */ dropdown; });
__webpack_require__.d(__webpack_exports__, "pb", function() { return /* reexport */ block_variation_picker; });
__webpack_require__.d(__webpack_exports__, "ob", function() { return /* reexport */ block_pattern_setup; });
__webpack_require__.d(__webpack_exports__, "qb", function() { return /* reexport */ components_block_variation_transforms; });
__webpack_require__.d(__webpack_exports__, "A", function() { return /* reexport */ BlockVerticalAlignmentToolbar; });
__webpack_require__.d(__webpack_exports__, "z", function() { return /* reexport */ BlockVerticalAlignmentControl; });
__webpack_require__.d(__webpack_exports__, "rb", function() { return /* reexport */ border_radius_control["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "sb", function() { return /* reexport */ border_style_control["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "C", function() { return /* reexport */ button_block_appender["a" /* ButtonBlockerAppender */]; });
__webpack_require__.d(__webpack_exports__, "B", function() { return /* reexport */ button_block_appender["b" /* default */]; });
__webpack_require__.d(__webpack_exports__, "D", function() { return /* reexport */ color_palette; });
__webpack_require__.d(__webpack_exports__, "E", function() { return /* reexport */ ColorPaletteControl; });
__webpack_require__.d(__webpack_exports__, "F", function() { return /* reexport */ contrast_checker["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "vb", function() { return /* reexport */ duotone_control["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "wb", function() { return /* reexport */ font_appearance_control["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "xb", function() { return /* reexport */ font_family["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Fb", function() { return /* reexport */ letter_spacing_control["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Pb", function() { return /* reexport */ text_decoration_control["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Qb", function() { return /* reexport */ text_transform_control["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "tb", function() { return /* reexport */ control["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "ub", function() { return /* reexport */ colors_gradients_dropdown["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Mb", function() { return /* reexport */ panel_color_gradient_settings["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Bb", function() { return /* reexport */ ImageEditor; });
__webpack_require__.d(__webpack_exports__, "Ab", function() { return /* reexport */ ImageEditingProvider; });
__webpack_require__.d(__webpack_exports__, "Cb", function() { return /* reexport */ ImageSizeControl; });
__webpack_require__.d(__webpack_exports__, "J", function() { return /* reexport */ inner_blocks["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "tc", function() { return /* reexport */ inner_blocks["b" /* useInnerBlocksProps */]; });
__webpack_require__.d(__webpack_exports__, "M", function() { return /* reexport */ inspector_controls["b" /* default */]; });
__webpack_require__.d(__webpack_exports__, "L", function() { return /* reexport */ inspector_controls["a" /* InspectorAdvancedControls */]; });
__webpack_require__.d(__webpack_exports__, "O", function() { return /* reexport */ justify_content_control["b" /* JustifyToolbar */]; });
__webpack_require__.d(__webpack_exports__, "N", function() { return /* reexport */ justify_content_control["a" /* JustifyContentControl */]; });
__webpack_require__.d(__webpack_exports__, "Hb", function() { return /* reexport */ link_control; });
__webpack_require__.d(__webpack_exports__, "Ib", function() { return /* reexport */ search_input; });
__webpack_require__.d(__webpack_exports__, "Kb", function() { return /* reexport */ LinkControlSearchResults; });
__webpack_require__.d(__webpack_exports__, "Jb", function() { return /* reexport */ search_item; });
__webpack_require__.d(__webpack_exports__, "P", function() { return /* reexport */ line_height_control["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Lb", function() { return /* reexport */ components_list_view; });
__webpack_require__.d(__webpack_exports__, "R", function() { return /* reexport */ media_replace_flow; });
__webpack_require__.d(__webpack_exports__, "Q", function() { return /* reexport */ media_placeholder; });
__webpack_require__.d(__webpack_exports__, "S", function() { return /* reexport */ media_upload; });
__webpack_require__.d(__webpack_exports__, "T", function() { return /* reexport */ media_upload_check; });
__webpack_require__.d(__webpack_exports__, "X", function() { return /* reexport */ panel_color_settings; });
__webpack_require__.d(__webpack_exports__, "Y", function() { return /* reexport */ plain_text; });
__webpack_require__.d(__webpack_exports__, "Ob", function() { return /* reexport */ responsive_block_control; });
__webpack_require__.d(__webpack_exports__, "ab", function() { return /* reexport */ rich_text; });
__webpack_require__.d(__webpack_exports__, "bb", function() { return /* reexport */ RichTextShortcut; });
__webpack_require__.d(__webpack_exports__, "cb", function() { return /* reexport */ RichTextToolbarButton; });
__webpack_require__.d(__webpack_exports__, "ac", function() { return /* reexport */ __unstableRichTextInputEvent; });
__webpack_require__.d(__webpack_exports__, "eb", function() { return /* reexport */ tool_selector; });
__webpack_require__.d(__webpack_exports__, "Rb", function() { return /* reexport */ UnitControl; });
__webpack_require__.d(__webpack_exports__, "gb", function() { return /* reexport */ url_input; });
__webpack_require__.d(__webpack_exports__, "hb", function() { return /* reexport */ url_input_button; });
__webpack_require__.d(__webpack_exports__, "ib", function() { return /* reexport */ url_popover; });
__webpack_require__.d(__webpack_exports__, "Db", function() { return /* reexport */ ImageURLInputUI; });
__webpack_require__.d(__webpack_exports__, "vc", function() { return /* reexport */ with_color_context; });
__webpack_require__.d(__webpack_exports__, "Wb", function() { return /* reexport */ block_settings_menu_first_item["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Zb", function() { return /* reexport */ inserter_menu_extension["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Nb", function() { return /* reexport */ PreviewOptions; });
__webpack_require__.d(__webpack_exports__, "Vb", function() { return /* reexport */ useResizeCanvas; });
__webpack_require__.d(__webpack_exports__, "o", function() { return /* reexport */ block_inspector; });
__webpack_require__.d(__webpack_exports__, "p", function() { return /* reexport */ block_list["c" /* default */]; });
__webpack_require__.d(__webpack_exports__, "sc", function() { return /* reexport */ use_block_props["a" /* useBlockProps */]; });
__webpack_require__.d(__webpack_exports__, "Eb", function() { return /* reexport */ block_list_layout["b" /* LayoutStyle */]; });
__webpack_require__.d(__webpack_exports__, "q", function() { return /* reexport */ block_mover["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "s", function() { return /* reexport */ block_preview["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Sb", function() { return /* reexport */ block_preview["b" /* useBlockPreview */]; });
__webpack_require__.d(__webpack_exports__, "t", function() { return /* reexport */ block_selection_clearer["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "bc", function() { return /* reexport */ block_selection_clearer["b" /* useBlockSelectionClearer */]; });
__webpack_require__.d(__webpack_exports__, "u", function() { return /* reexport */ block_settings_menu["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "v", function() { return /* reexport */ block_settings_menu_controls["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "w", function() { return /* reexport */ block_title["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "x", function() { return /* reexport */ block_toolbar["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "y", function() { return /* reexport */ BlockTools; });
__webpack_require__.d(__webpack_exports__, "G", function() { return /* reexport */ copy_handler["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "dc", function() { return /* reexport */ copy_handler["b" /* useClipboardHandler */]; });
__webpack_require__.d(__webpack_exports__, "H", function() { return /* reexport */ default_block_appender["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Xb", function() { return /* reexport */ editor_styles["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "K", function() { return /* reexport */ inserter["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Gb", function() { return /* reexport */ library; });
__webpack_require__.d(__webpack_exports__, "k", function() { return /* reexport */ keyboard_shortcuts; });
__webpack_require__.d(__webpack_exports__, "U", function() { return /* reexport */ MultiSelectScrollIntoView; });
__webpack_require__.d(__webpack_exports__, "V", function() { return /* reexport */ navigable_toolbar["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "W", function() { return /* reexport */ observe_typing; });
__webpack_require__.d(__webpack_exports__, "gc", function() { return /* reexport */ useTypingObserver; });
__webpack_require__.d(__webpack_exports__, "ec", function() { return /* reexport */ useMouseMoveTypingReset; });
__webpack_require__.d(__webpack_exports__, "Z", function() { return /* reexport */ PreserveScrollInReorder; });
__webpack_require__.d(__webpack_exports__, "db", function() { return /* reexport */ skip_to_selected_block; });
__webpack_require__.d(__webpack_exports__, "fb", function() { return /* reexport */ typewriter; });
__webpack_require__.d(__webpack_exports__, "fc", function() { return /* reexport */ useTypewriter; });
__webpack_require__.d(__webpack_exports__, "jb", function() { return /* reexport */ warning["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "kb", function() { return /* reexport */ writing_flow["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "cc", function() { return /* reexport */ useCanvasClickRedirect; });
__webpack_require__.d(__webpack_exports__, "qc", function() { return /* reexport */ use_block_display_information["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Yb", function() { return /* reexport */ iframe["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "Ub", function() { return /* reexport */ useNoRecursiveRenders; });
__webpack_require__.d(__webpack_exports__, "l", function() { return /* reexport */ provider["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "uc", function() { return /* reexport */ use_setting["a" /* default */]; });

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/colors/index.js + 1 modules
var components_colors = __webpack_require__("5gPN");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/gradients/index.js
var gradients = __webpack_require__("zmSX");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-sizes/index.js + 1 modules
var font_sizes = __webpack_require__("9XVa");

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: external ["wp","components"]
var external_wp_components_ = __webpack_require__("tI+e");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/align-left.js
var align_left = __webpack_require__("fPbg");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/align-center.js
var align_center = __webpack_require__("plpT");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/align-right.js
var align_right = __webpack_require__("ziDm");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/alignment-control/ui.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




const DEFAULT_ALIGNMENT_CONTROLS = [{
  icon: align_left["a" /* default */],
  title: Object(external_wp_i18n_["__"])('Align text left'),
  align: 'left'
}, {
  icon: align_center["a" /* default */],
  title: Object(external_wp_i18n_["__"])('Align text center'),
  align: 'center'
}, {
  icon: align_right["a" /* default */],
  title: Object(external_wp_i18n_["__"])('Align text right'),
  align: 'right'
}];
const ui_POPOVER_PROPS = {
  position: 'bottom right',
  isAlternate: true
};

function AlignmentUI(_ref) {
  let {
    value,
    onChange,
    alignmentControls = DEFAULT_ALIGNMENT_CONTROLS,
    label = Object(external_wp_i18n_["__"])('Align'),
    describedBy = Object(external_wp_i18n_["__"])('Change text alignment'),
    isCollapsed = true,
    isToolbar
  } = _ref;

  function applyOrUnset(align) {
    return () => onChange(value === align ? undefined : align);
  }

  const activeAlignment = Object(external_lodash_["find"])(alignmentControls, control => control.align === value);

  function setIcon() {
    if (activeAlignment) return activeAlignment.icon;
    return Object(external_wp_i18n_["isRTL"])() ? align_right["a" /* default */] : align_left["a" /* default */];
  }

  const UIComponent = isToolbar ? external_wp_components_["ToolbarGroup"] : external_wp_components_["ToolbarDropdownMenu"];
  const extraProps = isToolbar ? {
    isCollapsed
  } : {};
  return Object(external_wp_element_["createElement"])(UIComponent, Object(esm_extends["a" /* default */])({
    icon: setIcon(),
    label: label,
    toggleProps: {
      describedBy
    },
    popoverProps: ui_POPOVER_PROPS,
    controls: alignmentControls.map(control => {
      const {
        align
      } = control;
      const isActive = value === align;
      return { ...control,
        isActive,
        role: isCollapsed ? 'menuitemradio' : undefined,
        onClick: applyOrUnset(align)
      };
    })
  }, extraProps));
}

/* harmony default export */ var ui = (AlignmentUI);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/alignment-control/index.js



/**
 * Internal dependencies
 */

function AlignmentControl(props) {
  return Object(external_wp_element_["createElement"])(ui, Object(esm_extends["a" /* default */])({}, props, {
    isToolbar: false
  }));
}
function AlignmentToolbar(props) {
  return Object(external_wp_element_["createElement"])(ui, Object(esm_extends["a" /* default */])({}, props, {
    isToolbar: true
  }));
}

// EXTERNAL MODULE: external ["wp","hooks"]
var external_wp_hooks_ = __webpack_require__("g56x");

// EXTERNAL MODULE: external ["wp","blocks"]
var external_wp_blocks_ = __webpack_require__("HSyU");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-edit/context.js
var context = __webpack_require__("ur0x");

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter/search-items.js
var search_items = __webpack_require__("pOGT");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter/hooks/use-block-types-state.js
var use_block_types_state = __webpack_require__("+G0a");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-icon/index.js
var block_icon = __webpack_require__("7SSY");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js + 4 modules
var store = __webpack_require__("BhPs");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/autocompleters/block.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





const SHOWN_BLOCK_TYPES = 9;
/** @typedef {import('@wordpress/components').WPCompleter} WPCompleter */

/**
 * Creates a blocks repeater for replacing the current block with a selected block type.
 *
 * @return {WPCompleter} A blocks completer.
 */

function createBlockCompleter() {
  return {
    name: 'blocks',
    className: 'block-editor-autocompleters__block',
    triggerPrefix: '/',

    useItems(filterValue) {
      const {
        rootClientId,
        selectedBlockName
      } = Object(external_wp_data_["useSelect"])(select => {
        const {
          getSelectedBlockClientId,
          getBlockName,
          getBlockInsertionPoint
        } = select(store["a" /* store */]);
        const selectedBlockClientId = getSelectedBlockClientId();
        return {
          selectedBlockName: selectedBlockClientId ? getBlockName(selectedBlockClientId) : null,
          rootClientId: getBlockInsertionPoint().rootClientId
        };
      }, []);
      const [items, categories, collections] = Object(use_block_types_state["a" /* default */])(rootClientId, external_lodash_["noop"]);
      const filteredItems = Object(external_wp_element_["useMemo"])(() => {
        const initialFilteredItems = !!filterValue.trim() ? Object(search_items["a" /* searchBlockItems */])(items, categories, collections, filterValue) : Object(external_lodash_["orderBy"])(items, ['frecency'], ['desc']);
        return initialFilteredItems.filter(item => item.name !== selectedBlockName).slice(0, SHOWN_BLOCK_TYPES);
      }, [filterValue, selectedBlockName, items, categories, collections]);
      const options = Object(external_wp_element_["useMemo"])(() => filteredItems.map(blockItem => {
        const {
          title,
          icon,
          isDisabled
        } = blockItem;
        return {
          key: `block-${blockItem.id}`,
          value: blockItem,
          label: Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(block_icon["a" /* default */], {
            key: "icon",
            icon: icon,
            showColors: true
          }), title),
          isDisabled
        };
      }), [filteredItems]);
      return [options];
    },

    allowContext(before, after) {
      return !(/\S/.test(before) || /\S/.test(after));
    },

    getOptionCompletion(inserterItem) {
      const {
        name,
        initialAttributes,
        innerBlocks
      } = inserterItem;
      return {
        action: 'replace',
        value: Object(external_wp_blocks_["createBlock"])(name, initialAttributes, Object(external_wp_blocks_["createBlocksFromInnerBlocksTemplate"])(innerBlocks))
      };
    }

  };
}
/**
 * Creates a blocks repeater for replacing the current block with a selected block type.
 *
 * @return {WPCompleter} A blocks completer.
 */


/* harmony default export */ var autocompleters_block = (createBlockCompleter());

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/autocomplete/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



/**
 * Shared reference to an empty array for cases where it is important to avoid
 * returning a new array reference on every invocation.
 *
 * @type {Array}
 */

const EMPTY_ARRAY = [];

function useCompleters(_ref) {
  let {
    completers = EMPTY_ARRAY
  } = _ref;
  const {
    name
  } = Object(context["c" /* useBlockEditContext */])();
  return Object(external_wp_element_["useMemo"])(() => {
    let filteredCompleters = completers;

    if (name === Object(external_wp_blocks_["getDefaultBlockName"])() || Object(external_wp_blocks_["getBlockSupport"])(name, '__experimentalSlashInserter', false)) {
      filteredCompleters = filteredCompleters.concat([autocompleters_block]);
    }

    if (Object(external_wp_hooks_["hasFilter"])('editor.Autocomplete.completers')) {
      // Provide copies so filters may directly modify them.
      if (filteredCompleters === completers) {
        filteredCompleters = filteredCompleters.map(external_lodash_["clone"]);
      }

      filteredCompleters = Object(external_wp_hooks_["applyFilters"])('editor.Autocomplete.completers', filteredCompleters, name);
    }

    return filteredCompleters;
  }, [completers, name]);
}

function useBlockEditorAutocompleteProps(props) {
  return Object(external_wp_components_["__unstableUseAutocompleteProps"])({ ...props,
    completers: useCompleters(props)
  });
}
/**
 * Wrap the default Autocomplete component with one that supports a filter hook
 * for customizing its list of autocompleters.
 *
 * @type {import('react').FC}
 */

function BlockEditorAutocomplete(props) {
  return Object(external_wp_element_["createElement"])(external_wp_components_["Autocomplete"], Object(esm_extends["a" /* default */])({}, props, {
    completers: useCompleters(props)
  }));
}
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/autocomplete/README.md
 */


/* harmony default export */ var autocomplete = (BlockEditorAutocomplete);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-control/index.js + 4 modules
var block_alignment_control = __webpack_require__("vtO0");

// EXTERNAL MODULE: external ["wp","primitives"]
var external_wp_primitives_ = __webpack_require__("Tqx9");

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/fullscreen.js


/**
 * WordPress dependencies
 */

const fullscreen = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  d: "M4.2 9h1.5V5.8H9V4.2H4.2V9zm14 9.2H15v1.5h4.8V15h-1.5v3.2zM15 4.2v1.5h3.2V9h1.5V4.2H15zM5.8 15H4.2v4.8H9v-1.5H5.8V15z"
}));
/* harmony default export */ var library_fullscreen = (fullscreen);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-full-height-alignment-control/index.js


/**
 * WordPress dependencies
 */




function BlockFullHeightAlignmentControl(_ref) {
  let {
    isActive,
    label = Object(external_wp_i18n_["__"])('Toggle full height'),
    onToggle,
    isDisabled
  } = _ref;
  return Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
    isActive: isActive,
    icon: library_fullscreen,
    label: label,
    onClick: () => onToggle(!isActive),
    disabled: isDisabled
  });
}

/* harmony default export */ var block_full_height_alignment_control = (BlockFullHeightAlignmentControl);

// EXTERNAL MODULE: external ["wp","keycodes"]
var external_wp_keycodes_ = __webpack_require__("RxS6");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-alignment-matrix-control/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





function BlockAlignmentMatrixControl(props) {
  const {
    label = Object(external_wp_i18n_["__"])('Change matrix alignment'),
    onChange = external_lodash_["noop"],
    value = 'center',
    isDisabled
  } = props;
  const icon = Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalAlignmentMatrixControl"].Icon, {
    value: value
  });
  const className = 'block-editor-block-alignment-matrix-control';
  const popoverClassName = `${className}__popover`;
  const isAlternate = true;
  return Object(external_wp_element_["createElement"])(external_wp_components_["Dropdown"], {
    position: "bottom right",
    className: className,
    popoverProps: {
      className: popoverClassName,
      isAlternate
    },
    renderToggle: _ref => {
      let {
        onToggle,
        isOpen
      } = _ref;

      const openOnArrowDown = event => {
        if (!isOpen && event.keyCode === external_wp_keycodes_["DOWN"]) {
          event.preventDefault();
          onToggle();
        }
      };

      return Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
        onClick: onToggle,
        "aria-haspopup": "true",
        "aria-expanded": isOpen,
        onKeyDown: openOnArrowDown,
        label: label,
        icon: icon,
        showTooltip: true,
        disabled: isDisabled
      });
    },
    renderContent: () => Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalAlignmentMatrixControl"], {
      hasFocusBorder: false,
      onChange: onChange,
      value: value
    })
  });
}

/* harmony default export */ var block_alignment_matrix_control = (BlockAlignmentMatrixControl);

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/icon/index.js
var build_module_icon = __webpack_require__("iClF");

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-right-small.js


/**
 * WordPress dependencies
 */

const chevronRightSmall = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  d: "M10.8622 8.04053L14.2805 12.0286L10.8622 16.0167L9.72327 15.0405L12.3049 12.0286L9.72327 9.01672L10.8622 8.04053Z"
}));
/* harmony default export */ var chevron_right_small = (chevronRightSmall);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-title/index.js
var block_title = __webpack_require__("f8JO");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-breadcrumb/index.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



/**
 * Block breadcrumb component, displaying the hierarchy of the current block selection as a breadcrumb.
 *
 * @param {Object} props               Component props.
 * @param {string} props.rootLabelText Translated label for the root element of the breadcrumb trail.
 * @return {WPElement}                 Block Breadcrumb.
 */

function BlockBreadcrumb(_ref) {
  let {
    rootLabelText
  } = _ref;
  const {
    selectBlock,
    clearSelectedBlock
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const {
    clientId,
    parents,
    hasSelection
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      getSelectionStart,
      getSelectedBlockClientId,
      getBlockParents
    } = select(store["a" /* store */]);
    const selectedBlockClientId = getSelectedBlockClientId();
    return {
      parents: getBlockParents(selectedBlockClientId),
      clientId: selectedBlockClientId,
      hasSelection: !!getSelectionStart().clientId
    };
  }, []);

  const rootLabel = rootLabelText || Object(external_wp_i18n_["__"])('Document');
  /*
   * Disable reason: The `list` ARIA role is redundant but
   * Safari+VoiceOver won't announce the list otherwise.
   */

  /* eslint-disable jsx-a11y/no-redundant-roles */


  return Object(external_wp_element_["createElement"])("ul", {
    className: "block-editor-block-breadcrumb",
    role: "list",
    "aria-label": Object(external_wp_i18n_["__"])('Block breadcrumb')
  }, Object(external_wp_element_["createElement"])("li", {
    className: !hasSelection ? 'block-editor-block-breadcrumb__current' : undefined,
    "aria-current": !hasSelection ? 'true' : undefined
  }, hasSelection && Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    className: "block-editor-block-breadcrumb__button",
    variant: "tertiary",
    onClick: clearSelectedBlock
  }, rootLabel), !hasSelection && rootLabel, !!clientId && Object(external_wp_element_["createElement"])(build_module_icon["a" /* default */], {
    icon: chevron_right_small,
    className: "block-editor-block-breadcrumb__separator"
  })), parents.map(parentClientId => Object(external_wp_element_["createElement"])("li", {
    key: parentClientId
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    className: "block-editor-block-breadcrumb__button",
    variant: "tertiary",
    onClick: () => selectBlock(parentClientId)
  }, Object(external_wp_element_["createElement"])(block_title["a" /* default */], {
    clientId: parentClientId
  })), Object(external_wp_element_["createElement"])(build_module_icon["a" /* default */], {
    icon: chevron_right_small,
    className: "block-editor-block-breadcrumb__separator"
  }))), !!clientId && Object(external_wp_element_["createElement"])("li", {
    className: "block-editor-block-breadcrumb__current",
    "aria-current": "true"
  }, Object(external_wp_element_["createElement"])(block_title["a" /* default */], {
    clientId: clientId
  })))
  /* eslint-enable jsx-a11y/no-redundant-roles */
  ;
}

/* harmony default export */ var block_breadcrumb = (BlockBreadcrumb);

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__("TSYQ");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-content-overlay/index.js



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * External dependencies
 */


function BlockContentOverlay(_ref) {
  let {
    clientId,
    tagName: TagName = 'div',
    wrapperProps,
    className
  } = _ref;
  const baseClassName = 'block-editor-block-content-overlay';
  const [isOverlayActive, setIsOverlayActive] = Object(external_wp_element_["useState"])(true);
  const [isHovered, setIsHovered] = Object(external_wp_element_["useState"])(false);
  const {
    isParentSelected,
    hasChildSelected,
    isDraggingBlocks,
    isParentHighlighted
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      isBlockSelected,
      hasSelectedInnerBlock,
      isDraggingBlocks: _isDraggingBlocks,
      isBlockHighlighted
    } = select(store["a" /* store */]);
    return {
      isParentSelected: isBlockSelected(clientId),
      hasChildSelected: hasSelectedInnerBlock(clientId, true),
      isDraggingBlocks: _isDraggingBlocks(),
      isParentHighlighted: isBlockHighlighted(clientId)
    };
  }, [clientId]);
  const classes = classnames_default()(baseClassName, wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.className, className, {
    'overlay-active': isOverlayActive,
    'parent-highlighted': isParentHighlighted,
    'is-dragging-blocks': isDraggingBlocks
  });
  Object(external_wp_element_["useEffect"])(() => {
    // Reenable when blocks are not in use.
    if (!isParentSelected && !hasChildSelected && !isOverlayActive) {
      setIsOverlayActive(true);
    } // Disable if parent selected by another means (such as list view).
    // We check hover to ensure the overlay click interaction is not taking place.
    // Trying to click the overlay will select the parent block via its 'focusin'
    // listener on the wrapper, so if the block is selected while hovered we will
    // let the mouseup disable the overlay instead.


    if (isParentSelected && !isHovered && isOverlayActive) {
      setIsOverlayActive(false);
    } // Ensure overlay is disabled if a child block is selected.


    if (hasChildSelected && isOverlayActive) {
      setIsOverlayActive(false);
    }
  }, [isParentSelected, hasChildSelected, isOverlayActive, isHovered]); // Disabled because the overlay div doesn't actually have a role or functionality
  // as far as the a11y is concerned. We're just catching the first click so that
  // the block can be selected without interacting with its contents.

  /* eslint-disable jsx-a11y/no-static-element-interactions */

  return Object(external_wp_element_["createElement"])(TagName, Object(esm_extends["a" /* default */])({}, wrapperProps, {
    className: classes,
    onMouseEnter: () => setIsHovered(true),
    onMouseLeave: () => setIsHovered(false),
    onMouseUp: isOverlayActive ? () => setIsOverlayActive(false) : undefined
  }), wrapperProps === null || wrapperProps === void 0 ? void 0 : wrapperProps.children);
}
/* eslint-enable jsx-a11y/no-static-element-interactions */

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-context/index.js
var block_context = __webpack_require__("uoCR");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/index.js + 4 modules
var block_controls = __webpack_require__("fOYa");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/color-style-selector/index.js


/**
 * WordPress dependencies
 */




const ColorSelectorSVGIcon = () => Object(external_wp_element_["createElement"])(external_wp_components_["SVG"], {
  xmlns: "https://www.w3.org/2000/svg",
  viewBox: "0 0 20 20"
}, Object(external_wp_element_["createElement"])(external_wp_components_["Path"], {
  d: "M7.434 5l3.18 9.16H8.538l-.692-2.184H4.628l-.705 2.184H2L5.18 5h2.254zm-1.13 1.904h-.115l-1.148 3.593H7.44L6.304 6.904zM14.348 7.006c1.853 0 2.9.876 2.9 2.374v4.78h-1.79v-.914h-.114c-.362.64-1.123 1.022-2.031 1.022-1.346 0-2.292-.826-2.292-2.108 0-1.27.972-2.006 2.71-2.107l1.696-.102V9.38c0-.584-.42-.914-1.18-.914-.667 0-1.112.228-1.264.647h-1.701c.12-1.295 1.307-2.107 3.066-2.107zm1.079 4.1l-1.416.09c-.793.056-1.18.342-1.18.844 0 .52.45.837 1.091.837.857 0 1.505-.545 1.505-1.256v-.515z"
}));
/**
 * Color Selector Icon component.
 *
 * @param {Object} props           Component properties.
 * @param {Object} props.style     Style object.
 * @param {string} props.className Class name for component.
 *
 * @return {*} React Icon component.
 */


const ColorSelectorIcon = _ref => {
  let {
    style,
    className
  } = _ref;
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-library-colors-selector__icon-container"
  }, Object(external_wp_element_["createElement"])("div", {
    className: `${className} block-library-colors-selector__state-selection`,
    style: style
  }, Object(external_wp_element_["createElement"])(ColorSelectorSVGIcon, null)));
};
/**
 * Renders the Colors Selector Toolbar with the icon button.
 *
 * @param {Object} props                 Component properties.
 * @param {Object} props.TextColor       Text color component that wraps icon.
 * @param {Object} props.BackgroundColor Background color component that wraps icon.
 *
 * @return {*} React toggle button component.
 */


const renderToggleComponent = _ref2 => {
  let {
    TextColor,
    BackgroundColor
  } = _ref2;
  return _ref3 => {
    let {
      onToggle,
      isOpen
    } = _ref3;

    const openOnArrowDown = event => {
      if (!isOpen && event.keyCode === external_wp_keycodes_["DOWN"]) {
        event.preventDefault();
        onToggle();
      }
    };

    return Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarGroup"], null, Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
      className: "components-toolbar__control block-library-colors-selector__toggle",
      label: Object(external_wp_i18n_["__"])('Open Colors Selector'),
      onClick: onToggle,
      onKeyDown: openOnArrowDown,
      icon: Object(external_wp_element_["createElement"])(BackgroundColor, null, Object(external_wp_element_["createElement"])(TextColor, null, Object(external_wp_element_["createElement"])(ColorSelectorIcon, null)))
    }));
  };
};

const BlockColorsStyleSelector = _ref4 => {
  let {
    children,
    ...other
  } = _ref4;
  return Object(external_wp_element_["createElement"])(external_wp_components_["Dropdown"], {
    position: "bottom right",
    className: "block-library-colors-selector",
    contentClassName: "block-library-colors-selector__popover",
    renderToggle: renderToggleComponent(other),
    renderContent: () => children
  });
};

/* harmony default export */ var color_style_selector = (BlockColorsStyleSelector);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-edit/index.js + 1 modules
var block_edit = __webpack_require__("JRTi");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/list-view.js
var list_view = __webpack_require__("OzlF");

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/more-vertical.js
var more_vertical = __webpack_require__("VKE3");

// EXTERNAL MODULE: ./node_modules/@react-spring/web/dist/react-spring-web.esm.js
var react_spring_web_esm = __webpack_require__("+DUQ");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-moving-animation/index.js
var use_moving_animation = __webpack_require__("Xkls");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/leaf.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const AnimatedTreeGridRow = Object(react_spring_web_esm["animated"])(external_wp_components_["__experimentalTreeGridRow"]);
function ListViewLeaf(_ref) {
  let {
    isSelected,
    position,
    level,
    rowCount,
    children,
    className,
    path,
    ...props
  } = _ref;
  const ref = Object(use_moving_animation["a" /* default */])({
    isSelected,
    adjustScrolling: false,
    enableAnimation: true,
    triggerAnimationOnChange: path
  });
  return Object(external_wp_element_["createElement"])(AnimatedTreeGridRow, Object(esm_extends["a" /* default */])({
    ref: ref,
    className: classnames_default()('block-editor-list-view-leaf', className),
    level: level,
    positionInSet: position,
    setSize: rowCount
  }, props), children);
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-mover/button.js + 1 modules
var block_mover_button = __webpack_require__("9Ma0");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-block-display-information/index.js
var use_block_display_information = __webpack_require__("wC17");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/utils.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


const getBlockPositionDescription = (position, siblingCount, level) => Object(external_wp_i18n_["sprintf"])(
/* translators: 1: The numerical position of the block. 2: The total number of blocks. 3. The level of nesting for the block. */
Object(external_wp_i18n_["__"])('Block %1$d of %2$d, Level %3$d'), position, siblingCount, level);
/**
 * Returns true if the client ID occurs within the block selection or multi-selection,
 * or false otherwise.
 *
 * @param {string}          clientId               Block client ID.
 * @param {string|string[]} selectedBlockClientIds Selected block client ID, or an array of multi-selected blocks client IDs.
 *
 * @return {boolean} Whether the block is in multi-selection set.
 */

const isClientIdSelected = (clientId, selectedBlockClientIds) => Object(external_lodash_["isArray"])(selectedBlockClientIds) && selectedBlockClientIds.length ? selectedBlockClientIds.indexOf(clientId) !== -1 : selectedBlockClientIds === clientId;

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/expander.js


/**
 * WordPress dependencies
 */

function ListViewExpander(_ref) {
  let {
    onClick
  } = _ref;
  return (// Keyboard events are handled by TreeGrid see: components/src/tree-grid/index.js
    //
    // The expander component is implemented as a pseudo element in the w3 example
    // https://www.w3.org/TR/wai-aria-practices/examples/treegrid/treegrid-1.html
    //
    // We've mimicked this by adding an icon with aria-hidden set to true to hide this from the accessibility tree.
    // For the current tree grid implementation, please do not try to make this a button.
    //
    // eslint-disable-next-line jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions
    Object(external_wp_element_["createElement"])("span", {
      className: "block-editor-list-view__expander",
      onClick: event => onClick(event, {
        forceToggle: true
      }),
      "aria-hidden": "true"
    }, Object(external_wp_element_["createElement"])(build_module_icon["a" /* default */], {
      icon: chevron_right_small
    }))
  );
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/block-select-button.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */







function ListViewBlockSelectButton(_ref, ref) {
  let {
    className,
    block: {
      clientId
    },
    isSelected,
    onClick,
    onToggleExpanded,
    position,
    siblingBlockCount,
    level,
    tabIndex,
    onFocus,
    onDragStart,
    onDragEnd,
    draggable
  } = _ref;
  const blockInformation = Object(use_block_display_information["a" /* default */])(clientId);
  const instanceId = Object(external_wp_compose_["useInstanceId"])(ListViewBlockSelectButton);
  const descriptionId = `list-view-block-select-button__${instanceId}`;
  const blockPositionDescription = getBlockPositionDescription(position, siblingBlockCount, level);
  return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    className: classnames_default()('block-editor-list-view-block-select-button', className),
    onClick: onClick,
    "aria-describedby": descriptionId,
    ref: ref,
    tabIndex: tabIndex,
    onFocus: onFocus,
    onDragStart: onDragStart,
    onDragEnd: onDragEnd,
    draggable: draggable
  }, Object(external_wp_element_["createElement"])(ListViewExpander, {
    onClick: onToggleExpanded
  }), Object(external_wp_element_["createElement"])(block_icon["a" /* default */], {
    icon: blockInformation === null || blockInformation === void 0 ? void 0 : blockInformation.icon,
    showColors: true
  }), Object(external_wp_element_["createElement"])(block_title["a" /* default */], {
    clientId: clientId
  }), (blockInformation === null || blockInformation === void 0 ? void 0 : blockInformation.anchor) && Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-list-view-block-select-button__anchor"
  }, blockInformation.anchor), isSelected && Object(external_wp_element_["createElement"])(external_wp_components_["VisuallyHidden"], null, Object(external_wp_i18n_["__"])('(selected block)'))), Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-list-view-block-select-button__description",
    id: descriptionId
  }, blockPositionDescription));
}

/* harmony default export */ var block_select_button = (Object(external_wp_element_["forwardRef"])(ListViewBlockSelectButton));

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-draggable/index.js + 1 modules
var block_draggable = __webpack_require__("ZAjO");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/block-contents.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




const ListViewBlockContents = Object(external_wp_element_["forwardRef"])((_ref, ref) => {
  let {
    onClick,
    onToggleExpanded,
    block,
    isSelected,
    position,
    siblingBlockCount,
    level,
    ...props
  } = _ref;
  const {
    clientId
  } = block;
  const {
    blockMovingClientId,
    selectedBlockInBlockEditor
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      getBlockRootClientId,
      hasBlockMovingClientId,
      getSelectedBlockClientId
    } = select(store["a" /* store */]);
    return {
      rootClientId: getBlockRootClientId(clientId) || '',
      blockMovingClientId: hasBlockMovingClientId(),
      selectedBlockInBlockEditor: getSelectedBlockClientId()
    };
  }, [clientId]);
  const isBlockMoveTarget = blockMovingClientId && selectedBlockInBlockEditor === clientId;
  const className = classnames_default()('block-editor-list-view-block-contents', {
    'is-dropping-before': isBlockMoveTarget
  });
  return Object(external_wp_element_["createElement"])(block_draggable["a" /* default */], {
    clientIds: [block.clientId]
  }, _ref2 => {
    let {
      draggable,
      onDragStart,
      onDragEnd
    } = _ref2;
    return Object(external_wp_element_["createElement"])(block_select_button, Object(esm_extends["a" /* default */])({
      ref: ref,
      className: className,
      block: block,
      onClick: onClick,
      onToggleExpanded: onToggleExpanded,
      isSelected: isSelected,
      position: position,
      siblingBlockCount: siblingBlockCount,
      level: level,
      draggable: draggable,
      onDragStart: onDragStart,
      onDragEnd: onDragEnd
    }, props));
  });
});
/* harmony default export */ var block_contents = (ListViewBlockContents);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu/block-settings-dropdown.js + 4 modules
var block_settings_dropdown = __webpack_require__("1eGn");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/context.js
/**
 * WordPress dependencies
 */

const ListViewContext = Object(external_wp_element_["createContext"])({
  __experimentalFeatures: false,
  __experimentalPersistentListViewFeatures: false
});
const useListViewContext = () => Object(external_wp_element_["useContext"])(ListViewContext);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/block.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */








function ListViewBlock(_ref) {
  let {
    block,
    isDragged,
    isSelected,
    isBranchSelected,
    selectBlock,
    position,
    level,
    rowCount,
    siblingBlockCount,
    showBlockMovers,
    path,
    isExpanded
  } = _ref;
  const cellRef = Object(external_wp_element_["useRef"])(null);
  const [isHovered, setIsHovered] = Object(external_wp_element_["useState"])(false);
  const {
    clientId
  } = block;
  const {
    toggleBlockHighlight
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const {
    __experimentalFeatures: withExperimentalFeatures,
    __experimentalPersistentListViewFeatures: withExperimentalPersistentListViewFeatures,
    __experimentalHideContainerBlockActions: hideContainerBlockActions,
    isTreeGridMounted,
    expand,
    collapse
  } = useListViewContext();
  const hasSiblings = siblingBlockCount > 0;
  const hasRenderedMovers = showBlockMovers && hasSiblings;
  const moverCellClassName = classnames_default()('block-editor-list-view-block__mover-cell', {
    'is-visible': isHovered || isSelected
  });
  const listViewBlockSettingsClassName = classnames_default()('block-editor-list-view-block__menu-cell', {
    'is-visible': isHovered || isSelected
  }); // If ListView has experimental features related to the Persistent List View,
  // only focus the selected list item on mount; otherwise the list would always
  // try to steal the focus from the editor canvas.

  Object(external_wp_element_["useEffect"])(() => {
    if (withExperimentalPersistentListViewFeatures && !isTreeGridMounted && isSelected) {
      cellRef.current.focus();
    }
  }, []);
  const highlightBlock = withExperimentalPersistentListViewFeatures ? toggleBlockHighlight : () => {};
  const onMouseEnter = Object(external_wp_element_["useCallback"])(() => {
    setIsHovered(true);
    highlightBlock(clientId, true);
  }, [clientId, setIsHovered, highlightBlock]);
  const onMouseLeave = Object(external_wp_element_["useCallback"])(() => {
    setIsHovered(false);
    highlightBlock(clientId, false);
  }, [clientId, setIsHovered, highlightBlock]);
  const selectEditorBlock = Object(external_wp_element_["useCallback"])(event => {
    event.stopPropagation();
    selectBlock(clientId);
  }, [clientId, selectBlock]);
  const toggleExpanded = Object(external_wp_element_["useCallback"])(event => {
    event.stopPropagation();

    if (isExpanded === true) {
      collapse(clientId);
    } else if (isExpanded === false) {
      expand(clientId);
    }
  }, [clientId, expand, collapse, isExpanded]);
  const showBlockActions = withExperimentalFeatures && ( //hide actions for blocks like core/widget-areas
  !hideContainerBlockActions || hideContainerBlockActions && level > 1);
  const hideBlockActions = withExperimentalFeatures && !showBlockActions;
  let colSpan;

  if (hasRenderedMovers) {
    colSpan = 2;
  } else if (hideBlockActions) {
    colSpan = 3;
  }

  const classes = classnames_default()({
    'is-selected': isSelected,
    'is-branch-selected': withExperimentalPersistentListViewFeatures && isBranchSelected,
    'is-dragging': isDragged,
    'has-single-cell': hideBlockActions
  });
  return Object(external_wp_element_["createElement"])(ListViewLeaf, {
    className: classes,
    onMouseEnter: onMouseEnter,
    onMouseLeave: onMouseLeave,
    onFocus: onMouseEnter,
    onBlur: onMouseLeave,
    level: level,
    position: position,
    rowCount: rowCount,
    path: path,
    id: `list-view-block-${clientId}`,
    "data-block": clientId,
    isExpanded: isExpanded
  }, Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalTreeGridCell"], {
    className: "block-editor-list-view-block__contents-cell",
    colSpan: colSpan,
    ref: cellRef
  }, _ref2 => {
    let {
      ref,
      tabIndex,
      onFocus
    } = _ref2;
    return Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-list-view-block__contents-container"
    }, Object(external_wp_element_["createElement"])(block_contents, {
      block: block,
      onClick: selectEditorBlock,
      onToggleExpanded: toggleExpanded,
      isSelected: isSelected,
      position: position,
      siblingBlockCount: siblingBlockCount,
      level: level,
      ref: ref,
      tabIndex: tabIndex,
      onFocus: onFocus
    }));
  }), hasRenderedMovers && Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalTreeGridCell"], {
    className: moverCellClassName,
    withoutGridItem: true
  }, Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalTreeGridItem"], null, _ref3 => {
    let {
      ref,
      tabIndex,
      onFocus
    } = _ref3;
    return Object(external_wp_element_["createElement"])(block_mover_button["b" /* BlockMoverUpButton */], {
      orientation: "vertical",
      clientIds: [clientId],
      ref: ref,
      tabIndex: tabIndex,
      onFocus: onFocus
    });
  }), Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalTreeGridItem"], null, _ref4 => {
    let {
      ref,
      tabIndex,
      onFocus
    } = _ref4;
    return Object(external_wp_element_["createElement"])(block_mover_button["a" /* BlockMoverDownButton */], {
      orientation: "vertical",
      clientIds: [clientId],
      ref: ref,
      tabIndex: tabIndex,
      onFocus: onFocus
    });
  }))), showBlockActions && Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalTreeGridCell"], {
    className: listViewBlockSettingsClassName
  }, _ref5 => {
    let {
      ref,
      tabIndex,
      onFocus
    } = _ref5;
    return Object(external_wp_element_["createElement"])(block_settings_dropdown["a" /* default */], {
      clientIds: [clientId],
      icon: more_vertical["a" /* default */],
      toggleProps: {
        ref,
        className: 'block-editor-list-view-block__menu',
        tabIndex,
        onFocus
      },
      disableOpenOnArrowDown: true,
      __experimentalSelectBlock: selectEditorBlock
    });
  }));
}

/* harmony default export */ var list_view_block = (Object(external_wp_element_["memo"])(ListViewBlock));

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/branch.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




/**
 * Given a block, returns the total number of blocks in that subtree. This is used to help determine
 * the list position of a block.
 *
 * When a block is collapsed, we do not count their children as part of that total. In the current drag
 * implementation dragged blocks and their children are not counted.
 *
 * @param {Object} block            block tree
 * @param {Object} expandedState    state that notes which branches are collapsed
 * @param {Array}  draggedClientIds a list of dragged client ids
 * @return {number} block count
 */

function countBlocks(block, expandedState, draggedClientIds) {
  var _expandedState$block$;

  const isDragged = draggedClientIds === null || draggedClientIds === void 0 ? void 0 : draggedClientIds.includes(block.clientId);

  if (isDragged) {
    return 0;
  }

  const isExpanded = (_expandedState$block$ = expandedState[block.clientId]) !== null && _expandedState$block$ !== void 0 ? _expandedState$block$ : true;

  if (isExpanded) {
    return 1 + block.innerBlocks.reduce(countReducer(expandedState, draggedClientIds), 0);
  }

  return 1;
}

const countReducer = (expandedState, draggedClientIds) => (count, block) => {
  var _expandedState$block$2;

  const isDragged = draggedClientIds === null || draggedClientIds === void 0 ? void 0 : draggedClientIds.includes(block.clientId);

  if (isDragged) {
    return count;
  }

  const isExpanded = (_expandedState$block$2 = expandedState[block.clientId]) !== null && _expandedState$block$2 !== void 0 ? _expandedState$block$2 : true;

  if (isExpanded && block.innerBlocks.length > 0) {
    return count + countBlocks(block, expandedState, draggedClientIds);
  }

  return count + 1;
};

function ListViewBranch(props) {
  const {
    blocks,
    selectBlock,
    showBlockMovers,
    showNestedBlocks,
    selectedClientIds,
    level = 1,
    path = '',
    isBranchSelected = false,
    listPosition = 0,
    fixedListWindow
  } = props;
  const {
    expandedState,
    draggedClientIds,
    __experimentalPersistentListViewFeatures
  } = useListViewContext();
  const filteredBlocks = Object(external_lodash_["compact"])(blocks);
  const blockCount = filteredBlocks.length;
  let nextPosition = listPosition;
  return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, filteredBlocks.map((block, index) => {
    var _expandedState$client;

    const {
      clientId,
      innerBlocks
    } = block;

    if (index > 0) {
      nextPosition += countBlocks(filteredBlocks[index - 1], expandedState, draggedClientIds);
    }

    const usesWindowing = __experimentalPersistentListViewFeatures;
    const {
      itemInView
    } = fixedListWindow;
    const blockInView = !usesWindowing || itemInView(nextPosition);
    const position = index + 1;
    const updatedPath = path.length > 0 ? `${path}_${position}` : `${position}`;
    const hasNestedBlocks = showNestedBlocks && !!innerBlocks && !!innerBlocks.length;
    const isExpanded = hasNestedBlocks ? (_expandedState$client = expandedState[clientId]) !== null && _expandedState$client !== void 0 ? _expandedState$client : true : undefined;
    const isDragged = !!(draggedClientIds !== null && draggedClientIds !== void 0 && draggedClientIds.includes(clientId));
    const showBlock = isDragged || blockInView; // Make updates to the selected or dragged blocks synchronous,
    // but asynchronous for any other block.

    const isSelected = isClientIdSelected(clientId, selectedClientIds);
    const isSelectedBranch = isBranchSelected || isSelected && hasNestedBlocks;
    return Object(external_wp_element_["createElement"])(external_wp_data_["AsyncModeProvider"], {
      key: clientId,
      value: !isSelected
    }, showBlock && Object(external_wp_element_["createElement"])(list_view_block, {
      block: block,
      selectBlock: selectBlock,
      isSelected: isSelected,
      isBranchSelected: isSelectedBranch,
      isDragged: isDragged,
      level: level,
      position: position,
      rowCount: blockCount,
      siblingBlockCount: blockCount,
      showBlockMovers: showBlockMovers,
      path: updatedPath,
      isExpanded: isExpanded,
      listPosition: nextPosition
    }), !showBlock && Object(external_wp_element_["createElement"])("tr", null, Object(external_wp_element_["createElement"])("td", {
      className: "block-editor-list-view-placeholder"
    })), hasNestedBlocks && isExpanded && !isDragged && Object(external_wp_element_["createElement"])(ListViewBranch, {
      blocks: innerBlocks,
      selectBlock: selectBlock,
      showBlockMovers: showBlockMovers,
      showNestedBlocks: showNestedBlocks,
      level: level + 1,
      path: updatedPath,
      listPosition: nextPosition + 1,
      fixedListWindow: fixedListWindow,
      isBranchSelected: isSelectedBranch,
      selectedClientIds: selectedClientIds
    }));
  }));
}

ListViewBranch.defaultProps = {
  selectBlock: () => {}
};
/* harmony default export */ var branch = (Object(external_wp_element_["memo"])(ListViewBranch));

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/drop-indicator.js


/**
 * WordPress dependencies
 */


function ListViewDropIndicator(_ref) {
  let {
    listViewRef,
    blockDropTarget
  } = _ref;
  const {
    rootClientId,
    clientId,
    dropPosition
  } = blockDropTarget || {};
  const [rootBlockElement, blockElement] = Object(external_wp_element_["useMemo"])(() => {
    if (!listViewRef.current) {
      return [];
    } // The rootClientId will be defined whenever dropping into inner
    // block lists, but is undefined when dropping at the root level.


    const _rootBlockElement = rootClientId ? listViewRef.current.querySelector(`[data-block="${rootClientId}"]`) : undefined; // The clientId represents the sibling block, the dragged block will
    // usually be inserted adjacent to it. It will be undefined when
    // dropping a block into an empty block list.


    const _blockElement = clientId ? listViewRef.current.querySelector(`[data-block="${clientId}"]`) : undefined;

    return [_rootBlockElement, _blockElement];
  }, [rootClientId, clientId]); // The targetElement is the element that the drop indicator will appear
  // before or after. When dropping into an empty block list, blockElement
  // is undefined, so the indicator will appear after the rootBlockElement.

  const targetElement = blockElement || rootBlockElement;
  const getDropIndicatorIndent = Object(external_wp_element_["useCallback"])(() => {
    if (!rootBlockElement) {
      return 0;
    } // Calculate the indent using the block icon of the root block.
    // Using a classname selector here might be flaky and could be
    // improved.


    const targetElementRect = targetElement.getBoundingClientRect();
    const rootBlockIconElement = rootBlockElement.querySelector('.block-editor-block-icon');
    const rootBlockIconRect = rootBlockIconElement.getBoundingClientRect();
    return rootBlockIconRect.right - targetElementRect.left;
  }, [rootBlockElement, targetElement]);
  const style = Object(external_wp_element_["useMemo"])(() => {
    if (!targetElement) {
      return {};
    }

    const indent = getDropIndicatorIndent();
    return {
      width: targetElement.offsetWidth - indent
    };
  }, [getDropIndicatorIndent, targetElement]);
  const getAnchorRect = Object(external_wp_element_["useCallback"])(() => {
    if (!targetElement) {
      return {};
    }

    const ownerDocument = targetElement.ownerDocument;
    const rect = targetElement.getBoundingClientRect();
    const indent = getDropIndicatorIndent();
    const anchorRect = {
      left: rect.left + indent,
      right: rect.right,
      width: 0,
      height: rect.height,
      ownerDocument
    };

    if (dropPosition === 'top') {
      return { ...anchorRect,
        top: rect.top,
        bottom: rect.top
      };
    }

    if (dropPosition === 'bottom' || dropPosition === 'inside') {
      return { ...anchorRect,
        top: rect.bottom,
        bottom: rect.bottom
      };
    }

    return {};
  }, [targetElement, dropPosition, getDropIndicatorIndent]);

  if (!targetElement) {
    return null;
  }

  return Object(external_wp_element_["createElement"])(external_wp_components_["Popover"], {
    noArrow: true,
    animate: false,
    getAnchorRect: getAnchorRect,
    focusOnMount: false,
    className: "block-editor-list-view-drop-indicator"
  }, Object(external_wp_element_["createElement"])("div", {
    style: style,
    className: "block-editor-list-view-drop-indicator__line"
  }));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/use-list-view-client-ids.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function useListViewClientIds(blocks) {
  return Object(external_wp_data_["useSelect"])(select => {
    const {
      getDraggedBlockClientIds,
      getSelectedBlockClientIds,
      __unstableGetClientIdsTree
    } = select(store["a" /* store */]);
    return {
      selectedClientIds: getSelectedBlockClientIds(),
      draggedClientIds: getDraggedBlockClientIds(),
      clientIdsTree: blocks ? blocks : __unstableGetClientIdsTree()
    };
  }, [blocks]);
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/math.js
var math = __webpack_require__("vIlp");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-on-block-drop/index.js
var use_on_block_drop = __webpack_require__("/lNF");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/use-list-view-drop-zone.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




/** @typedef {import('../../utils/math').WPPoint} WPPoint */

/**
 * The type of a drag event.
 *
 * @typedef {'default'|'file'|'html'} WPDragEventType
 */

/**
 * An array representing data for blocks in the DOM used by drag and drop.
 *
 * @typedef {Object} WPListViewDropZoneBlocks
 * @property {string}  clientId                        The client id for the block.
 * @property {string}  rootClientId                    The root client id for the block.
 * @property {number}  blockIndex                      The block's index.
 * @property {Element} element                         The DOM element representing the block.
 * @property {number}  innerBlockCount                 The number of inner blocks the block has.
 * @property {boolean} isDraggedBlock                  Whether the block is currently being dragged.
 * @property {boolean} canInsertDraggedBlocksAsSibling Whether the dragged block can be a sibling of this block.
 * @property {boolean} canInsertDraggedBlocksAsChild   Whether the dragged block can be a child of this block.
 */

/**
 * An object containing details of a drop target.
 *
 * @typedef {Object} WPListViewDropZoneTarget
 * @property {string}                  blockIndex   The insertion index.
 * @property {string}                  rootClientId The root client id for the block.
 * @property {string|undefined}        clientId     The client id for the block.
 * @property {'top'|'bottom'|'inside'} dropPosition The position relative to the block that the user is dropping to.
 *                                                  'inside' refers to nesting as an inner block.
 */

/**
 * Is the point contained by the rectangle.
 *
 * @param {WPPoint} point The point.
 * @param {DOMRect} rect  The rectangle.
 *
 * @return {boolean} True if the point is contained by the rectangle, false otherwise.
 */

function isPointContainedByRect(point, rect) {
  return rect.left <= point.x && rect.right >= point.x && rect.top <= point.y && rect.bottom >= point.y;
}
/**
 * Determines whether the user positioning the dragged block to nest as an
 * inner block.
 *
 * Presently this is determined by whether the cursor is on the right hand side
 * of the block.
 *
 * @param {WPPoint} point The point representing the cursor position when dragging.
 * @param {DOMRect} rect  The rectangle.
 */


function isNestingGesture(point, rect) {
  const blockCenterX = rect.left + rect.width / 2;
  return point.x > blockCenterX;
} // Block navigation is always a vertical list, so only allow dropping
// to the above or below a block.


const ALLOWED_DROP_EDGES = ['top', 'bottom'];
/**
 * Given blocks data and the cursor position, compute the drop target.
 *
 * @param {WPListViewDropZoneBlocks} blocksData Data about the blocks in list view.
 * @param {WPPoint}                  position   The point representing the cursor position when dragging.
 *
 * @return {WPListViewDropZoneTarget} An object containing data about the drop target.
 */

function getListViewDropTarget(blocksData, position) {
  let candidateEdge;
  let candidateBlockData;
  let candidateDistance;
  let candidateRect;

  for (const blockData of blocksData) {
    if (blockData.isDraggedBlock) {
      continue;
    }

    const rect = blockData.element.getBoundingClientRect();
    const [distance, edge] = Object(math["a" /* getDistanceToNearestEdge */])(position, rect, ALLOWED_DROP_EDGES);
    const isCursorWithinBlock = isPointContainedByRect(position, rect);

    if (candidateDistance === undefined || distance < candidateDistance || isCursorWithinBlock) {
      candidateDistance = distance;
      const index = blocksData.indexOf(blockData);
      const previousBlockData = blocksData[index - 1]; // If dragging near the top of a block and the preceding block
      // is at the same level, use the preceding block as the candidate
      // instead, as later it makes determining a nesting drop easier.

      if (edge === 'top' && previousBlockData && previousBlockData.rootClientId === blockData.rootClientId && !previousBlockData.isDraggedBlock) {
        candidateBlockData = previousBlockData;
        candidateEdge = 'bottom';
        candidateRect = previousBlockData.element.getBoundingClientRect();
      } else {
        candidateBlockData = blockData;
        candidateEdge = edge;
        candidateRect = rect;
      } // If the mouse position is within the block, break early
      // as the user would intend to drop either before or after
      // this block.
      //
      // This solves an issue where some rows in the list view
      // tree overlap slightly due to sub-pixel rendering.


      if (isCursorWithinBlock) {
        break;
      }
    }
  }

  if (!candidateBlockData) {
    return;
  }

  const isDraggingBelow = candidateEdge === 'bottom'; // If the user is dragging towards the bottom of the block check whether
  // they might be trying to nest the block as a child.
  // If the block already has inner blocks, this should always be treated
  // as nesting since the next block in the tree will be the first child.

  if (isDraggingBelow && candidateBlockData.canInsertDraggedBlocksAsChild && (candidateBlockData.innerBlockCount > 0 || isNestingGesture(position, candidateRect))) {
    return {
      rootClientId: candidateBlockData.clientId,
      blockIndex: 0,
      dropPosition: 'inside'
    };
  } // If dropping as a sibling, but block cannot be inserted in
  // this context, return early.


  if (!candidateBlockData.canInsertDraggedBlocksAsSibling) {
    return;
  }

  const offset = isDraggingBelow ? 1 : 0;
  return {
    rootClientId: candidateBlockData.rootClientId,
    clientId: candidateBlockData.clientId,
    blockIndex: candidateBlockData.blockIndex + offset,
    dropPosition: candidateEdge
  };
}
/**
 * A react hook for implementing a drop zone in list view.
 *
 * @return {WPListViewDropZoneTarget} The drop target.
 */


function useListViewDropZone() {
  const {
    getBlockRootClientId,
    getBlockIndex,
    getBlockCount,
    getDraggedBlockClientIds,
    canInsertBlocks
  } = Object(external_wp_data_["useSelect"])(store["a" /* store */]);
  const [target, setTarget] = Object(external_wp_element_["useState"])();
  const {
    rootClientId: targetRootClientId,
    blockIndex: targetBlockIndex
  } = target || {};
  const onBlockDrop = Object(use_on_block_drop["a" /* default */])(targetRootClientId, targetBlockIndex);
  const draggedBlockClientIds = getDraggedBlockClientIds();
  const throttled = Object(external_wp_compose_["useThrottle"])(Object(external_wp_element_["useCallback"])((event, currentTarget) => {
    const position = {
      x: event.clientX,
      y: event.clientY
    };
    const isBlockDrag = !!(draggedBlockClientIds !== null && draggedBlockClientIds !== void 0 && draggedBlockClientIds.length);
    const blockElements = Array.from(currentTarget.querySelectorAll('[data-block]'));
    const blocksData = blockElements.map(blockElement => {
      const clientId = blockElement.dataset.block;
      const rootClientId = getBlockRootClientId(clientId);
      return {
        clientId,
        rootClientId,
        blockIndex: getBlockIndex(clientId),
        element: blockElement,
        isDraggedBlock: isBlockDrag ? draggedBlockClientIds.includes(clientId) : false,
        innerBlockCount: getBlockCount(clientId),
        canInsertDraggedBlocksAsSibling: isBlockDrag ? canInsertBlocks(draggedBlockClientIds, rootClientId) : true,
        canInsertDraggedBlocksAsChild: isBlockDrag ? canInsertBlocks(draggedBlockClientIds, clientId) : true
      };
    });
    const newTarget = getListViewDropTarget(blocksData, position);

    if (newTarget) {
      setTarget(newTarget);
    }
  }, [draggedBlockClientIds]), 200);
  const ref = Object(external_wp_compose_["__experimentalUseDropZone"])({
    onDrop: onBlockDrop,

    onDragOver(event) {
      // `currentTarget` is only available while the event is being
      // handled, so get it now and pass it to the thottled function.
      // https://developer.mozilla.org/en-US/docs/Web/API/Event/currentTarget
      throttled(event, event.currentTarget);
    },

    onDragEnd() {
      throttled.cancel();
      setTarget(null);
    }

  });
  return {
    ref,
    target
  };
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/list-view/index.js



/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */








const noop = () => {};

const list_view_expanded = (state, action) => {
  switch (action.type) {
    case 'expand':
      return { ...state,
        ...{
          [action.clientId]: true
        }
      };

    case 'collapse':
      return { ...state,
        ...{
          [action.clientId]: false
        }
      };

    default:
      return state;
  }
};
/**
 * Wrap `ListViewRows` with `TreeGrid`. ListViewRows is a
 * recursive component (it renders itself), so this ensures TreeGrid is only
 * present at the very top of the navigation grid.
 *
 * @param {Object}   props                                          Components props.
 * @param {Array}    props.blocks                                   Custom subset of block client IDs to be used instead of the default hierarchy.
 * @param {Function} props.onSelect                                 Block selection callback.
 * @param {boolean}  props.showNestedBlocks                         Flag to enable displaying nested blocks.
 * @param {boolean}  props.showBlockMovers                          Flag to enable block movers
 * @param {boolean}  props.__experimentalFeatures                   Flag to enable experimental features.
 * @param {boolean}  props.__experimentalPersistentListViewFeatures Flag to enable features for the Persistent List View experiment.
 * @param {boolean}  props.__experimentalHideContainerBlockActions  Flag to hide actions of top level blocks (like core/widget-area)
 * @param {Object}   ref                                            Forwarded ref
 */


function ListView(_ref, ref) {
  let {
    blocks,
    onSelect = noop,
    __experimentalFeatures,
    __experimentalPersistentListViewFeatures,
    __experimentalHideContainerBlockActions,
    showNestedBlocks,
    showBlockMovers,
    ...props
  } = _ref;
  const {
    clientIdsTree,
    draggedClientIds,
    selectedClientIds
  } = useListViewClientIds(blocks);
  const {
    selectBlock
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const {
    visibleBlockCount
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      getGlobalBlockCount,
      getClientIdsOfDescendants
    } = select(store["a" /* store */]);
    const draggedBlockCount = (draggedClientIds === null || draggedClientIds === void 0 ? void 0 : draggedClientIds.length) > 0 ? getClientIdsOfDescendants(draggedClientIds).length + 1 : 0;
    return {
      visibleBlockCount: getGlobalBlockCount() - draggedBlockCount
    };
  }, [draggedClientIds]);
  const selectEditorBlock = Object(external_wp_element_["useCallback"])(clientId => {
    selectBlock(clientId);
    onSelect(clientId);
  }, [selectBlock, onSelect]);
  const [expandedState, setExpandedState] = Object(external_wp_element_["useReducer"])(list_view_expanded, {});
  const {
    ref: dropZoneRef,
    target: blockDropTarget
  } = useListViewDropZone();
  const elementRef = Object(external_wp_element_["useRef"])();
  const treeGridRef = Object(external_wp_compose_["useMergeRefs"])([elementRef, dropZoneRef, ref]);
  const isMounted = Object(external_wp_element_["useRef"])(false);
  Object(external_wp_element_["useEffect"])(() => {
    isMounted.current = true;
  }, []); // List View renders a fixed number of items and relies on each having a fixed item height of 36px.
  // If this value changes, we should also change the itemHeight value set in useFixedWindowList.
  // See: https://github.com/WordPress/gutenberg/pull/35230 for additional context.

  const [fixedListWindow] = Object(external_wp_compose_["__experimentalUseFixedWindowList"])(elementRef, 36, visibleBlockCount, {
    useWindowing: __experimentalPersistentListViewFeatures,
    windowOverscan: 40
  });
  const expand = Object(external_wp_element_["useCallback"])(clientId => {
    if (!clientId) {
      return;
    }

    setExpandedState({
      type: 'expand',
      clientId
    });
  }, [setExpandedState]);
  const collapse = Object(external_wp_element_["useCallback"])(clientId => {
    if (!clientId) {
      return;
    }

    setExpandedState({
      type: 'collapse',
      clientId
    });
  }, [setExpandedState]);
  const expandRow = Object(external_wp_element_["useCallback"])(row => {
    var _row$dataset;

    expand(row === null || row === void 0 ? void 0 : (_row$dataset = row.dataset) === null || _row$dataset === void 0 ? void 0 : _row$dataset.block);
  }, [expand]);
  const collapseRow = Object(external_wp_element_["useCallback"])(row => {
    var _row$dataset2;

    collapse(row === null || row === void 0 ? void 0 : (_row$dataset2 = row.dataset) === null || _row$dataset2 === void 0 ? void 0 : _row$dataset2.block);
  }, [collapse]);
  const contextValue = Object(external_wp_element_["useMemo"])(() => ({
    __experimentalFeatures,
    __experimentalPersistentListViewFeatures,
    __experimentalHideContainerBlockActions,
    isTreeGridMounted: isMounted.current,
    draggedClientIds,
    expandedState,
    expand,
    collapse
  }), [__experimentalFeatures, __experimentalPersistentListViewFeatures, __experimentalHideContainerBlockActions, isMounted.current, draggedClientIds, expandedState, expand, collapse]);
  return Object(external_wp_element_["createElement"])(external_wp_data_["AsyncModeProvider"], {
    value: true
  }, Object(external_wp_element_["createElement"])(ListViewDropIndicator, {
    listViewRef: elementRef,
    blockDropTarget: blockDropTarget
  }), Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalTreeGrid"], {
    className: "block-editor-list-view-tree",
    "aria-label": Object(external_wp_i18n_["__"])('Block navigation structure'),
    ref: treeGridRef,
    onCollapseRow: collapseRow,
    onExpandRow: expandRow
  }, Object(external_wp_element_["createElement"])(ListViewContext.Provider, {
    value: contextValue
  }, Object(external_wp_element_["createElement"])(branch, Object(esm_extends["a" /* default */])({
    blocks: clientIdsTree,
    selectBlock: selectEditorBlock,
    showNestedBlocks: showNestedBlocks,
    showBlockMovers: showBlockMovers,
    fixedListWindow: fixedListWindow,
    selectedClientIds: selectedClientIds
  }, props)))));
}

/* harmony default export */ var components_list_view = (Object(external_wp_element_["forwardRef"])(ListView));

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-navigation/dropdown.js



/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




function BlockNavigationDropdownToggle(_ref) {
  let {
    isEnabled,
    onToggle,
    isOpen,
    innerRef,
    ...props
  } = _ref;
  return Object(external_wp_element_["createElement"])(external_wp_components_["Button"], Object(esm_extends["a" /* default */])({}, props, {
    ref: innerRef,
    icon: list_view["a" /* default */],
    "aria-expanded": isOpen,
    "aria-haspopup": "true",
    onClick: isEnabled ? onToggle : undefined
    /* translators: button label text should, if possible, be under 16 characters. */
    ,
    label: Object(external_wp_i18n_["__"])('List view'),
    className: "block-editor-block-navigation",
    "aria-disabled": !isEnabled
  }));
}

function BlockNavigationDropdown(_ref2, ref) {
  let {
    isDisabled,
    __experimentalFeatures,
    ...props
  } = _ref2;
  const hasBlocks = Object(external_wp_data_["useSelect"])(select => !!select(store["a" /* store */]).getBlockCount(), []);
  const isEnabled = hasBlocks && !isDisabled;
  return Object(external_wp_element_["createElement"])(external_wp_components_["Dropdown"], {
    contentClassName: "block-editor-block-navigation__popover",
    position: "bottom right",
    renderToggle: _ref3 => {
      let {
        isOpen,
        onToggle
      } = _ref3;
      return Object(external_wp_element_["createElement"])(BlockNavigationDropdownToggle, Object(esm_extends["a" /* default */])({}, props, {
        innerRef: ref,
        isOpen: isOpen,
        onToggle: onToggle,
        isEnabled: isEnabled
      }));
    },
    renderContent: () => Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-block-navigation__container"
    }, Object(external_wp_element_["createElement"])("p", {
      className: "block-editor-block-navigation__label"
    }, Object(external_wp_i18n_["__"])('List view')), Object(external_wp_element_["createElement"])(components_list_view, {
      showNestedBlocks: true,
      __experimentalFeatures: __experimentalFeatures
    }))
  });
}

/* harmony default export */ var dropdown = (Object(external_wp_element_["forwardRef"])(BlockNavigationDropdown));

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/layout.js
var layout = __webpack_require__("Civd");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-variation-picker/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





function BlockVariationPicker(_ref) {
  let {
    icon = layout["a" /* default */],
    label = Object(external_wp_i18n_["__"])('Choose variation'),
    instructions = Object(external_wp_i18n_["__"])('Select a variation to start with.'),
    variations,
    onSelect,
    allowSkip
  } = _ref;
  const classes = classnames_default()('block-editor-block-variation-picker', {
    'has-many-variations': variations.length > 4
  });
  return Object(external_wp_element_["createElement"])(external_wp_components_["Placeholder"], {
    icon: icon,
    label: label,
    instructions: instructions,
    className: classes
  }, Object(external_wp_element_["createElement"])("ul", {
    className: "block-editor-block-variation-picker__variations",
    role: "list",
    "aria-label": Object(external_wp_i18n_["__"])('Block variations')
  }, variations.map(variation => Object(external_wp_element_["createElement"])("li", {
    key: variation.name
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    variant: "secondary",
    icon: variation.icon,
    iconSize: 48,
    onClick: () => onSelect(variation),
    className: "block-editor-block-variation-picker__variation",
    label: variation.description || variation.title
  }), Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-block-variation-picker__variation-label",
    role: "presentation"
  }, variation.title)))), allowSkip && Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-variation-picker__skip"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    variant: "link",
    onClick: () => onSelect()
  }, Object(external_wp_i18n_["__"])('Skip'))));
}

/* harmony default export */ var block_variation_picker = (BlockVariationPicker);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-preview/index.js + 2 modules
var block_preview = __webpack_require__("REKd");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-left.js
var chevron_left = __webpack_require__("2gm7");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-right.js
var chevron_right = __webpack_require__("1iEr");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/stretch-full-width.js
var stretch_full_width = __webpack_require__("XNw2");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/grid.js
var grid = __webpack_require__("b2RC");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-pattern-setup/constants.js
const VIEWMODES = {
  carousel: 'carousel',
  grid: 'grid'
};

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-pattern-setup/setup-toolbar.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const Actions = _ref => {
  let {
    onStartBlank,
    onBlockPatternSelect
  } = _ref;
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-pattern-setup__actions"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    onClick: onStartBlank
  }, Object(external_wp_i18n_["__"])('Start blank')), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    variant: "primary",
    onClick: onBlockPatternSelect
  }, Object(external_wp_i18n_["__"])('Choose')));
};

const CarouselNavigation = _ref2 => {
  let {
    handlePrevious,
    handleNext,
    activeSlide,
    totalSlides
  } = _ref2;
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-pattern-setup__navigation"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    icon: chevron_left["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Previous pattern'),
    onClick: handlePrevious,
    disabled: activeSlide === 0
  }), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    icon: chevron_right["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Next pattern'),
    onClick: handleNext,
    disabled: activeSlide === totalSlides - 1
  }));
};

const SetupToolbar = _ref3 => {
  let {
    viewMode,
    setViewMode,
    handlePrevious,
    handleNext,
    activeSlide,
    totalSlides,
    onBlockPatternSelect,
    onStartBlank
  } = _ref3;
  const isCarouselView = viewMode === VIEWMODES.carousel;
  const displayControls = Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-pattern-setup__display-controls"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    icon: stretch_full_width["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Carousel view'),
    onClick: () => setViewMode(VIEWMODES.carousel),
    isPressed: isCarouselView
  }), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    icon: grid["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Grid view'),
    onClick: () => setViewMode(VIEWMODES.grid),
    isPressed: viewMode === VIEWMODES.grid
  }));
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-pattern-setup__toolbar"
  }, isCarouselView && Object(external_wp_element_["createElement"])(CarouselNavigation, {
    handlePrevious: handlePrevious,
    handleNext: handleNext,
    activeSlide: activeSlide,
    totalSlides: totalSlides
  }), displayControls, isCarouselView && Object(external_wp_element_["createElement"])(Actions, {
    onBlockPatternSelect: onBlockPatternSelect,
    onStartBlank: onStartBlank
  }));
};

/* harmony default export */ var setup_toolbar = (SetupToolbar);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-pattern-setup/use-patterns-setup.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



function usePatternsSetup(clientId, blockName, filterPatternsFn) {
  return Object(external_wp_data_["useSelect"])(select => {
    const {
      getBlockRootClientId,
      __experimentalGetPatternsByBlockTypes,
      __experimentalGetAllowedPatterns
    } = select(store["a" /* store */]);
    const rootClientId = getBlockRootClientId(clientId);

    if (filterPatternsFn) {
      return __experimentalGetAllowedPatterns(rootClientId).filter(filterPatternsFn);
    }

    return __experimentalGetPatternsByBlockTypes(blockName, rootClientId);
  }, [clientId, blockName, filterPatternsFn]);
}

/* harmony default export */ var use_patterns_setup = (usePatternsSetup);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-pattern-setup/index.js



/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */







const SetupContent = _ref => {
  let {
    viewMode,
    activeSlide,
    patterns,
    onBlockPatternSelect
  } = _ref;
  const composite = Object(external_wp_components_["__unstableUseCompositeState"])();
  const containerClass = 'block-editor-block-pattern-setup__container';

  if (viewMode === VIEWMODES.carousel) {
    const slideClass = new Map([[activeSlide, 'active-slide'], [activeSlide - 1, 'previous-slide'], [activeSlide + 1, 'next-slide']]);
    return Object(external_wp_element_["createElement"])("div", {
      className: containerClass
    }, Object(external_wp_element_["createElement"])("ul", {
      className: "carousel-container"
    }, patterns.map((pattern, index) => Object(external_wp_element_["createElement"])(BlockPatternSlide, {
      className: slideClass.get(index) || '',
      key: pattern.name,
      pattern: pattern
    }))));
  }

  return Object(external_wp_element_["createElement"])(external_wp_components_["__unstableComposite"], Object(esm_extends["a" /* default */])({}, composite, {
    role: "listbox",
    className: containerClass,
    "aria-label": Object(external_wp_i18n_["__"])('Patterns list')
  }), patterns.map(pattern => Object(external_wp_element_["createElement"])(BlockPattern, {
    key: pattern.name,
    pattern: pattern,
    onSelect: onBlockPatternSelect,
    composite: composite
  })));
};

function BlockPattern(_ref2) {
  let {
    pattern,
    onSelect,
    composite
  } = _ref2;
  const baseClassName = 'block-editor-block-pattern-setup-list';
  const {
    blocks,
    title,
    description,
    viewportWidth = 700
  } = pattern;
  const descriptionId = Object(external_wp_compose_["useInstanceId"])(BlockPattern, `${baseClassName}__item-description`);
  return Object(external_wp_element_["createElement"])("div", {
    className: `${baseClassName}__list-item`,
    "aria-label": pattern.title,
    "aria-describedby": pattern.description ? descriptionId : undefined
  }, Object(external_wp_element_["createElement"])(external_wp_components_["__unstableCompositeItem"], Object(esm_extends["a" /* default */])({
    role: "option",
    as: "div"
  }, composite, {
    className: `${baseClassName}__item`,
    onClick: () => onSelect(blocks)
  }), Object(external_wp_element_["createElement"])(block_preview["a" /* default */], {
    blocks: blocks,
    viewportWidth: viewportWidth
  }), Object(external_wp_element_["createElement"])("div", {
    className: `${baseClassName}__item-title`
  }, title)), !!description && Object(external_wp_element_["createElement"])(external_wp_components_["VisuallyHidden"], {
    id: descriptionId
  }, description));
}

function BlockPatternSlide(_ref3) {
  let {
    className,
    pattern
  } = _ref3;
  const {
    blocks,
    title,
    description
  } = pattern;
  const descriptionId = Object(external_wp_compose_["useInstanceId"])(BlockPatternSlide, 'block-editor-block-pattern-setup-list__item-description');
  return Object(external_wp_element_["createElement"])("li", {
    className: `pattern-slide ${className}`,
    "aria-label": title,
    "aria-describedby": description ? descriptionId : undefined
  }, Object(external_wp_element_["createElement"])(block_preview["a" /* default */], {
    blocks: blocks,
    __experimentalLive: true
  }), !!description && Object(external_wp_element_["createElement"])(external_wp_components_["VisuallyHidden"], {
    id: descriptionId
  }, description));
}

const BlockPatternSetup = _ref4 => {
  let {
    clientId,
    blockName,
    filterPatternsFn,
    startBlankComponent,
    onBlockPatternSelect
  } = _ref4;
  const [viewMode, setViewMode] = Object(external_wp_element_["useState"])(VIEWMODES.carousel);
  const [activeSlide, setActiveSlide] = Object(external_wp_element_["useState"])(0);
  const [showBlank, setShowBlank] = Object(external_wp_element_["useState"])(false);
  const {
    replaceBlock
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const patterns = use_patterns_setup(clientId, blockName, filterPatternsFn);

  if (!(patterns !== null && patterns !== void 0 && patterns.length) || showBlank) {
    return startBlankComponent;
  }

  const onBlockPatternSelectDefault = blocks => {
    const clonedBlocks = blocks.map(block => Object(external_wp_blocks_["cloneBlock"])(block));
    replaceBlock(clientId, clonedBlocks);
  };

  const onPatternSelectCallback = onBlockPatternSelect || onBlockPatternSelectDefault;
  return Object(external_wp_element_["createElement"])("div", {
    className: `block-editor-block-pattern-setup view-mode-${viewMode}`
  }, Object(external_wp_element_["createElement"])(setup_toolbar, {
    viewMode: viewMode,
    setViewMode: setViewMode,
    activeSlide: activeSlide,
    totalSlides: patterns.length,
    handleNext: () => {
      setActiveSlide(active => active + 1);
    },
    handlePrevious: () => {
      setActiveSlide(active => active - 1);
    },
    onBlockPatternSelect: () => {
      onPatternSelectCallback(patterns[activeSlide].blocks);
    },
    onStartBlank: () => {
      setShowBlank(true);
    }
  }), Object(external_wp_element_["createElement"])(SetupContent, {
    viewMode: viewMode,
    activeSlide: activeSlide,
    patterns: patterns,
    onBlockPatternSelect: onPatternSelectCallback
  }));
};

/* harmony default export */ var block_pattern_setup = (BlockPatternSetup);

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-down.js
var chevron_down = __webpack_require__("NWDH");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/block-variation-transforms.js
var block_variation_transforms = __webpack_require__("Btt3");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-variation-transforms/index.js


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




function __experimentalBlockVariationTransforms(_ref) {
  let {
    blockClientId
  } = _ref;
  const [selectedValue, setSelectedValue] = Object(external_wp_element_["useState"])();
  const {
    updateBlockAttributes
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const {
    variations,
    blockAttributes
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      getBlockVariations
    } = select(external_wp_blocks_["store"]);
    const {
      getBlockName,
      getBlockAttributes
    } = select(store["a" /* store */]);
    const blockName = blockClientId && getBlockName(blockClientId);
    return {
      variations: blockName && getBlockVariations(blockName, 'transform'),
      blockAttributes: getBlockAttributes(blockClientId)
    };
  }, [blockClientId]);
  Object(external_wp_element_["useEffect"])(() => {
    var _getMatchingVariation;

    setSelectedValue((_getMatchingVariation = Object(block_variation_transforms["a" /* __experimentalGetMatchingVariation */])(blockAttributes, variations)) === null || _getMatchingVariation === void 0 ? void 0 : _getMatchingVariation.name);
  }, [blockAttributes, variations]);
  if (!(variations !== null && variations !== void 0 && variations.length)) return null;
  const selectOptions = variations.map(_ref2 => {
    let {
      name,
      title,
      description
    } = _ref2;
    return {
      value: name,
      label: title,
      info: description
    };
  });

  const onSelectVariation = variationName => {
    updateBlockAttributes(blockClientId, { ...variations.find(_ref3 => {
        let {
          name
        } = _ref3;
        return name === variationName;
      }).attributes
    });
  };

  const baseClass = 'block-editor-block-variation-transforms';
  return Object(external_wp_element_["createElement"])(external_wp_components_["DropdownMenu"], {
    className: baseClass,
    label: Object(external_wp_i18n_["__"])('Transform to variation'),
    text: Object(external_wp_i18n_["__"])('Transform to variation'),
    popoverProps: {
      position: 'bottom center',
      className: `${baseClass}__popover`
    },
    icon: chevron_down["a" /* default */],
    toggleProps: {
      iconPosition: 'right'
    }
  }, () => Object(external_wp_element_["createElement"])("div", {
    className: `${baseClass}__container`
  }, Object(external_wp_element_["createElement"])(external_wp_components_["MenuGroup"], null, Object(external_wp_element_["createElement"])(external_wp_components_["MenuItemsChoice"], {
    choices: selectOptions,
    value: selectedValue,
    onSelect: onSelectVariation
  }))));
}

/* harmony default export */ var components_block_variation_transforms = (__experimentalBlockVariationTransforms);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/icons.js


/**
 * WordPress dependencies
 */

const alignBottom = Object(external_wp_element_["createElement"])(external_wp_components_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_components_["Path"], {
  d: "M15 4H9v11h6V4zM4 18.5V20h16v-1.5H4z"
}));
const alignCenter = Object(external_wp_element_["createElement"])(external_wp_components_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_components_["Path"], {
  d: "M20 11h-5V4H9v7H4v1.5h5V20h6v-7.5h5z"
}));
const alignTop = Object(external_wp_element_["createElement"])(external_wp_components_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_components_["Path"], {
  d: "M9 20h6V9H9v11zM4 4v1.5h16V4H4z"
}));

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/ui.js



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const BLOCK_ALIGNMENTS_CONTROLS = {
  top: {
    icon: alignTop,
    title: Object(external_wp_i18n_["_x"])('Align top', 'Block vertical alignment setting')
  },
  center: {
    icon: alignCenter,
    title: Object(external_wp_i18n_["_x"])('Align middle', 'Block vertical alignment setting')
  },
  bottom: {
    icon: alignBottom,
    title: Object(external_wp_i18n_["_x"])('Align bottom', 'Block vertical alignment setting')
  }
};
const DEFAULT_CONTROLS = ['top', 'center', 'bottom'];
const DEFAULT_CONTROL = 'top';
const block_vertical_alignment_control_ui_POPOVER_PROPS = {
  isAlternate: true
};

function BlockVerticalAlignmentUI(_ref) {
  let {
    value,
    onChange,
    controls = DEFAULT_CONTROLS,
    isCollapsed = true,
    isToolbar
  } = _ref;

  function applyOrUnset(align) {
    return () => onChange(value === align ? undefined : align);
  }

  const activeAlignment = BLOCK_ALIGNMENTS_CONTROLS[value];
  const defaultAlignmentControl = BLOCK_ALIGNMENTS_CONTROLS[DEFAULT_CONTROL];
  const UIComponent = isToolbar ? external_wp_components_["ToolbarGroup"] : external_wp_components_["ToolbarDropdownMenu"];
  const extraProps = isToolbar ? {
    isCollapsed
  } : {};
  return Object(external_wp_element_["createElement"])(UIComponent, Object(esm_extends["a" /* default */])({
    popoverProps: block_vertical_alignment_control_ui_POPOVER_PROPS,
    icon: activeAlignment ? activeAlignment.icon : defaultAlignmentControl.icon,
    label: Object(external_wp_i18n_["_x"])('Change vertical alignment', 'Block vertical alignment setting label'),
    controls: controls.map(control => {
      return { ...BLOCK_ALIGNMENTS_CONTROLS[control],
        isActive: value === control,
        role: isCollapsed ? 'menuitemradio' : undefined,
        onClick: applyOrUnset(control)
      };
    })
  }, extraProps));
}
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-vertical-alignment-toolbar/README.md
 */


/* harmony default export */ var block_vertical_alignment_control_ui = (BlockVerticalAlignmentUI);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-vertical-alignment-control/index.js



/**
 * Internal dependencies
 */

function BlockVerticalAlignmentControl(props) {
  return Object(external_wp_element_["createElement"])(block_vertical_alignment_control_ui, Object(esm_extends["a" /* default */])({}, props, {
    isToolbar: false
  }));
}
function BlockVerticalAlignmentToolbar(props) {
  return Object(external_wp_element_["createElement"])(block_vertical_alignment_control_ui, Object(esm_extends["a" /* default */])({}, props, {
    isToolbar: true
  }));
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/border-radius-control/index.js + 4 modules
var border_radius_control = __webpack_require__("Wy3j");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/border-style-control/index.js + 2 modules
var border_style_control = __webpack_require__("2YCo");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/button-block-appender/index.js
var button_block_appender = __webpack_require__("I5Hl");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-setting/index.js
var use_setting = __webpack_require__("v5LD");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/color-palette/with-color-context.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/* harmony default export */ var with_color_context = (Object(external_wp_compose_["createHigherOrderComponent"])(WrappedComponent => {
  return props => {
    const colorsFeature = Object(use_setting["a" /* default */])('color.palette');
    const disableCustomColorsFeature = !Object(use_setting["a" /* default */])('color.custom');
    const colors = props.colors === undefined ? colorsFeature : props.colors;
    const disableCustomColors = props.disableCustomColors === undefined ? disableCustomColorsFeature : props.disableCustomColors;
    const hasColorsToChoose = !Object(external_lodash_["isEmpty"])(colors) || !disableCustomColors;
    return Object(external_wp_element_["createElement"])(WrappedComponent, Object(esm_extends["a" /* default */])({}, props, {
      colors,
      disableCustomColors,
      hasColorsToChoose
    }));
  };
}, 'withColorContext'));

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/color-palette/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


/* harmony default export */ var color_palette = (with_color_context(external_wp_components_["ColorPalette"]));

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/colors-gradients/control.js
var control = __webpack_require__("hMaJ");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/color-palette/control.js



/**
 * Internal dependencies
 */

function ColorPaletteControl(_ref) {
  let {
    onChange,
    value,
    ...otherProps
  } = _ref;
  return Object(external_wp_element_["createElement"])(control["a" /* default */], Object(esm_extends["a" /* default */])({}, otherProps, {
    onColorChange: onChange,
    colorValue: value,
    gradients: [],
    disableCustomGradients: true
  }));
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/contrast-checker/index.js
var contrast_checker = __webpack_require__("6c9H");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/duotone-control/index.js
var duotone_control = __webpack_require__("1uGa");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-appearance-control/index.js
var font_appearance_control = __webpack_require__("Bo0k");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-family/index.js
var font_family = __webpack_require__("GKUk");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/letter-spacing-control/index.js
var letter_spacing_control = __webpack_require__("xBDm");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/text-decoration-control/index.js + 1 modules
var text_decoration_control = __webpack_require__("kVRd");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/text-transform-control/index.js + 3 modules
var text_transform_control = __webpack_require__("/Hvg");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/colors-gradients/dropdown.js
var colors_gradients_dropdown = __webpack_require__("dchM");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/colors-gradients/panel-color-gradient-settings.js
var panel_color_gradient_settings = __webpack_require__("yU1v");

// CONCATENATED MODULE: ./node_modules/react-easy-crop/node_modules/tslib/tslib.es6.js
/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: n === "return" } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, privateMap) {
    if (!privateMap.has(receiver)) {
        throw new TypeError("attempted to get private field on non-instance");
    }
    return privateMap.get(receiver);
}

function __classPrivateFieldSet(receiver, privateMap, value) {
    if (!privateMap.has(receiver)) {
        throw new TypeError("attempted to set private field on non-instance");
    }
    privateMap.set(receiver, value);
    return value;
}

// EXTERNAL MODULE: external "React"
var external_React_ = __webpack_require__("cDcd");
var external_React_default = /*#__PURE__*/__webpack_require__.n(external_React_);

// EXTERNAL MODULE: ./node_modules/normalize-wheel/index.js
var normalize_wheel = __webpack_require__("wJiJ");
var normalize_wheel_default = /*#__PURE__*/__webpack_require__.n(normalize_wheel);

// CONCATENATED MODULE: ./node_modules/react-easy-crop/index.module.js




/**
 * Compute the dimension of the crop area based on media size,
 * aspect ratio and optionally rotation
 */

function getCropSize(mediaWidth, mediaHeight, containerWidth, containerHeight, aspect, rotation) {
  if (rotation === void 0) {
    rotation = 0;
  }

  var _a = translateSize(mediaWidth, mediaHeight, rotation),
      width = _a.width,
      height = _a.height;

  var fittingWidth = Math.min(width, containerWidth);
  var fittingHeight = Math.min(height, containerHeight);

  if (fittingWidth > fittingHeight * aspect) {
    return {
      width: fittingHeight * aspect,
      height: fittingHeight
    };
  }

  return {
    width: fittingWidth,
    height: fittingWidth / aspect
  };
}
/**
 * Ensure a new media position stays in the crop area.
 */

function index_module_restrictPosition(position, mediaSize, cropSize, zoom, rotation) {
  if (rotation === void 0) {
    rotation = 0;
  }

  var _a = translateSize(mediaSize.width, mediaSize.height, rotation),
      width = _a.width,
      height = _a.height;

  return {
    x: restrictPositionCoord(position.x, width, cropSize.width, zoom),
    y: restrictPositionCoord(position.y, height, cropSize.height, zoom)
  };
}

function restrictPositionCoord(position, mediaSize, cropSize, zoom) {
  var maxPosition = mediaSize * zoom / 2 - cropSize / 2;
  return Math.min(maxPosition, Math.max(position, -maxPosition));
}

function getDistanceBetweenPoints(pointA, pointB) {
  return Math.sqrt(Math.pow(pointA.y - pointB.y, 2) + Math.pow(pointA.x - pointB.x, 2));
}
function getRotationBetweenPoints(pointA, pointB) {
  return Math.atan2(pointB.y - pointA.y, pointB.x - pointA.x) * 180 / Math.PI;
}
/**
 * Compute the output cropped area of the media in percentages and pixels.
 * x/y are the top-left coordinates on the src media
 */

function computeCroppedArea(crop, mediaSize, cropSize, aspect, zoom, rotation, restrictPosition) {
  if (rotation === void 0) {
    rotation = 0;
  }

  if (restrictPosition === void 0) {
    restrictPosition = true;
  } // if the media is rotated by the user, we cannot limit the position anymore
  // as it might need to be negative.


  var limitAreaFn = restrictPosition && rotation === 0 ? limitArea : noOp;
  var croppedAreaPercentages = {
    x: limitAreaFn(100, ((mediaSize.width - cropSize.width / zoom) / 2 - crop.x / zoom) / mediaSize.width * 100),
    y: limitAreaFn(100, ((mediaSize.height - cropSize.height / zoom) / 2 - crop.y / zoom) / mediaSize.height * 100),
    width: limitAreaFn(100, cropSize.width / mediaSize.width * 100 / zoom),
    height: limitAreaFn(100, cropSize.height / mediaSize.height * 100 / zoom)
  }; // we compute the pixels size naively

  var widthInPixels = Math.round(limitAreaFn(mediaSize.naturalWidth, croppedAreaPercentages.width * mediaSize.naturalWidth / 100));
  var heightInPixels = Math.round(limitAreaFn(mediaSize.naturalHeight, croppedAreaPercentages.height * mediaSize.naturalHeight / 100));
  var isImgWiderThanHigh = mediaSize.naturalWidth >= mediaSize.naturalHeight * aspect; // then we ensure the width and height exactly match the aspect (to avoid rounding approximations)
  // if the media is wider than high, when zoom is 0, the crop height will be equals to iamge height
  // thus we want to compute the width from the height and aspect for accuracy.
  // Otherwise, we compute the height from width and aspect.

  var sizePixels = isImgWiderThanHigh ? {
    width: Math.round(heightInPixels * aspect),
    height: heightInPixels
  } : {
    width: widthInPixels,
    height: Math.round(widthInPixels / aspect)
  };

  var croppedAreaPixels = __assign(__assign({}, sizePixels), {
    x: Math.round(limitAreaFn(mediaSize.naturalWidth - sizePixels.width, croppedAreaPercentages.x * mediaSize.naturalWidth / 100)),
    y: Math.round(limitAreaFn(mediaSize.naturalHeight - sizePixels.height, croppedAreaPercentages.y * mediaSize.naturalHeight / 100))
  });

  return {
    croppedAreaPercentages: croppedAreaPercentages,
    croppedAreaPixels: croppedAreaPixels
  };
}
/**
 * Ensure the returned value is between 0 and max
 */

function limitArea(max, value) {
  return Math.min(max, Math.max(0, value));
}

function noOp(_max, value) {
  return value;
}
/**
 * Compute the crop and zoom from the croppedAreaPixels
 */


function getZoomFromCroppedAreaPixels(croppedAreaPixels, mediaSize, cropSize) {
  var mediaZoom = mediaSize.width / mediaSize.naturalWidth;

  if (cropSize) {
    var isHeightMaxSize_1 = cropSize.height > cropSize.width;
    return isHeightMaxSize_1 ? cropSize.height / mediaZoom / croppedAreaPixels.height : cropSize.width / mediaZoom / croppedAreaPixels.width;
  }

  var aspect = croppedAreaPixels.width / croppedAreaPixels.height;
  var isHeightMaxSize = mediaSize.naturalWidth >= mediaSize.naturalHeight * aspect;
  return isHeightMaxSize ? mediaSize.naturalHeight / croppedAreaPixels.height : mediaSize.naturalWidth / croppedAreaPixels.width;
}
/**
 * Compute the crop and zoom from the croppedAreaPixels
 */


function getInitialCropFromCroppedAreaPixels(croppedAreaPixels, mediaSize, cropSize) {
  var mediaZoom = mediaSize.width / mediaSize.naturalWidth;
  var zoom = getZoomFromCroppedAreaPixels(croppedAreaPixels, mediaSize, cropSize);
  var cropZoom = mediaZoom * zoom;
  var crop = {
    x: ((mediaSize.naturalWidth - croppedAreaPixels.width) / 2 - croppedAreaPixels.x) * cropZoom,
    y: ((mediaSize.naturalHeight - croppedAreaPixels.height) / 2 - croppedAreaPixels.y) * cropZoom
  };
  return {
    crop: crop,
    zoom: zoom
  };
}
/**
 * Return the point that is the center of point a and b
 */

function getCenter(a, b) {
  return {
    x: (b.x + a.x) / 2,
    y: (b.y + a.y) / 2
  };
}
/**
 *
 * Returns an x,y point once rotated around xMid,yMid
 */

function rotateAroundMidPoint(x, y, xMid, yMid, degrees) {
  var cos = Math.cos;
  var sin = Math.sin;
  var radian = degrees * Math.PI / 180; // Convert to radians
  // Subtract midpoints, so that midpoint is translated to origin
  // and add it in the end again

  var xr = (x - xMid) * cos(radian) - (y - yMid) * sin(radian) + xMid;
  var yr = (x - xMid) * sin(radian) + (y - yMid) * cos(radian) + yMid;
  return [xr, yr];
}
/**
 * Returns the new bounding area of a rotated rectangle.
 */

function translateSize(width, height, rotation) {
  var centerX = width / 2;
  var centerY = height / 2;
  var outerBounds = [rotateAroundMidPoint(0, 0, centerX, centerY, rotation), rotateAroundMidPoint(width, 0, centerX, centerY, rotation), rotateAroundMidPoint(width, height, centerX, centerY, rotation), rotateAroundMidPoint(0, height, centerX, centerY, rotation)];
  var minX = Math.min.apply(Math, outerBounds.map(function (p) {
    return p[0];
  }));
  var maxX = Math.max.apply(Math, outerBounds.map(function (p) {
    return p[0];
  }));
  var minY = Math.min.apply(Math, outerBounds.map(function (p) {
    return p[1];
  }));
  var maxY = Math.max.apply(Math, outerBounds.map(function (p) {
    return p[1];
  }));
  return {
    width: maxX - minX,
    height: maxY - minY
  };
}
/**
 * Combine multiple class names into a single string.
 */

function classNames() {
  var args = [];

  for (var _i = 0; _i < arguments.length; _i++) {
    args[_i] = arguments[_i];
  }

  return args.filter(function (value) {
    if (typeof value === 'string' && value.length > 0) {
      return true;
    }

    return false;
  }).join(' ').trim();
}

var css_248z = ".reactEasyCrop_Container {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  user-select: none;\n  touch-action: none;\n  cursor: move;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n}\n\n.reactEasyCrop_Image,\n.reactEasyCrop_Video {\n  will-change: transform; /* this improves performances and prevent painting issues on iOS Chrome */\n}\n\n.reactEasyCrop_Contain {\n  max-width: 100%;\n  max-height: 100%;\n  margin: auto;\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n}\n.reactEasyCrop_Cover_Horizontal {\n  width: 100%;\n  height: auto;\n}\n.reactEasyCrop_Cover_Vertical {\n  width: auto;\n  height: 100%;\n}\n\n.reactEasyCrop_CropArea {\n  position: absolute;\n  left: 50%;\n  top: 50%;\n  transform: translate(-50%, -50%);\n  border: 1px solid rgba(255, 255, 255, 0.5);\n  box-sizing: border-box;\n  box-shadow: 0 0 0 9999em;\n  color: rgba(0, 0, 0, 0.5);\n  overflow: hidden;\n}\n\n.reactEasyCrop_CropAreaRound {\n  border-radius: 50%;\n}\n\n.reactEasyCrop_CropAreaGrid::before {\n  content: ' ';\n  box-sizing: border-box;\n  position: absolute;\n  border: 1px solid rgba(255, 255, 255, 0.5);\n  top: 0;\n  bottom: 0;\n  left: 33.33%;\n  right: 33.33%;\n  border-top: 0;\n  border-bottom: 0;\n}\n\n.reactEasyCrop_CropAreaGrid::after {\n  content: ' ';\n  box-sizing: border-box;\n  position: absolute;\n  border: 1px solid rgba(255, 255, 255, 0.5);\n  top: 33.33%;\n  bottom: 33.33%;\n  left: 0;\n  right: 0;\n  border-left: 0;\n  border-right: 0;\n}\n";

var MIN_ZOOM = 1;
var MAX_ZOOM = 3;

var index_module_Cropper =
/** @class */
function (_super) {
  __extends(Cropper, _super);

  function Cropper() {
    var _this = _super !== null && _super.apply(this, arguments) || this;

    _this.imageRef = null;
    _this.videoRef = null;
    _this.containerRef = null;
    _this.styleRef = null;
    _this.containerRect = null;
    _this.mediaSize = {
      width: 0,
      height: 0,
      naturalWidth: 0,
      naturalHeight: 0
    };
    _this.dragStartPosition = {
      x: 0,
      y: 0
    };
    _this.dragStartCrop = {
      x: 0,
      y: 0
    };
    _this.lastPinchDistance = 0;
    _this.lastPinchRotation = 0;
    _this.rafDragTimeout = null;
    _this.rafPinchTimeout = null;
    _this.wheelTimer = null;
    _this.state = {
      cropSize: null,
      hasWheelJustStarted: false
    }; // this is to prevent Safari on iOS >= 10 to zoom the page

    _this.preventZoomSafari = function (e) {
      return e.preventDefault();
    };

    _this.cleanEvents = function () {
      document.removeEventListener('mousemove', _this.onMouseMove);
      document.removeEventListener('mouseup', _this.onDragStopped);
      document.removeEventListener('touchmove', _this.onTouchMove);
      document.removeEventListener('touchend', _this.onDragStopped);
    };

    _this.clearScrollEvent = function () {
      if (_this.containerRef) _this.containerRef.removeEventListener('wheel', _this.onWheel);

      if (_this.wheelTimer) {
        clearTimeout(_this.wheelTimer);
      }
    };

    _this.onMediaLoad = function () {
      _this.computeSizes();

      _this.emitCropData();

      _this.setInitialCrop();

      if (_this.props.onMediaLoaded) {
        _this.props.onMediaLoaded(_this.mediaSize);
      }
    };

    _this.setInitialCrop = function () {
      var _a = _this.props,
          initialCroppedAreaPixels = _a.initialCroppedAreaPixels,
          cropSize = _a.cropSize;

      if (!initialCroppedAreaPixels) {
        return;
      }

      var _b = getInitialCropFromCroppedAreaPixels(initialCroppedAreaPixels, _this.mediaSize, cropSize),
          crop = _b.crop,
          zoom = _b.zoom;

      _this.props.onCropChange(crop);

      _this.props.onZoomChange && _this.props.onZoomChange(zoom);
    };

    _this.computeSizes = function () {
      var _a, _b, _c, _d, _e, _f;

      var mediaRef = _this.imageRef || _this.videoRef;

      if (mediaRef && _this.containerRef) {
        _this.containerRect = _this.containerRef.getBoundingClientRect();
        _this.mediaSize = {
          width: mediaRef.offsetWidth,
          height: mediaRef.offsetHeight,
          naturalWidth: ((_a = _this.imageRef) === null || _a === void 0 ? void 0 : _a.naturalWidth) || ((_b = _this.videoRef) === null || _b === void 0 ? void 0 : _b.videoWidth) || 0,
          naturalHeight: ((_c = _this.imageRef) === null || _c === void 0 ? void 0 : _c.naturalHeight) || ((_d = _this.videoRef) === null || _d === void 0 ? void 0 : _d.videoHeight) || 0
        };
        var cropSize = _this.props.cropSize ? _this.props.cropSize : getCropSize(mediaRef.offsetWidth, mediaRef.offsetHeight, _this.containerRect.width, _this.containerRect.height, _this.props.aspect, _this.props.rotation);

        if (((_e = _this.state.cropSize) === null || _e === void 0 ? void 0 : _e.height) !== cropSize.height || ((_f = _this.state.cropSize) === null || _f === void 0 ? void 0 : _f.width) !== cropSize.width) {
          _this.props.onCropSizeChange && _this.props.onCropSizeChange(cropSize);
        }

        _this.setState({
          cropSize: cropSize
        }, _this.recomputeCropPosition);
      }
    };

    _this.onMouseDown = function (e) {
      e.preventDefault();
      document.addEventListener('mousemove', _this.onMouseMove);
      document.addEventListener('mouseup', _this.onDragStopped);

      _this.onDragStart(Cropper.getMousePoint(e));
    };

    _this.onMouseMove = function (e) {
      return _this.onDrag(Cropper.getMousePoint(e));
    };

    _this.onTouchStart = function (e) {
      document.addEventListener('touchmove', _this.onTouchMove, {
        passive: false
      }); // iOS 11 now defaults to passive: true

      document.addEventListener('touchend', _this.onDragStopped);

      if (e.touches.length === 2) {
        _this.onPinchStart(e);
      } else if (e.touches.length === 1) {
        _this.onDragStart(Cropper.getTouchPoint(e.touches[0]));
      }
    };

    _this.onTouchMove = function (e) {
      // Prevent whole page from scrolling on iOS.
      e.preventDefault();

      if (e.touches.length === 2) {
        _this.onPinchMove(e);
      } else if (e.touches.length === 1) {
        _this.onDrag(Cropper.getTouchPoint(e.touches[0]));
      }
    };

    _this.onDragStart = function (_a) {
      var _b, _c;

      var x = _a.x,
          y = _a.y;
      _this.dragStartPosition = {
        x: x,
        y: y
      };
      _this.dragStartCrop = __assign({}, _this.props.crop);
      (_c = (_b = _this.props).onInteractionStart) === null || _c === void 0 ? void 0 : _c.call(_b);
    };

    _this.onDrag = function (_a) {
      var x = _a.x,
          y = _a.y;
      if (_this.rafDragTimeout) window.cancelAnimationFrame(_this.rafDragTimeout);
      _this.rafDragTimeout = window.requestAnimationFrame(function () {
        if (!_this.state.cropSize) return;
        if (x === undefined || y === undefined) return;
        var offsetX = x - _this.dragStartPosition.x;
        var offsetY = y - _this.dragStartPosition.y;
        var requestedPosition = {
          x: _this.dragStartCrop.x + offsetX,
          y: _this.dragStartCrop.y + offsetY
        };
        var newPosition = _this.props.restrictPosition ? index_module_restrictPosition(requestedPosition, _this.mediaSize, _this.state.cropSize, _this.props.zoom, _this.props.rotation) : requestedPosition;

        _this.props.onCropChange(newPosition);
      });
    };

    _this.onDragStopped = function () {
      var _a, _b;

      _this.cleanEvents();

      _this.emitCropData();

      (_b = (_a = _this.props).onInteractionEnd) === null || _b === void 0 ? void 0 : _b.call(_a);
    };

    _this.onWheel = function (e) {
      e.preventDefault();
      var point = Cropper.getMousePoint(e);
      var pixelY = normalize_wheel_default()(e).pixelY;
      var newZoom = _this.props.zoom - pixelY * _this.props.zoomSpeed / 200;

      _this.setNewZoom(newZoom, point);

      if (!_this.state.hasWheelJustStarted) {
        _this.setState({
          hasWheelJustStarted: true
        }, function () {
          var _a, _b;

          return (_b = (_a = _this.props).onInteractionStart) === null || _b === void 0 ? void 0 : _b.call(_a);
        });
      }

      if (_this.wheelTimer) {
        clearTimeout(_this.wheelTimer);
      }

      _this.wheelTimer = window.setTimeout(function () {
        return _this.setState({
          hasWheelJustStarted: false
        }, function () {
          var _a, _b;

          return (_b = (_a = _this.props).onInteractionEnd) === null || _b === void 0 ? void 0 : _b.call(_a);
        });
      }, 250);
    };

    _this.getPointOnContainer = function (_a) {
      var x = _a.x,
          y = _a.y;

      if (!_this.containerRect) {
        throw new Error('The Cropper is not mounted');
      }

      return {
        x: _this.containerRect.width / 2 - (x - _this.containerRect.left),
        y: _this.containerRect.height / 2 - (y - _this.containerRect.top)
      };
    };

    _this.getPointOnMedia = function (_a) {
      var x = _a.x,
          y = _a.y;
      var _b = _this.props,
          crop = _b.crop,
          zoom = _b.zoom;
      return {
        x: (x + crop.x) / zoom,
        y: (y + crop.y) / zoom
      };
    };

    _this.setNewZoom = function (zoom, point) {
      if (!_this.state.cropSize || !_this.props.onZoomChange) return;

      var zoomPoint = _this.getPointOnContainer(point);

      var zoomTarget = _this.getPointOnMedia(zoomPoint);

      var newZoom = Math.min(_this.props.maxZoom, Math.max(zoom, _this.props.minZoom));
      var requestedPosition = {
        x: zoomTarget.x * newZoom - zoomPoint.x,
        y: zoomTarget.y * newZoom - zoomPoint.y
      };
      var newPosition = _this.props.restrictPosition ? index_module_restrictPosition(requestedPosition, _this.mediaSize, _this.state.cropSize, newZoom, _this.props.rotation) : requestedPosition;

      _this.props.onCropChange(newPosition);

      _this.props.onZoomChange(newZoom);
    };

    _this.getCropData = function () {
      if (!_this.state.cropSize) {
        return null;
      } // this is to ensure the crop is correctly restricted after a zoom back (https://github.com/ricardo-ch/react-easy-crop/issues/6)


      var restrictedPosition = _this.props.restrictPosition ? index_module_restrictPosition(_this.props.crop, _this.mediaSize, _this.state.cropSize, _this.props.zoom, _this.props.rotation) : _this.props.crop;
      return computeCroppedArea(restrictedPosition, _this.mediaSize, _this.state.cropSize, _this.getAspect(), _this.props.zoom, _this.props.rotation, _this.props.restrictPosition);
    };

    _this.emitCropData = function () {
      var cropData = _this.getCropData();

      if (!cropData) return;
      var croppedAreaPercentages = cropData.croppedAreaPercentages,
          croppedAreaPixels = cropData.croppedAreaPixels;

      if (_this.props.onCropComplete) {
        _this.props.onCropComplete(croppedAreaPercentages, croppedAreaPixels);
      }

      if (_this.props.onCropAreaChange) {
        _this.props.onCropAreaChange(croppedAreaPercentages, croppedAreaPixels);
      }
    };

    _this.emitCropAreaChange = function () {
      var cropData = _this.getCropData();

      if (!cropData) return;
      var croppedAreaPercentages = cropData.croppedAreaPercentages,
          croppedAreaPixels = cropData.croppedAreaPixels;

      if (_this.props.onCropAreaChange) {
        _this.props.onCropAreaChange(croppedAreaPercentages, croppedAreaPixels);
      }
    };

    _this.recomputeCropPosition = function () {
      if (!_this.state.cropSize) return;
      var newPosition = _this.props.restrictPosition ? index_module_restrictPosition(_this.props.crop, _this.mediaSize, _this.state.cropSize, _this.props.zoom, _this.props.rotation) : _this.props.crop;

      _this.props.onCropChange(newPosition);

      _this.emitCropData();
    };

    return _this;
  }

  Cropper.prototype.componentDidMount = function () {
    window.addEventListener('resize', this.computeSizes);

    if (this.containerRef) {
      this.props.zoomWithScroll && this.containerRef.addEventListener('wheel', this.onWheel, {
        passive: false
      });
      this.containerRef.addEventListener('gesturestart', this.preventZoomSafari);
      this.containerRef.addEventListener('gesturechange', this.preventZoomSafari);
    }

    if (!this.props.disableAutomaticStylesInjection) {
      this.styleRef = document.createElement('style');
      this.styleRef.setAttribute('type', 'text/css');
      this.styleRef.innerHTML = css_248z;
      document.head.appendChild(this.styleRef);
    } // when rendered via SSR, the image can already be loaded and its onLoad callback will never be called


    if (this.imageRef && this.imageRef.complete) {
      this.onMediaLoad();
    }
  };

  Cropper.prototype.componentWillUnmount = function () {
    var _a;

    window.removeEventListener('resize', this.computeSizes);

    if (this.containerRef) {
      this.containerRef.removeEventListener('gesturestart', this.preventZoomSafari);
      this.containerRef.removeEventListener('gesturechange', this.preventZoomSafari);
    }

    if (this.styleRef) {
      (_a = this.styleRef.parentNode) === null || _a === void 0 ? void 0 : _a.removeChild(this.styleRef);
    }

    this.cleanEvents();
    this.props.zoomWithScroll && this.clearScrollEvent();
  };

  Cropper.prototype.componentDidUpdate = function (prevProps) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j;

    if (prevProps.rotation !== this.props.rotation) {
      this.computeSizes();
      this.recomputeCropPosition();
    } else if (prevProps.aspect !== this.props.aspect) {
      this.computeSizes();
    } else if (prevProps.zoom !== this.props.zoom) {
      this.recomputeCropPosition();
    } else if (((_a = prevProps.cropSize) === null || _a === void 0 ? void 0 : _a.height) !== ((_b = this.props.cropSize) === null || _b === void 0 ? void 0 : _b.height) || ((_c = prevProps.cropSize) === null || _c === void 0 ? void 0 : _c.width) !== ((_d = this.props.cropSize) === null || _d === void 0 ? void 0 : _d.width)) {
      this.computeSizes();
    } else if (((_e = prevProps.crop) === null || _e === void 0 ? void 0 : _e.x) !== ((_f = this.props.crop) === null || _f === void 0 ? void 0 : _f.x) || ((_g = prevProps.crop) === null || _g === void 0 ? void 0 : _g.y) !== ((_h = this.props.crop) === null || _h === void 0 ? void 0 : _h.y)) {
      this.emitCropAreaChange();
    }

    if (prevProps.zoomWithScroll !== this.props.zoomWithScroll && this.containerRef) {
      this.props.zoomWithScroll ? this.containerRef.addEventListener('wheel', this.onWheel, {
        passive: false
      }) : this.clearScrollEvent();
    }

    if (prevProps.video !== this.props.video) {
      (_j = this.videoRef) === null || _j === void 0 ? void 0 : _j.load();
    }
  };

  Cropper.prototype.getAspect = function () {
    var _a = this.props,
        cropSize = _a.cropSize,
        aspect = _a.aspect;

    if (cropSize) {
      return cropSize.width / cropSize.height;
    }

    return aspect;
  };

  Cropper.prototype.onPinchStart = function (e) {
    var pointA = Cropper.getTouchPoint(e.touches[0]);
    var pointB = Cropper.getTouchPoint(e.touches[1]);
    this.lastPinchDistance = getDistanceBetweenPoints(pointA, pointB);
    this.lastPinchRotation = getRotationBetweenPoints(pointA, pointB);
    this.onDragStart(getCenter(pointA, pointB));
  };

  Cropper.prototype.onPinchMove = function (e) {
    var _this = this;

    var pointA = Cropper.getTouchPoint(e.touches[0]);
    var pointB = Cropper.getTouchPoint(e.touches[1]);
    var center = getCenter(pointA, pointB);
    this.onDrag(center);
    if (this.rafPinchTimeout) window.cancelAnimationFrame(this.rafPinchTimeout);
    this.rafPinchTimeout = window.requestAnimationFrame(function () {
      var distance = getDistanceBetweenPoints(pointA, pointB);
      var newZoom = _this.props.zoom * (distance / _this.lastPinchDistance);

      _this.setNewZoom(newZoom, center);

      _this.lastPinchDistance = distance;
      var rotation = getRotationBetweenPoints(pointA, pointB);
      var newRotation = _this.props.rotation + (rotation - _this.lastPinchRotation);
      _this.props.onRotationChange && _this.props.onRotationChange(newRotation);
      _this.lastPinchRotation = rotation;
    });
  };

  Cropper.prototype.render = function () {
    var _this = this;

    var _a = this.props,
        image = _a.image,
        video = _a.video,
        mediaProps = _a.mediaProps,
        transform = _a.transform,
        _b = _a.crop,
        x = _b.x,
        y = _b.y,
        rotation = _a.rotation,
        zoom = _a.zoom,
        cropShape = _a.cropShape,
        showGrid = _a.showGrid,
        _c = _a.style,
        containerStyle = _c.containerStyle,
        cropAreaStyle = _c.cropAreaStyle,
        mediaStyle = _c.mediaStyle,
        _d = _a.classes,
        containerClassName = _d.containerClassName,
        cropAreaClassName = _d.cropAreaClassName,
        mediaClassName = _d.mediaClassName,
        objectFit = _a.objectFit;
    return /*#__PURE__*/external_React_default.a.createElement("div", {
      onMouseDown: this.onMouseDown,
      onTouchStart: this.onTouchStart,
      ref: function ref(el) {
        return _this.containerRef = el;
      },
      "data-testid": "container",
      style: containerStyle,
      className: classNames('reactEasyCrop_Container', containerClassName)
    }, image ? /*#__PURE__*/external_React_default.a.createElement("img", __assign({
      alt: "",
      className: classNames('reactEasyCrop_Image', objectFit === 'contain' && 'reactEasyCrop_Contain', objectFit === 'horizontal-cover' && 'reactEasyCrop_Cover_Horizontal', objectFit === 'vertical-cover' && 'reactEasyCrop_Cover_Vertical', mediaClassName)
    }, mediaProps, {
      src: image,
      ref: function ref(el) {
        return _this.imageRef = el;
      },
      style: __assign(__assign({}, mediaStyle), {
        transform: transform || "translate(" + x + "px, " + y + "px) rotate(" + rotation + "deg) scale(" + zoom + ")"
      }),
      onLoad: this.onMediaLoad
    })) : video && /*#__PURE__*/external_React_default.a.createElement("video", __assign({
      autoPlay: true,
      loop: true,
      muted: true,
      className: classNames('reactEasyCrop_Video', objectFit === 'contain' && 'reactEasyCrop_Contain', objectFit === 'horizontal-cover' && 'reactEasyCrop_Cover_Horizontal', objectFit === 'vertical-cover' && 'reactEasyCrop_Cover_Vertical', mediaClassName)
    }, mediaProps, {
      ref: function ref(el) {
        return _this.videoRef = el;
      },
      onLoadedMetadata: this.onMediaLoad,
      style: __assign(__assign({}, mediaStyle), {
        transform: transform || "translate(" + x + "px, " + y + "px) rotate(" + rotation + "deg) scale(" + zoom + ")"
      }),
      controls: false
    }), (Array.isArray(video) ? video : [{
      src: video
    }]).map(function (item) {
      return /*#__PURE__*/external_React_default.a.createElement("source", __assign({
        key: item.src
      }, item));
    })), this.state.cropSize && /*#__PURE__*/external_React_default.a.createElement("div", {
      style: __assign(__assign({}, cropAreaStyle), {
        width: this.state.cropSize.width,
        height: this.state.cropSize.height
      }),
      "data-testid": "cropper",
      className: classNames('reactEasyCrop_CropArea', cropShape === 'round' && 'reactEasyCrop_CropAreaRound', showGrid && 'reactEasyCrop_CropAreaGrid', cropAreaClassName)
    }));
  };

  Cropper.defaultProps = {
    zoom: 1,
    rotation: 0,
    aspect: 4 / 3,
    maxZoom: MAX_ZOOM,
    minZoom: MIN_ZOOM,
    cropShape: 'rect',
    objectFit: 'contain',
    showGrid: true,
    style: {},
    classes: {},
    mediaProps: {},
    zoomSpeed: 1,
    restrictPosition: true,
    zoomWithScroll: true
  };

  Cropper.getMousePoint = function (e) {
    return {
      x: Number(e.clientX),
      y: Number(e.clientY)
    };
  };

  Cropper.getTouchPoint = function (touch) {
    return {
      x: Number(touch.clientX),
      y: Number(touch.clientY)
    };
  };

  return Cropper;
}(external_React_default.a.Component);

/* harmony default export */ var index_module = (index_module_Cropper);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-editor/constants.js
const constants_MIN_ZOOM = 100;
const constants_MAX_ZOOM = 300;
const constants_POPOVER_PROPS = {
  position: 'bottom right',
  isAlternate: true
};

// EXTERNAL MODULE: external ["wp","apiFetch"]
var external_wp_apiFetch_ = __webpack_require__("ywyh");
var external_wp_apiFetch_default = /*#__PURE__*/__webpack_require__.n(external_wp_apiFetch_);

// EXTERNAL MODULE: external ["wp","notices"]
var external_wp_notices_ = __webpack_require__("onLe");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-editor/use-save-image.js
/**
 * WordPress dependencies
 */





function useSaveImage(_ref) {
  let {
    crop,
    rotation,
    height,
    width,
    aspect,
    url,
    id,
    onSaveImage,
    onFinishEditing
  } = _ref;
  const {
    createErrorNotice
  } = Object(external_wp_data_["useDispatch"])(external_wp_notices_["store"]);
  const [isInProgress, setIsInProgress] = Object(external_wp_element_["useState"])(false);
  const cancel = Object(external_wp_element_["useCallback"])(() => {
    setIsInProgress(false);
    onFinishEditing();
  }, [setIsInProgress, onFinishEditing]);
  const apply = Object(external_wp_element_["useCallback"])(() => {
    setIsInProgress(true);
    let attrs = {}; // The crop script may return some very small, sub-pixel values when the image was not cropped.
    // Crop only when the new size has changed by more than 0.1%.

    if (crop.width < 99.9 || crop.height < 99.9) {
      attrs = crop;
    }

    if (rotation > 0) {
      attrs.rotation = rotation;
    }

    attrs.src = url;
    external_wp_apiFetch_default()({
      path: `/wp/v2/media/${id}/edit`,
      method: 'POST',
      data: attrs
    }).then(response => {
      onSaveImage({
        id: response.id,
        url: response.source_url,
        height: height && width ? width / aspect : undefined
      });
    }).catch(error => {
      createErrorNotice(Object(external_wp_i18n_["sprintf"])(
      /* translators: 1. Error message */
      Object(external_wp_i18n_["__"])('Could not edit image. %s'), error.message), {
        id: 'image-editing-error',
        type: 'snackbar'
      });
    }).finally(() => {
      setIsInProgress(false);
      onFinishEditing();
    });
  }, [setIsInProgress, crop, rotation, height, width, aspect, url, onSaveImage, createErrorNotice, setIsInProgress, onFinishEditing]);
  return Object(external_wp_element_["useMemo"])(() => ({
    isInProgress,
    apply,
    cancel
  }), [isInProgress, apply, cancel]);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-editor/use-transform-image.js
/**
 * WordPress dependencies
 */



function useTransformState(_ref) {
  let {
    url,
    naturalWidth,
    naturalHeight
  } = _ref;
  const [editedUrl, setEditedUrl] = Object(external_wp_element_["useState"])();
  const [crop, setCrop] = Object(external_wp_element_["useState"])();
  const [position, setPosition] = Object(external_wp_element_["useState"])({
    x: 0,
    y: 0
  });
  const [zoom, setZoom] = Object(external_wp_element_["useState"])();
  const [rotation, setRotation] = Object(external_wp_element_["useState"])();
  const [aspect, setAspect] = Object(external_wp_element_["useState"])();
  const [defaultAspect, setDefaultAspect] = Object(external_wp_element_["useState"])();
  const initializeTransformValues = Object(external_wp_element_["useCallback"])(() => {
    setPosition({
      x: 0,
      y: 0
    });
    setZoom(100);
    setRotation(0);
    setAspect(naturalWidth / naturalHeight);
    setDefaultAspect(naturalWidth / naturalHeight);
  }, [naturalWidth, naturalHeight, setPosition, setZoom, setRotation, setAspect, setDefaultAspect]);
  const rotateClockwise = Object(external_wp_element_["useCallback"])(() => {
    const angle = (rotation + 90) % 360;
    let naturalAspectRatio = naturalWidth / naturalHeight;

    if (rotation % 180 === 90) {
      naturalAspectRatio = naturalHeight / naturalWidth;
    }

    if (angle === 0) {
      setEditedUrl();
      setRotation(angle);
      setAspect(1 / aspect);
      setPosition({
        x: -(position.y * naturalAspectRatio),
        y: position.x * naturalAspectRatio
      });
      return;
    }

    function editImage(event) {
      const canvas = document.createElement('canvas');
      let translateX = 0;
      let translateY = 0;

      if (angle % 180) {
        canvas.width = event.target.height;
        canvas.height = event.target.width;
      } else {
        canvas.width = event.target.width;
        canvas.height = event.target.height;
      }

      if (angle === 90 || angle === 180) {
        translateX = canvas.width;
      }

      if (angle === 270 || angle === 180) {
        translateY = canvas.height;
      }

      const context = canvas.getContext('2d');
      context.translate(translateX, translateY);
      context.rotate(angle * Math.PI / 180);
      context.drawImage(event.target, 0, 0);
      canvas.toBlob(blob => {
        setEditedUrl(URL.createObjectURL(blob));
        setRotation(angle);
        setAspect(1 / aspect);
        setPosition({
          x: -(position.y * naturalAspectRatio),
          y: position.x * naturalAspectRatio
        });
      });
    }

    const el = new window.Image();
    el.src = url;
    el.onload = editImage;
    const imgCrossOrigin = Object(external_wp_hooks_["applyFilters"])('media.crossOrigin', undefined, url);

    if (typeof imgCrossOrigin === 'string') {
      el.crossOrigin = imgCrossOrigin;
    }
  }, [rotation, naturalWidth, naturalHeight, setEditedUrl, setRotation, setAspect, setPosition]);
  return Object(external_wp_element_["useMemo"])(() => ({
    editedUrl,
    setEditedUrl,
    crop,
    setCrop,
    position,
    setPosition,
    zoom,
    setZoom,
    rotation,
    setRotation,
    rotateClockwise,
    aspect,
    setAspect,
    defaultAspect,
    initializeTransformValues
  }), [editedUrl, setEditedUrl, crop, setCrop, position, setPosition, zoom, setZoom, rotation, setRotation, rotateClockwise, aspect, setAspect, defaultAspect, initializeTransformValues]);
}

function useTransformImage(imageProperties, isEditing) {
  const transformState = useTransformState(imageProperties);
  const {
    initializeTransformValues
  } = transformState;
  Object(external_wp_element_["useEffect"])(() => {
    if (isEditing) {
      initializeTransformValues();
    }
  }, [isEditing, initializeTransformValues]);
  return transformState;
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-editor/context.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



const ImageEditingContext = Object(external_wp_element_["createContext"])({});
const useImageEditingContext = () => Object(external_wp_element_["useContext"])(ImageEditingContext);
function ImageEditingProvider(_ref) {
  let {
    id,
    url,
    naturalWidth,
    naturalHeight,
    isEditing,
    onFinishEditing,
    onSaveImage,
    children
  } = _ref;
  const transformImage = useTransformImage({
    url,
    naturalWidth,
    naturalHeight
  }, isEditing);
  const saveImage = useSaveImage({
    id,
    url,
    onSaveImage,
    onFinishEditing,
    ...transformImage
  });
  const providerValue = Object(external_wp_element_["useMemo"])(() => ({ ...transformImage,
    ...saveImage
  }), [transformImage, saveImage]);
  return Object(external_wp_element_["createElement"])(ImageEditingContext.Provider, {
    value: providerValue
  }, children);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-editor/cropper.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function ImageCropper(_ref) {
  let {
    url,
    width,
    height,
    clientWidth,
    naturalHeight,
    naturalWidth
  } = _ref;
  const {
    isInProgress,
    editedUrl,
    position,
    zoom,
    aspect,
    setPosition,
    setCrop,
    setZoom,
    rotation
  } = useImageEditingContext();
  let editedHeight = height || clientWidth * naturalHeight / naturalWidth;

  if (rotation % 180 === 90) {
    editedHeight = clientWidth * naturalWidth / naturalHeight;
  }

  return Object(external_wp_element_["createElement"])("div", {
    className: classnames_default()('wp-block-image__crop-area', {
      'is-applying': isInProgress
    }),
    style: {
      width: width || clientWidth,
      height: editedHeight
    }
  }, Object(external_wp_element_["createElement"])(index_module, {
    image: editedUrl || url,
    disabled: isInProgress,
    minZoom: constants_MIN_ZOOM / 100,
    maxZoom: constants_MAX_ZOOM / 100,
    crop: position,
    zoom: zoom / 100,
    aspect: aspect,
    onCropChange: setPosition,
    onCropComplete: newCropPercent => {
      setCrop(newCropPercent);
    },
    onZoomChange: newZoom => {
      setZoom(newZoom * 100);
    }
  }), isInProgress && Object(external_wp_element_["createElement"])(external_wp_components_["Spinner"], null));
}

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/search.js
var search = __webpack_require__("cGtP");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-editor/zoom-dropdown.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function ZoomDropdown() {
  const {
    isInProgress,
    zoom,
    setZoom
  } = useImageEditingContext();
  return Object(external_wp_element_["createElement"])(external_wp_components_["Dropdown"], {
    contentClassName: "wp-block-image__zoom",
    popoverProps: constants_POPOVER_PROPS,
    renderToggle: _ref => {
      let {
        isOpen,
        onToggle
      } = _ref;
      return Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
        icon: search["a" /* default */],
        label: Object(external_wp_i18n_["__"])('Zoom'),
        onClick: onToggle,
        "aria-expanded": isOpen,
        disabled: isInProgress
      });
    },
    renderContent: () => Object(external_wp_element_["createElement"])(external_wp_components_["RangeControl"], {
      label: Object(external_wp_i18n_["__"])('Zoom'),
      min: constants_MIN_ZOOM,
      max: constants_MAX_ZOOM,
      value: Math.round(zoom),
      onChange: setZoom
    })
  });
}

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/check.js
var check = __webpack_require__("RMJe");

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/aspect-ratio.js


/**
 * WordPress dependencies
 */

const aspectRatio = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  d: "M18.5 5.5h-13c-1.1 0-2 .9-2 2v9c0 1.1.9 2 2 2h13c1.1 0 2-.9 2-2v-9c0-1.1-.9-2-2-2zm.5 11c0 .3-.2.5-.5.5h-13c-.3 0-.5-.2-.5-.5v-9c0-.3.2-.5.5-.5h13c.3 0 .5.2.5.5v9zM6.5 12H8v-2h2V8.5H6.5V12zm9.5 2h-2v1.5h3.5V12H16v2z"
}));
/* harmony default export */ var aspect_ratio = (aspectRatio);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-editor/aspect-ratio-dropdown.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function AspectGroup(_ref) {
  let {
    aspectRatios,
    isDisabled,
    label,
    onClick,
    value
  } = _ref;
  return Object(external_wp_element_["createElement"])(external_wp_components_["MenuGroup"], {
    label: label
  }, aspectRatios.map(_ref2 => {
    let {
      title,
      aspect
    } = _ref2;
    return Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
      key: aspect,
      disabled: isDisabled,
      onClick: () => {
        onClick(aspect);
      },
      role: "menuitemradio",
      isSelected: aspect === value,
      icon: aspect === value ? check["a" /* default */] : undefined
    }, title);
  }));
}

function AspectRatioDropdown(_ref3) {
  let {
    toggleProps
  } = _ref3;
  const {
    isInProgress,
    aspect,
    setAspect,
    defaultAspect
  } = useImageEditingContext();
  return Object(external_wp_element_["createElement"])(external_wp_components_["DropdownMenu"], {
    icon: aspect_ratio,
    label: Object(external_wp_i18n_["__"])('Aspect Ratio'),
    popoverProps: constants_POPOVER_PROPS,
    toggleProps: toggleProps,
    className: "wp-block-image__aspect-ratio"
  }, _ref4 => {
    let {
      onClose
    } = _ref4;
    return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(AspectGroup, {
      isDisabled: isInProgress,
      onClick: newAspect => {
        setAspect(newAspect);
        onClose();
      },
      value: aspect,
      aspectRatios: [{
        title: Object(external_wp_i18n_["__"])('Original'),
        aspect: defaultAspect
      }, {
        title: Object(external_wp_i18n_["__"])('Square'),
        aspect: 1
      }]
    }), Object(external_wp_element_["createElement"])(AspectGroup, {
      label: Object(external_wp_i18n_["__"])('Landscape'),
      isDisabled: isInProgress,
      onClick: newAspect => {
        setAspect(newAspect);
        onClose();
      },
      value: aspect,
      aspectRatios: [{
        title: Object(external_wp_i18n_["__"])('16:10'),
        aspect: 16 / 10
      }, {
        title: Object(external_wp_i18n_["__"])('16:9'),
        aspect: 16 / 9
      }, {
        title: Object(external_wp_i18n_["__"])('4:3'),
        aspect: 4 / 3
      }, {
        title: Object(external_wp_i18n_["__"])('3:2'),
        aspect: 3 / 2
      }]
    }), Object(external_wp_element_["createElement"])(AspectGroup, {
      label: Object(external_wp_i18n_["__"])('Portrait'),
      isDisabled: isInProgress,
      onClick: newAspect => {
        setAspect(newAspect);
        onClose();
      },
      value: aspect,
      aspectRatios: [{
        title: Object(external_wp_i18n_["__"])('10:16'),
        aspect: 10 / 16
      }, {
        title: Object(external_wp_i18n_["__"])('9:16'),
        aspect: 9 / 16
      }, {
        title: Object(external_wp_i18n_["__"])('3:4'),
        aspect: 3 / 4
      }, {
        title: Object(external_wp_i18n_["__"])('2:3'),
        aspect: 2 / 3
      }]
    }));
  });
}

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/rotate-right.js


/**
 * WordPress dependencies
 */

const rotateRight = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  d: "M15.1 4.8l-3-2.5V4c-4.4 0-8 3.6-8 8 0 3.7 2.5 6.9 6 7.7.3.1.6.1 1 .2l.2-1.5c-.4 0-.7-.1-1.1-.2l-.1.2v-.2c-2.6-.8-4.5-3.3-4.5-6.2 0-3.6 2.9-6.5 6.5-6.5v1.8l3-2.5zM20 11c-.2-1.4-.7-2.7-1.6-3.8l-1.2.8c.7.9 1.1 2 1.3 3.1L20 11zm-1.5 1.8c-.1.5-.2 1.1-.4 1.6s-.5 1-.8 1.5l1.2.9c.4-.5.8-1.1 1-1.8s.5-1.3.5-2l-1.5-.2zm-5.6 5.6l.2 1.5c1.4-.2 2.7-.7 3.8-1.6l-.9-1.1c-.9.7-2 1.1-3.1 1.2z"
}));
/* harmony default export */ var rotate_right = (rotateRight);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-editor/rotation-button.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function RotationButton() {
  const {
    isInProgress,
    rotateClockwise
  } = useImageEditingContext();
  return Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
    icon: rotate_right,
    label: Object(external_wp_i18n_["__"])('Rotate'),
    onClick: rotateClockwise,
    disabled: isInProgress
  });
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-editor/form-controls.js


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function FormControls() {
  const {
    isInProgress,
    apply,
    cancel
  } = useImageEditingContext();
  return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
    onClick: apply,
    disabled: isInProgress
  }, Object(external_wp_i18n_["__"])('Apply')), Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
    onClick: cancel
  }, Object(external_wp_i18n_["__"])('Cancel')));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-editor/index.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */







function ImageEditor(_ref) {
  let {
    url,
    width,
    height,
    clientWidth,
    naturalHeight,
    naturalWidth
  } = _ref;
  return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(ImageCropper, {
    url: url,
    width: width,
    height: height,
    clientWidth: clientWidth,
    naturalHeight: naturalHeight,
    naturalWidth: naturalWidth
  }), Object(external_wp_element_["createElement"])(block_controls["b" /* default */], null, Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarGroup"], null, Object(external_wp_element_["createElement"])(ZoomDropdown, null), Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarItem"], null, toggleProps => Object(external_wp_element_["createElement"])(AspectRatioDropdown, {
    toggleProps: toggleProps
  })), Object(external_wp_element_["createElement"])(RotationButton, null)), Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarGroup"], null, Object(external_wp_element_["createElement"])(FormControls, null))));
}


// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-size-control/use-dimension-handler.js
/**
 * WordPress dependencies
 */

function useDimensionHandler(customHeight, customWidth, defaultHeight, defaultWidth, onChange) {
  var _ref, _ref2;

  const [currentWidth, setCurrentWidth] = Object(external_wp_element_["useState"])((_ref = customWidth !== null && customWidth !== void 0 ? customWidth : defaultWidth) !== null && _ref !== void 0 ? _ref : '');
  const [currentHeight, setCurrentHeight] = Object(external_wp_element_["useState"])((_ref2 = customHeight !== null && customHeight !== void 0 ? customHeight : defaultHeight) !== null && _ref2 !== void 0 ? _ref2 : ''); // When an image is first inserted, the default dimensions are initially
  // undefined. This effect updates the dimensions when the default values
  // come through.

  Object(external_wp_element_["useEffect"])(() => {
    if (customWidth === undefined && defaultWidth !== undefined) {
      setCurrentWidth(defaultWidth);
    }

    if (customHeight === undefined && defaultHeight !== undefined) {
      setCurrentHeight(defaultHeight);
    }
  }, [defaultWidth, defaultHeight]); // If custom values change, it means an outsider has resized the image using some other method (eg resize box)
  // this keeps track of these values too. We need to parse before comparing; custom values can be strings.

  Object(external_wp_element_["useEffect"])(() => {
    if (customWidth !== undefined && Number.parseInt(customWidth) !== Number.parseInt(currentWidth)) {
      setCurrentWidth(customWidth);
    }

    if (customHeight !== undefined && Number.parseInt(customHeight) !== Number.parseInt(currentHeight)) {
      setCurrentHeight(customHeight);
    }
  }, [customWidth, customHeight]);

  const updateDimension = (dimension, value) => {
    if (dimension === 'width') {
      setCurrentWidth(value);
    } else {
      setCurrentHeight(value);
    }

    onChange({
      [dimension]: value === '' ? undefined : parseInt(value, 10)
    });
  };

  const updateDimensions = (nextHeight, nextWidth) => {
    setCurrentHeight(nextHeight !== null && nextHeight !== void 0 ? nextHeight : defaultHeight);
    setCurrentWidth(nextWidth !== null && nextWidth !== void 0 ? nextWidth : defaultWidth);
    onChange({
      height: nextHeight,
      width: nextWidth
    });
  };

  return {
    currentHeight,
    currentWidth,
    updateDimension,
    updateDimensions
  };
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/image-size-control/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


const IMAGE_SIZE_PRESETS = [25, 50, 75, 100];
function ImageSizeControl(_ref) {
  let {
    imageWidth,
    imageHeight,
    imageSizeOptions = [],
    isResizable = true,
    slug,
    width,
    height,
    onChange,
    onChangeImage = external_lodash_["noop"]
  } = _ref;
  const {
    currentHeight,
    currentWidth,
    updateDimension,
    updateDimensions
  } = useDimensionHandler(height, width, imageHeight, imageWidth, onChange);
  return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, !Object(external_lodash_["isEmpty"])(imageSizeOptions) && Object(external_wp_element_["createElement"])(external_wp_components_["SelectControl"], {
    label: Object(external_wp_i18n_["__"])('Image size'),
    value: slug,
    options: imageSizeOptions,
    onChange: onChangeImage
  }), isResizable && Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-image-size-control"
  }, Object(external_wp_element_["createElement"])("p", {
    className: "block-editor-image-size-control__row"
  }, Object(external_wp_i18n_["__"])('Image dimensions')), Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-image-size-control__row"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["TextControl"], {
    type: "number",
    className: "block-editor-image-size-control__width",
    label: Object(external_wp_i18n_["__"])('Width'),
    value: currentWidth,
    min: 1,
    onChange: value => updateDimension('width', value)
  }), Object(external_wp_element_["createElement"])(external_wp_components_["TextControl"], {
    type: "number",
    className: "block-editor-image-size-control__height",
    label: Object(external_wp_i18n_["__"])('Height'),
    value: currentHeight,
    min: 1,
    onChange: value => updateDimension('height', value)
  })), Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-image-size-control__row"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["ButtonGroup"], {
    "aria-label": Object(external_wp_i18n_["__"])('Image size presets')
  }, IMAGE_SIZE_PRESETS.map(scale => {
    const scaledWidth = Math.round(imageWidth * (scale / 100));
    const scaledHeight = Math.round(imageHeight * (scale / 100));
    const isCurrent = currentWidth === scaledWidth && currentHeight === scaledHeight;
    return Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
      key: scale,
      isSmall: true,
      variant: isCurrent ? 'primary' : undefined,
      isPressed: isCurrent,
      onClick: () => updateDimensions(scaledHeight, scaledWidth)
    }, scale, "%");
  })), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    isSmall: true,
    onClick: () => updateDimensions()
  }, Object(external_wp_i18n_["__"])('Reset')))));
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inner-blocks/index.js + 7 modules
var inner_blocks = __webpack_require__("p3NJ");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inspector-controls/index.js
var inspector_controls = __webpack_require__("1oY3");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/justify-content-control/index.js + 1 modules
var justify_content_control = __webpack_require__("0E5u");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/keyboard-return.js
var keyboard_return = __webpack_require__("btIw");

// EXTERNAL MODULE: external ["wp","dom"]
var external_wp_dom_ = __webpack_require__("1CF3");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/settings-drawer.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




const LinkControlSettingsDrawer = _ref => {
  let {
    value,
    onChange = external_lodash_["noop"],
    settings
  } = _ref;

  if (!settings || !settings.length) {
    return null;
  }

  const handleSettingChange = setting => newValue => {
    onChange({ ...value,
      [setting.id]: newValue
    });
  };

  const theSettings = settings.map(setting => Object(external_wp_element_["createElement"])(external_wp_components_["ToggleControl"], {
    className: "block-editor-link-control__setting",
    key: setting.id,
    label: setting.title,
    onChange: handleSettingChange(setting),
    checked: value ? !!value[setting.id] : false
  }));
  return Object(external_wp_element_["createElement"])("fieldset", {
    className: "block-editor-link-control__settings"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["VisuallyHidden"], {
    as: "legend"
  }, Object(external_wp_i18n_["__"])('Currently selected link settings')), theSettings);
};

/* harmony default export */ var settings_drawer = (LinkControlSettingsDrawer);

// EXTERNAL MODULE: ./node_modules/dom-scroll-into-view/lib/index.js
var lib = __webpack_require__("9Do8");
var lib_default = /*#__PURE__*/__webpack_require__.n(lib);

// EXTERNAL MODULE: external ["wp","url"]
var external_wp_url_ = __webpack_require__("Mmq9");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/url-input/index.js



/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */








/**
 * Internal dependencies
 */



class url_input_URLInput extends external_wp_element_["Component"] {
  constructor(props) {
    super(props);
    this.onChange = this.onChange.bind(this);
    this.onFocus = this.onFocus.bind(this);
    this.onKeyDown = this.onKeyDown.bind(this);
    this.selectLink = this.selectLink.bind(this);
    this.handleOnClick = this.handleOnClick.bind(this);
    this.bindSuggestionNode = this.bindSuggestionNode.bind(this);
    this.autocompleteRef = props.autocompleteRef || Object(external_wp_element_["createRef"])();
    this.inputRef = Object(external_wp_element_["createRef"])();
    this.updateSuggestions = Object(external_lodash_["debounce"])(this.updateSuggestions.bind(this), 200);
    this.suggestionNodes = [];
    this.isUpdatingSuggestions = false;
    this.state = {
      suggestions: [],
      showSuggestions: false,
      selectedSuggestion: null,
      suggestionsListboxId: '',
      suggestionOptionIdPrefix: ''
    };
  }

  componentDidUpdate(prevProps) {
    const {
      showSuggestions,
      selectedSuggestion
    } = this.state;
    const {
      value,
      __experimentalShowInitialSuggestions = false
    } = this.props; // only have to worry about scrolling selected suggestion into view
    // when already expanded

    if (showSuggestions && selectedSuggestion !== null && this.suggestionNodes[selectedSuggestion] && !this.scrollingIntoView) {
      this.scrollingIntoView = true;
      lib_default()(this.suggestionNodes[selectedSuggestion], this.autocompleteRef.current, {
        onlyScrollIfNeeded: true
      });
      this.props.setTimeout(() => {
        this.scrollingIntoView = false;
      }, 100);
    } // Update suggestions when the value changes


    if (prevProps.value !== value && !this.props.disableSuggestions && !this.isUpdatingSuggestions) {
      if (value !== null && value !== void 0 && value.length) {
        // If the new value is not empty we need to update with suggestions for it
        this.updateSuggestions(value);
      } else if (__experimentalShowInitialSuggestions) {
        // If the new value is empty and we can show initial suggestions, then show initial suggestions
        this.updateSuggestions();
      }
    }
  }

  componentDidMount() {
    if (this.shouldShowInitialSuggestions()) {
      this.updateSuggestions();
    }
  }

  componentWillUnmount() {
    var _this$suggestionsRequ, _this$suggestionsRequ2;

    (_this$suggestionsRequ = this.suggestionsRequest) === null || _this$suggestionsRequ === void 0 ? void 0 : (_this$suggestionsRequ2 = _this$suggestionsRequ.cancel) === null || _this$suggestionsRequ2 === void 0 ? void 0 : _this$suggestionsRequ2.call(_this$suggestionsRequ);
    delete this.suggestionsRequest;
  }

  bindSuggestionNode(index) {
    return ref => {
      this.suggestionNodes[index] = ref;
    };
  }

  shouldShowInitialSuggestions() {
    const {
      suggestions
    } = this.state;
    const {
      __experimentalShowInitialSuggestions = false,
      value
    } = this.props;
    return !this.isUpdatingSuggestions && __experimentalShowInitialSuggestions && !(value && value.length) && !(suggestions && suggestions.length);
  }

  updateSuggestions() {
    var _value;

    let value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    const {
      __experimentalFetchLinkSuggestions: fetchLinkSuggestions,
      __experimentalHandleURLSuggestions: handleURLSuggestions
    } = this.props;

    if (!fetchLinkSuggestions) {
      return;
    } // Initial suggestions may only show if there is no value
    // (note: this includes whitespace).


    const isInitialSuggestions = !((_value = value) !== null && _value !== void 0 && _value.length); // Trim only now we've determined whether or not it originally had a "length"
    // (even if that value was all whitespace).

    value = value.trim(); // Allow a suggestions request if:
    // - there are at least 2 characters in the search input (except manual searches where
    //   search input length is not required to trigger a fetch)
    // - this is a direct entry (eg: a URL)

    if (!isInitialSuggestions && (value.length < 2 || !handleURLSuggestions && Object(external_wp_url_["isURL"])(value))) {
      this.setState({
        showSuggestions: false,
        selectedSuggestion: null,
        loading: false
      });
      return;
    }

    this.isUpdatingSuggestions = true;
    this.setState({
      selectedSuggestion: null,
      loading: true
    });
    const request = fetchLinkSuggestions(value, {
      isInitialSuggestions
    });
    request.then(suggestions => {
      // A fetch Promise doesn't have an abort option. It's mimicked by
      // comparing the request reference in on the instance, which is
      // reset or deleted on subsequent requests or unmounting.
      if (this.suggestionsRequest !== request) {
        return;
      }

      this.setState({
        suggestions,
        loading: false,
        showSuggestions: !!suggestions.length
      });

      if (!!suggestions.length) {
        this.props.debouncedSpeak(Object(external_wp_i18n_["sprintf"])(
        /* translators: %s: number of results. */
        Object(external_wp_i18n_["_n"])('%d result found, use up and down arrow keys to navigate.', '%d results found, use up and down arrow keys to navigate.', suggestions.length), suggestions.length), 'assertive');
      } else {
        this.props.debouncedSpeak(Object(external_wp_i18n_["__"])('No results.'), 'assertive');
      }

      this.isUpdatingSuggestions = false;
    }).catch(() => {
      if (this.suggestionsRequest === request) {
        this.setState({
          loading: false
        });
        this.isUpdatingSuggestions = false;
      }
    }); // Note that this assignment is handled *before* the async search request
    // as a Promise always resolves on the next tick of the event loop.

    this.suggestionsRequest = request;
  }

  onChange(event) {
    const inputValue = event.target.value;
    this.props.onChange(inputValue);

    if (!this.props.disableSuggestions) {
      this.updateSuggestions(inputValue);
    }
  }

  onFocus() {
    const {
      suggestions
    } = this.state;
    const {
      disableSuggestions,
      value
    } = this.props; // When opening the link editor, if there's a value present, we want to load the suggestions pane with the results for this input search value
    // Don't re-run the suggestions on focus if there are already suggestions present (prevents searching again when tabbing between the input and buttons)

    if (value && !disableSuggestions && !this.isUpdatingSuggestions && !(suggestions && suggestions.length)) {
      // Ensure the suggestions are updated with the current input value
      this.updateSuggestions(value);
    }
  }

  onKeyDown(event) {
    const {
      showSuggestions,
      selectedSuggestion,
      suggestions,
      loading
    } = this.state; // If the suggestions are not shown or loading, we shouldn't handle the arrow keys
    // We shouldn't preventDefault to allow block arrow keys navigation

    if (!showSuggestions || !suggestions.length || loading) {
      // In the Windows version of Firefox the up and down arrows don't move the caret
      // within an input field like they do for Mac Firefox/Chrome/Safari. This causes
      // a form of focus trapping that is disruptive to the user experience. This disruption
      // only happens if the caret is not in the first or last position in the text input.
      // See: https://github.com/WordPress/gutenberg/issues/5693#issuecomment-436684747
      switch (event.keyCode) {
        // When UP is pressed, if the caret is at the start of the text, move it to the 0
        // position.
        case external_wp_keycodes_["UP"]:
          {
            if (0 !== event.target.selectionStart) {
              event.preventDefault(); // Set the input caret to position 0

              event.target.setSelectionRange(0, 0);
            }

            break;
          }
        // When DOWN is pressed, if the caret is not at the end of the text, move it to the
        // last position.

        case external_wp_keycodes_["DOWN"]:
          {
            if (this.props.value.length !== event.target.selectionStart) {
              event.preventDefault(); // Set the input caret to the last position

              event.target.setSelectionRange(this.props.value.length, this.props.value.length);
            }

            break;
          }
        // Submitting while loading should trigger onSubmit

        case external_wp_keycodes_["ENTER"]:
          {
            if (this.props.onSubmit) {
              this.props.onSubmit(null, event);
            }

            break;
          }
      }

      return;
    }

    const suggestion = this.state.suggestions[this.state.selectedSuggestion];

    switch (event.keyCode) {
      case external_wp_keycodes_["UP"]:
        {
          event.preventDefault();
          const previousIndex = !selectedSuggestion ? suggestions.length - 1 : selectedSuggestion - 1;
          this.setState({
            selectedSuggestion: previousIndex
          });
          break;
        }

      case external_wp_keycodes_["DOWN"]:
        {
          event.preventDefault();
          const nextIndex = selectedSuggestion === null || selectedSuggestion === suggestions.length - 1 ? 0 : selectedSuggestion + 1;
          this.setState({
            selectedSuggestion: nextIndex
          });
          break;
        }

      case external_wp_keycodes_["TAB"]:
        {
          if (this.state.selectedSuggestion !== null) {
            this.selectLink(suggestion); // Announce a link has been selected when tabbing away from the input field.

            this.props.speak(Object(external_wp_i18n_["__"])('Link selected.'));
          }

          break;
        }

      case external_wp_keycodes_["ENTER"]:
        {
          if (this.state.selectedSuggestion !== null) {
            this.selectLink(suggestion);

            if (this.props.onSubmit) {
              this.props.onSubmit(suggestion, event);
            }
          } else if (this.props.onSubmit) {
            this.props.onSubmit(null, event);
          }

          break;
        }
    }
  }

  selectLink(suggestion) {
    this.props.onChange(suggestion.url, suggestion);
    this.setState({
      selectedSuggestion: null,
      showSuggestions: false
    });
  }

  handleOnClick(suggestion) {
    this.selectLink(suggestion); // Move focus to the input field when a link suggestion is clicked.

    this.inputRef.current.focus();
  }

  static getDerivedStateFromProps(_ref, _ref2) {
    let {
      value,
      instanceId,
      disableSuggestions,
      __experimentalShowInitialSuggestions = false
    } = _ref;
    let {
      showSuggestions
    } = _ref2;
    let shouldShowSuggestions = showSuggestions;
    const hasValue = value && value.length;

    if (!__experimentalShowInitialSuggestions && !hasValue) {
      shouldShowSuggestions = false;
    }

    if (disableSuggestions === true) {
      shouldShowSuggestions = false;
    }

    return {
      showSuggestions: shouldShowSuggestions,
      suggestionsListboxId: `block-editor-url-input-suggestions-${instanceId}`,
      suggestionOptionIdPrefix: `block-editor-url-input-suggestion-${instanceId}`
    };
  }

  render() {
    return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, this.renderControl(), this.renderSuggestions());
  }

  renderControl() {
    const {
      label,
      className,
      isFullWidth,
      instanceId,
      placeholder = Object(external_wp_i18n_["__"])('Paste URL or type to search'),
      __experimentalRenderControl: renderControl,
      value = ''
    } = this.props;
    const {
      loading,
      showSuggestions,
      selectedSuggestion,
      suggestionsListboxId,
      suggestionOptionIdPrefix
    } = this.state;
    const controlProps = {
      id: `url-input-control-${instanceId}`,
      label,
      className: classnames_default()('block-editor-url-input', className, {
        'is-full-width': isFullWidth
      })
    };
    const inputProps = {
      value,
      required: true,
      className: 'block-editor-url-input__input',
      type: 'text',
      onChange: this.onChange,
      onFocus: this.onFocus,
      placeholder,
      onKeyDown: this.onKeyDown,
      role: 'combobox',
      'aria-label': Object(external_wp_i18n_["__"])('URL'),
      'aria-expanded': showSuggestions,
      'aria-autocomplete': 'list',
      'aria-owns': suggestionsListboxId,
      'aria-activedescendant': selectedSuggestion !== null ? `${suggestionOptionIdPrefix}-${selectedSuggestion}` : undefined,
      ref: this.inputRef
    };

    if (renderControl) {
      return renderControl(controlProps, inputProps, loading);
    }

    return Object(external_wp_element_["createElement"])(external_wp_components_["BaseControl"], controlProps, Object(external_wp_element_["createElement"])("input", inputProps), loading && Object(external_wp_element_["createElement"])(external_wp_components_["Spinner"], null));
  }

  renderSuggestions() {
    const {
      className,
      __experimentalRenderSuggestions: renderSuggestions,
      value = '',
      __experimentalShowInitialSuggestions = false
    } = this.props;
    const {
      showSuggestions,
      suggestions,
      selectedSuggestion,
      suggestionsListboxId,
      suggestionOptionIdPrefix,
      loading
    } = this.state;
    const suggestionsListProps = {
      id: suggestionsListboxId,
      ref: this.autocompleteRef,
      role: 'listbox'
    };

    const buildSuggestionItemProps = (suggestion, index) => {
      return {
        role: 'option',
        tabIndex: '-1',
        id: `${suggestionOptionIdPrefix}-${index}`,
        ref: this.bindSuggestionNode(index),
        'aria-selected': index === selectedSuggestion
      };
    };

    if (Object(external_lodash_["isFunction"])(renderSuggestions) && showSuggestions && !!suggestions.length) {
      return renderSuggestions({
        suggestions,
        selectedSuggestion,
        suggestionsListProps,
        buildSuggestionItemProps,
        isLoading: loading,
        handleSuggestionClick: this.handleOnClick,
        isInitialSuggestions: __experimentalShowInitialSuggestions && !(value && value.length)
      });
    }

    if (!Object(external_lodash_["isFunction"])(renderSuggestions) && showSuggestions && !!suggestions.length) {
      return Object(external_wp_element_["createElement"])(external_wp_components_["Popover"], {
        position: "bottom",
        noArrow: true,
        focusOnMount: false
      }, Object(external_wp_element_["createElement"])("div", Object(esm_extends["a" /* default */])({}, suggestionsListProps, {
        className: classnames_default()('block-editor-url-input__suggestions', `${className}__suggestions`)
      }), suggestions.map((suggestion, index) => Object(external_wp_element_["createElement"])(external_wp_components_["Button"], Object(esm_extends["a" /* default */])({}, buildSuggestionItemProps(suggestion, index), {
        key: suggestion.id,
        className: classnames_default()('block-editor-url-input__suggestion', {
          'is-selected': index === selectedSuggestion
        }),
        onClick: () => this.handleOnClick(suggestion)
      }), suggestion.title))));
    }

    return null;
  }

}
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/url-input/README.md
 */


/* harmony default export */ var url_input = (Object(external_wp_compose_["compose"])(external_wp_compose_["withSafeTimeout"], external_wp_components_["withSpokenMessages"], external_wp_compose_["withInstanceId"], Object(external_wp_data_["withSelect"])((select, props) => {
  // If a link suggestions handler is already provided then
  // bail
  if (Object(external_lodash_["isFunction"])(props.__experimentalFetchLinkSuggestions)) {
    return;
  }

  const {
    getSettings
  } = select(store["a" /* store */]);
  return {
    __experimentalFetchLinkSuggestions: getSettings().__experimentalFetchLinkSuggestions
  };
}))(url_input_URLInput));

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/plus.js
var plus = __webpack_require__("Q4Sy");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-create-button.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */





const LinkControlSearchCreate = _ref => {
  let {
    searchTerm,
    onClick,
    itemProps,
    isSelected,
    buttonText
  } = _ref;

  if (!searchTerm) {
    return null;
  }

  let text;

  if (buttonText) {
    text = Object(external_lodash_["isFunction"])(buttonText) ? buttonText(searchTerm) : buttonText;
  } else {
    text = Object(external_wp_element_["createInterpolateElement"])(Object(external_wp_i18n_["sprintf"])(
    /* translators: %s: search term. */
    Object(external_wp_i18n_["__"])('Create: <mark>%s</mark>'), searchTerm), {
      mark: Object(external_wp_element_["createElement"])("mark", null)
    });
  }

  return Object(external_wp_element_["createElement"])(external_wp_components_["Button"], Object(esm_extends["a" /* default */])({}, itemProps, {
    className: classnames_default()('block-editor-link-control__search-create block-editor-link-control__search-item', {
      'is-selected': isSelected
    }),
    onClick: onClick
  }), Object(external_wp_element_["createElement"])(build_module_icon["a" /* default */], {
    className: "block-editor-link-control__search-item-icon",
    icon: plus["a" /* default */]
  }), Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-link-control__search-item-header"
  }, Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-link-control__search-item-title"
  }, text)));
};
/* harmony default export */ var search_create_button = (LinkControlSearchCreate);

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/globe.js
var globe = __webpack_require__("K8zD");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-item.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





const LinkControlSearchItem = _ref => {
  let {
    itemProps,
    suggestion,
    isSelected = false,
    onClick,
    isURL = false,
    searchTerm = '',
    shouldShowType = false
  } = _ref;
  return Object(external_wp_element_["createElement"])(external_wp_components_["Button"], Object(esm_extends["a" /* default */])({}, itemProps, {
    onClick: onClick,
    className: classnames_default()('block-editor-link-control__search-item', {
      'is-selected': isSelected,
      'is-url': isURL,
      'is-entity': !isURL
    })
  }), isURL && Object(external_wp_element_["createElement"])(build_module_icon["a" /* default */], {
    className: "block-editor-link-control__search-item-icon",
    icon: globe["a" /* default */]
  }), Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-link-control__search-item-header"
  }, Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-link-control__search-item-title"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["TextHighlight"], {
    text: suggestion.title,
    highlight: searchTerm
  })), Object(external_wp_element_["createElement"])("span", {
    "aria-hidden": !isURL,
    className: "block-editor-link-control__search-item-info"
  }, !isURL && (Object(external_wp_url_["filterURLForDisplay"])(Object(external_wp_url_["safeDecodeURI"])(suggestion.url)) || ''), isURL && Object(external_wp_i18n_["__"])('Press ENTER to add this link'))), shouldShowType && suggestion.type && Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-link-control__search-item-type"
  }, suggestion.type === 'post_tag' ? 'tag' : suggestion.type));
};
/* harmony default export */ var search_item = (LinkControlSearchItem);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/constants.js
/**
 * WordPress dependencies
 */
 // Used as a unique identifier for the "Create" option within search results.
// Used to help distinguish the "Create" suggestion within the search results in
// order to handle it as a unique case.

const CREATE_TYPE = '__CREATE__';
const DEFAULT_LINK_SETTINGS = [{
  id: 'opensInNewTab',
  title: Object(external_wp_i18n_["__"])('Open in new tab')
}];

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-results.js


/**
 * WordPress dependencies
 */


/**
 * External dependencies
 */



/**
 * Internal dependencies
 */




function LinkControlSearchResults(_ref) {
  let {
    instanceId,
    withCreateSuggestion,
    currentInputValue,
    handleSuggestionClick,
    suggestionsListProps,
    buildSuggestionItemProps,
    suggestions,
    selectedSuggestion,
    isLoading,
    isInitialSuggestions,
    createSuggestionButtonText,
    suggestionsQuery
  } = _ref;
  const resultsListClasses = classnames_default()('block-editor-link-control__search-results', {
    'is-loading': isLoading
  });
  const directLinkEntryTypes = ['url', 'mailto', 'tel', 'internal'];
  const isSingleDirectEntryResult = suggestions.length === 1 && directLinkEntryTypes.includes(suggestions[0].type.toLowerCase());
  const shouldShowCreateSuggestion = withCreateSuggestion && !isSingleDirectEntryResult && !isInitialSuggestions; // If the query has a specified type, then we can skip showing them in the result. See #24839.

  const shouldShowSuggestionsTypes = !(suggestionsQuery !== null && suggestionsQuery !== void 0 && suggestionsQuery.type); // According to guidelines aria-label should be added if the label
  // itself is not visible.
  // See: https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles/listbox_role

  const searchResultsLabelId = `block-editor-link-control-search-results-label-${instanceId}`;
  const labelText = isInitialSuggestions ? Object(external_wp_i18n_["__"])('Recently updated') : Object(external_wp_i18n_["sprintf"])(
  /* translators: %s: search term. */
  Object(external_wp_i18n_["__"])('Search results for "%s"'), currentInputValue); // VisuallyHidden rightly doesn't accept custom classNames
  // so we conditionally render it as a wrapper to visually hide the label
  // when that is required.

  const searchResultsLabel = Object(external_wp_element_["createElement"])(isInitialSuggestions ? external_wp_element_["Fragment"] : external_wp_components_["VisuallyHidden"], {}, // empty props
  Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-link-control__search-results-label",
    id: searchResultsLabelId
  }, labelText));
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-link-control__search-results-wrapper"
  }, searchResultsLabel, Object(external_wp_element_["createElement"])("div", Object(esm_extends["a" /* default */])({}, suggestionsListProps, {
    className: resultsListClasses,
    "aria-labelledby": searchResultsLabelId
  }), suggestions.map((suggestion, index) => {
    if (shouldShowCreateSuggestion && CREATE_TYPE === suggestion.type) {
      return Object(external_wp_element_["createElement"])(search_create_button, {
        searchTerm: currentInputValue,
        buttonText: createSuggestionButtonText,
        onClick: () => handleSuggestionClick(suggestion) // Intentionally only using `type` here as
        // the constant is enough to uniquely
        // identify the single "CREATE" suggestion.
        ,
        key: suggestion.type,
        itemProps: buildSuggestionItemProps(suggestion, index),
        isSelected: index === selectedSuggestion
      });
    } // If we're not handling "Create" suggestions above then
    // we don't want them in the main results so exit early


    if (CREATE_TYPE === suggestion.type) {
      return null;
    }

    return Object(external_wp_element_["createElement"])(search_item, {
      key: `${suggestion.id}-${suggestion.type}`,
      itemProps: buildSuggestionItemProps(suggestion, index),
      suggestion: suggestion,
      index: index,
      onClick: () => {
        handleSuggestionClick(suggestion);
      },
      isSelected: index === selectedSuggestion,
      isURL: directLinkEntryTypes.includes(suggestion.type.toLowerCase()),
      searchTerm: currentInputValue,
      shouldShowType: shouldShowSuggestionsTypes
    });
  })));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/is-url-like.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Determines whether a given value could be a URL. Note this does not
 * guarantee the value is a URL only that it looks like it might be one. For
 * example, just because a string has `www.` in it doesn't make it a URL,
 * but it does make it highly likely that it will be so in the context of
 * creating a link it makes sense to treat it like one.
 *
 * @param {string} val the candidate for being URL-like (or not).
 *
 * @return {boolean} whether or not the value is potentially a URL.
 */

function isURLLike(val) {
  const isInternal = Object(external_lodash_["startsWith"])(val, '#');
  return Object(external_wp_url_["isURL"])(val) || val && val.includes('www.') || isInternal;
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-search-handler.js
/**
 * WordPress dependencies
 */



/**
 * External dependencies
 */


/**
 * Internal dependencies
 */




const handleNoop = () => Promise.resolve([]);
const handleDirectEntry = val => {
  let type = 'URL';
  const protocol = Object(external_wp_url_["getProtocol"])(val) || '';

  if (protocol.includes('mailto')) {
    type = 'mailto';
  }

  if (protocol.includes('tel')) {
    type = 'tel';
  }

  if (Object(external_lodash_["startsWith"])(val, '#')) {
    type = 'internal';
  }

  return Promise.resolve([{
    id: val,
    title: val,
    url: type === 'URL' ? Object(external_wp_url_["prependHTTP"])(val) : val,
    type
  }]);
};

const handleEntitySearch = async (val, suggestionsQuery, fetchSearchSuggestions, directEntryHandler, withCreateSuggestion, withURLSuggestion) => {
  const {
    isInitialSuggestions
  } = suggestionsQuery;
  let results = await Promise.all([fetchSearchSuggestions(val, suggestionsQuery), directEntryHandler(val)]);
  const couldBeURL = !val.includes(' '); // If it's potentially a URL search then concat on a URL search suggestion
  // just for good measure. That way once the actual results run out we always
  // have a URL option to fallback on.

  if (couldBeURL && withURLSuggestion && !isInitialSuggestions) {
    results = results[0].concat(results[1]);
  } else {
    results = results[0];
  } // If displaying initial suggestions just return plain results.


  if (isInitialSuggestions) {
    return results;
  } // Here we append a faux suggestion to represent a "CREATE" option. This
  // is detected in the rendering of the search results and handled as a
  // special case. This is currently necessary because the suggestions
  // dropdown will only appear if there are valid suggestions and
  // therefore unless the create option is a suggestion it will not
  // display in scenarios where there are no results returned from the
  // API. In addition promoting CREATE to a first class suggestion affords
  // the a11y benefits afforded by `URLInput` to all suggestions (eg:
  // keyboard handling, ARIA roles...etc).
  //
  // Note also that the value of the `title` and `url` properties must correspond
  // to the text value of the `<input>`. This is because `title` is used
  // when creating the suggestion. Similarly `url` is used when using keyboard to select
  // the suggestion (the <form> `onSubmit` handler falls-back to `url`).


  return isURLLike(val) || !withCreateSuggestion ? results : results.concat({
    // the `id` prop is intentionally ommitted here because it
    // is never exposed as part of the component's public API.
    // see: https://github.com/WordPress/gutenberg/pull/19775#discussion_r378931316.
    title: val,
    // must match the existing `<input>`s text value
    url: val,
    // must match the existing `<input>`s text value
    type: CREATE_TYPE
  });
};

function useSearchHandler(suggestionsQuery, allowDirectEntry, withCreateSuggestion, withURLSuggestion) {
  const {
    fetchSearchSuggestions
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      getSettings
    } = select(store["a" /* store */]);
    return {
      fetchSearchSuggestions: getSettings().__experimentalFetchLinkSuggestions
    };
  }, []);
  const directEntryHandler = allowDirectEntry ? handleDirectEntry : handleNoop;
  return Object(external_wp_element_["useCallback"])((val, _ref) => {
    let {
      isInitialSuggestions
    } = _ref;
    return isURLLike(val) ? directEntryHandler(val, {
      isInitialSuggestions
    }) : handleEntitySearch(val, { ...suggestionsQuery,
      isInitialSuggestions
    }, fetchSearchSuggestions, directEntryHandler, withCreateSuggestion, withURLSuggestion);
  }, [directEntryHandler, fetchSearchSuggestions, withCreateSuggestion]);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/search-input.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




 // Must be a function as otherwise URLInput will default
// to the fetchLinkSuggestions passed in block editor settings
// which will cause an unintended http request.

const noopSearchHandler = () => Promise.resolve([]);

const LinkControlSearchInput = Object(external_wp_element_["forwardRef"])((_ref, ref) => {
  let {
    value,
    children,
    currentLink = {},
    className = null,
    placeholder = null,
    withCreateSuggestion = false,
    onCreateSuggestion = external_lodash_["noop"],
    onChange = external_lodash_["noop"],
    onSelect = external_lodash_["noop"],
    showSuggestions = true,
    renderSuggestions = props => Object(external_wp_element_["createElement"])(LinkControlSearchResults, props),
    fetchSuggestions = null,
    allowDirectEntry = true,
    showInitialSuggestions = false,
    suggestionsQuery = {},
    withURLSuggestion = true,
    createSuggestionButtonText,
    useLabel = false
  } = _ref;
  const genericSearchHandler = useSearchHandler(suggestionsQuery, allowDirectEntry, withCreateSuggestion, withURLSuggestion);
  const searchHandler = showSuggestions ? fetchSuggestions || genericSearchHandler : noopSearchHandler;
  const instanceId = Object(external_wp_compose_["useInstanceId"])(LinkControlSearchInput);
  const [focusedSuggestion, setFocusedSuggestion] = Object(external_wp_element_["useState"])();
  /**
   * Handles the user moving between different suggestions. Does not handle
   * choosing an individual item.
   *
   * @param {string} selection  the url of the selected suggestion.
   * @param {Object} suggestion the suggestion object.
   */

  const onInputChange = (selection, suggestion) => {
    onChange(selection);
    setFocusedSuggestion(suggestion);
  };

  const handleRenderSuggestions = props => renderSuggestions({ ...props,
    instanceId,
    withCreateSuggestion,
    currentInputValue: value,
    createSuggestionButtonText,
    suggestionsQuery,
    handleSuggestionClick: suggestion => {
      if (props.handleSuggestionClick) {
        props.handleSuggestionClick(suggestion);
      }

      onSuggestionSelected(suggestion);
    }
  });

  const onSuggestionSelected = async selectedSuggestion => {
    let suggestion = selectedSuggestion;

    if (CREATE_TYPE === selectedSuggestion.type) {
      // Create a new page and call onSelect with the output from the onCreateSuggestion callback
      try {
        var _suggestion;

        suggestion = await onCreateSuggestion(selectedSuggestion.title);

        if ((_suggestion = suggestion) !== null && _suggestion !== void 0 && _suggestion.url) {
          onSelect(suggestion);
        }
      } catch (e) {}

      return;
    }

    if (allowDirectEntry || suggestion && Object.keys(suggestion).length >= 1) {
      onSelect( // Some direct entries don't have types or IDs, and we still need to clear the previous ones.
      { ...Object(external_lodash_["omit"])(currentLink, 'id', 'url'),
        ...suggestion
      }, suggestion);
    }
  };

  const inputClasses = classnames_default()(className, {
    'has-no-label': !useLabel
  });
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-link-control__search-input-container"
  }, Object(external_wp_element_["createElement"])(url_input, {
    label: useLabel ? 'URL' : undefined,
    className: inputClasses,
    value: value,
    onChange: onInputChange,
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : Object(external_wp_i18n_["__"])('Search or type url'),
    __experimentalRenderSuggestions: showSuggestions ? handleRenderSuggestions : null,
    __experimentalFetchLinkSuggestions: searchHandler,
    __experimentalHandleURLSuggestions: true,
    __experimentalShowInitialSuggestions: showInitialSuggestions,
    onSubmit: (suggestion, event) => {
      var _value$trim;

      const hasSuggestion = suggestion || focusedSuggestion; // If there is no suggestion and the value (ie: any manually entered URL) is empty
      // then don't allow submission otherwise we get empty links.

      if (!hasSuggestion && !(value !== null && value !== void 0 && (_value$trim = value.trim()) !== null && _value$trim !== void 0 && _value$trim.length)) {
        event.preventDefault();
      } else {
        onSuggestionSelected(hasSuggestion || {
          url: value
        });
      }
    },
    ref: ref
  }), children);
});
/* harmony default export */ var search_input = (LinkControlSearchInput);

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/info.js
var info = __webpack_require__("FnAh");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/edit.js + 1 modules
var edit = __webpack_require__("B9Az");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/link-off.js
var link_off = __webpack_require__("Mp0b");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/viewer-slot.js
/**
 * WordPress dependencies
 */

const {
  Slot: ViewerSlot,
  Fill: ViewerFill
} = Object(external_wp_components_["createSlotFill"])('BlockEditorLinkControlViewer');

/* harmony default export */ var viewer_slot = (ViewerSlot);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-rich-url-data.js
/**
 * Internal dependencies
 */

/**
 * WordPress dependencies
 */




function reducer(state, action) {
  switch (action.type) {
    case 'RESOLVED':
      return { ...state,
        isFetching: false,
        richData: action.richData
      };

    case 'ERROR':
      return { ...state,
        isFetching: false,
        richData: null
      };

    case 'LOADING':
      return { ...state,
        isFetching: true
      };

    default:
      throw new Error(`Unexpected action type ${action.type}`);
  }
}

function useRemoteUrlData(url) {
  const [state, dispatch] = Object(external_wp_element_["useReducer"])(reducer, {
    richData: null,
    isFetching: false
  });
  const {
    fetchRichUrlData
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      getSettings
    } = select(store["a" /* store */]);
    return {
      fetchRichUrlData: getSettings().__experimentalFetchRichUrlData
    };
  }, []);
  Object(external_wp_element_["useEffect"])(() => {
    // Only make the request if we have an actual URL
    // and the fetching util is available. In some editors
    // there may not be such a util.
    if (url !== null && url !== void 0 && url.length && fetchRichUrlData && typeof AbortController !== 'undefined') {
      dispatch({
        type: 'LOADING'
      });
      const controller = new window.AbortController();
      const signal = controller.signal;
      fetchRichUrlData(url, {
        signal
      }).then(urlData => {
        dispatch({
          type: 'RESOLVED',
          richData: urlData
        });
      }).catch(() => {
        // Avoid setting state on unmounted component
        if (!signal.aborted) {
          dispatch({
            type: 'ERROR'
          });
        }
      }); // Cleanup: when the URL changes the abort the current request

      return () => {
        controller.abort();
      };
    }
  }, [url]);
  return state;
}

/* harmony default export */ var use_rich_url_data = (useRemoteUrlData);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/link-preview.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



function LinkPreview(_ref) {
  var _value$url;

  let {
    value,
    onEditClick,
    hasRichPreviews = false,
    hasUnlinkControl = false,
    onRemove
  } = _ref;
  // Avoid fetching if rich previews are not desired.
  const showRichPreviews = hasRichPreviews ? value === null || value === void 0 ? void 0 : value.url : null;
  const {
    richData,
    isFetching
  } = use_rich_url_data(showRichPreviews); // Rich data may be an empty object so test for that.

  const hasRichData = richData && Object.keys(richData).length;
  const displayURL = value && Object(external_wp_url_["filterURLForDisplay"])(Object(external_wp_url_["safeDecodeURI"])(value.url), 16) || '';
  const displayTitle = (richData === null || richData === void 0 ? void 0 : richData.title) || (value === null || value === void 0 ? void 0 : value.title) || displayURL; // url can be undefined if the href attribute is unset

  const isEmptyURL = !(value !== null && value !== void 0 && (_value$url = value.url) !== null && _value$url !== void 0 && _value$url.length);
  let icon;

  if (richData !== null && richData !== void 0 && richData.icon) {
    icon = Object(external_wp_element_["createElement"])("img", {
      src: richData === null || richData === void 0 ? void 0 : richData.icon,
      alt: ""
    });
  } else if (isEmptyURL) {
    icon = Object(external_wp_element_["createElement"])(build_module_icon["a" /* default */], {
      icon: info["a" /* default */],
      size: 32
    });
  } else {
    icon = Object(external_wp_element_["createElement"])(build_module_icon["a" /* default */], {
      icon: globe["a" /* default */]
    });
  }

  return Object(external_wp_element_["createElement"])("div", {
    "aria-label": Object(external_wp_i18n_["__"])('Currently selected'),
    "aria-selected": "true",
    className: classnames_default()('block-editor-link-control__search-item', {
      'is-current': true,
      'is-rich': hasRichData,
      'is-fetching': !!isFetching,
      'is-preview': true,
      'is-error': isEmptyURL
    })
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-link-control__search-item-top"
  }, Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-link-control__search-item-header"
  }, Object(external_wp_element_["createElement"])("span", {
    className: classnames_default()('block-editor-link-control__search-item-icon', {
      'is-image': richData === null || richData === void 0 ? void 0 : richData.icon
    })
  }, icon), Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-link-control__search-item-details"
  }, !isEmptyURL ? Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["ExternalLink"], {
    className: "block-editor-link-control__search-item-title",
    href: value.url
  }, Object(external_wp_dom_["__unstableStripHTML"])(displayTitle)), (value === null || value === void 0 ? void 0 : value.url) && Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-link-control__search-item-info"
  }, displayURL)) : Object(external_wp_element_["createElement"])("span", {
    className: "block-editor-link-control__search-item-error-notice"
  }, "Link is empty"))), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    icon: edit["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Edit'),
    className: "block-editor-link-control__search-item-action",
    onClick: onEditClick,
    iconSize: 24
  }), hasUnlinkControl && Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    icon: link_off["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Unlink'),
    className: "block-editor-link-control__search-item-action block-editor-link-control__unlink",
    onClick: onRemove,
    iconSize: 24
  }), Object(external_wp_element_["createElement"])(ViewerSlot, {
    fillProps: value
  })), (hasRichData && ((richData === null || richData === void 0 ? void 0 : richData.image) || (richData === null || richData === void 0 ? void 0 : richData.description)) || isFetching) && Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-link-control__search-item-bottom"
  }, ((richData === null || richData === void 0 ? void 0 : richData.image) || isFetching) && Object(external_wp_element_["createElement"])("div", {
    "aria-hidden": !(richData !== null && richData !== void 0 && richData.image),
    className: classnames_default()('block-editor-link-control__search-item-image', {
      'is-placeholder': !(richData !== null && richData !== void 0 && richData.image)
    })
  }, (richData === null || richData === void 0 ? void 0 : richData.image) && Object(external_wp_element_["createElement"])("img", {
    src: richData === null || richData === void 0 ? void 0 : richData.image,
    alt: ""
  })), ((richData === null || richData === void 0 ? void 0 : richData.description) || isFetching) && Object(external_wp_element_["createElement"])("div", {
    "aria-hidden": !(richData !== null && richData !== void 0 && richData.description),
    className: classnames_default()('block-editor-link-control__search-item-description', {
      'is-placeholder': !(richData !== null && richData !== void 0 && richData.description)
    })
  }, (richData === null || richData === void 0 ? void 0 : richData.description) && Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalText"], {
    truncate: true,
    numberOfLines: "2"
  }, richData.description))));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/use-create-page.js
/**
 * WordPress dependencies
 */


function useCreatePage(handleCreatePage) {
  const cancelableCreateSuggestion = Object(external_wp_element_["useRef"])();
  const [isCreatingPage, setIsCreatingPage] = Object(external_wp_element_["useState"])(false);
  const [errorMessage, setErrorMessage] = Object(external_wp_element_["useState"])(null);

  const createPage = async function (suggestionTitle) {
    setIsCreatingPage(true);
    setErrorMessage(null);

    try {
      // Make cancellable in order that we can avoid setting State
      // if the component unmounts during the call to `createSuggestion`
      cancelableCreateSuggestion.current = makeCancelable( // Using Promise.resolve to allow createSuggestion to return a
      // non-Promise based value.
      Promise.resolve(handleCreatePage(suggestionTitle)));
      return await cancelableCreateSuggestion.current.promise;
    } catch (error) {
      if (error && error.isCanceled) {
        return; // bail if canceled to avoid setting state
      }

      setErrorMessage(error.message || Object(external_wp_i18n_["__"])('An unknown error occurred during creation. Please try again.'));
      throw error;
    } finally {
      setIsCreatingPage(false);
    }
  };
  /**
   * Handles cancelling any pending Promises that have been made cancelable.
   */


  Object(external_wp_element_["useEffect"])(() => {
    return () => {
      // componentDidUnmount
      if (cancelableCreateSuggestion.current) {
        cancelableCreateSuggestion.current.cancel();
      }
    };
  }, []);
  return {
    createPage,
    isCreatingPage,
    errorMessage
  };
}
/**
 * Creates a wrapper around a promise which allows it to be programmatically
 * cancelled.
 * See: https://reactjs.org/blog/2015/12/16/ismounted-antipattern.html
 *
 * @param {Promise} promise the Promise to make cancelable
 */

const makeCancelable = promise => {
  let hasCanceled_ = false;
  const wrappedPromise = new Promise((resolve, reject) => {
    promise.then(val => hasCanceled_ ? reject({
      isCanceled: true
    }) : resolve(val), error => hasCanceled_ ? reject({
      isCanceled: true
    }) : reject(error));
  });
  return {
    promise: wrappedPromise,

    cancel() {
      hasCanceled_ = true;
    }

  };
};

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/link-control/index.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */







/**
 * Default properties associated with a link control value.
 *
 * @typedef WPLinkControlDefaultValue
 *
 * @property {string}   url           Link URL.
 * @property {string=}  title         Link title.
 * @property {boolean=} opensInNewTab Whether link should open in a new browser
 *                                    tab. This value is only assigned if not
 *                                    providing a custom `settings` prop.
 */

/* eslint-disable jsdoc/valid-types */

/**
 * Custom settings values associated with a link.
 *
 * @typedef {{[setting:string]:any}} WPLinkControlSettingsValue
 */

/* eslint-enable */

/**
 * Custom settings values associated with a link.
 *
 * @typedef WPLinkControlSetting
 *
 * @property {string} id    Identifier to use as property for setting value.
 * @property {string} title Human-readable label to show in user interface.
 */

/**
 * Properties associated with a link control value, composed as a union of the
 * default properties and any custom settings values.
 *
 * @typedef {WPLinkControlDefaultValue&WPLinkControlSettingsValue} WPLinkControlValue
 */

/** @typedef {(nextValue:WPLinkControlValue)=>void} WPLinkControlOnChangeProp */

/**
 * Properties associated with a search suggestion used within the LinkControl.
 *
 * @typedef WPLinkControlSuggestion
 *
 * @property {string} id    Identifier to use to uniquely identify the suggestion.
 * @property {string} type  Identifies the type of the suggestion (eg: `post`,
 *                          `page`, `url`...etc)
 * @property {string} title Human-readable label to show in user interface.
 * @property {string} url   A URL for the suggestion.
 */

/** @typedef {(title:string)=>WPLinkControlSuggestion} WPLinkControlCreateSuggestionProp */

/**
 * @typedef WPLinkControlProps
 *
 * @property {(WPLinkControlSetting[])=}  settings                   An array of settings objects. Each object will used to
 *                                                                   render a `ToggleControl` for that setting.
 * @property {boolean=}                   forceIsEditingLink         If passed as either `true` or `false`, controls the
 *                                                                   internal editing state of the component to respective
 *                                                                   show or not show the URL input field.
 * @property {WPLinkControlValue=}        value                      Current link value.
 * @property {WPLinkControlOnChangeProp=} onChange                   Value change handler, called with the updated value if
 *                                                                   the user selects a new link or updates settings.
 * @property {boolean=}                   noDirectEntry              Whether to allow turning a URL-like search query directly into a link.
 * @property {boolean=}                   showSuggestions            Whether to present suggestions when typing the URL.
 * @property {boolean=}                   showInitialSuggestions     Whether to present initial suggestions immediately.
 * @property {boolean=}                   withCreateSuggestion       Whether to allow creation of link value from suggestion.
 * @property {Object=}                    suggestionsQuery           Query parameters to pass along to wp.blockEditor.__experimentalFetchLinkSuggestions.
 * @property {boolean=}                   noURLSuggestion            Whether to add a fallback suggestion which treats the search query as a URL.
 * @property {string|Function|undefined}  createSuggestionButtonText The text to use in the button that calls createSuggestion.
 * @property {Function}                   renderControlBottom        Optional controls to be rendered at the bottom of the component.
 */

/**
 * Renders a link control. A link control is a controlled input which maintains
 * a value associated with a link (HTML anchor element) and relevant settings
 * for how that link is expected to behave.
 *
 * @param {WPLinkControlProps} props Component props.
 */

function LinkControl(_ref) {
  var _currentInputValue$tr, _value$url, _value$url$trim;

  let {
    searchInputPlaceholder,
    value,
    settings = DEFAULT_LINK_SETTINGS,
    onChange = external_lodash_["noop"],
    onRemove,
    noDirectEntry = false,
    showSuggestions = true,
    showInitialSuggestions,
    forceIsEditingLink,
    createSuggestion,
    withCreateSuggestion,
    inputValue: propInputValue = '',
    suggestionsQuery = {},
    noURLSuggestion = false,
    createSuggestionButtonText,
    hasRichPreviews = false,
    hasTextControl = false,
    renderControlBottom = null
  } = _ref;

  if (withCreateSuggestion === undefined && createSuggestion) {
    withCreateSuggestion = true;
  }

  const isMounting = Object(external_wp_element_["useRef"])(true);
  const wrapperNode = Object(external_wp_element_["useRef"])();
  const textInputRef = Object(external_wp_element_["useRef"])();
  const [internalInputValue, setInternalInputValue] = Object(external_wp_element_["useState"])((value === null || value === void 0 ? void 0 : value.url) || '');
  const [internalTextValue, setInternalTextValue] = Object(external_wp_element_["useState"])((value === null || value === void 0 ? void 0 : value.title) || '');
  const currentInputValue = propInputValue || internalInputValue;
  const [isEditingLink, setIsEditingLink] = Object(external_wp_element_["useState"])(forceIsEditingLink !== undefined ? forceIsEditingLink : !value || !value.url);
  const isEndingEditWithFocus = Object(external_wp_element_["useRef"])(false);
  const currentInputIsEmpty = !(currentInputValue !== null && currentInputValue !== void 0 && (_currentInputValue$tr = currentInputValue.trim()) !== null && _currentInputValue$tr !== void 0 && _currentInputValue$tr.length);
  Object(external_wp_element_["useEffect"])(() => {
    if (forceIsEditingLink !== undefined && forceIsEditingLink !== isEditingLink) {
      setIsEditingLink(forceIsEditingLink);
    }
  }, [forceIsEditingLink]);
  Object(external_wp_element_["useEffect"])(() => {
    // We don't auto focus into the Link UI on mount
    // because otherwise using the keyboard to select text
    // *within* the link format is not possible.
    if (isMounting.current) {
      isMounting.current = false;
      return;
    } // Unless we are mounting, we always want to focus either:
    // - the URL input
    // - the first focusable element in the Link UI.
    // But in editing mode if there is a text input present then
    // the URL input is at index 1. If not then it is at index 0.


    const whichFocusTargetIndex = textInputRef !== null && textInputRef !== void 0 && textInputRef.current ? 1 : 0; // Scenario - when:
    // - switching between editable and non editable LinkControl
    // - clicking on a link
    // ...then move focus to the *first* element to avoid focus loss
    // and to ensure focus is *within* the Link UI.

    const nextFocusTarget = external_wp_dom_["focus"].focusable.find(wrapperNode.current)[whichFocusTargetIndex] || wrapperNode.current;
    nextFocusTarget.focus();
    isEndingEditWithFocus.current = false;
  }, [isEditingLink]);
  Object(external_wp_element_["useEffect"])(() => {
    /**
     * If the value's `text` property changes then sync this
     * back up with state.
     */
    if (value !== null && value !== void 0 && value.title && value.title !== internalTextValue) {
      setInternalTextValue(value.title);
    }
    /**
     * Update the state value internalInputValue if the url value changes
     * for example when clicking on another anchor
     */


    if (value !== null && value !== void 0 && value.url) {
      setInternalInputValue(value.url);
    }
  }, [value]);
  /**
   * Cancels editing state and marks that focus may need to be restored after
   * the next render, if focus was within the wrapper when editing finished.
   */

  function stopEditing() {
    var _wrapperNode$current;

    isEndingEditWithFocus.current = !!((_wrapperNode$current = wrapperNode.current) !== null && _wrapperNode$current !== void 0 && _wrapperNode$current.contains(wrapperNode.current.ownerDocument.activeElement));
    setIsEditingLink(false);
  }

  const {
    createPage,
    isCreatingPage,
    errorMessage
  } = useCreatePage(createSuggestion);

  const handleSelectSuggestion = updatedValue => {
    onChange({ ...updatedValue,
      title: internalTextValue || (updatedValue === null || updatedValue === void 0 ? void 0 : updatedValue.title)
    });
    stopEditing();
  };

  const handleSubmit = () => {
    if (currentInputValue !== (value === null || value === void 0 ? void 0 : value.url) || internalTextValue !== (value === null || value === void 0 ? void 0 : value.title)) {
      onChange({
        url: currentInputValue,
        title: internalTextValue
      });
    }

    stopEditing();
  };

  const handleSubmitWithEnter = event => {
    const {
      keyCode
    } = event;

    if (keyCode === external_wp_keycodes_["ENTER"] && !currentInputIsEmpty // disallow submitting empty values.
    ) {
      event.preventDefault();
      handleSubmit();
    }
  };

  const shownUnlinkControl = onRemove && value && !isEditingLink && !isCreatingPage;
  const showSettingsDrawer = !!(settings !== null && settings !== void 0 && settings.length); // Only show text control once a URL value has been committed
  // and it isn't just empty whitespace.
  // See https://github.com/WordPress/gutenberg/pull/33849/#issuecomment-932194927.

  const showTextControl = (value === null || value === void 0 ? void 0 : (_value$url = value.url) === null || _value$url === void 0 ? void 0 : (_value$url$trim = _value$url.trim()) === null || _value$url$trim === void 0 ? void 0 : _value$url$trim.length) > 0 && hasTextControl;
  return Object(external_wp_element_["createElement"])("div", {
    tabIndex: -1,
    ref: wrapperNode,
    className: "block-editor-link-control"
  }, isCreatingPage && Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-link-control__loading"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Spinner"], null), " ", Object(external_wp_i18n_["__"])('Creating'), "\u2026"), (isEditingLink || !value) && !isCreatingPage && Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])("div", {
    className: classnames_default()({
      'block-editor-link-control__search-input-wrapper': true,
      'has-text-control': showTextControl
    })
  }, showTextControl && Object(external_wp_element_["createElement"])(external_wp_components_["TextControl"], {
    ref: textInputRef,
    className: "block-editor-link-control__field block-editor-link-control__text-content",
    label: "Text",
    value: internalTextValue,
    onChange: setInternalTextValue,
    onKeyDown: handleSubmitWithEnter
  }), Object(external_wp_element_["createElement"])(search_input, {
    currentLink: value,
    className: "block-editor-link-control__field block-editor-link-control__search-input",
    placeholder: searchInputPlaceholder,
    value: currentInputValue,
    withCreateSuggestion: withCreateSuggestion,
    onCreateSuggestion: createPage,
    onChange: setInternalInputValue,
    onSelect: handleSelectSuggestion,
    showInitialSuggestions: showInitialSuggestions,
    allowDirectEntry: !noDirectEntry,
    showSuggestions: showSuggestions,
    suggestionsQuery: suggestionsQuery,
    withURLSuggestion: !noURLSuggestion,
    createSuggestionButtonText: createSuggestionButtonText,
    useLabel: showTextControl
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-link-control__search-actions"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    onClick: handleSubmit,
    label: Object(external_wp_i18n_["__"])('Submit'),
    icon: keyboard_return["a" /* default */],
    className: "block-editor-link-control__search-submit",
    disabled: currentInputIsEmpty // disallow submitting empty values.

  })))), errorMessage && Object(external_wp_element_["createElement"])(external_wp_components_["Notice"], {
    className: "block-editor-link-control__search-error",
    status: "error",
    isDismissible: false
  }, errorMessage)), value && !isEditingLink && !isCreatingPage && Object(external_wp_element_["createElement"])(LinkPreview, {
    key: value === null || value === void 0 ? void 0 : value.url // force remount when URL changes to avoid race conditions for rich previews
    ,
    value: value,
    onEditClick: () => setIsEditingLink(true),
    hasRichPreviews: hasRichPreviews,
    hasUnlinkControl: shownUnlinkControl,
    onRemove: onRemove
  }), showSettingsDrawer && Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-link-control__tools"
  }, Object(external_wp_element_["createElement"])(settings_drawer, {
    value: value,
    settings: settings,
    onChange: onChange
  })), renderControlBottom && renderControlBottom());
}

LinkControl.ViewerFill = ViewerFill;
/* harmony default export */ var link_control = (LinkControl);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/line-height-control/index.js + 1 modules
var line_height_control = __webpack_require__("weEX");

// EXTERNAL MODULE: external ["wp","a11y"]
var external_wp_a11y_ = __webpack_require__("gdqT");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/media.js
var library_media = __webpack_require__("rH4q");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/upload.js
var upload = __webpack_require__("NTP4");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/media-upload/index.js
/**
 * WordPress dependencies
 */

/**
 * This is a placeholder for the media upload component necessary to make it possible to provide
 * an integration with the core blocks that handle media files. By default it renders nothing but
 * it provides a way to have it overridden with the `editor.MediaUpload` filter.
 *
 * @return {WPComponent} The component to be rendered.
 */

const MediaUpload = () => null;
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/media-upload/README.md
 */


/* harmony default export */ var media_upload = (Object(external_wp_components_["withFilters"])('editor.MediaUpload')(MediaUpload));

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/media-upload/check.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function MediaUploadCheck(_ref) {
  let {
    fallback = null,
    children
  } = _ref;
  const hasUploadPermissions = Object(external_wp_data_["useSelect"])(select => {
    const {
      getSettings
    } = select(store["a" /* store */]);
    return !!getSettings().mediaUpload;
  }, []);
  return hasUploadPermissions ? children : fallback;
}
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/media-upload/README.md
 */

/* harmony default export */ var media_upload_check = (MediaUploadCheck);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/media-replace-flow/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */










/**
 * Internal dependencies
 */






const MediaReplaceFlow = _ref => {
  let {
    mediaURL,
    mediaId,
    allowedTypes,
    accept,
    onSelect,
    onSelectURL,
    onFilesUpload = external_lodash_["noop"],
    name = Object(external_wp_i18n_["__"])('Replace'),
    createNotice,
    removeNotice,
    children
  } = _ref;
  const [mediaURLValue, setMediaURLValue] = Object(external_wp_element_["useState"])(mediaURL);
  const mediaUpload = Object(external_wp_data_["useSelect"])(select => {
    return select(store["a" /* store */]).getSettings().mediaUpload;
  }, []);
  const editMediaButtonRef = Object(external_wp_element_["createRef"])();
  const errorNoticeID = Object(external_lodash_["uniqueId"])('block-editor/media-replace-flow/error-notice/');

  const onError = message => {
    const errorElement = document.createElement('div');
    errorElement.innerHTML = Object(external_wp_element_["renderToString"])(message); // The default error contains some HTML that,
    // for example, makes the filename bold.
    // The notice, by default, accepts strings only and so
    // we need to remove the html from the error.

    const renderMsg = errorElement.textContent || errorElement.innerText || ''; // We need to set a timeout for showing the notice
    // so that VoiceOver and possibly other screen readers
    // can announce the error afer the toolbar button
    // regains focus once the upload dialog closes.
    // Otherwise VO simply skips over the notice and announces
    // the focused element and the open menu.

    setTimeout(() => {
      createNotice('error', renderMsg, {
        speak: true,
        id: errorNoticeID,
        isDismissible: true
      });
    }, 1000);
  };

  const selectMedia = media => {
    setMediaURLValue(media.url); // Calling `onSelect` after the state update since it might unmount the component.

    onSelect(media);
    Object(external_wp_a11y_["speak"])(Object(external_wp_i18n_["__"])('The media file has been replaced'));
    removeNotice(errorNoticeID);
  };

  const selectURL = newURL => {
    onSelectURL(newURL);
  };

  const uploadFiles = event => {
    const files = event.target.files;
    onFilesUpload(files);

    const setMedia = _ref2 => {
      let [media] = _ref2;
      selectMedia(media);
    };

    mediaUpload({
      allowedTypes,
      filesList: files,
      onFileChange: setMedia,
      onError
    });
  };

  const openOnArrowDown = event => {
    if (event.keyCode === external_wp_keycodes_["DOWN"]) {
      event.preventDefault();
      event.target.click();
    }
  };

  const POPOVER_PROPS = {
    isAlternate: true
  };
  return Object(external_wp_element_["createElement"])(external_wp_components_["Dropdown"], {
    popoverProps: POPOVER_PROPS,
    contentClassName: "block-editor-media-replace-flow__options",
    renderToggle: _ref3 => {
      let {
        isOpen,
        onToggle
      } = _ref3;
      return Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
        ref: editMediaButtonRef,
        "aria-expanded": isOpen,
        "aria-haspopup": "true",
        onClick: onToggle,
        onKeyDown: openOnArrowDown
      }, name);
    },
    renderContent: _ref4 => {
      let {
        onClose
      } = _ref4;
      return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["NavigableMenu"], {
        className: "block-editor-media-replace-flow__media-upload-menu"
      }, Object(external_wp_element_["createElement"])(media_upload, {
        value: mediaId,
        onSelect: media => selectMedia(media),
        allowedTypes: allowedTypes,
        render: _ref5 => {
          let {
            open
          } = _ref5;
          return Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
            icon: library_media["a" /* default */],
            onClick: open
          }, Object(external_wp_i18n_["__"])('Open Media Library'));
        }
      }), Object(external_wp_element_["createElement"])(media_upload_check, null, Object(external_wp_element_["createElement"])(external_wp_components_["FormFileUpload"], {
        onChange: event => {
          uploadFiles(event, onClose);
        },
        accept: accept,
        render: _ref6 => {
          let {
            openFileDialog
          } = _ref6;
          return Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
            icon: upload["a" /* default */],
            onClick: () => {
              openFileDialog();
            }
          }, Object(external_wp_i18n_["__"])('Upload'));
        }
      })), children), onSelectURL && // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
      Object(external_wp_element_["createElement"])("form", {
        className: "block-editor-media-flow__url-input"
      }, Object(external_wp_element_["createElement"])("span", {
        className: "block-editor-media-replace-flow__image-url-label"
      }, Object(external_wp_i18n_["__"])('Current media URL:')), Object(external_wp_element_["createElement"])(link_control, {
        value: {
          url: mediaURLValue
        },
        settings: [],
        showSuggestions: false,
        onChange: _ref7 => {
          let {
            url
          } = _ref7;
          setMediaURLValue(url);
          selectURL(url);
          editMediaButtonRef.current.focus();
        }
      })));
    }
  });
};

/* harmony default export */ var media_replace_flow = (Object(external_wp_compose_["compose"])([Object(external_wp_data_["withDispatch"])(dispatch => {
  const {
    createNotice,
    removeNotice
  } = dispatch(external_wp_notices_["store"]);
  return {
    createNotice,
    removeNotice
  };
}), Object(external_wp_components_["withFilters"])('editor.MediaReplaceFlow')])(MediaReplaceFlow));

// EXTERNAL MODULE: external ["wp","deprecated"]
var external_wp_deprecated_ = __webpack_require__("NMb1");
var external_wp_deprecated_default = /*#__PURE__*/__webpack_require__.n(external_wp_deprecated_);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/url-popover/link-viewer-url.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



function LinkViewerURL(_ref) {
  let {
    url,
    urlLabel,
    className
  } = _ref;
  const linkClassName = classnames_default()(className, 'block-editor-url-popover__link-viewer-url');

  if (!url) {
    return Object(external_wp_element_["createElement"])("span", {
      className: linkClassName
    });
  }

  return Object(external_wp_element_["createElement"])(external_wp_components_["ExternalLink"], {
    className: linkClassName,
    href: url
  }, urlLabel || Object(external_wp_url_["filterURLForDisplay"])(Object(external_wp_url_["safeDecodeURI"])(url)));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/url-popover/link-viewer.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function LinkViewer(_ref) {
  let {
    className,
    linkClassName,
    onEditLinkClick,
    url,
    urlLabel,
    ...props
  } = _ref;
  return Object(external_wp_element_["createElement"])("div", Object(esm_extends["a" /* default */])({
    className: classnames_default()('block-editor-url-popover__link-viewer', className)
  }, props), Object(external_wp_element_["createElement"])(LinkViewerURL, {
    url: url,
    urlLabel: urlLabel,
    className: linkClassName
  }), onEditLinkClick && Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    icon: edit["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Edit'),
    onClick: onEditLinkClick
  }));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/url-popover/link-editor.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function LinkEditor(_ref) {
  let {
    autocompleteRef,
    className,
    onChangeInputValue,
    value,
    ...props
  } = _ref;
  return Object(external_wp_element_["createElement"])("form", Object(esm_extends["a" /* default */])({
    className: classnames_default()('block-editor-url-popover__link-editor', className)
  }, props), Object(external_wp_element_["createElement"])(url_input, {
    value: value,
    onChange: onChangeInputValue,
    autocompleteRef: autocompleteRef
  }), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    icon: keyboard_return["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Apply'),
    type: "submit"
  }));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/url-popover/index.js



/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




function URLPopover(_ref) {
  let {
    additionalControls,
    children,
    renderSettings,
    position = 'bottom center',
    focusOnMount = 'firstElement',
    ...popoverProps
  } = _ref;
  const [isSettingsExpanded, setIsSettingsExpanded] = Object(external_wp_element_["useState"])(false);
  const showSettings = !!renderSettings && isSettingsExpanded;

  const toggleSettingsVisibility = () => {
    setIsSettingsExpanded(!isSettingsExpanded);
  };

  return Object(external_wp_element_["createElement"])(external_wp_components_["Popover"], Object(esm_extends["a" /* default */])({
    className: "block-editor-url-popover",
    focusOnMount: focusOnMount,
    position: position
  }, popoverProps), Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-url-popover__input-container"
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-url-popover__row"
  }, children, !!renderSettings && Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    className: "block-editor-url-popover__settings-toggle",
    icon: chevron_down["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Link settings'),
    onClick: toggleSettingsVisibility,
    "aria-expanded": isSettingsExpanded
  })), showSettings && Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-url-popover__row block-editor-url-popover__settings"
  }, renderSettings())), additionalControls && !showSettings && Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-url-popover__additional-controls"
  }, additionalControls));
}

URLPopover.LinkEditor = LinkEditor;
URLPopover.LinkViewer = LinkViewer;
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/url-popover/README.md
 */

/* harmony default export */ var url_popover = (URLPopover);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/media-placeholder/index.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */






const InsertFromURLPopover = _ref => {
  let {
    src,
    onChange,
    onSubmit,
    onClose
  } = _ref;
  return Object(external_wp_element_["createElement"])(url_popover, {
    onClose: onClose
  }, Object(external_wp_element_["createElement"])("form", {
    className: "block-editor-media-placeholder__url-input-form",
    onSubmit: onSubmit
  }, Object(external_wp_element_["createElement"])("input", {
    className: "block-editor-media-placeholder__url-input-field",
    type: "text",
    "aria-label": Object(external_wp_i18n_["__"])('URL'),
    placeholder: Object(external_wp_i18n_["__"])('Paste or type URL'),
    onChange: onChange,
    value: src
  }), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    className: "block-editor-media-placeholder__url-input-submit-button",
    icon: keyboard_return["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Apply'),
    type: "submit"
  })));
};

function MediaPlaceholder(_ref2) {
  let {
    value = {},
    allowedTypes,
    className,
    icon,
    labels = {},
    mediaPreview,
    notices,
    isAppender,
    accept,
    addToGallery,
    multiple = false,
    handleUpload = true,
    dropZoneUIOnly,
    disableDropZone,
    disableMediaButtons,
    onError,
    onSelect,
    onCancel,
    onSelectURL,
    onDoubleClick,
    onFilesPreUpload = external_lodash_["noop"],
    onHTMLDrop = external_lodash_["noop"],
    children,
    mediaLibraryButton,
    placeholder,
    style
  } = _ref2;
  const mediaUpload = Object(external_wp_data_["useSelect"])(select => {
    const {
      getSettings
    } = select(store["a" /* store */]);
    return getSettings().mediaUpload;
  }, []);
  const [src, setSrc] = Object(external_wp_element_["useState"])('');
  const [isURLInputVisible, setIsURLInputVisible] = Object(external_wp_element_["useState"])(false);
  Object(external_wp_element_["useEffect"])(() => {
    var _value$src;

    setSrc((_value$src = value === null || value === void 0 ? void 0 : value.src) !== null && _value$src !== void 0 ? _value$src : '');
  }, [value === null || value === void 0 ? void 0 : value.src]);

  const onlyAllowsImages = () => {
    if (!allowedTypes || allowedTypes.length === 0) {
      return false;
    }

    return allowedTypes.every(allowedType => allowedType === 'image' || allowedType.startsWith('image/'));
  };

  const onChangeSrc = event => {
    setSrc(event.target.value);
  };

  const openURLInput = () => {
    setIsURLInputVisible(true);
  };

  const closeURLInput = () => {
    setIsURLInputVisible(false);
  };

  const onSubmitSrc = event => {
    event.preventDefault();

    if (src && onSelectURL) {
      onSelectURL(src);
      closeURLInput();
    }
  };

  const onFilesUpload = files => {
    if (!handleUpload) {
      return onSelect(files);
    }

    onFilesPreUpload(files);
    let setMedia;

    if (multiple) {
      if (addToGallery) {
        // Since the setMedia function runs multiple times per upload group
        // and is passed newMedia containing every item in its group each time, we must
        // filter out whatever this upload group had previously returned to the
        // gallery before adding and returning the image array with replacement newMedia
        // values.
        // Define an array to store urls from newMedia between subsequent function calls.
        let lastMediaPassed = [];

        setMedia = newMedia => {
          // Remove any images this upload group is responsible for (lastMediaPassed).
          // Their replacements are contained in newMedia.
          const filteredMedia = (value !== null && value !== void 0 ? value : []).filter(item => {
            // If Item has id, only remove it if lastMediaPassed has an item with that id.
            if (item.id) {
              return !lastMediaPassed.some( // Be sure to convert to number for comparison.
              _ref3 => {
                let {
                  id
                } = _ref3;
                return Number(id) === Number(item.id);
              });
            } // Compare transient images via .includes since gallery may append extra info onto the url.


            return !lastMediaPassed.some(_ref4 => {
              let {
                urlSlug
              } = _ref4;
              return item.url.includes(urlSlug);
            });
          }); // Return the filtered media array along with newMedia.

          onSelect(filteredMedia.concat(newMedia)); // Reset lastMediaPassed and set it with ids and urls from newMedia.

          lastMediaPassed = newMedia.map(media => {
            // Add everything up to '.fileType' to compare via .includes.
            const cutOffIndex = media.url.lastIndexOf('.');
            const urlSlug = media.url.slice(0, cutOffIndex);
            return {
              id: media.id,
              urlSlug
            };
          });
        };
      } else {
        setMedia = onSelect;
      }
    } else {
      setMedia = _ref5 => {
        let [media] = _ref5;
        return onSelect(media);
      };
    }

    mediaUpload({
      allowedTypes,
      filesList: files,
      onFileChange: setMedia,
      onError
    });
  };

  const onUpload = event => {
    onFilesUpload(event.target.files);
  };

  const defaultRenderPlaceholder = content => {
    let {
      instructions,
      title
    } = labels;

    if (!mediaUpload && !onSelectURL) {
      instructions = Object(external_wp_i18n_["__"])('To edit this block, you need permission to upload media.');
    }

    if (instructions === undefined || title === undefined) {
      const typesAllowed = allowedTypes !== null && allowedTypes !== void 0 ? allowedTypes : [];
      const [firstAllowedType] = typesAllowed;
      const isOneType = 1 === typesAllowed.length;
      const isAudio = isOneType && 'audio' === firstAllowedType;
      const isImage = isOneType && 'image' === firstAllowedType;
      const isVideo = isOneType && 'video' === firstAllowedType;

      if (instructions === undefined && mediaUpload) {
        instructions = Object(external_wp_i18n_["__"])('Upload a media file or pick one from your media library.');

        if (isAudio) {
          instructions = Object(external_wp_i18n_["__"])('Upload an audio file, pick one from your media library, or add one with a URL.');
        } else if (isImage) {
          instructions = Object(external_wp_i18n_["__"])('Upload an image file, pick one from your media library, or add one with a URL.');
        } else if (isVideo) {
          instructions = Object(external_wp_i18n_["__"])('Upload a video file, pick one from your media library, or add one with a URL.');
        }
      }

      if (title === undefined) {
        title = Object(external_wp_i18n_["__"])('Media');

        if (isAudio) {
          title = Object(external_wp_i18n_["__"])('Audio');
        } else if (isImage) {
          title = Object(external_wp_i18n_["__"])('Image');
        } else if (isVideo) {
          title = Object(external_wp_i18n_["__"])('Video');
        }
      }
    }

    const placeholderClassName = classnames_default()('block-editor-media-placeholder', className, {
      'is-appender': isAppender
    });
    return Object(external_wp_element_["createElement"])(external_wp_components_["Placeholder"], {
      icon: icon,
      label: title,
      instructions: instructions,
      className: placeholderClassName,
      notices: notices,
      onDoubleClick: onDoubleClick,
      preview: mediaPreview,
      style: style
    }, content, children);
  };

  const renderPlaceholder = placeholder !== null && placeholder !== void 0 ? placeholder : defaultRenderPlaceholder;

  const renderDropZone = () => {
    if (disableDropZone) {
      return null;
    }

    return Object(external_wp_element_["createElement"])(external_wp_components_["DropZone"], {
      onFilesDrop: onFilesUpload,
      onHTMLDrop: onHTMLDrop
    });
  };

  const renderCancelLink = () => {
    return onCancel && Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
      className: "block-editor-media-placeholder__cancel-button",
      title: Object(external_wp_i18n_["__"])('Cancel'),
      variant: "link",
      onClick: onCancel
    }, Object(external_wp_i18n_["__"])('Cancel'));
  };

  const renderUrlSelectionUI = () => {
    return onSelectURL && Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-media-placeholder__url-input-container"
    }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
      className: "block-editor-media-placeholder__button",
      onClick: openURLInput,
      isPressed: isURLInputVisible,
      variant: "tertiary"
    }, Object(external_wp_i18n_["__"])('Insert from URL')), isURLInputVisible && Object(external_wp_element_["createElement"])(InsertFromURLPopover, {
      src: src,
      onChange: onChangeSrc,
      onSubmit: onSubmitSrc,
      onClose: closeURLInput
    }));
  };

  const renderMediaUploadChecked = () => {
    const defaultButton = _ref6 => {
      let {
        open
      } = _ref6;
      return Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
        variant: "tertiary",
        onClick: () => {
          open();
        }
      }, Object(external_wp_i18n_["__"])('Media Library'));
    };

    const libraryButton = mediaLibraryButton !== null && mediaLibraryButton !== void 0 ? mediaLibraryButton : defaultButton;
    const uploadMediaLibraryButton = Object(external_wp_element_["createElement"])(media_upload, {
      addToGallery: addToGallery,
      gallery: multiple && onlyAllowsImages(),
      multiple: multiple,
      onSelect: onSelect,
      allowedTypes: allowedTypes,
      value: Array.isArray(value) ? value.map(_ref7 => {
        let {
          id
        } = _ref7;
        return id;
      }) : value.id,
      render: libraryButton
    });

    if (mediaUpload && isAppender) {
      return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, renderDropZone(), Object(external_wp_element_["createElement"])(external_wp_components_["FormFileUpload"], {
        onChange: onUpload,
        accept: accept,
        multiple: multiple,
        render: _ref8 => {
          let {
            openFileDialog
          } = _ref8;
          const content = Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
            variant: "primary",
            className: classnames_default()('block-editor-media-placeholder__button', 'block-editor-media-placeholder__upload-button'),
            onClick: openFileDialog
          }, Object(external_wp_i18n_["__"])('Upload')), uploadMediaLibraryButton, renderUrlSelectionUI(), renderCancelLink());
          return renderPlaceholder(content);
        }
      }));
    }

    if (mediaUpload) {
      const content = Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, renderDropZone(), Object(external_wp_element_["createElement"])(external_wp_components_["FormFileUpload"], {
        variant: "primary",
        className: classnames_default()('block-editor-media-placeholder__button', 'block-editor-media-placeholder__upload-button'),
        onChange: onUpload,
        accept: accept,
        multiple: multiple
      }, Object(external_wp_i18n_["__"])('Upload')), uploadMediaLibraryButton, renderUrlSelectionUI(), renderCancelLink());
      return renderPlaceholder(content);
    }

    return renderPlaceholder(uploadMediaLibraryButton);
  };

  if (dropZoneUIOnly || disableMediaButtons) {
    if (dropZoneUIOnly) {
      external_wp_deprecated_default()('wp.blockEditor.MediaPlaceholder dropZoneUIOnly prop', {
        since: '5.4',
        alternative: 'disableMediaButtons'
      });
    }

    return Object(external_wp_element_["createElement"])(media_upload_check, null, renderDropZone());
  }

  return Object(external_wp_element_["createElement"])(media_upload_check, {
    fallback: renderPlaceholder(renderUrlSelectionUI())
  }, renderMediaUploadChecked());
}
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/media-placeholder/README.md
 */

/* harmony default export */ var media_placeholder = (Object(external_wp_components_["withFilters"])('editor.MediaPlaceholder')(MediaPlaceholder));

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/panel-color-settings/index.js



/**
 * Internal dependencies
 */


const PanelColorSettings = _ref => {
  let {
    colorSettings,
    ...props
  } = _ref;
  const settings = colorSettings.map(_ref2 => {
    let {
      value,
      onChange,
      ...otherSettings
    } = _ref2;
    return { ...otherSettings,
      colorValue: value,
      onColorChange: onChange
    };
  });
  return Object(external_wp_element_["createElement"])(panel_color_gradient_settings["a" /* default */], Object(esm_extends["a" /* default */])({
    settings: settings,
    gradients: [],
    disableCustomGradients: true
  }, props));
};

/* harmony default export */ var panel_color_settings = (PanelColorSettings);

// EXTERNAL MODULE: ./node_modules/react-autosize-textarea/lib/index.js
var react_autosize_textarea_lib = __webpack_require__("O6Fj");
var react_autosize_textarea_lib_default = /*#__PURE__*/__webpack_require__.n(react_autosize_textarea_lib);

// EXTERNAL MODULE: external ["wp","richText"]
var external_wp_richText_ = __webpack_require__("qRz9");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/format-toolbar/index.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




const format_toolbar_POPOVER_PROPS = {
  position: 'bottom right',
  isAlternate: true
};

const FormatToolbar = () => {
  return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, ['bold', 'italic', 'link'].map(format => Object(external_wp_element_["createElement"])(external_wp_components_["Slot"], {
    name: `RichText.ToolbarControls.${format}`,
    key: format
  })), Object(external_wp_element_["createElement"])(external_wp_components_["Slot"], {
    name: "RichText.ToolbarControls"
  }, fills => {
    if (!fills.length) {
      return null;
    }

    const allProps = fills.map(_ref => {
      let [{
        props
      }] = _ref;
      return props;
    });
    const hasActive = allProps.some(_ref2 => {
      let {
        isActive
      } = _ref2;
      return isActive;
    });
    return Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarItem"], null, toggleProps => Object(external_wp_element_["createElement"])(external_wp_components_["DropdownMenu"], {
      icon: chevron_down["a" /* default */]
      /* translators: button label text should, if possible, be under 16 characters. */
      ,
      label: Object(external_wp_i18n_["__"])('More'),
      toggleProps: { ...toggleProps,
        className: classnames_default()(toggleProps.className, {
          'is-pressed': hasActive
        }),
        describedBy: Object(external_wp_i18n_["__"])('Displays more block tools')
      },
      controls: Object(external_lodash_["orderBy"])(fills.map(_ref3 => {
        let [{
          props
        }] = _ref3;
        return props;
      }), 'title'),
      popoverProps: format_toolbar_POPOVER_PROPS
    }));
  }));
};

/* harmony default export */ var format_toolbar = (FormatToolbar);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/format-toolbar-container.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




const FormatToolbarContainer = _ref => {
  let {
    inline,
    anchorRef
  } = _ref;

  if (inline) {
    // Render in popover
    return Object(external_wp_element_["createElement"])(external_wp_components_["Popover"], {
      noArrow: true,
      position: "top center",
      focusOnMount: false,
      anchorRef: anchorRef,
      className: "block-editor-rich-text__inline-format-toolbar",
      __unstableSlotName: "block-toolbar"
    }, Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-rich-text__inline-format-toolbar-group"
    }, Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarGroup"], null, Object(external_wp_element_["createElement"])(format_toolbar, null))));
  } // Render regular toolbar


  return Object(external_wp_element_["createElement"])(block_controls["b" /* default */], {
    group: "inline"
  }, Object(external_wp_element_["createElement"])(format_toolbar, null));
};

/* harmony default export */ var format_toolbar_container = (FormatToolbarContainer);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/use-undo-automatic-change.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function useUndoAutomaticChange() {
  const {
    didAutomaticChange,
    getSettings
  } = Object(external_wp_data_["useSelect"])(store["a" /* store */]);
  return Object(external_wp_compose_["useRefEffect"])(element => {
    function onKeyDown(event) {
      const {
        keyCode
      } = event;

      if (event.defaultPrevented) {
        return;
      }

      if (keyCode !== external_wp_keycodes_["DELETE"] && keyCode !== external_wp_keycodes_["BACKSPACE"] && keyCode !== external_wp_keycodes_["ESCAPE"]) {
        return;
      }

      if (!didAutomaticChange()) {
        return;
      }

      event.preventDefault();

      getSettings().__experimentalUndo();
    }

    element.addEventListener('keydown', onKeyDown);
    return () => {
      element.removeEventListener('keydown', onKeyDown);
    };
  }, []);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/use-caret-in-format.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useCaretInFormat(_ref) {
  let {
    value
  } = _ref;
  const hasActiveFormats = value.activeFormats && !!value.activeFormats.length;
  const {
    isCaretWithinFormattedText
  } = Object(external_wp_data_["useSelect"])(store["a" /* store */]);
  const {
    enterFormattedText,
    exitFormattedText
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  Object(external_wp_element_["useEffect"])(() => {
    if (hasActiveFormats) {
      if (!isCaretWithinFormattedText()) {
        enterFormattedText();
      }
    } else if (isCaretWithinFormattedText()) {
      exitFormattedText();
    }
  }, [hasActiveFormats]);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/use-mark-persistent.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function useMarkPersistent(_ref) {
  let {
    html,
    value
  } = _ref;
  const previousText = Object(external_wp_element_["useRef"])();
  const hasActiveFormats = value.activeFormats && !!value.activeFormats.length;
  const {
    __unstableMarkLastChangeAsPersistent
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]); // Must be set synchronously to make sure it applies to the last change.

  Object(external_wp_element_["useLayoutEffect"])(() => {
    // Ignore mount.
    if (!previousText.current) {
      previousText.current = value.text;
      return;
    } // Text input, so don't create an undo level for every character.
    // Create an undo level after 1 second of no input.


    if (previousText.current !== value.text) {
      const timeout = window.setTimeout(() => {
        __unstableMarkLastChangeAsPersistent();
      }, 1000);
      previousText.current = value.text;
      return () => {
        window.clearTimeout(timeout);
      };
    }

    __unstableMarkLastChangeAsPersistent();
  }, [html, hasActiveFormats]);
}

// EXTERNAL MODULE: external ["wp","blob"]
var external_wp_blob_ = __webpack_require__("xTGt");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/file-paste-handler.js
/**
 * WordPress dependencies
 */

function filePasteHandler(files) {
  return files.filter(_ref => {
    let {
      type
    } = _ref;
    return /^image\/(?:jpe?g|png|gif)$/.test(type);
  }).map(file => `<img src="${Object(external_wp_blob_["createBlobURL"])(file)}">`).join('');
}

// EXTERNAL MODULE: external ["wp","shortcode"]
var external_wp_shortcode_ = __webpack_require__("SVSp");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/utils.js


/**
 * WordPress dependencies
 */




function addActiveFormats(value, activeFormats) {
  if (activeFormats !== null && activeFormats !== void 0 && activeFormats.length) {
    let index = value.formats.length;

    while (index--) {
      value.formats[index] = [...activeFormats, ...(value.formats[index] || [])];
    }
  }
}
/**
 * Get the multiline tag based on the multiline prop.
 *
 * @param {?(string|boolean)} multiline The multiline prop.
 *
 * @return {?string} The multiline tag.
 */

function getMultilineTag(multiline) {
  if (multiline !== true && multiline !== 'p' && multiline !== 'li') {
    return;
  }

  return multiline === true ? 'p' : multiline;
}
function getAllowedFormats(_ref) {
  let {
    allowedFormats,
    formattingControls,
    disableFormats
  } = _ref;

  if (disableFormats) {
    return getAllowedFormats.EMPTY_ARRAY;
  }

  if (!allowedFormats && !formattingControls) {
    return;
  }

  if (allowedFormats) {
    return allowedFormats;
  }

  external_wp_deprecated_default()('wp.blockEditor.RichText formattingControls prop', {
    since: '5.4',
    alternative: 'allowedFormats'
  });
  return formattingControls.map(name => `core/${name}`);
}
getAllowedFormats.EMPTY_ARRAY = [];
const isShortcode = text => Object(external_wp_shortcode_["regexp"])('.*').test(text);
/**
 * Creates a link from pasted URL.
 * Creates a paragraph block containing a link to the URL, and calls `onReplace`.
 *
 * @param {string}   url       The URL that could not be embedded.
 * @param {Function} onReplace Function to call with the created fallback block.
 */

function createLinkInParagraph(url, onReplace) {
  const link = Object(external_wp_element_["createElement"])("a", {
    href: url
  }, url);
  onReplace(Object(external_wp_blocks_["createBlock"])('core/paragraph', {
    content: Object(external_wp_element_["renderToString"])(link)
  }));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/split-value.js
/**
 * WordPress dependencies
 */

/*
 * Signals to the RichText owner that the block can be replaced with two blocks
 * as a result of splitting the block by pressing enter, or with blocks as a
 * result of splitting the block by pasting block content in the instance.
 */

function splitValue(_ref) {
  let {
    value,
    pastedBlocks = [],
    onReplace,
    onSplit,
    onSplitMiddle,
    multilineTag
  } = _ref;

  if (!onReplace || !onSplit) {
    return;
  }

  const blocks = [];
  const [before, after] = Object(external_wp_richText_["split"])(value);
  const hasPastedBlocks = pastedBlocks.length > 0;
  let lastPastedBlockIndex = -1; // Consider the after value to be the original it is not empty and the
  // before value *is* empty.

  const isAfterOriginal = Object(external_wp_richText_["isEmpty"])(before) && !Object(external_wp_richText_["isEmpty"])(after); // Create a block with the content before the caret if there's no pasted
  // blocks, or if there are pasted blocks and the value is not empty. We do
  // not want a leading empty block on paste, but we do if split with e.g. the
  // enter key.

  if (!hasPastedBlocks || !Object(external_wp_richText_["isEmpty"])(before)) {
    blocks.push(onSplit(Object(external_wp_richText_["toHTMLString"])({
      value: before,
      multilineTag
    }), !isAfterOriginal));
    lastPastedBlockIndex += 1;
  }

  if (hasPastedBlocks) {
    blocks.push(...pastedBlocks);
    lastPastedBlockIndex += pastedBlocks.length;
  } else if (onSplitMiddle) {
    blocks.push(onSplitMiddle());
  } // If there's pasted blocks, append a block with non empty content / after
  // the caret. Otherwise, do append an empty block if there is no
  // `onSplitMiddle` prop, but if there is and the content is empty, the
  // middle block is enough to set focus in.


  if (hasPastedBlocks ? !Object(external_wp_richText_["isEmpty"])(after) : !onSplitMiddle || !Object(external_wp_richText_["isEmpty"])(after)) {
    blocks.push(onSplit(Object(external_wp_richText_["toHTMLString"])({
      value: after,
      multilineTag
    }), isAfterOriginal));
  } // If there are pasted blocks, set the selection to the last one. Otherwise,
  // set the selection to the second block.


  const indexToSelect = hasPastedBlocks ? lastPastedBlockIndex : 1; // If there are pasted blocks, move the caret to the end of the selected
  // block Otherwise, retain the default value.

  const initialPosition = hasPastedBlocks ? -1 : 0;
  onReplace(blocks, indexToSelect, initialPosition);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/use-paste-handler.js
/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




/** @typedef {import('@wordpress/rich-text').RichTextValue} RichTextValue */

/**
 * Replaces line separators with line breaks if not multiline.
 * Replaces line breaks with line separators if multiline.
 *
 * @param {RichTextValue} value       Value to adjust.
 * @param {boolean}       isMultiline Whether to adjust to multiline or not.
 *
 * @return {RichTextValue} Adjusted value.
 */

function adjustLines(value, isMultiline) {
  if (isMultiline) {
    return Object(external_wp_richText_["replace"])(value, /\n+/g, external_wp_richText_["__UNSTABLE_LINE_SEPARATOR"]);
  }

  return Object(external_wp_richText_["replace"])(value, new RegExp(external_wp_richText_["__UNSTABLE_LINE_SEPARATOR"], 'g'), '\n');
}

function usePasteHandler(props) {
  const propsRef = Object(external_wp_element_["useRef"])(props);
  propsRef.current = props;
  return Object(external_wp_compose_["useRefEffect"])(element => {
    function _onPaste(event) {
      const {
        isSelected,
        disableFormats,
        onChange,
        value,
        formatTypes,
        tagName,
        onReplace,
        onSplit,
        onSplitMiddle,
        __unstableEmbedURLOnPaste,
        multilineTag,
        preserveWhiteSpace,
        pastePlainText
      } = propsRef.current;

      if (!isSelected) {
        event.preventDefault();
        return;
      }

      const {
        clipboardData
      } = event;
      let plainText = '';
      let html = ''; // IE11 only supports `Text` as an argument for `getData` and will
      // otherwise throw an invalid argument error, so we try the standard
      // arguments first, then fallback to `Text` if they fail.

      try {
        plainText = clipboardData.getData('text/plain');
        html = clipboardData.getData('text/html');
      } catch (error1) {
        try {
          html = clipboardData.getData('Text');
        } catch (error2) {
          // Some browsers like UC Browser paste plain text by default and
          // don't support clipboardData at all, so allow default
          // behaviour.
          return;
        }
      } // Remove Windows-specific metadata appended within copied HTML text.


      html = removeWindowsFragments(html); // Strip meta tag.

      html = removeCharsetMetaTag(html);
      event.preventDefault(); // Allows us to ask for this information when we get a report.

      window.console.log('Received HTML:\n\n', html);
      window.console.log('Received plain text:\n\n', plainText);

      if (disableFormats) {
        onChange(Object(external_wp_richText_["insert"])(value, plainText));
        return;
      }

      const transformed = formatTypes.reduce((accumlator, _ref) => {
        let {
          __unstablePasteRule
        } = _ref;

        // Only allow one transform.
        if (__unstablePasteRule && accumlator === value) {
          accumlator = __unstablePasteRule(value, {
            html,
            plainText
          });
        }

        return accumlator;
      }, value);

      if (transformed !== value) {
        onChange(transformed);
        return;
      }

      const files = [...Object(external_wp_dom_["getFilesFromDataTransfer"])(clipboardData)];
      const isInternal = clipboardData.getData('rich-text') === 'true'; // If the data comes from a rich text instance, we can directly use it
      // without filtering the data. The filters are only meant for externally
      // pasted content and remove inline styles.

      if (isInternal) {
        const pastedMultilineTag = clipboardData.getData('rich-text-multi-line-tag') || undefined;
        let pastedValue = Object(external_wp_richText_["create"])({
          html,
          multilineTag: pastedMultilineTag,
          multilineWrapperTags: pastedMultilineTag === 'li' ? ['ul', 'ol'] : undefined,
          preserveWhiteSpace
        });
        pastedValue = adjustLines(pastedValue, !!multilineTag);
        addActiveFormats(pastedValue, value.activeFormats);
        onChange(Object(external_wp_richText_["insert"])(value, pastedValue));
        return;
      }

      if (pastePlainText) {
        onChange(Object(external_wp_richText_["insert"])(value, Object(external_wp_richText_["create"])({
          text: plainText
        })));
        return;
      } // Only process file if no HTML is present.
      // Note: a pasted file may have the URL as plain text.


      if (files && files.length && !html) {
        const content = Object(external_wp_blocks_["pasteHandler"])({
          HTML: filePasteHandler(files),
          mode: 'BLOCKS',
          tagName,
          preserveWhiteSpace
        }); // Allows us to ask for this information when we get a report.
        // eslint-disable-next-line no-console

        window.console.log('Received items:\n\n', files);

        if (onReplace && Object(external_wp_richText_["isEmpty"])(value)) {
          onReplace(content);
        } else {
          splitValue({
            value,
            pastedBlocks: content,
            onReplace,
            onSplit,
            onSplitMiddle,
            multilineTag
          });
        }

        return;
      }

      let mode = onReplace && onSplit ? 'AUTO' : 'INLINE'; // Force the blocks mode when the user is pasting
      // on a new line & the content resembles a shortcode.
      // Otherwise it's going to be detected as inline
      // and the shortcode won't be replaced.

      if (mode === 'AUTO' && Object(external_wp_richText_["isEmpty"])(value) && isShortcode(plainText)) {
        mode = 'BLOCKS';
      }

      if (__unstableEmbedURLOnPaste && Object(external_wp_richText_["isEmpty"])(value) && Object(external_wp_url_["isURL"])(plainText.trim())) {
        mode = 'BLOCKS';
      }

      const content = Object(external_wp_blocks_["pasteHandler"])({
        HTML: html,
        plainText,
        mode,
        tagName,
        preserveWhiteSpace
      });

      if (typeof content === 'string') {
        let valueToInsert = Object(external_wp_richText_["create"])({
          html: content
        }); // If the content should be multiline, we should process text
        // separated by a line break as separate lines.

        valueToInsert = adjustLines(valueToInsert, !!multilineTag);
        addActiveFormats(valueToInsert, value.activeFormats);
        onChange(Object(external_wp_richText_["insert"])(value, valueToInsert));
      } else if (content.length > 0) {
        if (onReplace && Object(external_wp_richText_["isEmpty"])(value)) {
          onReplace(content, content.length - 1, -1);
        } else {
          splitValue({
            value,
            pastedBlocks: content,
            onReplace,
            onSplit,
            onSplitMiddle,
            multilineTag
          });
        }
      }
    }

    element.addEventListener('paste', _onPaste);
    return () => {
      element.removeEventListener('paste', _onPaste);
    };
  }, []);
}
/**
 * Normalizes a given string of HTML to remove the Windows specific "Fragment" comments
 * and any preceeding and trailing whitespace.
 *
 * @param {string} html the html to be normalized
 * @return {string} the normalized html
 */

function removeWindowsFragments(html) {
  const startReg = /.*<!--StartFragment-->/s;
  const endReg = /<!--EndFragment-->.*/s;
  return html.replace(startReg, '').replace(endReg, '');
}
/**
 * Removes the charset meta tag inserted by Chromium.
 * See:
 * - https://github.com/WordPress/gutenberg/issues/33585
 * - https://bugs.chromium.org/p/chromium/issues/detail?id=1264616#c4
 *
 * @param {string} html the html to be stripped of the meta tag.
 * @return {string} the cleaned html
 */


function removeCharsetMetaTag(html) {
  const metaTag = `<meta charset='utf-8'>`;

  if (html.startsWith(metaTag)) {
    return html.slice(metaTag.length);
  }

  return html;
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/use-input-rules.js
/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


function useInputRules(props) {
  const {
    __unstableMarkLastChangeAsPersistent,
    __unstableMarkAutomaticChange
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const propsRef = Object(external_wp_element_["useRef"])(props);
  propsRef.current = props;
  return Object(external_wp_compose_["useRefEffect"])(element => {
    function inputRule() {
      const {
        value,
        onReplace
      } = propsRef.current;

      if (!onReplace) {
        return;
      }

      const {
        start,
        text
      } = value;
      const characterBefore = text.slice(start - 1, start); // The character right before the caret must be a plain space.

      if (characterBefore !== ' ') {
        return;
      }

      const trimmedTextBefore = text.slice(0, start).trim();
      const prefixTransforms = Object(external_wp_blocks_["getBlockTransforms"])('from').filter(_ref => {
        let {
          type
        } = _ref;
        return type === 'prefix';
      });
      const transformation = Object(external_wp_blocks_["findTransform"])(prefixTransforms, _ref2 => {
        let {
          prefix
        } = _ref2;
        return trimmedTextBefore === prefix;
      });

      if (!transformation) {
        return;
      }

      const content = Object(external_wp_richText_["toHTMLString"])({
        value: Object(external_wp_richText_["slice"])(value, start, text.length)
      });
      const block = transformation.transform(content);
      onReplace([block]);

      __unstableMarkAutomaticChange();
    }

    function onInput(event) {
      const {
        inputType,
        type
      } = event;
      const {
        value,
        onChange,
        __unstableAllowPrefixTransformations,
        formatTypes
      } = propsRef.current; // Only run input rules when inserting text.

      if (inputType !== 'insertText' && type !== 'compositionend') {
        return;
      }

      if (__unstableAllowPrefixTransformations && inputRule) {
        inputRule();
      }

      const transformed = formatTypes.reduce((accumlator, _ref3) => {
        let {
          __unstableInputRule
        } = _ref3;

        if (__unstableInputRule) {
          accumlator = __unstableInputRule(accumlator);
        }

        return accumlator;
      }, value);

      if (transformed !== value) {
        __unstableMarkLastChangeAsPersistent();

        onChange({ ...transformed,
          activeFormats: value.activeFormats
        });

        __unstableMarkAutomaticChange();
      }
    }

    element.addEventListener('input', onInput);
    element.addEventListener('compositionend', onInput);
    return () => {
      element.removeEventListener('input', onInput);
      element.removeEventListener('compositionend', onInput);
    };
  }, []);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/use-enter.js
/**
 * WordPress dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



function useEnter(props) {
  const {
    __unstableMarkAutomaticChange
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const propsRef = Object(external_wp_element_["useRef"])(props);
  propsRef.current = props;
  return Object(external_wp_compose_["useRefEffect"])(element => {
    function onKeyDown(event) {
      if (event.defaultPrevented) {
        return;
      }

      const {
        removeEditorOnlyFormats,
        value,
        onReplace,
        onSplit,
        onSplitMiddle,
        multilineTag,
        onChange,
        disableLineBreaks,
        onSplitAtEnd
      } = propsRef.current;

      if (event.keyCode !== external_wp_keycodes_["ENTER"]) {
        return;
      }

      event.preventDefault();
      const _value = { ...value
      };
      _value.formats = removeEditorOnlyFormats(value);
      const canSplit = onReplace && onSplit;

      if (onReplace) {
        const transforms = Object(external_wp_blocks_["getBlockTransforms"])('from').filter(_ref => {
          let {
            type
          } = _ref;
          return type === 'enter';
        });
        const transformation = Object(external_wp_blocks_["findTransform"])(transforms, item => {
          return item.regExp.test(_value.text);
        });

        if (transformation) {
          onReplace([transformation.transform({
            content: _value.text
          })]);

          __unstableMarkAutomaticChange();
        }
      }

      if (multilineTag) {
        if (event.shiftKey) {
          if (!disableLineBreaks) {
            onChange(Object(external_wp_richText_["insert"])(_value, '\n'));
          }
        } else if (canSplit && Object(external_wp_richText_["__unstableIsEmptyLine"])(_value)) {
          splitValue({
            value: _value,
            onReplace,
            onSplit,
            onSplitMiddle,
            multilineTag
          });
        } else {
          onChange(Object(external_wp_richText_["__unstableInsertLineSeparator"])(_value));
        }
      } else {
        const {
          text,
          start,
          end
        } = _value;
        const canSplitAtEnd = onSplitAtEnd && start === end && end === text.length;

        if (event.shiftKey || !canSplit && !canSplitAtEnd) {
          if (!disableLineBreaks) {
            onChange(Object(external_wp_richText_["insert"])(_value, '\n'));
          }
        } else if (!canSplit && canSplitAtEnd) {
          onSplitAtEnd();
        } else if (canSplit) {
          splitValue({
            value: _value,
            onReplace,
            onSplit,
            onSplitMiddle,
            multilineTag
          });
        }
      }
    }

    element.addEventListener('keydown', onKeyDown);
    return () => {
      element.removeEventListener('keydown', onKeyDown);
    };
  }, []);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/use-format-types.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function formatTypesSelector(select) {
  return select(external_wp_richText_["store"]).getFormatTypes();
}
/**
 * Set of all interactive content tags.
 *
 * @see https://html.spec.whatwg.org/multipage/dom.html#interactive-content
 */


const interactiveContentTags = new Set(['a', 'audio', 'button', 'details', 'embed', 'iframe', 'input', 'label', 'select', 'textarea', 'video']);
/**
 * This hook provides RichText with the `formatTypes` and its derived props from
 * experimental format type settings.
 *
 * @param {Object}  $0                              Options
 * @param {string}  $0.clientId                     Block client ID.
 * @param {string}  $0.identifier                   Block attribute.
 * @param {boolean} $0.withoutInteractiveFormatting Whether to clean the interactive formattings or not.
 * @param {Array}   $0.allowedFormats               Allowed formats
 */

function useFormatTypes(_ref) {
  let {
    clientId,
    identifier,
    withoutInteractiveFormatting,
    allowedFormats
  } = _ref;
  const allFormatTypes = Object(external_wp_data_["useSelect"])(formatTypesSelector, []);
  const formatTypes = Object(external_wp_element_["useMemo"])(() => {
    return allFormatTypes.filter(_ref2 => {
      let {
        name,
        tagName
      } = _ref2;

      if (allowedFormats && !allowedFormats.includes(name)) {
        return false;
      }

      if (withoutInteractiveFormatting && interactiveContentTags.has(tagName)) {
        return false;
      }

      return true;
    });
  }, [allFormatTypes, allowedFormats, interactiveContentTags]);
  const keyedSelected = Object(external_wp_data_["useSelect"])(select => formatTypes.reduce((accumulator, type) => {
    if (type.__experimentalGetPropsForEditableTreePreparation) {
      accumulator[type.name] = type.__experimentalGetPropsForEditableTreePreparation(select, {
        richTextIdentifier: identifier,
        blockClientId: clientId
      });
    }

    return accumulator;
  }, {}), [formatTypes, clientId, identifier]);
  const dispatch = Object(external_wp_data_["useDispatch"])();
  const prepareHandlers = [];
  const valueHandlers = [];
  const changeHandlers = [];
  const dependencies = [];
  formatTypes.forEach(type => {
    if (type.__experimentalCreatePrepareEditableTree) {
      const selected = keyedSelected[type.name];

      const handler = type.__experimentalCreatePrepareEditableTree(selected, {
        richTextIdentifier: identifier,
        blockClientId: clientId
      });

      if (type.__experimentalCreateOnChangeEditableValue) {
        valueHandlers.push(handler);
      } else {
        prepareHandlers.push(handler);
      }

      for (const key in selected) {
        dependencies.push(selected[key]);
      }
    }

    if (type.__experimentalCreateOnChangeEditableValue) {
      let dispatchers = {};

      if (type.__experimentalGetPropsForEditableTreeChangeHandler) {
        dispatchers = type.__experimentalGetPropsForEditableTreeChangeHandler(dispatch, {
          richTextIdentifier: identifier,
          blockClientId: clientId
        });
      }

      changeHandlers.push(type.__experimentalCreateOnChangeEditableValue({ ...(keyedSelected[type.name] || {}),
        ...dispatchers
      }, {
        richTextIdentifier: identifier,
        blockClientId: clientId
      }));
    }
  });
  return {
    formatTypes,
    prepareHandlers,
    valueHandlers,
    changeHandlers,
    dependencies
  };
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/use-remove-browser-shortcuts.js
/**
 * WordPress dependencies
 */


/**
 * Hook to prevent default behaviors for key combinations otherwise handled
 * internally by RichText.
 *
 * @return {import('react').RefObject} The component to be rendered.
 */

function useRemoveBrowserShortcuts() {
  return Object(external_wp_compose_["useRefEffect"])(node => {
    function onKeydown(event) {
      if (external_wp_keycodes_["isKeyboardEvent"].primary(event, 'z') || external_wp_keycodes_["isKeyboardEvent"].primary(event, 'y') || external_wp_keycodes_["isKeyboardEvent"].primaryShift(event, 'z')) {
        event.preventDefault();
      }
    }

    node.addEventListener('keydown', onKeydown);
    return () => {
      node.addEventListener('keydown', onKeydown);
    };
  }, []);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/use-shortcuts.js
/**
 * WordPress dependencies
 */

function useShortcuts(keyboardShortcuts) {
  return Object(external_wp_compose_["useRefEffect"])(element => {
    function onKeyDown(event) {
      for (const keyboardShortcut of keyboardShortcuts.current) {
        keyboardShortcut(event);
      }
    }

    element.addEventListener('keydown', onKeyDown);
    return () => {
      element.removeEventListener('keydown', onKeyDown);
    };
  }, []);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/use-input-events.js
/**
 * WordPress dependencies
 */

function useInputEvents(inputEvents) {
  return Object(external_wp_compose_["useRefEffect"])(element => {
    function onInput(event) {
      for (const keyboardShortcut of inputEvents.current) {
        keyboardShortcut(event);
      }
    }

    element.addEventListener('input', onInput);
    return () => {
      element.removeEventListener('input', onInput);
    };
  }, []);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/format-edit.js


/**
 * WordPress dependencies
 */

/**
 * External dependencies
 */


function FormatEdit(_ref) {
  let {
    formatTypes,
    onChange,
    onFocus,
    value,
    forwardedRef
  } = _ref;
  return formatTypes.map(settings => {
    const {
      name,
      edit: Edit
    } = settings;

    if (!Edit) {
      return null;
    }

    const activeFormat = Object(external_wp_richText_["getActiveFormat"])(value, name);
    let isActive = activeFormat !== undefined;
    const activeObject = Object(external_wp_richText_["getActiveObject"])(value);
    const isObjectActive = activeObject !== undefined && activeObject.type === name; // Edge case: un-collapsed link formats.
    // If there is a missing link format at either end of the selection
    // then we shouldn't show the Edit UI because the selection has exceeded
    // the bounds of the link format.
    // Also if the format objects don't match then we're dealing with two separate
    // links so we should not allow the link to be modified over the top.

    if (name === 'core/link' && !Object(external_wp_richText_["isCollapsed"])(value)) {
      const formats = value.formats;
      const linkFormatAtStart = Object(external_lodash_["find"])(formats[value.start], {
        type: 'core/link'
      });
      const linkFormatAtEnd = Object(external_lodash_["find"])(formats[value.end - 1], {
        type: 'core/link'
      });

      if (!linkFormatAtStart || !linkFormatAtEnd || linkFormatAtStart !== linkFormatAtEnd) {
        isActive = false;
      }
    }

    return Object(external_wp_element_["createElement"])(Edit, {
      key: name,
      isActive: isActive,
      activeAttributes: isActive ? activeFormat.attributes || {} : {},
      isObjectActive: isObjectActive,
      activeObjectAttributes: isObjectActive ? activeObject.attributes || {} : {},
      value: value,
      onChange: onChange,
      onFocus: onFocus,
      contentRef: forwardedRef
    });
  });
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/index.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */

















const keyboardShortcutContext = Object(external_wp_element_["createContext"])();
const inputEventContext = Object(external_wp_element_["createContext"])();
/**
 * Removes props used for the native version of RichText so that they are not
 * passed to the DOM element and log warnings.
 *
 * @param {Object} props Props to filter.
 *
 * @return {Object} Filtered props.
 */

function removeNativeProps(props) {
  return Object(external_lodash_["omit"])(props, ['__unstableMobileNoFocusOnMount', 'deleteEnter', 'placeholderTextColor', 'textAlign', 'selectionColor', 'tagsToEliminate', 'rootTagsToEliminate', 'disableEditingMenu', 'fontSize', 'fontFamily', 'fontWeight', 'fontStyle', 'minWidth', 'maxWidth', 'setRef']);
}

function RichTextWrapper(_ref, forwardedRef) {
  let {
    children,
    tagName = 'div',
    value: originalValue = '',
    onChange: originalOnChange,
    isSelected: originalIsSelected,
    multiline,
    inlineToolbar,
    wrapperClassName,
    autocompleters,
    onReplace,
    placeholder,
    allowedFormats,
    formattingControls,
    withoutInteractiveFormatting,
    onRemove,
    onMerge,
    onSplit,
    __unstableOnSplitAtEnd: onSplitAtEnd,
    __unstableOnSplitMiddle: onSplitMiddle,
    identifier,
    preserveWhiteSpace,
    __unstablePastePlainText: pastePlainText,
    __unstableEmbedURLOnPaste,
    __unstableDisableFormats: disableFormats,
    disableLineBreaks,
    unstableOnFocus,
    __unstableAllowPrefixTransformations,
    ...props
  } = _ref;
  const instanceId = Object(external_wp_compose_["useInstanceId"])(RichTextWrapper);
  identifier = identifier || instanceId;
  props = removeNativeProps(props);
  const anchorRef = Object(external_wp_element_["useRef"])();
  const {
    clientId
  } = Object(context["c" /* useBlockEditContext */])();

  const selector = select => {
    const {
      getSelectionStart,
      getSelectionEnd,
      isMultiSelecting,
      hasMultiSelection
    } = select(store["a" /* store */]);
    const selectionStart = getSelectionStart();
    const selectionEnd = getSelectionEnd();
    let isSelected;

    if (originalIsSelected === undefined) {
      isSelected = selectionStart.clientId === clientId && selectionStart.attributeKey === identifier;
    } else if (originalIsSelected) {
      isSelected = selectionStart.clientId === clientId;
    }

    return {
      selectionStart: isSelected ? selectionStart.offset : undefined,
      selectionEnd: isSelected ? selectionEnd.offset : undefined,
      isSelected,
      disabled: isMultiSelecting() || hasMultiSelection()
    };
  }; // This selector must run on every render so the right selection state is
  // retreived from the store on merge.
  // To do: fix this somehow.


  const {
    selectionStart,
    selectionEnd,
    isSelected,
    disabled
  } = Object(external_wp_data_["useSelect"])(selector);
  const {
    selectionChange
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const multilineTag = getMultilineTag(multiline);
  const adjustedAllowedFormats = getAllowedFormats({
    allowedFormats,
    formattingControls,
    disableFormats
  });
  const hasFormats = !adjustedAllowedFormats || adjustedAllowedFormats.length > 0;
  let adjustedValue = originalValue;
  let adjustedOnChange = originalOnChange; // Handle deprecated format.

  if (Array.isArray(originalValue)) {
    adjustedValue = external_wp_blocks_["children"].toHTML(originalValue);

    adjustedOnChange = newValue => originalOnChange(external_wp_blocks_["children"].fromDOM(Object(external_wp_richText_["__unstableCreateElement"])(document, newValue).childNodes));
  }

  const onSelectionChange = Object(external_wp_element_["useCallback"])((start, end) => {
    selectionChange(clientId, identifier, start, end);
  }, [clientId, identifier]);
  const {
    formatTypes,
    prepareHandlers,
    valueHandlers,
    changeHandlers,
    dependencies
  } = useFormatTypes({
    clientId,
    identifier,
    withoutInteractiveFormatting,
    allowedFormats: adjustedAllowedFormats
  });

  function addEditorOnlyFormats(value) {
    return valueHandlers.reduce((accumulator, fn) => fn(accumulator, value.text), value.formats);
  }

  function removeEditorOnlyFormats(value) {
    formatTypes.forEach(formatType => {
      // Remove formats created by prepareEditableTree, because they are editor only.
      if (formatType.__experimentalCreatePrepareEditableTree) {
        value = Object(external_wp_richText_["removeFormat"])(value, formatType.name, 0, value.text.length);
      }
    });
    return value.formats;
  }

  function addInvisibleFormats(value) {
    return prepareHandlers.reduce((accumulator, fn) => fn(accumulator, value.text), value.formats);
  }

  const {
    value,
    onChange,
    ref: richTextRef
  } = Object(external_wp_richText_["__unstableUseRichText"])({
    value: adjustedValue,

    onChange(html, _ref2) {
      let {
        __unstableFormats,
        __unstableText
      } = _ref2;
      adjustedOnChange(html);
      Object.values(changeHandlers).forEach(changeHandler => {
        changeHandler(__unstableFormats, __unstableText);
      });
    },

    selectionStart,
    selectionEnd,
    onSelectionChange,
    placeholder,
    __unstableIsSelected: isSelected,
    __unstableMultilineTag: multilineTag,
    __unstableDisableFormats: disableFormats,
    preserveWhiteSpace,
    __unstableDependencies: [...dependencies, tagName],
    __unstableAfterParse: addEditorOnlyFormats,
    __unstableBeforeSerialize: removeEditorOnlyFormats,
    __unstableAddInvisibleFormats: addInvisibleFormats
  });
  const autocompleteProps = useBlockEditorAutocompleteProps({
    onReplace,
    completers: autocompleters,
    record: value,
    onChange
  });
  useCaretInFormat({
    value
  });
  useMarkPersistent({
    html: adjustedValue,
    value
  });
  const keyboardShortcuts = Object(external_wp_element_["useRef"])(new Set());
  const inputEvents = Object(external_wp_element_["useRef"])(new Set());

  function onKeyDown(event) {
    const {
      keyCode
    } = event;

    if (event.defaultPrevented) {
      return;
    }

    if (keyCode === external_wp_keycodes_["DELETE"] || keyCode === external_wp_keycodes_["BACKSPACE"]) {
      const {
        start,
        end,
        text
      } = value;
      const isReverse = keyCode === external_wp_keycodes_["BACKSPACE"];
      const hasActiveFormats = value.activeFormats && !!value.activeFormats.length; // Only process delete if the key press occurs at an uncollapsed edge.

      if (!Object(external_wp_richText_["isCollapsed"])(value) || hasActiveFormats || isReverse && start !== 0 || !isReverse && end !== text.length) {
        return;
      }

      if (onMerge) {
        onMerge(!isReverse);
      } // Only handle remove on Backspace. This serves dual-purpose of being
      // an intentional user interaction distinguishing between Backspace and
      // Delete to remove the empty field, but also to avoid merge & remove
      // causing destruction of two fields (merge, then removed merged).


      if (onRemove && Object(external_wp_richText_["isEmpty"])(value) && isReverse) {
        onRemove(!isReverse);
      }

      event.preventDefault();
    }
  }

  function onFocus() {
    anchorRef.current.focus();
  }

  const TagName = tagName;
  const content = Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, isSelected && Object(external_wp_element_["createElement"])(keyboardShortcutContext.Provider, {
    value: keyboardShortcuts
  }, Object(external_wp_element_["createElement"])(inputEventContext.Provider, {
    value: inputEvents
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Popover"].__unstableSlotNameProvider, {
    value: "__unstable-block-tools-after"
  }, children && children({
    value,
    onChange,
    onFocus
  }), Object(external_wp_element_["createElement"])(FormatEdit, {
    value: value,
    onChange: onChange,
    onFocus: onFocus,
    formatTypes: formatTypes,
    forwardedRef: anchorRef
  })))), isSelected && hasFormats && Object(external_wp_element_["createElement"])(format_toolbar_container, {
    inline: inlineToolbar,
    anchorRef: anchorRef.current
  }), Object(external_wp_element_["createElement"])(TagName // Overridable props.
  , Object(esm_extends["a" /* default */])({
    role: "textbox",
    "aria-multiline": true,
    "aria-label": placeholder
  }, props, autocompleteProps, {
    ref: Object(external_wp_compose_["useMergeRefs"])([autocompleteProps.ref, props.ref, richTextRef, useInputRules({
      value,
      onChange,
      __unstableAllowPrefixTransformations,
      formatTypes,
      onReplace
    }), useRemoveBrowserShortcuts(), useShortcuts(keyboardShortcuts), useInputEvents(inputEvents), useUndoAutomaticChange(), usePasteHandler({
      isSelected,
      disableFormats,
      onChange,
      value,
      formatTypes,
      tagName,
      onReplace,
      onSplit,
      onSplitMiddle,
      __unstableEmbedURLOnPaste,
      multilineTag,
      preserveWhiteSpace,
      pastePlainText
    }), useEnter({
      removeEditorOnlyFormats,
      value,
      onReplace,
      onSplit,
      onSplitMiddle,
      multilineTag,
      onChange,
      disableLineBreaks,
      onSplitAtEnd
    }), anchorRef, forwardedRef]) // Do not set the attribute if disabled.
    ,
    contentEditable: disabled ? undefined : true,
    suppressContentEditableWarning: !disabled,
    className: classnames_default()('block-editor-rich-text__editable', props.className, 'rich-text'),
    onFocus: unstableOnFocus,
    onKeyDown: onKeyDown
  })));

  if (!wrapperClassName) {
    return content;
  }

  external_wp_deprecated_default()('wp.blockEditor.RichText wrapperClassName prop', {
    since: '5.4',
    alternative: 'className prop or create your own wrapper div'
  });
  const className = classnames_default()('block-editor-rich-text', wrapperClassName);
  return Object(external_wp_element_["createElement"])("div", {
    className: className
  }, content);
}

const ForwardedRichTextContainer = Object(external_wp_element_["forwardRef"])(RichTextWrapper);

ForwardedRichTextContainer.Content = _ref3 => {
  let {
    value,
    tagName: Tag,
    multiline,
    ...props
  } = _ref3;

  // Handle deprecated `children` and `node` sources.
  if (Array.isArray(value)) {
    value = external_wp_blocks_["children"].toHTML(value);
  }

  const MultilineTag = getMultilineTag(multiline);

  if (!value && MultilineTag) {
    value = `<${MultilineTag}></${MultilineTag}>`;
  }

  const content = Object(external_wp_element_["createElement"])(external_wp_element_["RawHTML"], null, value);

  if (Tag) {
    return Object(external_wp_element_["createElement"])(Tag, Object(external_lodash_["omit"])(props, ['format']), content);
  }

  return content;
};

ForwardedRichTextContainer.isEmpty = value => {
  return !value || value.length === 0;
};
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/rich-text/README.md
 */


/* harmony default export */ var rich_text = (ForwardedRichTextContainer);




// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/editable-text/index.js



/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const EditableText = Object(external_wp_element_["forwardRef"])((props, ref) => {
  return Object(external_wp_element_["createElement"])(rich_text, Object(esm_extends["a" /* default */])({
    ref: ref
  }, props, {
    __unstableDisableFormats: true,
    preserveWhiteSpace: true
  }));
});

EditableText.Content = _ref => {
  let {
    value = '',
    tagName: Tag = 'div',
    ...props
  } = _ref;
  return Object(external_wp_element_["createElement"])(Tag, props, value);
};
/**
 * Renders an editable text input in which text formatting is not allowed.
 */


/* harmony default export */ var editable_text = (EditableText);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/plain-text/index.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/plain-text/README.md
 */

const PlainText = Object(external_wp_element_["forwardRef"])((_ref, ref) => {
  let {
    __experimentalVersion,
    ...props
  } = _ref;

  if (__experimentalVersion === 2) {
    return Object(external_wp_element_["createElement"])(editable_text, Object(esm_extends["a" /* default */])({
      ref: ref
    }, props));
  }

  const {
    className,
    onChange,
    ...remainingProps
  } = props;
  return Object(external_wp_element_["createElement"])(react_autosize_textarea_lib_default.a, Object(esm_extends["a" /* default */])({
    ref: ref,
    className: classnames_default()('block-editor-plain-text', className),
    onChange: event => onChange(event.target.value)
  }, remainingProps));
});
/* harmony default export */ var plain_text = (PlainText);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/responsive-block-control/label.js


/**
 * WordPress dependencies
 */




function ResponsiveBlockControlLabel(_ref) {
  let {
    property,
    viewport,
    desc
  } = _ref;
  const instanceId = Object(external_wp_compose_["useInstanceId"])(ResponsiveBlockControlLabel);
  const accessibleLabel = desc || Object(external_wp_i18n_["sprintf"])(
  /* translators: 1: property name. 2: viewport name. */
  Object(external_wp_i18n_["_x"])('Controls the %1$s property for %2$s viewports.', 'Text labelling a interface as controlling a given layout property (eg: margin) for a given screen size.'), property, viewport.label);
  return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])("span", {
    "aria-describedby": `rbc-desc-${instanceId}`
  }, viewport.label), Object(external_wp_element_["createElement"])(external_wp_components_["VisuallyHidden"], {
    as: "span",
    id: `rbc-desc-${instanceId}`
  }, accessibleLabel));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/responsive-block-control/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



function ResponsiveBlockControl(props) {
  const {
    title,
    property,
    toggleLabel,
    onIsResponsiveChange,
    renderDefaultControl,
    renderResponsiveControls,
    isResponsive = false,
    defaultLabel = {
      id: 'all',

      /* translators: 'Label. Used to signify a layout property (eg: margin, padding) will apply uniformly to all screensizes.' */
      label: Object(external_wp_i18n_["__"])('All')
    },
    viewports = [{
      id: 'small',
      label: Object(external_wp_i18n_["__"])('Small screens')
    }, {
      id: 'medium',
      label: Object(external_wp_i18n_["__"])('Medium screens')
    }, {
      id: 'large',
      label: Object(external_wp_i18n_["__"])('Large screens')
    }]
  } = props;

  if (!title || !property || !renderDefaultControl) {
    return null;
  }

  const toggleControlLabel = toggleLabel || Object(external_wp_i18n_["sprintf"])(
  /* translators: 'Toggle control label. Should the property be the same across all screen sizes or unique per screen size.'. %s property value for the control (eg: margin, padding...etc) */
  Object(external_wp_i18n_["__"])('Use the same %s on all screensizes.'), property);
  /* translators: 'Help text for the responsive mode toggle control.' */

  const toggleHelpText = Object(external_wp_i18n_["__"])('Toggle between using the same value for all screen sizes or using a unique value per screen size.');

  const defaultControl = renderDefaultControl(Object(external_wp_element_["createElement"])(ResponsiveBlockControlLabel, {
    property: property,
    viewport: defaultLabel
  }), defaultLabel);

  const defaultResponsiveControls = () => {
    return viewports.map(viewport => Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], {
      key: viewport.id
    }, renderDefaultControl(Object(external_wp_element_["createElement"])(ResponsiveBlockControlLabel, {
      property: property,
      viewport: viewport
    }), viewport)));
  };

  return Object(external_wp_element_["createElement"])("fieldset", {
    className: "block-editor-responsive-block-control"
  }, Object(external_wp_element_["createElement"])("legend", {
    className: "block-editor-responsive-block-control__title"
  }, title), Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-responsive-block-control__inner"
  }, Object(external_wp_element_["createElement"])(external_wp_components_["ToggleControl"], {
    className: "block-editor-responsive-block-control__toggle",
    label: toggleControlLabel,
    checked: !isResponsive,
    onChange: onIsResponsiveChange,
    help: toggleHelpText
  }), Object(external_wp_element_["createElement"])("div", {
    className: classnames_default()('block-editor-responsive-block-control__group', {
      'is-responsive': isResponsive
    })
  }, !isResponsive && defaultControl, isResponsive && (renderResponsiveControls ? renderResponsiveControls(viewports) : defaultResponsiveControls()))));
}

/* harmony default export */ var responsive_block_control = (ResponsiveBlockControl);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/shortcut.js
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


function RichTextShortcut(_ref) {
  let {
    character,
    type,
    onUse
  } = _ref;
  const keyboardShortcuts = Object(external_wp_element_["useContext"])(keyboardShortcutContext);
  const onUseRef = Object(external_wp_element_["useRef"])();
  onUseRef.current = onUse;
  Object(external_wp_element_["useEffect"])(() => {
    function callback(event) {
      if (external_wp_keycodes_["isKeyboardEvent"][type](event, character)) {
        onUseRef.current();
        event.preventDefault();
      }
    }

    keyboardShortcuts.current.add(callback);
    return () => {
      keyboardShortcuts.current.delete(callback);
    };
  }, [character, type]);
  return null;
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/toolbar-button.js



/**
 * WordPress dependencies
 */


function RichTextToolbarButton(_ref) {
  let {
    name,
    shortcutType,
    shortcutCharacter,
    ...props
  } = _ref;
  let shortcut;
  let fillName = 'RichText.ToolbarControls';

  if (name) {
    fillName += `.${name}`;
  }

  if (shortcutType && shortcutCharacter) {
    shortcut = external_wp_keycodes_["displayShortcut"][shortcutType](shortcutCharacter);
  }

  return Object(external_wp_element_["createElement"])(external_wp_components_["Fill"], {
    name: fillName
  }, Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], Object(esm_extends["a" /* default */])({}, props, {
    shortcut: shortcut
  })));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/rich-text/input-event.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function __unstableRichTextInputEvent(_ref) {
  let {
    inputType,
    onInput
  } = _ref;
  const callbacks = Object(external_wp_element_["useContext"])(inputEventContext);
  const onInputRef = Object(external_wp_element_["useRef"])();
  onInputRef.current = onInput;
  Object(external_wp_element_["useEffect"])(() => {
    function callback(event) {
      if (event.inputType === inputType) {
        onInputRef.current();
        event.preventDefault();
      }
    }

    callbacks.current.add(callback);
    return () => {
      callbacks.current.delete(callback);
    };
  }, [inputType]);
  return null;
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/tool-selector/index.js



/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


const selectIcon = Object(external_wp_element_["createElement"])(external_wp_components_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_components_["Path"], {
  d: "M9.4 20.5L5.2 3.8l14.6 9-2 .3c-.2 0-.4.1-.7.1-.9.2-1.6.3-2.2.5-.8.3-1.4.5-1.8.8-.4.3-.8.8-1.3 1.5-.4.5-.8 1.2-1.2 2l-.3.6-.9 1.9zM7.6 7.1l2.4 9.3c.2-.4.5-.8.7-1.1.6-.8 1.1-1.4 1.6-1.8.5-.4 1.3-.8 2.2-1.1l1.2-.3-8.1-5z"
}));

function ToolSelector(props, ref) {
  const isNavigationTool = Object(external_wp_data_["useSelect"])(select => select(store["a" /* store */]).isNavigationMode(), []);
  const {
    setNavigationMode
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);

  const onSwitchMode = mode => {
    setNavigationMode(mode === 'edit' ? false : true);
  };

  return Object(external_wp_element_["createElement"])(external_wp_components_["Dropdown"], {
    renderToggle: _ref => {
      let {
        isOpen,
        onToggle
      } = _ref;
      return Object(external_wp_element_["createElement"])(external_wp_components_["Button"], Object(esm_extends["a" /* default */])({}, props, {
        ref: ref,
        icon: isNavigationTool ? selectIcon : edit["a" /* default */],
        "aria-expanded": isOpen,
        "aria-haspopup": "true",
        onClick: onToggle
        /* translators: button label text should, if possible, be under 16 characters. */
        ,
        label: Object(external_wp_i18n_["__"])('Tools')
      }));
    },
    position: "bottom right",
    renderContent: () => Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["NavigableMenu"], {
      role: "menu",
      "aria-label": Object(external_wp_i18n_["__"])('Tools')
    }, Object(external_wp_element_["createElement"])(external_wp_components_["MenuItemsChoice"], {
      value: isNavigationTool ? 'select' : 'edit',
      onSelect: onSwitchMode,
      choices: [{
        value: 'edit',
        label: Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(build_module_icon["a" /* default */], {
          icon: edit["a" /* default */]
        }), Object(external_wp_i18n_["__"])('Edit'))
      }, {
        value: 'select',
        label: Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, selectIcon, Object(external_wp_i18n_["__"])('Select'))
      }]
    })), Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-tool-selector__help"
    }, Object(external_wp_i18n_["__"])('Tools provide different interactions for selecting, navigating, and editing blocks. Toggle between select and edit by pressing Escape and Enter.')))
  });
}

/* harmony default export */ var tool_selector = (Object(external_wp_element_["forwardRef"])(ToolSelector));

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/unit-control/index.js



/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function UnitControl(_ref) {
  let {
    units: unitsProp,
    ...props
  } = _ref;
  const units = Object(external_wp_components_["__experimentalUseCustomUnits"])({
    availableUnits: Object(use_setting["a" /* default */])('spacing.units') || ['%', 'px', 'em', 'rem', 'vw'],
    units: unitsProp
  });
  return Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalUnitControl"], Object(esm_extends["a" /* default */])({
    units: units
  }, props));
}

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/link.js
var library_link = __webpack_require__("Bpkj");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/arrow-left.js
var arrow_left = __webpack_require__("cjQ8");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/url-input/button.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */



class button_URLInputButton extends external_wp_element_["Component"] {
  constructor() {
    super(...arguments);
    this.toggle = this.toggle.bind(this);
    this.submitLink = this.submitLink.bind(this);
    this.state = {
      expanded: false
    };
  }

  toggle() {
    this.setState({
      expanded: !this.state.expanded
    });
  }

  submitLink(event) {
    event.preventDefault();
    this.toggle();
  }

  render() {
    const {
      url,
      onChange
    } = this.props;
    const {
      expanded
    } = this.state;
    const buttonLabel = url ? Object(external_wp_i18n_["__"])('Edit link') : Object(external_wp_i18n_["__"])('Insert link');
    return Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-url-input__button"
    }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
      icon: library_link["a" /* default */],
      label: buttonLabel,
      onClick: this.toggle,
      className: "components-toolbar__control",
      isPressed: !!url
    }), expanded && Object(external_wp_element_["createElement"])("form", {
      className: "block-editor-url-input__button-modal",
      onSubmit: this.submitLink
    }, Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-url-input__button-modal-line"
    }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
      className: "block-editor-url-input__back",
      icon: arrow_left["a" /* default */],
      label: Object(external_wp_i18n_["__"])('Close'),
      onClick: this.toggle
    }), Object(external_wp_element_["createElement"])(url_input, {
      value: url || '',
      onChange: onChange
    }), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
      icon: keyboard_return["a" /* default */],
      label: Object(external_wp_i18n_["__"])('Submit'),
      type: "submit"
    }))));
  }

}
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/url-input/README.md
 */


/* harmony default export */ var url_input_button = (button_URLInputButton);

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/close.js
var library_close = __webpack_require__("w95h");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/url-popover/image-url-input-ui.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


const LINK_DESTINATION_NONE = 'none';
const LINK_DESTINATION_CUSTOM = 'custom';
const LINK_DESTINATION_MEDIA = 'media';
const LINK_DESTINATION_ATTACHMENT = 'attachment';
const NEW_TAB_REL = ['noreferrer', 'noopener'];
const image_url_input_ui_icon = Object(external_wp_element_["createElement"])(external_wp_components_["SVG"], {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, Object(external_wp_element_["createElement"])(external_wp_components_["Path"], {
  d: "M0,0h24v24H0V0z",
  fill: "none"
}), Object(external_wp_element_["createElement"])(external_wp_components_["Path"], {
  d: "m19 5v14h-14v-14h14m0-2h-14c-1.1 0-2 0.9-2 2v14c0 1.1 0.9 2 2 2h14c1.1 0 2-0.9 2-2v-14c0-1.1-0.9-2-2-2z"
}), Object(external_wp_element_["createElement"])(external_wp_components_["Path"], {
  d: "m14.14 11.86l-3 3.87-2.14-2.59-3 3.86h12l-3.86-5.14z"
}));

const ImageURLInputUI = _ref => {
  let {
    linkDestination,
    onChangeUrl,
    url,
    mediaType = 'image',
    mediaUrl,
    mediaLink,
    linkTarget,
    linkClass,
    rel
  } = _ref;
  const [isOpen, setIsOpen] = Object(external_wp_element_["useState"])(false);
  const openLinkUI = Object(external_wp_element_["useCallback"])(() => {
    setIsOpen(true);
  });
  const [isEditingLink, setIsEditingLink] = Object(external_wp_element_["useState"])(false);
  const [urlInput, setUrlInput] = Object(external_wp_element_["useState"])(null);
  const autocompleteRef = Object(external_wp_element_["useRef"])(null);
  const startEditLink = Object(external_wp_element_["useCallback"])(() => {
    if (linkDestination === LINK_DESTINATION_MEDIA || linkDestination === LINK_DESTINATION_ATTACHMENT) {
      setUrlInput('');
    }

    setIsEditingLink(true);
  });
  const stopEditLink = Object(external_wp_element_["useCallback"])(() => {
    setIsEditingLink(false);
  });
  const closeLinkUI = Object(external_wp_element_["useCallback"])(() => {
    setUrlInput(null);
    stopEditLink();
    setIsOpen(false);
  });

  const removeNewTabRel = currentRel => {
    let newRel = currentRel;

    if (currentRel !== undefined && !Object(external_lodash_["isEmpty"])(newRel)) {
      if (!Object(external_lodash_["isEmpty"])(newRel)) {
        Object(external_lodash_["each"])(NEW_TAB_REL, relVal => {
          const regExp = new RegExp('\\b' + relVal + '\\b', 'gi');
          newRel = newRel.replace(regExp, '');
        }); // Only trim if NEW_TAB_REL values was replaced.

        if (newRel !== currentRel) {
          newRel = newRel.trim();
        }

        if (Object(external_lodash_["isEmpty"])(newRel)) {
          newRel = undefined;
        }
      }
    }

    return newRel;
  };

  const getUpdatedLinkTargetSettings = value => {
    const newLinkTarget = value ? '_blank' : undefined;
    let updatedRel;

    if (!newLinkTarget && !rel) {
      updatedRel = undefined;
    } else {
      updatedRel = removeNewTabRel(rel);
    }

    return {
      linkTarget: newLinkTarget,
      rel: updatedRel
    };
  };

  const onFocusOutside = Object(external_wp_element_["useCallback"])(() => {
    return event => {
      // The autocomplete suggestions list renders in a separate popover (in a portal),
      // so onFocusOutside fails to detect that a click on a suggestion occurred in the
      // LinkContainer. Detect clicks on autocomplete suggestions using a ref here, and
      // return to avoid the popover being closed.
      const autocompleteElement = autocompleteRef.current;

      if (autocompleteElement && autocompleteElement.contains(event.target)) {
        return;
      }

      setIsOpen(false);
      setUrlInput(null);
      stopEditLink();
    };
  });
  const onSubmitLinkChange = Object(external_wp_element_["useCallback"])(() => {
    return event => {
      if (urlInput) {
        var _getLinkDestinations$;

        // It is possible the entered URL actually matches a named link destination.
        // This check will ensure our link destination is correct.
        const selectedDestination = ((_getLinkDestinations$ = getLinkDestinations().find(destination => destination.url === urlInput)) === null || _getLinkDestinations$ === void 0 ? void 0 : _getLinkDestinations$.linkDestination) || LINK_DESTINATION_CUSTOM;
        onChangeUrl({
          href: urlInput,
          linkDestination: selectedDestination
        });
      }

      stopEditLink();
      setUrlInput(null);
      event.preventDefault();
    };
  });
  const onLinkRemove = Object(external_wp_element_["useCallback"])(() => {
    onChangeUrl({
      linkDestination: LINK_DESTINATION_NONE,
      href: ''
    });
  });

  const getLinkDestinations = () => {
    const linkDestinations = [{
      linkDestination: LINK_DESTINATION_MEDIA,
      title: Object(external_wp_i18n_["__"])('Media File'),
      url: mediaType === 'image' ? mediaUrl : undefined,
      icon: image_url_input_ui_icon
    }];

    if (mediaType === 'image' && mediaLink) {
      linkDestinations.push({
        linkDestination: LINK_DESTINATION_ATTACHMENT,
        title: Object(external_wp_i18n_["__"])('Attachment Page'),
        url: mediaType === 'image' ? mediaLink : undefined,
        icon: Object(external_wp_element_["createElement"])(external_wp_components_["SVG"], {
          viewBox: "0 0 24 24",
          xmlns: "http://www.w3.org/2000/svg"
        }, Object(external_wp_element_["createElement"])(external_wp_components_["Path"], {
          d: "M0 0h24v24H0V0z",
          fill: "none"
        }), Object(external_wp_element_["createElement"])(external_wp_components_["Path"], {
          d: "M14 2H6c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6zM6 20V4h7v5h5v11H6z"
        }))
      });
    }

    return linkDestinations;
  };

  const onSetHref = value => {
    const linkDestinations = getLinkDestinations();
    let linkDestinationInput;

    if (!value) {
      linkDestinationInput = LINK_DESTINATION_NONE;
    } else {
      linkDestinationInput = (Object(external_lodash_["find"])(linkDestinations, destination => {
        return destination.url === value;
      }) || {
        linkDestination: LINK_DESTINATION_CUSTOM
      }).linkDestination;
    }

    onChangeUrl({
      linkDestination: linkDestinationInput,
      href: value
    });
  };

  const onSetNewTab = value => {
    const updatedLinkTarget = getUpdatedLinkTargetSettings(value);
    onChangeUrl(updatedLinkTarget);
  };

  const onSetLinkRel = value => {
    onChangeUrl({
      rel: value
    });
  };

  const onSetLinkClass = value => {
    onChangeUrl({
      linkClass: value
    });
  };

  const advancedOptions = Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["ToggleControl"], {
    label: Object(external_wp_i18n_["__"])('Open in new tab'),
    onChange: onSetNewTab,
    checked: linkTarget === '_blank'
  }), Object(external_wp_element_["createElement"])(external_wp_components_["TextControl"], {
    label: Object(external_wp_i18n_["__"])('Link Rel'),
    value: removeNewTabRel(rel) || '',
    onChange: onSetLinkRel
  }), Object(external_wp_element_["createElement"])(external_wp_components_["TextControl"], {
    label: Object(external_wp_i18n_["__"])('Link CSS Class'),
    value: linkClass || '',
    onChange: onSetLinkClass
  }));
  const linkEditorValue = urlInput !== null ? urlInput : url;
  const urlLabel = (Object(external_lodash_["find"])(getLinkDestinations(), ['linkDestination', linkDestination]) || {}).title;
  return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["ToolbarButton"], {
    icon: library_link["a" /* default */],
    className: "components-toolbar__control",
    label: url ? Object(external_wp_i18n_["__"])('Edit link') : Object(external_wp_i18n_["__"])('Insert link'),
    "aria-expanded": isOpen,
    onClick: openLinkUI
  }), isOpen && Object(external_wp_element_["createElement"])(url_popover, {
    onFocusOutside: onFocusOutside(),
    onClose: closeLinkUI,
    renderSettings: () => advancedOptions,
    additionalControls: !linkEditorValue && Object(external_wp_element_["createElement"])(external_wp_components_["NavigableMenu"], null, Object(external_lodash_["map"])(getLinkDestinations(), link => Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
      key: link.linkDestination,
      icon: link.icon,
      onClick: () => {
        setUrlInput(null);
        onSetHref(link.url);
        stopEditLink();
      }
    }, link.title)))
  }, (!url || isEditingLink) && Object(external_wp_element_["createElement"])(url_popover.LinkEditor, {
    className: "block-editor-format-toolbar__link-container-content",
    value: linkEditorValue,
    onChangeInputValue: setUrlInput,
    onSubmit: onSubmitLinkChange(),
    autocompleteRef: autocompleteRef
  }), url && !isEditingLink && Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(url_popover.LinkViewer, {
    className: "block-editor-format-toolbar__link-container-content",
    url: url,
    onEditLinkClick: startEditLink,
    urlLabel: urlLabel
  }), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    icon: library_close["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Remove link'),
    onClick: onLinkRemove
  }))));
};



// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu/block-settings-menu-first-item.js
var block_settings_menu_first_item = __webpack_require__("Jyyd");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter-menu-extension/index.js
var inserter_menu_extension = __webpack_require__("mlss");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/preview-options/index.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





function PreviewOptions(_ref) {
  let {
    children,
    className,
    isEnabled = true,
    deviceType,
    setDeviceType
  } = _ref;
  const isMobile = Object(external_wp_compose_["useViewportMatch"])('small', '<');
  if (isMobile) return null;
  const popoverProps = {
    className: classnames_default()(className, 'block-editor-post-preview__dropdown-content'),
    position: 'bottom left'
  };
  const toggleProps = {
    variant: 'tertiary',
    className: 'block-editor-post-preview__button-toggle',
    disabled: !isEnabled,

    /* translators: button label text should, if possible, be under 16 characters. */
    children: Object(external_wp_i18n_["__"])('Preview')
  };
  return Object(external_wp_element_["createElement"])(external_wp_components_["DropdownMenu"], {
    className: "block-editor-post-preview__dropdown",
    popoverProps: popoverProps,
    toggleProps: toggleProps,
    icon: null
  }, () => Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["MenuGroup"], null, Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
    className: "block-editor-post-preview__button-resize",
    onClick: () => setDeviceType('Desktop'),
    icon: deviceType === 'Desktop' && check["a" /* default */]
  }, Object(external_wp_i18n_["__"])('Desktop')), Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
    className: "block-editor-post-preview__button-resize",
    onClick: () => setDeviceType('Tablet'),
    icon: deviceType === 'Tablet' && check["a" /* default */]
  }, Object(external_wp_i18n_["__"])('Tablet')), Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
    className: "block-editor-post-preview__button-resize",
    onClick: () => setDeviceType('Mobile'),
    icon: deviceType === 'Mobile' && check["a" /* default */]
  }, Object(external_wp_i18n_["__"])('Mobile'))), children));
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-resize-canvas/index.js
/**
 * WordPress dependencies
 */

/**
 * Function to resize the editor window.
 *
 * @param {string} deviceType Used for determining the size of the container (e.g. Desktop, Tablet, Mobile)
 *
 * @return {Object} Inline styles to be added to resizable container.
 */

function useResizeCanvas(deviceType) {
  const [actualWidth, updateActualWidth] = Object(external_wp_element_["useState"])(window.innerWidth);
  Object(external_wp_element_["useEffect"])(() => {
    if (deviceType === 'Desktop') {
      return;
    }

    const resizeListener = () => updateActualWidth(window.innerWidth);

    window.addEventListener('resize', resizeListener);
    return () => {
      window.removeEventListener('resize', resizeListener);
    };
  }, [deviceType]);

  const getCanvasWidth = device => {
    let deviceWidth;

    switch (device) {
      case 'Tablet':
        deviceWidth = 780;
        break;

      case 'Mobile':
        deviceWidth = 360;
        break;

      default:
        return null;
    }

    return deviceWidth < actualWidth ? deviceWidth : actualWidth;
  };

  const marginValue = () => window.innerHeight < 800 ? 36 : 72;

  const contentInlineStyles = device => {
    const height = device === 'Mobile' ? '768px' : '1024px';

    switch (device) {
      case 'Tablet':
      case 'Mobile':
        return {
          width: getCanvasWidth(device),
          margin: marginValue() + 'px auto',
          height,
          borderRadius: '2px 2px 2px 2px',
          border: '1px solid #ddd',
          overflowY: 'auto'
        };

      default:
        return null;
    }
  };

  return contentInlineStyles(deviceType);
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/use-block-props/use-block-refs.js
var use_block_refs = __webpack_require__("PKbb");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/skip-to-selected-block/index.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




const SkipToSelectedBlock = _ref => {
  let {
    selectedBlockClientId
  } = _ref;
  const ref = Object(use_block_refs["b" /* __unstableUseBlockRef */])(selectedBlockClientId);

  const onClick = () => {
    ref.current.focus();
  };

  return selectedBlockClientId ? Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    variant: "secondary",
    className: "block-editor-skip-to-selected-block",
    onClick: onClick
  }, Object(external_wp_i18n_["__"])('Skip to the selected block')) : null;
};

/* harmony default export */ var skip_to_selected_block = (Object(external_wp_data_["withSelect"])(select => {
  return {
    selectedBlockClientId: select(store["a" /* store */]).getBlockSelectionStart()
  };
})(SkipToSelectedBlock));

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-card/index.js
var block_card = __webpack_require__("GvwK");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-styles/index.js + 1 modules
var block_styles = __webpack_require__("7NR9");

// EXTERNAL MODULE: external ["wp","wordcount"]
var external_wp_wordcount_ = __webpack_require__("7fqt");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/stack.js
var stack = __webpack_require__("wzfx");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/multi-selection-inspector/index.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */




function MultiSelectionInspector(_ref) {
  let {
    blocks
  } = _ref;
  const words = Object(external_wp_wordcount_["count"])(Object(external_wp_blocks_["serialize"])(blocks), 'words');
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-multi-selection-inspector__card"
  }, Object(external_wp_element_["createElement"])(block_icon["a" /* default */], {
    icon: stack["a" /* default */],
    showColors: true
  }), Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-multi-selection-inspector__card-content"
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-multi-selection-inspector__card-title"
  }, Object(external_wp_i18n_["sprintf"])(
  /* translators: %d: number of blocks */
  Object(external_wp_i18n_["_n"])('%d block', '%d blocks', blocks.length), blocks.length)), Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-multi-selection-inspector__card-description"
  }, Object(external_wp_i18n_["sprintf"])(
  /* translators: %d: number of words */
  Object(external_wp_i18n_["_n"])('%d word', '%d words', words), words))));
}

/* harmony default export */ var multi_selection_inspector = (Object(external_wp_data_["withSelect"])(select => {
  const {
    getMultiSelectedBlocks
  } = select(store["a" /* store */]);
  return {
    blocks: getMultiSelectedBlocks()
  };
})(MultiSelectionInspector));

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/default-style-picker/index.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


function DefaultStylePicker(_ref) {
  let {
    blockName
  } = _ref;
  const {
    preferredStyle,
    onUpdatePreferredStyleVariations,
    styles
  } = Object(external_wp_data_["useSelect"])(select => {
    var _preferredStyleVariat, _preferredStyleVariat2;

    const settings = select(store["a" /* store */]).getSettings();
    const preferredStyleVariations = settings.__experimentalPreferredStyleVariations;
    return {
      preferredStyle: preferredStyleVariations === null || preferredStyleVariations === void 0 ? void 0 : (_preferredStyleVariat = preferredStyleVariations.value) === null || _preferredStyleVariat === void 0 ? void 0 : _preferredStyleVariat[blockName],
      onUpdatePreferredStyleVariations: (_preferredStyleVariat2 = preferredStyleVariations === null || preferredStyleVariations === void 0 ? void 0 : preferredStyleVariations.onChange) !== null && _preferredStyleVariat2 !== void 0 ? _preferredStyleVariat2 : null,
      styles: select(external_wp_blocks_["store"]).getBlockStyles(blockName)
    };
  }, [blockName]);
  const selectOptions = Object(external_wp_element_["useMemo"])(() => [{
    label: Object(external_wp_i18n_["__"])('Not set'),
    value: ''
  }, ...styles.map(_ref2 => {
    let {
      label,
      name
    } = _ref2;
    return {
      label,
      value: name
    };
  })], [styles]);
  const selectOnChange = Object(external_wp_element_["useCallback"])(blockStyle => {
    onUpdatePreferredStyleVariations(blockName, blockStyle);
  }, [blockName, onUpdatePreferredStyleVariations]);
  return onUpdatePreferredStyleVariations && Object(external_wp_element_["createElement"])(external_wp_components_["SelectControl"], {
    options: selectOptions,
    value: preferredStyle || '',
    label: Object(external_wp_i18n_["__"])('Default Style'),
    onChange: selectOnChange
  });
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-inspector/index.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */











const BlockInspector = _ref => {
  let {
    showNoBlockSelectedMessage = true,
    bubblesVirtually = true
  } = _ref;
  const {
    count,
    hasBlockStyles,
    selectedBlockName,
    selectedBlockClientId,
    blockType
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      getSelectedBlockClientId,
      getSelectedBlockCount,
      getBlockName
    } = select(store["a" /* store */]);
    const {
      getBlockStyles
    } = select(external_wp_blocks_["store"]);

    const _selectedBlockClientId = getSelectedBlockClientId();

    const _selectedBlockName = _selectedBlockClientId && getBlockName(_selectedBlockClientId);

    const _blockType = _selectedBlockName && Object(external_wp_blocks_["getBlockType"])(_selectedBlockName);

    const blockStyles = _selectedBlockName && getBlockStyles(_selectedBlockName);

    return {
      count: getSelectedBlockCount(),
      selectedBlockClientId: _selectedBlockClientId,
      selectedBlockName: _selectedBlockName,
      blockType: _blockType,
      hasBlockStyles: blockStyles && blockStyles.length > 0
    };
  }, []);

  if (count > 1) {
    return Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-block-inspector"
    }, Object(external_wp_element_["createElement"])(multi_selection_inspector, null), Object(external_wp_element_["createElement"])(inspector_controls["b" /* default */].Slot, null), Object(external_wp_element_["createElement"])(inspector_controls["b" /* default */].Slot, {
      __experimentalGroup: "typography",
      label: Object(external_wp_i18n_["__"])('Typography')
    }), Object(external_wp_element_["createElement"])(inspector_controls["b" /* default */].Slot, {
      __experimentalGroup: "dimensions",
      label: Object(external_wp_i18n_["__"])('Dimensions')
    }), Object(external_wp_element_["createElement"])(inspector_controls["b" /* default */].Slot, {
      __experimentalGroup: "border",
      label: Object(external_wp_i18n_["__"])('Border')
    }));
  }

  const isSelectedBlockUnregistered = selectedBlockName === Object(external_wp_blocks_["getUnregisteredTypeHandlerName"])();
  /*
   * If the selected block is of an unregistered type, avoid showing it as an actual selection
   * because we want the user to focus on the unregistered block warning, not block settings.
   */

  if (!blockType || !selectedBlockClientId || isSelectedBlockUnregistered) {
    if (showNoBlockSelectedMessage) {
      return Object(external_wp_element_["createElement"])("span", {
        className: "block-editor-block-inspector__no-blocks"
      }, Object(external_wp_i18n_["__"])('No block selected.'));
    }

    return null;
  }

  return Object(external_wp_element_["createElement"])(BlockInspectorSingleBlock, {
    clientId: selectedBlockClientId,
    blockName: blockType.name,
    hasBlockStyles: hasBlockStyles,
    bubblesVirtually: bubblesVirtually
  });
};

const BlockInspectorSingleBlock = _ref2 => {
  let {
    clientId,
    blockName,
    hasBlockStyles,
    bubblesVirtually
  } = _ref2;
  const blockInformation = Object(use_block_display_information["a" /* default */])(clientId);
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-inspector"
  }, Object(external_wp_element_["createElement"])(block_card["a" /* default */], blockInformation), Object(external_wp_element_["createElement"])(components_block_variation_transforms, {
    blockClientId: clientId
  }), hasBlockStyles && Object(external_wp_element_["createElement"])("div", null, Object(external_wp_element_["createElement"])(external_wp_components_["PanelBody"], {
    title: Object(external_wp_i18n_["__"])('Styles')
  }, Object(external_wp_element_["createElement"])(block_styles["a" /* default */], {
    clientId: clientId
  }), Object(external_wp_blocks_["hasBlockSupport"])(blockName, 'defaultStylePicker', true) && Object(external_wp_element_["createElement"])(DefaultStylePicker, {
    blockName: blockName
  }))), Object(external_wp_element_["createElement"])(inspector_controls["b" /* default */].Slot, {
    bubblesVirtually: bubblesVirtually
  }), Object(external_wp_element_["createElement"])(inspector_controls["b" /* default */].Slot, {
    __experimentalGroup: "typography",
    bubblesVirtually: bubblesVirtually,
    label: Object(external_wp_i18n_["__"])('Typography')
  }), Object(external_wp_element_["createElement"])(inspector_controls["b" /* default */].Slot, {
    __experimentalGroup: "dimensions",
    bubblesVirtually: bubblesVirtually,
    label: Object(external_wp_i18n_["__"])('Dimensions')
  }), Object(external_wp_element_["createElement"])(inspector_controls["b" /* default */].Slot, {
    __experimentalGroup: "border",
    label: Object(external_wp_i18n_["__"])('Border')
  }), Object(external_wp_element_["createElement"])("div", null, Object(external_wp_element_["createElement"])(AdvancedControls, {
    bubblesVirtually: bubblesVirtually
  })), Object(external_wp_element_["createElement"])(skip_to_selected_block, {
    key: "back"
  }));
};

const AdvancedControls = _ref3 => {
  let {
    bubblesVirtually
  } = _ref3;
  const slot = Object(external_wp_components_["__experimentalUseSlot"])(inspector_controls["a" /* InspectorAdvancedControls */].slotName);
  const hasFills = Boolean(slot.fills && slot.fills.length);

  if (!hasFills) {
    return null;
  }

  return Object(external_wp_element_["createElement"])(external_wp_components_["PanelBody"], {
    className: "block-editor-block-inspector__advanced",
    title: Object(external_wp_i18n_["__"])('Advanced'),
    initialOpen: false
  }, Object(external_wp_element_["createElement"])(inspector_controls["b" /* default */].Slot, {
    __experimentalGroup: "advanced",
    bubblesVirtually: bubblesVirtually
  }));
};

/* harmony default export */ var block_inspector = (BlockInspector);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/index.js + 4 modules
var block_list = __webpack_require__("VyCT");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/use-block-props/index.js
var use_block_props = __webpack_require__("nlh6");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/layout.js
var block_list_layout = __webpack_require__("w8sn");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-mover/index.js
var block_mover = __webpack_require__("JygI");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-selection-clearer/index.js
var block_selection_clearer = __webpack_require__("zQI6");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu/index.js
var block_settings_menu = __webpack_require__("U1WI");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu-controls/index.js + 2 modules
var block_settings_menu_controls = __webpack_require__("pXCJ");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-toolbar/index.js + 9 modules
var block_toolbar = __webpack_require__("+gtr");

// EXTERNAL MODULE: external ["wp","keyboardShortcuts"]
var external_wp_keyboardShortcuts_ = __webpack_require__("hF7m");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-tools/insertion-point.js
var insertion_point = __webpack_require__("PS/H");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-tools/block-popover.js + 1 modules
var block_popover = __webpack_require__("xCFn");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-tools/block-contextual-toolbar.js
var block_contextual_toolbar = __webpack_require__("JUfZ");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-tools/use-popover-scroll.js
var use_popover_scroll = __webpack_require__("2z9l");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-tools/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */






/**
 * Renders block tools (the block toolbar, select/navigation mode toolbar, the
 * insertion point and a slot for the inline rich text toolbar). Must be wrapped
 * around the block content and editor styles wrapper or iframe.
 *
 * @param {Object} $0                      Props.
 * @param {Object} $0.children             The block content and style container.
 * @param {Object} $0.__unstableContentRef Ref holding the content scroll container.
 */

function BlockTools(_ref) {
  let {
    children,
    __unstableContentRef,
    ...props
  } = _ref;
  const isLargeViewport = Object(external_wp_compose_["useViewportMatch"])('medium');
  const hasFixedToolbar = Object(external_wp_data_["useSelect"])(select => select(store["a" /* store */]).getSettings().hasFixedToolbar, []);
  const isMatch = Object(external_wp_keyboardShortcuts_["__unstableUseShortcutEventMatch"])();
  const {
    getSelectedBlockClientIds,
    getBlockRootClientId
  } = Object(external_wp_data_["useSelect"])(store["a" /* store */]);
  const {
    duplicateBlocks,
    removeBlocks,
    insertAfterBlock,
    insertBeforeBlock,
    clearSelectedBlock,
    moveBlocksUp,
    moveBlocksDown
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);

  function onKeyDown(event) {
    if (isMatch('core/block-editor/move-up', event)) {
      const clientIds = getSelectedBlockClientIds();

      if (clientIds.length) {
        event.preventDefault();
        const rootClientId = getBlockRootClientId(Object(external_lodash_["first"])(clientIds));
        moveBlocksUp(clientIds, rootClientId);
      }
    } else if (isMatch('core/block-editor/move-down', event)) {
      const clientIds = getSelectedBlockClientIds();

      if (clientIds.length) {
        event.preventDefault();
        const rootClientId = getBlockRootClientId(Object(external_lodash_["first"])(clientIds));
        moveBlocksDown(clientIds, rootClientId);
      }
    } else if (isMatch('core/block-editor/duplicate', event)) {
      const clientIds = getSelectedBlockClientIds();

      if (clientIds.length) {
        event.preventDefault();
        duplicateBlocks(clientIds);
      }
    } else if (isMatch('core/block-editor/remove', event)) {
      const clientIds = getSelectedBlockClientIds();

      if (clientIds.length) {
        event.preventDefault();
        removeBlocks(clientIds);
      }
    } else if (isMatch('core/block-editor/insert-after', event)) {
      const clientIds = getSelectedBlockClientIds();

      if (clientIds.length) {
        event.preventDefault();
        insertAfterBlock(Object(external_lodash_["last"])(clientIds));
      }
    } else if (isMatch('core/block-editor/insert-before', event)) {
      const clientIds = getSelectedBlockClientIds();

      if (clientIds.length) {
        event.preventDefault();
        insertBeforeBlock(Object(external_lodash_["first"])(clientIds));
      }
    } else if (isMatch('core/block-editor/delete-multi-selection', event)) {
      /**
       * Check if the target element is a text area, input or
       * event.defaultPrevented and return early. In all these
       * cases backspace could be handled elsewhere.
       */
      if (['INPUT', 'TEXTAREA'].includes(event.target.nodeName) || event.defaultPrevented) {
        return;
      }

      const clientIds = getSelectedBlockClientIds();

      if (clientIds.length > 1) {
        event.preventDefault();
        removeBlocks(clientIds);
      }
    } else if (isMatch('core/block-editor/unselect', event)) {
      const clientIds = getSelectedBlockClientIds();

      if (clientIds.length > 1) {
        event.preventDefault();
        clearSelectedBlock();
        event.target.ownerDocument.defaultView.getSelection().removeAllRanges();
      }
    }
  }

  return (// eslint-disable-next-line jsx-a11y/no-static-element-interactions
    Object(external_wp_element_["createElement"])("div", Object(esm_extends["a" /* default */])({}, props, {
      onKeyDown: onKeyDown
    }), Object(external_wp_element_["createElement"])(insertion_point["b" /* default */], {
      __unstableContentRef: __unstableContentRef
    }, (hasFixedToolbar || !isLargeViewport) && Object(external_wp_element_["createElement"])(block_contextual_toolbar["a" /* default */], {
      isFixed: true
    }), Object(external_wp_element_["createElement"])(block_popover["a" /* default */], {
      __unstableContentRef: __unstableContentRef
    }), Object(external_wp_element_["createElement"])(external_wp_components_["Popover"].Slot, {
      name: "block-toolbar",
      ref: Object(use_popover_scroll["a" /* usePopoverScroll */])(__unstableContentRef)
    }), children, Object(external_wp_element_["createElement"])(external_wp_components_["Popover"].Slot, {
      name: "__unstable-block-tools-after",
      ref: Object(use_popover_scroll["a" /* usePopoverScroll */])(__unstableContentRef)
    })))
  );
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/copy-handler/index.js + 1 modules
var copy_handler = __webpack_require__("+0ps");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/default-block-appender/index.js
var default_block_appender = __webpack_require__("5L8O");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/editor-styles/index.js
var editor_styles = __webpack_require__("KyyN");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter/index.js + 1 modules
var inserter = __webpack_require__("qrxh");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter/menu.js + 10 modules
var menu = __webpack_require__("xZzQ");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter/library.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */




function InserterLibrary(_ref) {
  let {
    rootClientId,
    clientId,
    isAppender,
    showInserterHelpPanel,
    showMostUsedBlocks = false,
    __experimentalInsertionIndex,
    __experimentalFilterValue,
    onSelect = external_lodash_["noop"],
    shouldFocusBlock = false
  } = _ref;
  const destinationRootClientId = Object(external_wp_data_["useSelect"])(select => {
    const {
      getBlockRootClientId
    } = select(store["a" /* store */]);
    return rootClientId || getBlockRootClientId(clientId) || undefined;
  }, [clientId, rootClientId]);
  return Object(external_wp_element_["createElement"])(menu["a" /* default */], {
    onSelect: onSelect,
    rootClientId: destinationRootClientId,
    clientId: clientId,
    isAppender: isAppender,
    showInserterHelpPanel: showInserterHelpPanel,
    showMostUsedBlocks: showMostUsedBlocks,
    __experimentalInsertionIndex: __experimentalInsertionIndex,
    __experimentalFilterValue: __experimentalFilterValue,
    shouldFocusBlock: shouldFocusBlock
  });
}

/* harmony default export */ var library = (InserterLibrary);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/keyboard-shortcuts/index.js
/**
 * WordPress dependencies
 */





function KeyboardShortcuts() {
  return null;
}

function KeyboardShortcutsRegister() {
  // Registering the shortcuts
  const {
    registerShortcut
  } = Object(external_wp_data_["useDispatch"])(external_wp_keyboardShortcuts_["store"]);
  Object(external_wp_element_["useEffect"])(() => {
    registerShortcut({
      name: 'core/block-editor/duplicate',
      category: 'block',
      description: Object(external_wp_i18n_["__"])('Duplicate the selected block(s).'),
      keyCombination: {
        modifier: 'primaryShift',
        character: 'd'
      }
    });
    registerShortcut({
      name: 'core/block-editor/remove',
      category: 'block',
      description: Object(external_wp_i18n_["__"])('Remove the selected block(s).'),
      keyCombination: {
        modifier: 'access',
        character: 'z'
      }
    });
    registerShortcut({
      name: 'core/block-editor/insert-before',
      category: 'block',
      description: Object(external_wp_i18n_["__"])('Insert a new block before the selected block(s).'),
      keyCombination: {
        modifier: 'primaryAlt',
        character: 't'
      }
    });
    registerShortcut({
      name: 'core/block-editor/insert-after',
      category: 'block',
      description: Object(external_wp_i18n_["__"])('Insert a new block after the selected block(s).'),
      keyCombination: {
        modifier: 'primaryAlt',
        character: 'y'
      }
    });
    registerShortcut({
      name: 'core/block-editor/delete-multi-selection',
      category: 'block',
      description: Object(external_wp_i18n_["__"])('Remove multiple selected blocks.'),
      keyCombination: {
        character: 'del'
      },
      aliases: [{
        character: 'backspace'
      }]
    });
    registerShortcut({
      name: 'core/block-editor/select-all',
      category: 'selection',
      description: Object(external_wp_i18n_["__"])('Select all text when typing. Press again to select all blocks.'),
      keyCombination: {
        modifier: 'primary',
        character: 'a'
      }
    });
    registerShortcut({
      name: 'core/block-editor/unselect',
      category: 'selection',
      description: Object(external_wp_i18n_["__"])('Clear selection.'),
      keyCombination: {
        character: 'escape'
      }
    });
    registerShortcut({
      name: 'core/block-editor/focus-toolbar',
      category: 'global',
      description: Object(external_wp_i18n_["__"])('Navigate to the nearest toolbar.'),
      keyCombination: {
        modifier: 'alt',
        character: 'F10'
      }
    });
    registerShortcut({
      name: 'core/block-editor/move-up',
      category: 'block',
      description: Object(external_wp_i18n_["__"])('Move the selected block(s) up.'),
      keyCombination: {
        modifier: 'secondary',
        character: 't'
      }
    });
    registerShortcut({
      name: 'core/block-editor/move-down',
      category: 'block',
      description: Object(external_wp_i18n_["__"])('Move the selected block(s) down.'),
      keyCombination: {
        modifier: 'secondary',
        character: 'y'
      }
    });
  }, [registerShortcut]);
  return null;
}

KeyboardShortcuts.Register = KeyboardShortcutsRegister;
/* harmony default export */ var keyboard_shortcuts = (KeyboardShortcuts);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/selection-scroll-into-view/index.js
/**
 * WordPress dependencies
 */

/**
 * Scrolls the multi block selection end into view if not in view already. This
 * is important to do after selection by keyboard.
 *
 * @deprecated
 */

function MultiSelectScrollIntoView() {
  external_wp_deprecated_default()('wp.blockEditor.MultiSelectScrollIntoView', {
    hint: 'This behaviour is now built-in.'
  });
  return null;
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/navigable-toolbar/index.js
var navigable_toolbar = __webpack_require__("GkEL");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/observe-typing/index.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * Set of key codes upon which typing is to be initiated on a keydown event.
 *
 * @type {Set<number>}
 */

const KEY_DOWN_ELIGIBLE_KEY_CODES = new Set([external_wp_keycodes_["UP"], external_wp_keycodes_["RIGHT"], external_wp_keycodes_["DOWN"], external_wp_keycodes_["LEFT"], external_wp_keycodes_["ENTER"], external_wp_keycodes_["BACKSPACE"]]);
/**
 * Returns true if a given keydown event can be inferred as intent to start
 * typing, or false otherwise. A keydown is considered eligible if it is a
 * text navigation without shift active.
 *
 * @param {KeyboardEvent} event Keydown event to test.
 *
 * @return {boolean} Whether event is eligible to start typing.
 */

function isKeyDownEligibleForStartTyping(event) {
  const {
    keyCode,
    shiftKey
  } = event;
  return !shiftKey && KEY_DOWN_ELIGIBLE_KEY_CODES.has(keyCode);
}
/**
 * Removes the `isTyping` flag when the mouse moves in the document of the given
 * element.
 */


function useMouseMoveTypingReset() {
  const isTyping = Object(external_wp_data_["useSelect"])(select => select(store["a" /* store */]).isTyping(), []);
  const {
    stopTyping
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  return Object(external_wp_compose_["useRefEffect"])(node => {
    if (!isTyping) {
      return;
    }

    const {
      ownerDocument
    } = node;
    let lastClientX;
    let lastClientY;
    /**
     * On mouse move, unset typing flag if user has moved cursor.
     *
     * @param {MouseEvent} event Mousemove event.
     */

    function stopTypingOnMouseMove(event) {
      const {
        clientX,
        clientY
      } = event; // We need to check that the mouse really moved because Safari
      // triggers mousemove events when shift or ctrl are pressed.

      if (lastClientX && lastClientY && (lastClientX !== clientX || lastClientY !== clientY)) {
        stopTyping();
      }

      lastClientX = clientX;
      lastClientY = clientY;
    }

    ownerDocument.addEventListener('mousemove', stopTypingOnMouseMove);
    return () => {
      ownerDocument.removeEventListener('mousemove', stopTypingOnMouseMove);
    };
  }, [isTyping, stopTyping]);
}
/**
 * Sets and removes the `isTyping` flag based on user actions:
 *
 * - Sets the flag if the user types within the given element.
 * - Removes the flag when the user selects some text, focusses a non-text
 *   field, presses ESC or TAB, or moves the mouse in the document.
 */

function useTypingObserver() {
  const isTyping = Object(external_wp_data_["useSelect"])(select => select(store["a" /* store */]).isTyping());
  const {
    startTyping,
    stopTyping
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const ref1 = useMouseMoveTypingReset();
  const ref2 = Object(external_wp_compose_["useRefEffect"])(node => {
    const {
      ownerDocument
    } = node;
    const {
      defaultView
    } = ownerDocument; // Listeners to stop typing should only be added when typing.
    // Listeners to start typing should only be added when not typing.

    if (isTyping) {
      let timerId;
      /**
       * Stops typing when focus transitions to a non-text field element.
       *
       * @param {FocusEvent} event Focus event.
       */

      function stopTypingOnNonTextField(event) {
        const {
          target
        } = event; // Since focus to a non-text field via arrow key will trigger
        // before the keydown event, wait until after current stack
        // before evaluating whether typing is to be stopped. Otherwise,
        // typing will re-start.

        timerId = defaultView.setTimeout(() => {
          if (!Object(external_wp_dom_["isTextField"])(target)) {
            stopTyping();
          }
        });
      }
      /**
       * Unsets typing flag if user presses Escape while typing flag is
       * active.
       *
       * @param {KeyboardEvent} event Keypress or keydown event to
       *                              interpret.
       */


      function stopTypingOnEscapeKey(event) {
        const {
          keyCode
        } = event;

        if (keyCode === external_wp_keycodes_["ESCAPE"] || keyCode === external_wp_keycodes_["TAB"]) {
          stopTyping();
        }
      }
      /**
       * On selection change, unset typing flag if user has made an
       * uncollapsed (shift) selection.
       */


      function stopTypingOnSelectionUncollapse() {
        const selection = defaultView.getSelection();
        const isCollapsed = selection.rangeCount > 0 && selection.getRangeAt(0).collapsed;

        if (!isCollapsed) {
          stopTyping();
        }
      }

      node.addEventListener('focus', stopTypingOnNonTextField);
      node.addEventListener('keydown', stopTypingOnEscapeKey);
      ownerDocument.addEventListener('selectionchange', stopTypingOnSelectionUncollapse);
      return () => {
        defaultView.clearTimeout(timerId);
        node.removeEventListener('focus', stopTypingOnNonTextField);
        node.removeEventListener('keydown', stopTypingOnEscapeKey);
        ownerDocument.removeEventListener('selectionchange', stopTypingOnSelectionUncollapse);
      };
    }
    /**
     * Handles a keypress or keydown event to infer intention to start
     * typing.
     *
     * @param {KeyboardEvent} event Keypress or keydown event to interpret.
     */


    function startTypingInTextField(event) {
      const {
        type,
        target
      } = event; // Abort early if already typing, or key press is incurred outside a
      // text field (e.g. arrow-ing through toolbar buttons).
      // Ignore typing if outside the current DOM container

      if (!Object(external_wp_dom_["isTextField"])(target) || !node.contains(target)) {
        return;
      } // Special-case keydown because certain keys do not emit a keypress
      // event. Conversely avoid keydown as the canonical event since
      // there are many keydown which are explicitly not targeted for
      // typing.


      if (type === 'keydown' && !isKeyDownEligibleForStartTyping(event)) {
        return;
      }

      startTyping();
    }

    node.addEventListener('keypress', startTypingInTextField);
    node.addEventListener('keydown', startTypingInTextField);
    return () => {
      node.removeEventListener('keypress', startTypingInTextField);
      node.removeEventListener('keydown', startTypingInTextField);
    };
  }, [isTyping, startTyping, stopTyping]);
  return Object(external_wp_compose_["useMergeRefs"])([ref1, ref2]);
}

function ObserveTyping(_ref) {
  let {
    children
  } = _ref;
  return Object(external_wp_element_["createElement"])("div", {
    ref: useTypingObserver()
  }, children);
}
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/observe-typing/README.md
 */


/* harmony default export */ var observe_typing = (ObserveTyping);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/preserve-scroll-in-reorder/index.js
/**
 * WordPress dependencies
 */

function PreserveScrollInReorder() {
  external_wp_deprecated_default()('PreserveScrollInReorder component', {
    since: '5.4',
    hint: 'This behavior is now built-in the block list'
  });
  return null;
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/typewriter/index.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


const isIE = window.navigator.userAgent.indexOf('Trident') !== -1;
const arrowKeyCodes = new Set([external_wp_keycodes_["UP"], external_wp_keycodes_["DOWN"], external_wp_keycodes_["LEFT"], external_wp_keycodes_["RIGHT"]]);
const initialTriggerPercentage = 0.75;
function useTypewriter() {
  const hasSelectedBlock = Object(external_wp_data_["useSelect"])(select => select(store["a" /* store */]).hasSelectedBlock(), []);
  return Object(external_wp_compose_["useRefEffect"])(node => {
    if (!hasSelectedBlock) {
      return;
    }

    const {
      ownerDocument
    } = node;
    const {
      defaultView
    } = ownerDocument;
    let scrollResizeRafId;
    let onKeyDownRafId;
    let caretRect;

    function onScrollResize() {
      if (scrollResizeRafId) {
        return;
      }

      scrollResizeRafId = defaultView.requestAnimationFrame(() => {
        computeCaretRectangle();
        scrollResizeRafId = null;
      });
    }

    function onKeyDown(event) {
      // Ensure the any remaining request is cancelled.
      if (onKeyDownRafId) {
        defaultView.cancelAnimationFrame(onKeyDownRafId);
      } // Use an animation frame for a smooth result.


      onKeyDownRafId = defaultView.requestAnimationFrame(() => {
        maintainCaretPosition(event);
        onKeyDownRafId = null;
      });
    }
    /**
     * Maintains the scroll position after a selection change caused by a
     * keyboard event.
     *
     * @param {KeyboardEvent} event Keyboard event.
     */


    function maintainCaretPosition(_ref) {
      let {
        keyCode
      } = _ref;

      if (!isSelectionEligibleForScroll()) {
        return;
      }

      const currentCaretRect = Object(external_wp_dom_["computeCaretRect"])(defaultView);

      if (!currentCaretRect) {
        return;
      } // If for some reason there is no position set to be scrolled to, let
      // this be the position to be scrolled to in the future.


      if (!caretRect) {
        caretRect = currentCaretRect;
        return;
      } // Even though enabling the typewriter effect for arrow keys results in
      // a pleasant experience, it may not be the case for everyone, so, for
      // now, let's disable it.


      if (arrowKeyCodes.has(keyCode)) {
        // Reset the caret position to maintain.
        caretRect = currentCaretRect;
        return;
      }

      const diff = currentCaretRect.top - caretRect.top;

      if (diff === 0) {
        return;
      }

      const scrollContainer = Object(external_wp_dom_["getScrollContainer"])(node); // The page must be scrollable.

      if (!scrollContainer) {
        return;
      }

      const windowScroll = scrollContainer === ownerDocument.body;
      const scrollY = windowScroll ? defaultView.scrollY : scrollContainer.scrollTop;
      const scrollContainerY = windowScroll ? 0 : scrollContainer.getBoundingClientRect().top;
      const relativeScrollPosition = windowScroll ? caretRect.top / defaultView.innerHeight : (caretRect.top - scrollContainerY) / (defaultView.innerHeight - scrollContainerY); // If the scroll position is at the start, the active editable element
      // is the last one, and the caret is positioned within the initial
      // trigger percentage of the page, do not scroll the page.
      // The typewriter effect should not kick in until an empty page has been
      // filled with the initial trigger percentage or the user scrolls
      // intentionally down.

      if (scrollY === 0 && relativeScrollPosition < initialTriggerPercentage && isLastEditableNode()) {
        // Reset the caret position to maintain.
        caretRect = currentCaretRect;
        return;
      }

      const scrollContainerHeight = windowScroll ? defaultView.innerHeight : scrollContainer.clientHeight; // Abort if the target scroll position would scroll the caret out of
      // view.

      if ( // The caret is under the lower fold.
      caretRect.top + caretRect.height > scrollContainerY + scrollContainerHeight || // The caret is above the upper fold.
      caretRect.top < scrollContainerY) {
        // Reset the caret position to maintain.
        caretRect = currentCaretRect;
        return;
      }

      if (windowScroll) {
        defaultView.scrollBy(0, diff);
      } else {
        scrollContainer.scrollTop += diff;
      }
    }
    /**
     * Adds a `selectionchange` listener to reset the scroll position to be
     * maintained.
     */


    function addSelectionChangeListener() {
      ownerDocument.addEventListener('selectionchange', computeCaretRectOnSelectionChange);
    }
    /**
     * Resets the scroll position to be maintained during a `selectionchange`
     * event. Also removes the listener, so it acts as a one-time listener.
     */


    function computeCaretRectOnSelectionChange() {
      ownerDocument.removeEventListener('selectionchange', computeCaretRectOnSelectionChange);
      computeCaretRectangle();
    }
    /**
     * Resets the scroll position to be maintained.
     */


    function computeCaretRectangle() {
      if (isSelectionEligibleForScroll()) {
        caretRect = Object(external_wp_dom_["computeCaretRect"])(defaultView);
      }
    }
    /**
     * Checks if the current situation is elegible for scroll:
     * - There should be one and only one block selected.
     * - The component must contain the selection.
     * - The active element must be contenteditable.
     */


    function isSelectionEligibleForScroll() {
      return node.contains(ownerDocument.activeElement) && ownerDocument.activeElement.isContentEditable;
    }

    function isLastEditableNode() {
      const editableNodes = node.querySelectorAll('[contenteditable="true"]');
      const lastEditableNode = editableNodes[editableNodes.length - 1];
      return lastEditableNode === ownerDocument.activeElement;
    } // When the user scrolls or resizes, the scroll position should be
    // reset.


    defaultView.addEventListener('scroll', onScrollResize, true);
    defaultView.addEventListener('resize', onScrollResize, true);
    node.addEventListener('keydown', onKeyDown);
    node.addEventListener('keyup', maintainCaretPosition);
    node.addEventListener('mousedown', addSelectionChangeListener);
    node.addEventListener('touchstart', addSelectionChangeListener);
    return () => {
      defaultView.removeEventListener('scroll', onScrollResize, true);
      defaultView.removeEventListener('resize', onScrollResize, true);
      node.removeEventListener('keydown', onKeyDown);
      node.removeEventListener('keyup', maintainCaretPosition);
      node.removeEventListener('mousedown', addSelectionChangeListener);
      node.removeEventListener('touchstart', addSelectionChangeListener);
      ownerDocument.removeEventListener('selectionchange', computeCaretRectOnSelectionChange);
      defaultView.cancelAnimationFrame(scrollResizeRafId);
      defaultView.cancelAnimationFrame(onKeyDownRafId);
    };
  }, [hasSelectedBlock]);
}

function Typewriter(_ref2) {
  let {
    children
  } = _ref2;
  return Object(external_wp_element_["createElement"])("div", {
    ref: useTypewriter(),
    className: "block-editor__typewriter"
  }, children);
}
/**
 * The exported component. The implementation of Typewriter faced technical
 * challenges in Internet Explorer, and is simply skipped, rendering the given
 * props children instead.
 *
 * @type {WPComponent}
 */


const TypewriterOrIEBypass = isIE ? props => props.children : Typewriter;
/**
 * Ensures that the text selection keeps the same vertical distance from the
 * viewport during keyboard events within this component. The vertical distance
 * can vary. It is the last clicked or scrolled to position.
 */

/* harmony default export */ var typewriter = (TypewriterOrIEBypass);

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/warning/index.js + 1 modules
var warning = __webpack_require__("Zzu2");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/writing-flow/index.js + 4 modules
var writing_flow = __webpack_require__("TVFh");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-canvas-click-redirect/index.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Given an element, returns true if the element is a tabbable text field, or
 * false otherwise.
 *
 * @param {Element} element Element to test.
 *
 * @return {boolean} Whether element is a tabbable text field.
 */

const isTabbableTextField = Object(external_lodash_["overEvery"])([external_wp_dom_["isTextField"], external_wp_dom_["focus"].tabbable.isTabbableIndex]);
function useCanvasClickRedirect() {
  return Object(external_wp_compose_["useRefEffect"])(node => {
    function onMouseDown(event) {
      // Only handle clicks on the canvas, not the content.
      if (event.target !== node) {
        return;
      }

      const focusableNodes = external_wp_dom_["focus"].focusable.find(node);
      const target = Object(external_lodash_["findLast"])(focusableNodes, isTabbableTextField);

      if (!target) {
        return;
      }

      const {
        bottom
      } = target.getBoundingClientRect(); // Ensure the click is below the last block.

      if (event.clientY < bottom) {
        return;
      }

      Object(external_wp_dom_["placeCaretAtHorizontalEdge"])(target, true);
      event.preventDefault();
    }

    node.addEventListener('mousedown', onMouseDown);
    return () => {
      node.addEventListener('mousedown', onMouseDown);
    };
  }, []);
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/iframe/index.js
var iframe = __webpack_require__("hHnB");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-no-recursive-renders/index.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


const RenderedRefsContext = Object(external_wp_element_["createContext"])({});
/**
 * Immutably adds an unique identifier to a set scoped for a given block type.
 *
 * @param {Object} renderedBlocks Rendered blocks grouped by block name
 * @param {string} blockName      Name of the block.
 * @param {*}      uniqueId       Any value that acts as a unique identifier for a block instance.
 *
 * @return {Object} The list of rendered blocks grouped by block name.
 */

function addToBlockType(renderedBlocks, blockName, uniqueId) {
  const result = { ...renderedBlocks,
    [blockName]: renderedBlocks[blockName] ? new Set(renderedBlocks[blockName]) : new Set()
  };
  result[blockName].add(uniqueId);
  return result;
}
/**
 * A React hook for keeping track of blocks previously rendered up in the block
 * tree. Blocks susceptible to recursion can use this hook in their `Edit`
 * function to prevent said recursion.
 *
 * @param {*}      uniqueId  Any value that acts as a unique identifier for a block instance.
 * @param {string} blockName Optional block name.
 *
 * @return {[boolean, Function]} A tuple of:
 *                               - a boolean describing whether the provided id
 *                                 has already been rendered;
 *                               - a React context provider to be used to wrap
 *                                 other elements.
 */


function useNoRecursiveRenders(uniqueId) {
  var _previouslyRenderedBl;

  let blockName = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  const previouslyRenderedBlocks = Object(external_wp_element_["useContext"])(RenderedRefsContext);
  const {
    name
  } = Object(context["c" /* useBlockEditContext */])();
  blockName = blockName || name;
  const hasAlreadyRendered = Boolean((_previouslyRenderedBl = previouslyRenderedBlocks[blockName]) === null || _previouslyRenderedBl === void 0 ? void 0 : _previouslyRenderedBl.has(uniqueId));
  const newRenderedBlocks = Object(external_wp_element_["useMemo"])(() => addToBlockType(previouslyRenderedBlocks, blockName, uniqueId), [previouslyRenderedBlocks, blockName, uniqueId]);
  const Provider = Object(external_wp_element_["useCallback"])(_ref => {
    let {
      children
    } = _ref;
    return Object(external_wp_element_["createElement"])(RenderedRefsContext.Provider, {
      value: newRenderedBlocks
    }, children);
  }, [newRenderedBlocks]);
  return [hasAlreadyRendered, Provider];
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/provider/index.js + 1 modules
var provider = __webpack_require__("/QNa");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/index.js
/*
 * Block Creation Components
 */





























































/*
 * Content Related Components
 */



































/*
 * State Related Components
 */





/***/ }),

/***/ "16Al":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */



var ReactPropTypesSecret = __webpack_require__("WbBG");

function emptyFunction() {}
function emptyFunctionWithReset() {}
emptyFunctionWithReset.resetWarningCache = emptyFunction;

module.exports = function() {
  function shim(props, propName, componentName, location, propFullName, secret) {
    if (secret === ReactPropTypesSecret) {
      // It is still safe when called from React.
      return;
    }
    var err = new Error(
      'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +
      'Use PropTypes.checkPropTypes() to call them. ' +
      'Read more at http://fb.me/use-check-prop-types'
    );
    err.name = 'Invariant Violation';
    throw err;
  };
  shim.isRequired = shim;
  function getShim() {
    return shim;
  };
  // Important!
  // Keep this list in sync with production version in `./factoryWithTypeCheckers.js`.
  var ReactPropTypes = {
    array: shim,
    bigint: shim,
    bool: shim,
    func: shim,
    number: shim,
    object: shim,
    string: shim,
    symbol: shim,

    any: shim,
    arrayOf: getShim,
    element: shim,
    elementType: shim,
    instanceOf: getShim,
    node: shim,
    objectOf: getShim,
    oneOf: getShim,
    oneOfType: getShim,
    shape: getShim,
    exact: getShim,

    checkPropTypes: emptyFunctionWithReset,
    resetWarningCache: emptyFunction
  };

  ReactPropTypes.PropTypes = ReactPropTypes;

  return ReactPropTypes;
};


/***/ }),

/***/ "17x9":
/***/ (function(module, exports, __webpack_require__) {

/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

if (false) { var throwOnDirectAccess, ReactIs; } else {
  // By explicitly using `prop-types` you are opting into new production behavior.
  // http://fb.me/prop-types-in-prod
  module.exports = __webpack_require__("16Al")();
}


/***/ }),

/***/ "1CF3":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["dom"]; }());

/***/ }),

/***/ "1K8p":
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/**
 * Copyright (c) 2015, Facebook, Inc.
 * All rights reserved.
 *
 * This source code is licensed under the BSD-style license found in the
 * LICENSE file in the root directory of this source tree. An additional grant
 * of patent rights can be found in the PATENTS file in the same directory.
 *
 * @providesModule normalizeWheel
 * @typechecks
 */



var UserAgent_DEPRECATED = __webpack_require__("jrfk");

var isEventSupported = __webpack_require__("ez49");


// Reasonable defaults
var PIXEL_STEP  = 10;
var LINE_HEIGHT = 40;
var PAGE_HEIGHT = 800;

/**
 * Mouse wheel (and 2-finger trackpad) support on the web sucks.  It is
 * complicated, thus this doc is long and (hopefully) detailed enough to answer
 * your questions.
 *
 * If you need to react to the mouse wheel in a predictable way, this code is
 * like your bestest friend. * hugs *
 *
 * As of today, there are 4 DOM event types you can listen to:
 *
 *   'wheel'                -- Chrome(31+), FF(17+), IE(9+)
 *   'mousewheel'           -- Chrome, IE(6+), Opera, Safari
 *   'MozMousePixelScroll'  -- FF(3.5 only!) (2010-2013) -- don't bother!
 *   'DOMMouseScroll'       -- FF(0.9.7+) since 2003
 *
 * So what to do?  The is the best:
 *
 *   normalizeWheel.getEventType();
 *
 * In your event callback, use this code to get sane interpretation of the
 * deltas.  This code will return an object with properties:
 *
 *   spinX   -- normalized spin speed (use for zoom) - x plane
 *   spinY   -- " - y plane
 *   pixelX  -- normalized distance (to pixels) - x plane
 *   pixelY  -- " - y plane
 *
 * Wheel values are provided by the browser assuming you are using the wheel to
 * scroll a web page by a number of lines or pixels (or pages).  Values can vary
 * significantly on different platforms and browsers, forgetting that you can
 * scroll at different speeds.  Some devices (like trackpads) emit more events
 * at smaller increments with fine granularity, and some emit massive jumps with
 * linear speed or acceleration.
 *
 * This code does its best to normalize the deltas for you:
 *
 *   - spin is trying to normalize how far the wheel was spun (or trackpad
 *     dragged).  This is super useful for zoom support where you want to
 *     throw away the chunky scroll steps on the PC and make those equal to
 *     the slow and smooth tiny steps on the Mac. Key data: This code tries to
 *     resolve a single slow step on a wheel to 1.
 *
 *   - pixel is normalizing the desired scroll delta in pixel units.  You'll
 *     get the crazy differences between browsers, but at least it'll be in
 *     pixels!
 *
 *   - positive value indicates scrolling DOWN/RIGHT, negative UP/LEFT.  This
 *     should translate to positive value zooming IN, negative zooming OUT.
 *     This matches the newer 'wheel' event.
 *
 * Why are there spinX, spinY (or pixels)?
 *
 *   - spinX is a 2-finger side drag on the trackpad, and a shift + wheel turn
 *     with a mouse.  It results in side-scrolling in the browser by default.
 *
 *   - spinY is what you expect -- it's the classic axis of a mouse wheel.
 *
 *   - I dropped spinZ/pixelZ.  It is supported by the DOM 3 'wheel' event and
 *     probably is by browsers in conjunction with fancy 3D controllers .. but
 *     you know.
 *
 * Implementation info:
 *
 * Examples of 'wheel' event if you scroll slowly (down) by one step with an
 * average mouse:
 *
 *   OS X + Chrome  (mouse)     -    4   pixel delta  (wheelDelta -120)
 *   OS X + Safari  (mouse)     -  N/A   pixel delta  (wheelDelta  -12)
 *   OS X + Firefox (mouse)     -    0.1 line  delta  (wheelDelta  N/A)
 *   Win8 + Chrome  (mouse)     -  100   pixel delta  (wheelDelta -120)
 *   Win8 + Firefox (mouse)     -    3   line  delta  (wheelDelta -120)
 *
 * On the trackpad:
 *
 *   OS X + Chrome  (trackpad)  -    2   pixel delta  (wheelDelta   -6)
 *   OS X + Firefox (trackpad)  -    1   pixel delta  (wheelDelta  N/A)
 *
 * On other/older browsers.. it's more complicated as there can be multiple and
 * also missing delta values.
 *
 * The 'wheel' event is more standard:
 *
 * http://www.w3.org/TR/DOM-Level-3-Events/#events-wheelevents
 *
 * The basics is that it includes a unit, deltaMode (pixels, lines, pages), and
 * deltaX, deltaY and deltaZ.  Some browsers provide other values to maintain
 * backward compatibility with older events.  Those other values help us
 * better normalize spin speed.  Example of what the browsers provide:
 *
 *                          | event.wheelDelta | event.detail
 *        ------------------+------------------+--------------
 *          Safari v5/OS X  |       -120       |       0
 *          Safari v5/Win7  |       -120       |       0
 *         Chrome v17/OS X  |       -120       |       0
 *         Chrome v17/Win7  |       -120       |       0
 *                IE9/Win7  |       -120       |   undefined
 *         Firefox v4/OS X  |     undefined    |       1
 *         Firefox v4/Win7  |     undefined    |       3
 *
 */
function normalizeWheel(/*object*/ event) /*object*/ {
  var sX = 0, sY = 0,       // spinX, spinY
      pX = 0, pY = 0;       // pixelX, pixelY

  // Legacy
  if ('detail'      in event) { sY = event.detail; }
  if ('wheelDelta'  in event) { sY = -event.wheelDelta / 120; }
  if ('wheelDeltaY' in event) { sY = -event.wheelDeltaY / 120; }
  if ('wheelDeltaX' in event) { sX = -event.wheelDeltaX / 120; }

  // side scrolling on FF with DOMMouseScroll
  if ( 'axis' in event && event.axis === event.HORIZONTAL_AXIS ) {
    sX = sY;
    sY = 0;
  }

  pX = sX * PIXEL_STEP;
  pY = sY * PIXEL_STEP;

  if ('deltaY' in event) { pY = event.deltaY; }
  if ('deltaX' in event) { pX = event.deltaX; }

  if ((pX || pY) && event.deltaMode) {
    if (event.deltaMode == 1) {          // delta in LINE units
      pX *= LINE_HEIGHT;
      pY *= LINE_HEIGHT;
    } else {                             // delta in PAGE units
      pX *= PAGE_HEIGHT;
      pY *= PAGE_HEIGHT;
    }
  }

  // Fall-back if spin cannot be determined
  if (pX && !sX) { sX = (pX < 1) ? -1 : 1; }
  if (pY && !sY) { sY = (pY < 1) ? -1 : 1; }

  return { spinX  : sX,
           spinY  : sY,
           pixelX : pX,
           pixelY : pY };
}


/**
 * The best combination if you prefer spinX + spinY normalization.  It favors
 * the older DOMMouseScroll for Firefox, as FF does not include wheelDelta with
 * 'wheel' event, making spin speed determination impossible.
 */
normalizeWheel.getEventType = function() /*string*/ {
  return (UserAgent_DEPRECATED.firefox())
           ? 'DOMMouseScroll'
           : (isEventSupported('wheel'))
               ? 'wheel'
               : 'mousewheel';
};

module.exports = normalizeWheel;


/***/ }),

/***/ "1ZqX":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["data"]; }());

/***/ }),

/***/ "1eGn":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// UNUSED EXPORTS: BlockSettingsDropdown

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: external ["wp","components"]
var external_wp_components_ = __webpack_require__("tI+e");

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/more-vertical.js
var more_vertical = __webpack_require__("VKE3");

// EXTERNAL MODULE: external ["wp","blocks"]
var external_wp_blocks_ = __webpack_require__("HSyU");

// EXTERNAL MODULE: external ["wp","keyboardShortcuts"]
var external_wp_keyboardShortcuts_ = __webpack_require__("hF7m");

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/copy-handler/index.js + 1 modules
var copy_handler = __webpack_require__("+0ps");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js + 4 modules
var store = __webpack_require__("BhPs");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-actions/index.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function BlockActions(_ref) {
  let {
    clientIds,
    children,
    __experimentalUpdateSelection: updateSelection
  } = _ref;
  const {
    canInsertBlockType,
    getBlockRootClientId,
    getBlocksByClientId,
    canMoveBlocks,
    canRemoveBlocks
  } = Object(external_wp_data_["useSelect"])(store["a" /* store */]);
  const {
    getDefaultBlockName,
    getGroupingBlockName
  } = Object(external_wp_data_["useSelect"])(external_wp_blocks_["store"]);
  const blocks = getBlocksByClientId(clientIds);
  const rootClientId = getBlockRootClientId(clientIds[0]);
  const canDuplicate = Object(external_lodash_["every"])(blocks, block => {
    return !!block && Object(external_wp_blocks_["hasBlockSupport"])(block.name, 'multiple', true) && canInsertBlockType(block.name, rootClientId);
  });
  const canInsertDefaultBlock = canInsertBlockType(getDefaultBlockName(), rootClientId);
  const canMove = canMoveBlocks(clientIds, rootClientId);
  const canRemove = canRemoveBlocks(clientIds, rootClientId);
  const {
    removeBlocks,
    replaceBlocks,
    duplicateBlocks,
    insertAfterBlock,
    insertBeforeBlock,
    flashBlock,
    setBlockMovingClientId,
    setNavigationMode,
    selectBlock
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const notifyCopy = Object(copy_handler["c" /* useNotifyCopy */])();
  return children({
    canDuplicate,
    canInsertDefaultBlock,
    canMove,
    canRemove,
    rootClientId,
    blocks,

    onDuplicate() {
      return duplicateBlocks(clientIds, updateSelection);
    },

    onRemove() {
      return removeBlocks(clientIds, updateSelection);
    },

    onInsertBefore() {
      insertBeforeBlock(Object(external_lodash_["first"])(Object(external_lodash_["castArray"])(clientIds)));
    },

    onInsertAfter() {
      insertAfterBlock(Object(external_lodash_["last"])(Object(external_lodash_["castArray"])(clientIds)));
    },

    onMoveTo() {
      setNavigationMode(true);
      selectBlock(clientIds[0]);
      setBlockMovingClientId(clientIds[0]);
    },

    onGroup() {
      if (!blocks.length) {
        return;
      }

      const groupingBlockName = getGroupingBlockName(); // Activate the `transform` on `core/group` which does the conversion

      const newBlocks = Object(external_wp_blocks_["switchToBlockType"])(blocks, groupingBlockName);

      if (!newBlocks) {
        return;
      }

      replaceBlocks(clientIds, newBlocks);
    },

    onUngroup() {
      if (!blocks.length) {
        return;
      }

      const innerBlocks = blocks[0].innerBlocks;

      if (!innerBlocks.length) {
        return;
      }

      replaceBlocks(clientIds, innerBlocks);
    },

    onCopy() {
      const selectedBlockClientIds = blocks.map(_ref2 => {
        let {
          clientId
        } = _ref2;
        return clientId;
      });

      if (blocks.length === 1) {
        flashBlock(selectedBlockClientIds[0]);
      }

      notifyCopy('copy', selectedBlockClientIds);
    }

  });
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu/block-mode-toggle.js


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


function BlockModeToggle(_ref) {
  let {
    blockType,
    mode,
    onToggleMode,
    small = false,
    isCodeEditingEnabled = true
  } = _ref;

  if (!Object(external_wp_blocks_["hasBlockSupport"])(blockType, 'html', true) || !isCodeEditingEnabled) {
    return null;
  }

  const label = mode === 'visual' ? Object(external_wp_i18n_["__"])('Edit as HTML') : Object(external_wp_i18n_["__"])('Edit visually');
  return Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
    onClick: onToggleMode
  }, !small && label);
}
/* harmony default export */ var block_mode_toggle = (Object(external_wp_compose_["compose"])([Object(external_wp_data_["withSelect"])((select, _ref2) => {
  let {
    clientId
  } = _ref2;
  const {
    getBlock,
    getBlockMode,
    getSettings
  } = select(store["a" /* store */]);
  const block = getBlock(clientId);
  const isCodeEditingEnabled = getSettings().codeEditingEnabled;
  return {
    mode: getBlockMode(clientId),
    blockType: block ? Object(external_wp_blocks_["getBlockType"])(block.name) : null,
    isCodeEditingEnabled
  };
}), Object(external_wp_data_["withDispatch"])((dispatch, _ref3) => {
  let {
    onToggle = external_lodash_["noop"],
    clientId
  } = _ref3;
  return {
    onToggleMode() {
      dispatch(store["a" /* store */]).toggleBlockMode(clientId);
      onToggle();
    }

  };
})])(BlockModeToggle));

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu/block-convert-button.js


/**
 * WordPress dependencies
 */


function BlockConvertButton(_ref) {
  let {
    shouldRender,
    onClick,
    small
  } = _ref;

  if (!shouldRender) {
    return null;
  }

  const label = Object(external_wp_i18n_["__"])('Convert to Blocks');

  return Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
    onClick: onClick
  }, !small && label);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu/block-html-convert-button.js
/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/* harmony default export */ var block_html_convert_button = (Object(external_wp_compose_["compose"])(Object(external_wp_data_["withSelect"])((select, _ref) => {
  let {
    clientId
  } = _ref;
  const block = select(store["a" /* store */]).getBlock(clientId);
  return {
    block,
    shouldRender: block && block.name === 'core/html'
  };
}), Object(external_wp_data_["withDispatch"])((dispatch, _ref2) => {
  let {
    block
  } = _ref2;
  return {
    onClick: () => dispatch(store["a" /* store */]).replaceBlocks(block.clientId, Object(external_wp_blocks_["rawHandler"])({
      HTML: Object(external_wp_blocks_["getBlockContent"])(block)
    }))
  };
}))(BlockConvertButton));

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu/block-settings-menu-first-item.js
var block_settings_menu_first_item = __webpack_require__("Jyyd");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu-controls/index.js + 2 modules
var block_settings_menu_controls = __webpack_require__("pXCJ");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-settings-menu/block-settings-dropdown.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */









/**
 * Internal dependencies
 */







const POPOVER_PROPS = {
  className: 'block-editor-block-settings-menu__popover',
  position: 'bottom right',
  isAlternate: true
};

function CopyMenuItem(_ref) {
  let {
    blocks,
    onCopy
  } = _ref;
  const ref = Object(external_wp_compose_["useCopyToClipboard"])(() => Object(external_wp_blocks_["serialize"])(blocks), onCopy);
  return Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
    ref: ref
  }, Object(external_wp_i18n_["__"])('Copy'));
}

function BlockSettingsDropdown(_ref2) {
  let {
    clientIds,
    __experimentalSelectBlock,
    children,
    ...props
  } = _ref2;
  const blockClientIds = Object(external_lodash_["castArray"])(clientIds);
  const count = blockClientIds.length;
  const firstBlockClientId = blockClientIds[0];
  const {
    onlyBlock,
    title
  } = Object(external_wp_data_["useSelect"])(select => {
    var _getBlockType;

    const {
      getBlockCount,
      getBlockName
    } = select(store["a" /* store */]);
    const {
      getBlockType
    } = select(external_wp_blocks_["store"]);
    return {
      onlyBlock: 1 === getBlockCount(),
      title: (_getBlockType = getBlockType(getBlockName(firstBlockClientId))) === null || _getBlockType === void 0 ? void 0 : _getBlockType.title
    };
  }, [firstBlockClientId]);
  const shortcuts = Object(external_wp_data_["useSelect"])(select => {
    const {
      getShortcutRepresentation
    } = select(external_wp_keyboardShortcuts_["store"]);
    return {
      duplicate: getShortcutRepresentation('core/block-editor/duplicate'),
      remove: getShortcutRepresentation('core/block-editor/remove'),
      insertAfter: getShortcutRepresentation('core/block-editor/insert-after'),
      insertBefore: getShortcutRepresentation('core/block-editor/insert-before')
    };
  }, []);
  const updateSelection = Object(external_wp_element_["useCallback"])(__experimentalSelectBlock ? async clientIdsPromise => {
    const ids = await clientIdsPromise;

    if (ids && ids[0]) {
      __experimentalSelectBlock(ids[0]);
    }
  } : external_lodash_["noop"], [__experimentalSelectBlock]);
  const label = Object(external_wp_i18n_["sprintf"])(
  /* translators: %s: block name */
  Object(external_wp_i18n_["__"])('Remove %s'), title);
  const removeBlockLabel = count === 1 ? label : Object(external_wp_i18n_["__"])('Remove blocks');
  return Object(external_wp_element_["createElement"])(BlockActions, {
    clientIds: clientIds,
    __experimentalUpdateSelection: !__experimentalSelectBlock
  }, _ref3 => {
    let {
      canDuplicate,
      canInsertDefaultBlock,
      canMove,
      canRemove,
      onDuplicate,
      onInsertAfter,
      onInsertBefore,
      onRemove,
      onCopy,
      onMoveTo,
      blocks
    } = _ref3;
    return Object(external_wp_element_["createElement"])(external_wp_components_["DropdownMenu"], Object(esm_extends["a" /* default */])({
      icon: more_vertical["a" /* default */],
      label: Object(external_wp_i18n_["__"])('Options'),
      className: "block-editor-block-settings-menu",
      popoverProps: POPOVER_PROPS,
      noIcons: true
    }, props), _ref4 => {
      let {
        onClose
      } = _ref4;
      return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["MenuGroup"], null, Object(external_wp_element_["createElement"])(block_settings_menu_first_item["a" /* default */].Slot, {
        fillProps: {
          onClose
        }
      }), count === 1 && Object(external_wp_element_["createElement"])(block_html_convert_button, {
        clientId: firstBlockClientId
      }), Object(external_wp_element_["createElement"])(CopyMenuItem, {
        blocks: blocks,
        onCopy: onCopy
      }), canDuplicate && Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
        onClick: Object(external_lodash_["flow"])(onClose, onDuplicate, updateSelection),
        shortcut: shortcuts.duplicate
      }, Object(external_wp_i18n_["__"])('Duplicate')), canInsertDefaultBlock && Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
        onClick: Object(external_lodash_["flow"])(onClose, onInsertBefore),
        shortcut: shortcuts.insertBefore
      }, Object(external_wp_i18n_["__"])('Insert before')), Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
        onClick: Object(external_lodash_["flow"])(onClose, onInsertAfter),
        shortcut: shortcuts.insertAfter
      }, Object(external_wp_i18n_["__"])('Insert after'))), canMove && !onlyBlock && Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
        onClick: Object(external_lodash_["flow"])(onClose, onMoveTo)
      }, Object(external_wp_i18n_["__"])('Move to')), count === 1 && Object(external_wp_element_["createElement"])(block_mode_toggle, {
        clientId: firstBlockClientId,
        onToggle: onClose
      })), Object(external_wp_element_["createElement"])(block_settings_menu_controls["a" /* default */].Slot, {
        fillProps: {
          onClose
        },
        clientIds: clientIds
      }), typeof children === 'function' ? children({
        onClose
      }) : external_wp_element_["Children"].map(child => Object(external_wp_element_["cloneElement"])(child, {
        onClose
      })), canRemove && Object(external_wp_element_["createElement"])(external_wp_components_["MenuGroup"], null, Object(external_wp_element_["createElement"])(external_wp_components_["MenuItem"], {
        onClick: Object(external_lodash_["flow"])(onClose, onRemove, updateSelection),
        shortcut: shortcuts.remove
      }, removeBlockLabel)));
    });
  });
}
/* harmony default export */ var block_settings_dropdown = __webpack_exports__["a"] = (BlockSettingsDropdown);


/***/ }),

/***/ "1iEr":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const chevronRight = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M10.6 6L9.4 7l4.6 5-4.6 5 1.2 1 5.4-6z"
}));
/* harmony default export */ __webpack_exports__["a"] = (chevronRight);


/***/ }),

/***/ "1oY3":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return InspectorAdvancedControls; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wx14");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _fill__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("NtoT");
/* harmony import */ var _slot__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("jwne");



/**
 * Internal dependencies
 */


const InspectorControls = _fill__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"];
InspectorControls.Slot = _slot__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"]; // This is just here for backward compatibility.

const InspectorAdvancedControls = props => {
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_fill__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({}, props, {
    __experimentalGroup: "advanced"
  }));
};

InspectorAdvancedControls.Slot = props => {
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_slot__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({}, props, {
    __experimentalGroup: "advanced"
  }));
};

InspectorAdvancedControls.slotName = 'InspectorAdvancedControls';
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/inspector-controls/README.md
 */

/* harmony default export */ __webpack_exports__["b"] = (InspectorControls);


/***/ }),

/***/ "1uGa":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("RxS6");
/* harmony import */ var _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_keycodes__WEBPACK_IMPORTED_MODULE_3__);


/**
 * WordPress dependencies
 */




function DuotoneControl(_ref) {
  let {
    colorPalette,
    duotonePalette,
    disableCustomColors,
    disableCustomDuotone,
    value,
    onChange
  } = _ref;
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__["Dropdown"], {
    popoverProps: {
      className: 'block-editor-duotone-control__popover',
      headerTitle: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Duotone'),
      isAlternate: true
    },
    renderToggle: _ref2 => {
      let {
        isOpen,
        onToggle
      } = _ref2;

      const openOnArrowDown = event => {
        if (!isOpen && event.keyCode === _wordpress_keycodes__WEBPACK_IMPORTED_MODULE_3__["DOWN"]) {
          event.preventDefault();
          onToggle();
        }
      };

      return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__["ToolbarButton"], {
        showTooltip: true,
        onClick: onToggle,
        "aria-haspopup": "true",
        "aria-expanded": isOpen,
        onKeyDown: openOnArrowDown,
        label: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Apply duotone filter'),
        icon: Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__["DuotoneSwatch"], {
          values: value
        })
      });
    },
    renderContent: () => Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__["MenuGroup"], {
      label: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Duotone')
    }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("div", {
      className: "block-editor-duotone-control__description"
    }, Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Create a two-tone color effect without losing your original image.')), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__["DuotonePicker"], {
      colorPalette: colorPalette,
      duotonePalette: duotonePalette,
      disableCustomColors: disableCustomColors,
      disableCustomDuotone: disableCustomDuotone,
      value: value,
      onChange: onChange
    }))
  });
}

/* harmony default export */ __webpack_exports__["a"] = (DuotoneControl);


/***/ }),

/***/ "2YCo":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ BorderStyleControl; });

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external ["wp","components"]
var external_wp_components_ = __webpack_require__("tI+e");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/line-solid.js
var line_solid = __webpack_require__("bVTw");

// EXTERNAL MODULE: external ["wp","primitives"]
var external_wp_primitives_ = __webpack_require__("Tqx9");

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/line-dashed.js


/**
 * WordPress dependencies
 */

const lineDashed = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  fill: "none"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  fillRule: "evenodd",
  d: "M5 11.25h3v1.5H5v-1.5zm5.5 0h3v1.5h-3v-1.5zm8.5 0h-3v1.5h3v-1.5z",
  clipRule: "evenodd"
}));
/* harmony default export */ var line_dashed = (lineDashed);

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/line-dotted.js


/**
 * WordPress dependencies
 */

const lineDotted = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  width: "24",
  height: "24",
  fill: "none"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  fillRule: "evenodd",
  d: "M5.25 11.25h1.5v1.5h-1.5v-1.5zm3 0h1.5v1.5h-1.5v-1.5zm4.5 0h-1.5v1.5h1.5v-1.5zm1.5 0h1.5v1.5h-1.5v-1.5zm4.5 0h-1.5v1.5h1.5v-1.5z",
  clipRule: "evenodd"
}));
/* harmony default export */ var line_dotted = (lineDotted);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/border-style-control/index.js


/**
 * WordPress dependencies
 */



const BORDER_STYLES = [{
  label: Object(external_wp_i18n_["__"])('Solid'),
  icon: line_solid["a" /* default */],
  value: 'solid'
}, {
  label: Object(external_wp_i18n_["__"])('Dashed'),
  icon: line_dashed,
  value: 'dashed'
}, {
  label: Object(external_wp_i18n_["__"])('Dotted'),
  icon: line_dotted,
  value: 'dotted'
}];
/**
 * Control to display border style options.
 *
 * @param {Object}   props          Component props.
 * @param {Function} props.onChange Handler for changing border style selection.
 * @param {string}   props.value    Currently selected border style value.
 *
 * @return {WPElement} Custom border style segmented control.
 */

function BorderStyleControl(_ref) {
  let {
    onChange,
    value
  } = _ref;
  return Object(external_wp_element_["createElement"])("fieldset", {
    className: "components-border-style-control"
  }, Object(external_wp_element_["createElement"])("legend", null, Object(external_wp_i18n_["__"])('Style')), Object(external_wp_element_["createElement"])("div", {
    className: "components-border-style-control__buttons"
  }, BORDER_STYLES.map(borderStyle => Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    key: borderStyle.value,
    icon: borderStyle.icon,
    isSmall: true,
    isPressed: borderStyle.value === value,
    onClick: () => onChange(borderStyle.value === value ? undefined : borderStyle.value),
    "aria-label": borderStyle.label
  }))));
}


/***/ }),

/***/ "2gm7":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const chevronLeft = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M14.6 7l-1.2-1L8 12l5.4 6 1.2-1-4.6-5z"
}));
/* harmony default export */ __webpack_exports__["a"] = (chevronLeft);


/***/ }),

/***/ "2z9l":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return usePopoverScroll; });
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("K9lf");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */

/**
 * Allow scrolling "through" popovers over the canvas. This is only called for
 * as long as the pointer is over a popover. Do not use React events because it
 * will bubble through portals.
 *
 * @param {Object} scrollableRef
 */

function usePopoverScroll(scrollableRef) {
  return Object(_wordpress_compose__WEBPACK_IMPORTED_MODULE_0__["useRefEffect"])(node => {
    if (!scrollableRef) {
      return;
    }

    function onWheel(event) {
      const {
        deltaX,
        deltaY
      } = event;
      scrollableRef.current.scrollBy(deltaX, deltaY);
    } // Tell the browser that we do not call event.preventDefault
    // See https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#improving_scrolling_performance_with_passive_listeners


    const options = {
      passive: true
    };
    node.addEventListener('wheel', onWheel, options);
    return () => {
      node.removeEventListener('wheel', onWheel, options);
    };
  }, [scrollableRef]);
}


/***/ }),

/***/ "5L8O":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export ZWNBSP */
/* unused harmony export DefaultBlockAppender */
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("TSYQ");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("K9lf");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("HSyU");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_html_entities__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("rmEH");
/* harmony import */ var _wordpress_html_entities__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_html_entities__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _inserter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("qrxh");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("BhPs");


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



/**
 * Zero width non-breaking space, used as padding for the paragraph when it is
 * empty.
 */

const ZWNBSP = '\ufeff';
function DefaultBlockAppender(_ref) {
  let {
    isLocked,
    isVisible,
    onAppend,
    showPrompt,
    placeholder,
    rootClientId
  } = _ref;

  if (isLocked || !isVisible) {
    return null;
  }

  const value = Object(_wordpress_html_entities__WEBPACK_IMPORTED_MODULE_5__["decodeEntities"])(placeholder) || Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Type / to choose a block');

  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("div", {
    "data-root-client-id": rootClientId || '',
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('block-editor-default-block-appender', {
      'has-visible-prompt': showPrompt
    })
  }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("p", {
    tabIndex: "0" // Only necessary for `useCanvasClickRedirect` to consider it
    // as a target. Ideally it should consider any tabbable target,
    // but the inserter is rendered in place while it should be
    // rendered in a popover, just like it does for an empty
    // paragraph block.
    ,
    contentEditable: true,
    suppressContentEditableWarning: true // We want this element to be styled as a paragraph by themes.
    // eslint-disable-next-line jsx-a11y/no-noninteractive-element-to-interactive-role
    ,
    role: "button",
    "aria-label": Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Add block') // A wrapping container for this one already has the wp-block className.
    ,
    className: "block-editor-default-block-appender__content",
    onFocus: onAppend
  }, showPrompt ? value : ZWNBSP), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_inserter__WEBPACK_IMPORTED_MODULE_7__[/* default */ "a"], {
    rootClientId: rootClientId,
    position: "bottom right",
    isAppender: true,
    __experimentalIsQuick: true
  }));
}
/* harmony default export */ __webpack_exports__["a"] = (Object(_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__["compose"])(Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_6__["withSelect"])((select, ownProps) => {
  const {
    getBlockCount,
    getBlockName,
    isBlockValid,
    getSettings,
    getTemplateLock
  } = select(_store__WEBPACK_IMPORTED_MODULE_8__[/* store */ "a"]);
  const isEmpty = !getBlockCount(ownProps.rootClientId);
  const isLastBlockDefault = getBlockName(ownProps.lastBlockClientId) === Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__["getDefaultBlockName"])();
  const isLastBlockValid = isBlockValid(ownProps.lastBlockClientId);
  const {
    bodyPlaceholder
  } = getSettings();
  return {
    isVisible: isEmpty || !isLastBlockDefault || !isLastBlockValid,
    showPrompt: isEmpty,
    isLocked: !!getTemplateLock(ownProps.rootClientId),
    placeholder: bodyPlaceholder
  };
}), Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_6__["withDispatch"])((dispatch, ownProps) => {
  const {
    insertDefaultBlock,
    startTyping
  } = dispatch(_store__WEBPACK_IMPORTED_MODULE_8__[/* store */ "a"]);
  return {
    onAppend() {
      const {
        rootClientId
      } = ownProps;
      insertDefaultBlock(undefined, rootClientId);
      startTyping();
    }

  };
}))(DefaultBlockAppender));


/***/ }),

/***/ "5gPN":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* reexport */ utils["a" /* getColorClassName */]; });
__webpack_require__.d(__webpack_exports__, "c", function() { return /* reexport */ utils["b" /* getColorObjectByAttributeValues */]; });
__webpack_require__.d(__webpack_exports__, "d", function() { return /* reexport */ utils["c" /* getColorObjectByColorValue */]; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* reexport */ createCustomColorsHOC; });
__webpack_require__.d(__webpack_exports__, "e", function() { return /* reexport */ withColors; });

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/colors/utils.js
var utils = __webpack_require__("bVpQ");

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-setting/index.js
var use_setting = __webpack_require__("v5LD");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/colors/with-colors.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/**
 * Higher order component factory for injecting the `colorsArray` argument as
 * the colors prop in the `withCustomColors` HOC.
 *
 * @param {Array} colorsArray An array of color objects.
 *
 * @return {Function} The higher order component.
 */

const withCustomColorPalette = colorsArray => Object(external_wp_compose_["createHigherOrderComponent"])(WrappedComponent => props => Object(external_wp_element_["createElement"])(WrappedComponent, Object(esm_extends["a" /* default */])({}, props, {
  colors: colorsArray
})), 'withCustomColorPalette');
/**
 * Higher order component factory for injecting the editor colors as the
 * `colors` prop in the `withColors` HOC.
 *
 * @return {Function} The higher order component.
 */


const withEditorColorPalette = () => Object(external_wp_compose_["createHigherOrderComponent"])(WrappedComponent => props => {
  // Some color settings have a special handling for deprecated flags in `useSetting`,
  // so we can't unwrap them by doing const { ... } = useSetting('color')
  // until https://github.com/WordPress/gutenberg/issues/37094 is fixed.
  const userPalette = Object(use_setting["a" /* default */])('color.palette.custom');
  const themePalette = Object(use_setting["a" /* default */])('color.palette.theme');
  const defaultPalette = Object(use_setting["a" /* default */])('color.palette.default');
  const allColors = Object(external_wp_element_["useMemo"])(() => [...(userPalette || []), ...(themePalette || []), ...(defaultPalette || [])], [userPalette, themePalette, defaultPalette]);
  return Object(external_wp_element_["createElement"])(WrappedComponent, Object(esm_extends["a" /* default */])({}, props, {
    colors: allColors
  }));
}, 'withEditorColorPalette');
/**
 * Helper function used with `createHigherOrderComponent` to create
 * higher order components for managing color logic.
 *
 * @param {Array}    colorTypes       An array of color types (e.g. 'backgroundColor, borderColor).
 * @param {Function} withColorPalette A HOC for injecting the 'colors' prop into the WrappedComponent.
 *
 * @return {WPComponent} The component that can be used as a HOC.
 */


function createColorHOC(colorTypes, withColorPalette) {
  const colorMap = Object(external_lodash_["reduce"])(colorTypes, (colorObject, colorType) => {
    return { ...colorObject,
      ...(Object(external_lodash_["isString"])(colorType) ? {
        [colorType]: Object(external_lodash_["kebabCase"])(colorType)
      } : colorType)
    };
  }, {});
  return Object(external_wp_compose_["compose"])([withColorPalette, WrappedComponent => {
    return class extends external_wp_element_["Component"] {
      constructor(props) {
        super(props);
        this.setters = this.createSetters();
        this.colorUtils = {
          getMostReadableColor: this.getMostReadableColor.bind(this)
        };
        this.state = {};
      }

      getMostReadableColor(colorValue) {
        const {
          colors
        } = this.props;
        return Object(utils["d" /* getMostReadableColor */])(colors, colorValue);
      }

      createSetters() {
        return Object(external_lodash_["reduce"])(colorMap, (settersAccumulator, colorContext, colorAttributeName) => {
          const upperFirstColorAttributeName = Object(external_lodash_["upperFirst"])(colorAttributeName);
          const customColorAttributeName = `custom${upperFirstColorAttributeName}`;
          settersAccumulator[`set${upperFirstColorAttributeName}`] = this.createSetColor(colorAttributeName, customColorAttributeName);
          return settersAccumulator;
        }, {});
      }

      createSetColor(colorAttributeName, customColorAttributeName) {
        return colorValue => {
          const colorObject = Object(utils["c" /* getColorObjectByColorValue */])(this.props.colors, colorValue);
          this.props.setAttributes({
            [colorAttributeName]: colorObject && colorObject.slug ? colorObject.slug : undefined,
            [customColorAttributeName]: colorObject && colorObject.slug ? undefined : colorValue
          });
        };
      }

      static getDerivedStateFromProps(_ref, previousState) {
        let {
          attributes,
          colors
        } = _ref;
        return Object(external_lodash_["reduce"])(colorMap, (newState, colorContext, colorAttributeName) => {
          const colorObject = Object(utils["b" /* getColorObjectByAttributeValues */])(colors, attributes[colorAttributeName], attributes[`custom${Object(external_lodash_["upperFirst"])(colorAttributeName)}`]);
          const previousColorObject = previousState[colorAttributeName];
          const previousColor = previousColorObject === null || previousColorObject === void 0 ? void 0 : previousColorObject.color;
          /**
           * The "and previousColorObject" condition checks that a previous color object was already computed.
           * At the start previousColorObject and colorValue are both equal to undefined
           * bus as previousColorObject does not exist we should compute the object.
           */

          if (previousColor === colorObject.color && previousColorObject) {
            newState[colorAttributeName] = previousColorObject;
          } else {
            newState[colorAttributeName] = { ...colorObject,
              class: Object(utils["a" /* getColorClassName */])(colorContext, colorObject.slug)
            };
          }

          return newState;
        }, {});
      }

      render() {
        return Object(external_wp_element_["createElement"])(WrappedComponent, Object(esm_extends["a" /* default */])({}, this.props, {
          colors: undefined
        }, this.state, this.setters, {
          colorUtils: this.colorUtils
        }));
      }

    };
  }]);
}
/**
 * A higher-order component factory for creating a 'withCustomColors' HOC, which handles color logic
 * for class generation color value, retrieval and color attribute setting.
 *
 * Use this higher-order component to work with a custom set of colors.
 *
 * @example
 *
 * ```jsx
 * const CUSTOM_COLORS = [ { name: 'Red', slug: 'red', color: '#ff0000' }, { name: 'Blue', slug: 'blue', color: '#0000ff' } ];
 * const withCustomColors = createCustomColorsHOC( CUSTOM_COLORS );
 * // ...
 * export default compose(
 *     withCustomColors( 'backgroundColor', 'borderColor' ),
 *     MyColorfulComponent,
 * );
 * ```
 *
 * @param {Array} colorsArray The array of color objects (name, slug, color, etc... ).
 *
 * @return {Function} Higher-order component.
 */


function createCustomColorsHOC(colorsArray) {
  return function () {
    const withColorPalette = withCustomColorPalette(colorsArray);

    for (var _len = arguments.length, colorTypes = new Array(_len), _key = 0; _key < _len; _key++) {
      colorTypes[_key] = arguments[_key];
    }

    return Object(external_wp_compose_["createHigherOrderComponent"])(createColorHOC(colorTypes, withColorPalette), 'withCustomColors');
  };
}
/**
 * A higher-order component, which handles color logic for class generation color value, retrieval and color attribute setting.
 *
 * For use with the default editor/theme color palette.
 *
 * @example
 *
 * ```jsx
 * export default compose(
 *     withColors( 'backgroundColor', { textColor: 'color' } ),
 *     MyColorfulComponent,
 * );
 * ```
 *
 * @param {...(Object|string)} colorTypes The arguments can be strings or objects. If the argument is an object,
 *                                        it should contain the color attribute name as key and the color context as value.
 *                                        If the argument is a string the value should be the color attribute name,
 *                                        the color context is computed by applying a kebab case transform to the value.
 *                                        Color context represents the context/place where the color is going to be used.
 *                                        The class name of the color is generated using 'has' followed by the color name
 *                                        and ending with the color context all in kebab case e.g: has-green-background-color.
 *
 * @return {Function} Higher-order component.
 */

function withColors() {
  const withColorPalette = withEditorColorPalette();

  for (var _len2 = arguments.length, colorTypes = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
    colorTypes[_key2] = arguments[_key2];
  }

  return Object(external_wp_compose_["createHigherOrderComponent"])(createColorHOC(colorTypes, withColorPalette), 'withColors');
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/colors/index.js




/***/ }),

/***/ "6ZVF":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external ["wp","blocks"]
var external_wp_blocks_ = __webpack_require__("HSyU");

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__("TSYQ");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: external ["wp","keycodes"]
var external_wp_keycodes_ = __webpack_require__("RxS6");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-icon/index.js
var block_icon = __webpack_require__("7SSY");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter-listbox/item.js
var inserter_listbox_item = __webpack_require__("M+co");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter-draggable-blocks/index.js
var inserter_draggable_blocks = __webpack_require__("j6zP");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter-list-item/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




/**
 * Return true if platform is MacOS.
 *
 * @param {Object} _window window object by default; used for DI testing.
 *
 * @return {boolean} True if MacOS; false otherwise.
 */

function isAppleOS() {
  let _window = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : window;

  const {
    platform
  } = _window.navigator;
  return platform.indexOf('Mac') !== -1 || ['iPad', 'iPhone'].includes(platform);
}

function InserterListItem(_ref) {
  let {
    className,
    isFirst,
    item,
    onSelect,
    onHover,
    isDraggable,
    ...props
  } = _ref;
  const isDragging = Object(external_wp_element_["useRef"])(false);
  const itemIconStyle = item.icon ? {
    backgroundColor: item.icon.background,
    color: item.icon.foreground
  } : {};
  const blocks = Object(external_wp_element_["useMemo"])(() => {
    return [Object(external_wp_blocks_["createBlock"])(item.name, item.initialAttributes, Object(external_wp_blocks_["createBlocksFromInnerBlocksTemplate"])(item.innerBlocks))];
  }, [item.name, item.initialAttributes, item.initialAttributes]);
  return Object(external_wp_element_["createElement"])(inserter_draggable_blocks["a" /* default */], {
    isEnabled: isDraggable && !item.disabled,
    blocks: blocks,
    icon: item.icon
  }, _ref2 => {
    let {
      draggable,
      onDragStart,
      onDragEnd
    } = _ref2;
    return Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-block-types-list__list-item",
      draggable: draggable,
      onDragStart: event => {
        isDragging.current = true;

        if (onDragStart) {
          onHover(null);
          onDragStart(event);
        }
      },
      onDragEnd: event => {
        isDragging.current = false;

        if (onDragEnd) {
          onDragEnd(event);
        }
      }
    }, Object(external_wp_element_["createElement"])(inserter_listbox_item["a" /* default */], Object(esm_extends["a" /* default */])({
      isFirst: isFirst,
      className: classnames_default()('block-editor-block-types-list__item', className),
      disabled: item.isDisabled,
      onClick: event => {
        event.preventDefault();
        onSelect(item, isAppleOS() ? event.metaKey : event.ctrlKey);
        onHover(null);
      },
      onKeyDown: event => {
        const {
          keyCode
        } = event;

        if (keyCode === external_wp_keycodes_["ENTER"]) {
          event.preventDefault();
          onSelect(item, isAppleOS() ? event.metaKey : event.ctrlKey);
          onHover(null);
        }
      },
      onFocus: () => {
        if (isDragging.current) {
          return;
        }

        onHover(item);
      },
      onMouseEnter: () => {
        if (isDragging.current) {
          return;
        }

        onHover(item);
      },
      onMouseLeave: () => onHover(null),
      onBlur: () => onHover(null)
    }, props), Object(external_wp_element_["createElement"])("span", {
      className: "block-editor-block-types-list__item-icon",
      style: itemIconStyle
    }, Object(external_wp_element_["createElement"])(block_icon["a" /* default */], {
      icon: item.icon,
      showColors: true
    })), Object(external_wp_element_["createElement"])("span", {
      className: "block-editor-block-types-list__item-title"
    }, item.title)));
  });
}

/* harmony default export */ var inserter_list_item = (Object(external_wp_element_["memo"])(InserterListItem));

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter-listbox/group.js
var group = __webpack_require__("xkPd");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/inserter-listbox/row.js
var inserter_listbox_row = __webpack_require__("HC45");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-types-list/index.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




function chunk(array, size) {
  const chunks = [];

  for (let i = 0, j = array.length; i < j; i += size) {
    chunks.push(array.slice(i, i + size));
  }

  return chunks;
}

function BlockTypesList(_ref) {
  let {
    items = [],
    onSelect,
    onHover = () => {},
    children,
    label,
    isDraggable = true
  } = _ref;
  return Object(external_wp_element_["createElement"])(group["a" /* default */], {
    className: "block-editor-block-types-list",
    "aria-label": label
  }, chunk(items, 3).map((row, i) => Object(external_wp_element_["createElement"])(inserter_listbox_row["a" /* default */], {
    key: i
  }, row.map((item, j) => Object(external_wp_element_["createElement"])(inserter_list_item, {
    key: item.id,
    item: item,
    className: Object(external_wp_blocks_["getBlockMenuDefaultClassName"])(item.id),
    onSelect: onSelect,
    onHover: onHover,
    isDraggable: isDraggable,
    isFirst: i === 0 && j === 0
  })))), children);
}

/* harmony default export */ var block_types_list = __webpack_exports__["a"] = (BlockTypesList);


/***/ }),

/***/ "6c9H":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var colord__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("fHnH");
/* harmony import */ var colord_plugins_names__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("abaT");
/* harmony import */ var colord_plugins_a11y__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("7bKH");
/* harmony import */ var _wordpress_a11y__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("gdqT");
/* harmony import */ var _wordpress_a11y__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_a11y__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__);


/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */





Object(colord__WEBPACK_IMPORTED_MODULE_1__[/* extend */ "b"])([colord_plugins_names__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"], colord_plugins_a11y__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"]]);

function ContrastCheckerMessage(_ref) {
  let {
    colordBackgroundColor,
    colordTextColor,
    backgroundColor,
    textColor
  } = _ref;
  const msg = colordBackgroundColor.brightness() < colordTextColor.brightness() ? Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__["__"])('This color combination may be hard for people to read. Try using a darker background color and/or a brighter text color.') : Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__["__"])('This color combination may be hard for people to read. Try using a brighter background color and/or a darker text color.'); // Note: The `Notice` component can speak messages via its `spokenMessage`
  // prop, but the contrast checker requires granular control over when the
  // announcements are made. Notably, the message will be re-announced if a
  // new color combination is selected and the contrast is still insufficient.

  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(() => {
    Object(_wordpress_a11y__WEBPACK_IMPORTED_MODULE_4__["speak"])(Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__["__"])('This color combination may be hard for people to read.'));
  }, [backgroundColor, textColor]);
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("div", {
    className: "block-editor-contrast-checker"
  }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_6__["Notice"], {
    spokenMessage: null,
    status: "warning",
    isDismissible: false
  }, msg));
}

function ContrastChecker(_ref2) {
  let {
    backgroundColor,
    fallbackBackgroundColor,
    fallbackTextColor,
    fontSize,
    // font size value in pixels
    isLargeText,
    textColor
  } = _ref2;

  if (!(backgroundColor || fallbackBackgroundColor) || !(textColor || fallbackTextColor)) {
    return null;
  }

  const colordBackgroundColor = Object(colord__WEBPACK_IMPORTED_MODULE_1__[/* colord */ "a"])(backgroundColor || fallbackBackgroundColor);
  const colordTextColor = Object(colord__WEBPACK_IMPORTED_MODULE_1__[/* colord */ "a"])(textColor || fallbackTextColor);
  const hasTransparency = colordBackgroundColor.alpha() !== 1 || colordTextColor.alpha() !== 1;

  if (hasTransparency || colordTextColor.isReadable(colordBackgroundColor, {
    level: 'AA',
    size: isLargeText || isLargeText !== false && fontSize >= 24 ? 'large' : 'small'
  })) {
    return null;
  }

  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(ContrastCheckerMessage, {
    backgroundColor: backgroundColor,
    textColor: textColor,
    colordBackgroundColor: colordBackgroundColor,
    colordTextColor: colordTextColor
  });
}

/* harmony default export */ __webpack_exports__["a"] = (ContrastChecker);


/***/ }),

/***/ "6jxZ":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useFocusHandler; });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("K9lf");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("OL6h");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("BhPs");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



/**
 * Selects the block if it receives focus.
 *
 * @param {string} clientId Block client ID.
 */

function useFocusHandler(clientId) {
  const {
    isBlockSelected
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__["useSelect"])(_store__WEBPACK_IMPORTED_MODULE_3__[/* store */ "a"]);
  const {
    selectBlock,
    selectionChange
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__["useDispatch"])(_store__WEBPACK_IMPORTED_MODULE_3__[/* store */ "a"]);
  return Object(_wordpress_compose__WEBPACK_IMPORTED_MODULE_1__["useRefEffect"])(node => {
    /**
     * Marks the block as selected when focused and not already
     * selected. This specifically handles the case where block does not
     * set focus on its own (via `setFocus`), typically if there is no
     * focusable input in the block.
     *
     * @param {FocusEvent} event Focus event.
     */
    function onFocus(event) {
      // Check synchronously because a non-selected block might be
      // getting data through `useSelect` asynchronously.
      if (isBlockSelected(clientId)) {
        // Potentially change selection away from rich text.
        if (!event.target.isContentEditable) {
          selectionChange(clientId);
        }

        return;
      } // If an inner block is focussed, that block is resposible for
      // setting the selected block.


      if (!Object(_utils_dom__WEBPACK_IMPORTED_MODULE_2__[/* isInsideRootBlock */ "c"])(node, event.target)) {
        return;
      }

      selectBlock(clientId);
    }

    node.addEventListener('focusin', onFocus);
    return () => {
      node.removeEventListener('focusin', onFocus);
    };
  }, [isBlockSelected, selectBlock]);
}


/***/ }),

/***/ "715p":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return cleanEmptyObject; });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("YLtl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

/**
 * Removed falsy values from nested object.
 *
 * @param {*} object
 * @return {*} Object cleaned from falsy values
 */

const cleanEmptyObject = object => {
  if (!Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isObject"])(object) || Array.isArray(object)) {
    return object;
  }

  const cleanedNestedObjects = Object(lodash__WEBPACK_IMPORTED_MODULE_0__["pickBy"])(Object(lodash__WEBPACK_IMPORTED_MODULE_0__["mapValues"])(object, cleanEmptyObject), lodash__WEBPACK_IMPORTED_MODULE_0__["identity"]);
  return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(cleanedNestedObjects) ? undefined : cleanedNestedObjects;
};


/***/ }),

/***/ "7NR9":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__("TSYQ");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: external ["wp","keycodes"]
var external_wp_keycodes_ = __webpack_require__("RxS6");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: external ["wp","blocks"]
var external_wp_blocks_ = __webpack_require__("HSyU");

// EXTERNAL MODULE: external ["wp","tokenList"]
var external_wp_tokenList_ = __webpack_require__("BLeD");
var external_wp_tokenList_default = /*#__PURE__*/__webpack_require__.n(external_wp_tokenList_);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-styles/utils.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */


/**
 * Returns the active style from the given className.
 *
 * @param {Array}  styles    Block style variations.
 * @param {string} className Class name
 *
 * @return {Object?} The active style.
 */

function getActiveStyle(styles, className) {
  for (const style of new external_wp_tokenList_default.a(className).values()) {
    if (style.indexOf('is-style-') === -1) {
      continue;
    }

    const potentialStyleName = style.substring(9);
    const activeStyle = Object(external_lodash_["find"])(styles, {
      name: potentialStyleName
    });

    if (activeStyle) {
      return activeStyle;
    }
  }

  return Object(external_lodash_["find"])(styles, 'isDefault');
}
/**
 * Replaces the active style in the block's className.
 *
 * @param {string}  className   Class name.
 * @param {Object?} activeStyle The replaced style.
 * @param {Object}  newStyle    The replacing style.
 *
 * @return {string} The updated className.
 */

function replaceActiveStyle(className, activeStyle, newStyle) {
  const list = new external_wp_tokenList_default.a(className);

  if (activeStyle) {
    list.remove('is-style-' + activeStyle.name);
  }

  list.add('is-style-' + newStyle.name);
  return list.value;
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-preview/index.js + 2 modules
var block_preview = __webpack_require__("REKd");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js + 4 modules
var store = __webpack_require__("BhPs");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-styles/index.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */




const EMPTY_OBJECT = {};

function useGenericPreviewBlock(block, type) {
  return Object(external_wp_element_["useMemo"])(() => {
    const example = type === null || type === void 0 ? void 0 : type.example;
    const blockName = type === null || type === void 0 ? void 0 : type.name;

    if (example && blockName) {
      return Object(external_wp_blocks_["getBlockFromExample"])(blockName, {
        attributes: example.attributes,
        innerBlocks: example.innerBlocks
      });
    }

    if (block) {
      return Object(external_wp_blocks_["cloneBlock"])(block);
    }
  }, [type !== null && type !== void 0 && type.example ? block === null || block === void 0 ? void 0 : block.name : block, type]);
}

function BlockStyles(_ref) {
  let {
    clientId,
    onSwitch = external_lodash_["noop"],
    onHoverClassName = external_lodash_["noop"],
    itemRole
  } = _ref;

  const selector = select => {
    const {
      getBlock
    } = select(store["a" /* store */]);
    const block = getBlock(clientId);

    if (!block) {
      return EMPTY_OBJECT;
    }

    const blockType = Object(external_wp_blocks_["getBlockType"])(block.name);
    const {
      getBlockStyles
    } = select(external_wp_blocks_["store"]);
    return {
      block,
      type: blockType,
      styles: getBlockStyles(block.name),
      className: block.attributes.className || ''
    };
  };

  const {
    styles,
    block,
    type,
    className
  } = Object(external_wp_data_["useSelect"])(selector, [clientId]);
  const {
    updateBlockAttributes
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const genericPreviewBlock = useGenericPreviewBlock(block, type);

  if (!styles || styles.length === 0) {
    return null;
  }

  const renderedStyles = Object(external_lodash_["find"])(styles, 'isDefault') ? styles : [{
    name: 'default',
    label: Object(external_wp_i18n_["_x"])('Default', 'block style'),
    isDefault: true
  }, ...styles];
  const activeStyle = getActiveStyle(renderedStyles, className);
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-styles"
  }, renderedStyles.map(style => {
    var _type$example$viewpor, _type$example;

    const styleClassName = replaceActiveStyle(className, activeStyle, style);
    return Object(external_wp_element_["createElement"])(BlockStyleItem, {
      genericPreviewBlock: genericPreviewBlock,
      viewportWidth: (_type$example$viewpor = (_type$example = type.example) === null || _type$example === void 0 ? void 0 : _type$example.viewportWidth) !== null && _type$example$viewpor !== void 0 ? _type$example$viewpor : 500,
      className: className,
      isActive: activeStyle === style,
      key: style.name,
      onSelect: () => {
        updateBlockAttributes(clientId, {
          className: styleClassName
        });
        onHoverClassName(null);
        onSwitch();
      },
      onBlur: () => onHoverClassName(null),
      onHover: () => onHoverClassName(styleClassName),
      style: style,
      styleClassName: styleClassName,
      itemRole: itemRole
    });
  }));
}

function BlockStyleItem(_ref2) {
  let {
    genericPreviewBlock,
    viewportWidth,
    style,
    isActive,
    onBlur,
    onHover,
    onSelect,
    styleClassName,
    itemRole
  } = _ref2;
  const previewBlocks = Object(external_wp_element_["useMemo"])(() => {
    return { ...genericPreviewBlock,
      attributes: { ...genericPreviewBlock.attributes,
        className: styleClassName
      }
    };
  }, [genericPreviewBlock, styleClassName]);
  return Object(external_wp_element_["createElement"])("div", {
    key: style.name,
    className: classnames_default()('block-editor-block-styles__item', {
      'is-active': isActive
    }),
    onClick: () => onSelect(),
    onKeyDown: event => {
      if (external_wp_keycodes_["ENTER"] === event.keyCode || external_wp_keycodes_["SPACE"] === event.keyCode) {
        event.preventDefault();
        onSelect();
      }
    },
    onMouseEnter: onHover,
    onMouseLeave: onBlur,
    role: itemRole || 'button',
    tabIndex: "0",
    "aria-label": style.label || style.name
  }, Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-styles__item-preview"
  }, Object(external_wp_element_["createElement"])(block_preview["a" /* default */], {
    viewportWidth: viewportWidth,
    blocks: previewBlocks
  })), Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-styles__item-label"
  }, style.label || style.name));
}

/* harmony default export */ var block_styles = __webpack_exports__["a"] = (BlockStyles);


/***/ }),

/***/ "7SSY":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("TSYQ");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("//Lo");


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





function BlockIcon(_ref) {
  var _icon;

  let {
    icon,
    showColors = false,
    className
  } = _ref;

  if (((_icon = icon) === null || _icon === void 0 ? void 0 : _icon.src) === 'block-default') {
    icon = {
      src: _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"]
    };
  }

  const renderedIcon = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["Icon"], {
    icon: icon && icon.src ? icon.src : icon
  });
  const style = showColors ? {
    backgroundColor: icon && icon.background,
    color: icon && icon.foreground
  } : {};
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("span", {
    style: style,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('block-editor-block-icon', className, {
      'has-colors': showColors
    })
  }, renderedIcon);
}

/* harmony default export */ __webpack_exports__["a"] = (Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["memo"])(BlockIcon));


/***/ }),

/***/ "7bKH":
/***/ (function(__webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
var o=function(o){var t=o/255;return t<.04045?t/12.92:Math.pow((t+.055)/1.055,2.4)},t=function(t){return.2126*o(t.r)+.7152*o(t.g)+.0722*o(t.b)};/* harmony default export */ __webpack_exports__["a"] = (function(o){o.prototype.luminance=function(){return o=t(this.rgba),void 0===(r=2)&&(r=0),void 0===n&&(n=Math.pow(10,r)),Math.round(n*o)/n+0;var o,r,n},o.prototype.contrast=function(r){void 0===r&&(r="#FFF");var n,a,i,e,v,u,d,c=r instanceof o?r:new o(r);return e=this.rgba,v=c.toRgb(),u=t(e),d=t(v),n=u>d?(u+.05)/(d+.05):(d+.05)/(u+.05),void 0===(a=2)&&(a=0),void 0===i&&(i=Math.pow(10,a)),Math.floor(i*n)/i+0},o.prototype.isReadable=function(o,t){return void 0===o&&(o="#FFF"),void 0===t&&(t={}),this.contrast(o)>=(e=void 0===(i=(r=t).size)?"normal":i,"AAA"===(a=void 0===(n=r.level)?"AA":n)&&"normal"===e?7:"AA"===a&&"large"===e?3:4.5);var r,n,a,i,e}});


/***/ }),

/***/ "7fqt":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["wordcount"]; }());

/***/ }),

/***/ "8oxB":
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),

/***/ "9Do8":
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = __webpack_require__("zt9T");

/***/ }),

/***/ "9Ma0":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ BlockMoverUpButton; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ BlockMoverDownButton; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__("TSYQ");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: external ["wp","blocks"]
var external_wp_blocks_ = __webpack_require__("HSyU");

// EXTERNAL MODULE: external ["wp","components"]
var external_wp_components_ = __webpack_require__("tI+e");

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-right.js
var chevron_right = __webpack_require__("1iEr");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-left.js
var chevron_left = __webpack_require__("2gm7");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-up.js
var chevron_up = __webpack_require__("XgzB");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/chevron-down.js
var chevron_down = __webpack_require__("NWDH");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-mover/mover-description.js
/**
 * WordPress dependencies
 */

/**
 * Return a label for the block movement controls depending on block position.
 *
 * @param {number}  selectedCount Number of blocks selected.
 * @param {string}  type          Block type - in the case of a single block, should
 *                                define its 'type'. I.e. 'Text', 'Heading', 'Image' etc.
 * @param {number}  firstIndex    The index (position - 1) of the first block selected.
 * @param {boolean} isFirst       This is the first block.
 * @param {boolean} isLast        This is the last block.
 * @param {number}  dir           Direction of movement (> 0 is considered to be going
 *                                down, < 0 is up).
 * @param {string}  orientation   The orientation of the block movers, vertical or
 *                                horizontal.
 *
 * @return {string} Label for the block movement controls.
 */

function getBlockMoverDescription(selectedCount, type, firstIndex, isFirst, isLast, dir, orientation) {
  const position = firstIndex + 1;

  const getMovementDirection = moveDirection => {
    if (moveDirection === 'up') {
      if (orientation === 'horizontal') {
        return Object(external_wp_i18n_["isRTL"])() ? 'right' : 'left';
      }

      return 'up';
    } else if (moveDirection === 'down') {
      if (orientation === 'horizontal') {
        return Object(external_wp_i18n_["isRTL"])() ? 'left' : 'right';
      }

      return 'down';
    }

    return null;
  };

  if (selectedCount > 1) {
    return getMultiBlockMoverDescription(selectedCount, firstIndex, isFirst, isLast, dir);
  }

  if (isFirst && isLast) {
    return Object(external_wp_i18n_["sprintf"])( // translators: %s: Type of block (i.e. Text, Image etc)
    Object(external_wp_i18n_["__"])('Block %s is the only block, and cannot be moved'), type);
  }

  if (dir > 0 && !isLast) {
    // moving down
    const movementDirection = getMovementDirection('down');

    if (movementDirection === 'down') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      Object(external_wp_i18n_["__"])('Move %1$s block from position %2$d down to position %3$d'), type, position, position + 1);
    }

    if (movementDirection === 'left') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      Object(external_wp_i18n_["__"])('Move %1$s block from position %2$d left to position %3$d'), type, position, position + 1);
    }

    if (movementDirection === 'right') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      Object(external_wp_i18n_["__"])('Move %1$s block from position %2$d right to position %3$d'), type, position, position + 1);
    }
  }

  if (dir > 0 && isLast) {
    // moving down, and is the last item
    const movementDirection = getMovementDirection('down');

    if (movementDirection === 'down') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc)
      Object(external_wp_i18n_["__"])('Block %1$s is at the end of the content and can’t be moved down'), type);
    }

    if (movementDirection === 'left') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc)
      Object(external_wp_i18n_["__"])('Block %1$s is at the end of the content and can’t be moved left'), type);
    }

    if (movementDirection === 'right') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc)
      Object(external_wp_i18n_["__"])('Block %1$s is at the end of the content and can’t be moved right'), type);
    }
  }

  if (dir < 0 && !isFirst) {
    // moving up
    const movementDirection = getMovementDirection('up');

    if (movementDirection === 'up') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      Object(external_wp_i18n_["__"])('Move %1$s block from position %2$d up to position %3$d'), type, position, position - 1);
    }

    if (movementDirection === 'left') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      Object(external_wp_i18n_["__"])('Move %1$s block from position %2$d left to position %3$d'), type, position, position - 1);
    }

    if (movementDirection === 'right') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc), 2: Position of selected block, 3: New position
      Object(external_wp_i18n_["__"])('Move %1$s block from position %2$d right to position %3$d'), type, position, position - 1);
    }
  }

  if (dir < 0 && isFirst) {
    // moving up, and is the first item
    const movementDirection = getMovementDirection('up');

    if (movementDirection === 'up') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc)
      Object(external_wp_i18n_["__"])('Block %1$s is at the beginning of the content and can’t be moved up'), type);
    }

    if (movementDirection === 'left') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc)
      Object(external_wp_i18n_["__"])('Block %1$s is at the beginning of the content and can’t be moved left'), type);
    }

    if (movementDirection === 'right') {
      return Object(external_wp_i18n_["sprintf"])( // translators: 1: Type of block (i.e. Text, Image etc)
      Object(external_wp_i18n_["__"])('Block %1$s is at the beginning of the content and can’t be moved right'), type);
    }
  }
}
/**
 * Return a label for the block movement controls depending on block position.
 *
 * @param {number}  selectedCount Number of blocks selected.
 * @param {number}  firstIndex    The index (position - 1) of the first block selected.
 * @param {boolean} isFirst       This is the first block.
 * @param {boolean} isLast        This is the last block.
 * @param {number}  dir           Direction of movement (> 0 is considered to be going
 *                                down, < 0 is up).
 *
 * @return {string} Label for the block movement controls.
 */

function getMultiBlockMoverDescription(selectedCount, firstIndex, isFirst, isLast, dir) {
  const position = firstIndex + 1;

  if (dir < 0 && isFirst) {
    return Object(external_wp_i18n_["__"])('Blocks cannot be moved up as they are already at the top');
  }

  if (dir > 0 && isLast) {
    return Object(external_wp_i18n_["__"])('Blocks cannot be moved down as they are already at the bottom');
  }

  if (dir < 0 && !isFirst) {
    return Object(external_wp_i18n_["sprintf"])( // translators: 1: Number of selected blocks, 2: Position of selected blocks
    Object(external_wp_i18n_["_n"])('Move %1$d block from position %2$d up by one place', 'Move %1$d blocks from position %2$d up by one place', selectedCount), selectedCount, position);
  }

  if (dir > 0 && !isLast) {
    return Object(external_wp_i18n_["sprintf"])( // translators: 1: Number of selected blocks, 2: Position of selected blocks
    Object(external_wp_i18n_["_n"])('Move %1$d block from position %2$d down by one place', 'Move %1$d blocks from position %2$d down by one place', selectedCount), selectedCount, position);
  }
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js + 4 modules
var store = __webpack_require__("BhPs");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-mover/button.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */





const getArrowIcon = (direction, orientation) => {
  if (direction === 'up') {
    if (orientation === 'horizontal') {
      return Object(external_wp_i18n_["isRTL"])() ? chevron_right["a" /* default */] : chevron_left["a" /* default */];
    }

    return chevron_up["a" /* default */];
  } else if (direction === 'down') {
    if (orientation === 'horizontal') {
      return Object(external_wp_i18n_["isRTL"])() ? chevron_left["a" /* default */] : chevron_right["a" /* default */];
    }

    return chevron_down["a" /* default */];
  }

  return null;
};

const getMovementDirectionLabel = (moveDirection, orientation) => {
  if (moveDirection === 'up') {
    if (orientation === 'horizontal') {
      return Object(external_wp_i18n_["isRTL"])() ? Object(external_wp_i18n_["__"])('Move right') : Object(external_wp_i18n_["__"])('Move left');
    }

    return Object(external_wp_i18n_["__"])('Move up');
  } else if (moveDirection === 'down') {
    if (orientation === 'horizontal') {
      return Object(external_wp_i18n_["isRTL"])() ? Object(external_wp_i18n_["__"])('Move left') : Object(external_wp_i18n_["__"])('Move right');
    }

    return Object(external_wp_i18n_["__"])('Move down');
  }

  return null;
};

const BlockMoverButton = Object(external_wp_element_["forwardRef"])((_ref, ref) => {
  let {
    clientIds,
    direction,
    orientation: moverOrientation,
    ...props
  } = _ref;
  const instanceId = Object(external_wp_compose_["useInstanceId"])(BlockMoverButton);
  const blocksCount = Object(external_lodash_["castArray"])(clientIds).length;
  const {
    blockType,
    isDisabled,
    rootClientId,
    isFirst,
    isLast,
    firstIndex,
    orientation = 'vertical'
  } = Object(external_wp_data_["useSelect"])(select => {
    const {
      getBlockIndex,
      getBlockRootClientId,
      getBlockOrder,
      getBlock,
      getBlockListSettings
    } = select(store["a" /* store */]);
    const normalizedClientIds = Object(external_lodash_["castArray"])(clientIds);
    const firstClientId = Object(external_lodash_["first"])(normalizedClientIds);
    const blockRootClientId = getBlockRootClientId(firstClientId);
    const firstBlockIndex = getBlockIndex(firstClientId);
    const lastBlockIndex = getBlockIndex(Object(external_lodash_["last"])(normalizedClientIds));
    const blockOrder = getBlockOrder(blockRootClientId);
    const block = getBlock(firstClientId);
    const isFirstBlock = firstBlockIndex === 0;
    const isLastBlock = lastBlockIndex === blockOrder.length - 1;
    const {
      orientation: blockListOrientation
    } = getBlockListSettings(blockRootClientId) || {};
    return {
      blockType: block ? Object(external_wp_blocks_["getBlockType"])(block.name) : null,
      isDisabled: direction === 'up' ? isFirstBlock : isLastBlock,
      rootClientId: blockRootClientId,
      firstIndex: firstBlockIndex,
      isFirst: isFirstBlock,
      isLast: isLastBlock,
      orientation: moverOrientation || blockListOrientation
    };
  }, [clientIds, direction]);
  const {
    moveBlocksDown,
    moveBlocksUp
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const moverFunction = direction === 'up' ? moveBlocksUp : moveBlocksDown;

  const onClick = event => {
    moverFunction(clientIds, rootClientId);

    if (props.onClick) {
      props.onClick(event);
    }
  };

  const descriptionId = `block-editor-block-mover-button__description-${instanceId}`;
  return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], Object(esm_extends["a" /* default */])({
    ref: ref,
    className: classnames_default()('block-editor-block-mover-button', `is-${direction}-button`),
    icon: getArrowIcon(direction, orientation),
    label: getMovementDirectionLabel(direction, orientation),
    "aria-describedby": descriptionId
  }, props, {
    onClick: isDisabled ? null : onClick,
    "aria-disabled": isDisabled
  })), Object(external_wp_element_["createElement"])("span", {
    id: descriptionId,
    className: "block-editor-block-mover-button__description"
  }, getBlockMoverDescription(blocksCount, blockType && blockType.title, firstIndex, isFirst, isLast, direction === 'up' ? -1 : 1, orientation)));
});
const BlockMoverUpButton = Object(external_wp_element_["forwardRef"])((props, ref) => {
  return Object(external_wp_element_["createElement"])(BlockMoverButton, Object(esm_extends["a" /* default */])({
    direction: "up",
    ref: ref
  }, props));
});
const BlockMoverDownButton = Object(external_wp_element_["forwardRef"])((props, ref) => {
  return Object(external_wp_element_["createElement"])(BlockMoverButton, Object(esm_extends["a" /* default */])({
    direction: "down",
    ref: ref
  }, props));
});


/***/ }),

/***/ "9XVa":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* reexport */ utils["a" /* getFontSize */]; });
__webpack_require__.d(__webpack_exports__, "c", function() { return /* reexport */ utils["b" /* getFontSizeClass */]; });
__webpack_require__.d(__webpack_exports__, "d", function() { return /* reexport */ utils["c" /* getFontSizeObjectByValue */]; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* reexport */ font_size_picker["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "e", function() { return /* reexport */ with_font_sizes; });

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-sizes/utils.js
var utils = __webpack_require__("NMUH");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-sizes/font-size-picker.js
var font_size_picker = __webpack_require__("QP/w");

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-setting/index.js
var use_setting = __webpack_require__("v5LD");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-sizes/with-font-sizes.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



const DEFAULT_FONT_SIZES = [];
/**
 * Higher-order component, which handles font size logic for class generation,
 * font size value retrieval, and font size change handling.
 *
 * @param {...(Object|string)} fontSizeNames The arguments should all be strings.
 *                                           Each string contains the font size
 *                                           attribute name e.g: 'fontSize'.
 *
 * @return {Function} Higher-order component.
 */

/* harmony default export */ var with_font_sizes = (function () {
  for (var _len = arguments.length, fontSizeNames = new Array(_len), _key = 0; _key < _len; _key++) {
    fontSizeNames[_key] = arguments[_key];
  }

  /*
   * Computes an object whose key is the font size attribute name as passed in the array,
   * and the value is the custom font size attribute name.
   * Custom font size is automatically compted by appending custom followed by the font size attribute name in with the first letter capitalized.
   */
  const fontSizeAttributeNames = Object(external_lodash_["reduce"])(fontSizeNames, (fontSizeAttributeNamesAccumulator, fontSizeAttributeName) => {
    fontSizeAttributeNamesAccumulator[fontSizeAttributeName] = `custom${Object(external_lodash_["upperFirst"])(fontSizeAttributeName)}`;
    return fontSizeAttributeNamesAccumulator;
  }, {});
  return Object(external_wp_compose_["createHigherOrderComponent"])(Object(external_wp_compose_["compose"])([Object(external_wp_compose_["createHigherOrderComponent"])(WrappedComponent => props => {
    const fontSizes = Object(use_setting["a" /* default */])('typography.fontSizes') || DEFAULT_FONT_SIZES;
    return Object(external_wp_element_["createElement"])(WrappedComponent, Object(esm_extends["a" /* default */])({}, props, {
      fontSizes: fontSizes
    }));
  }, 'withFontSizes'), WrappedComponent => {
    return class extends external_wp_element_["Component"] {
      constructor(props) {
        super(props);
        this.setters = this.createSetters();
        this.state = {};
      }

      createSetters() {
        return Object(external_lodash_["reduce"])(fontSizeAttributeNames, (settersAccumulator, customFontSizeAttributeName, fontSizeAttributeName) => {
          const upperFirstFontSizeAttributeName = Object(external_lodash_["upperFirst"])(fontSizeAttributeName);
          settersAccumulator[`set${upperFirstFontSizeAttributeName}`] = this.createSetFontSize(fontSizeAttributeName, customFontSizeAttributeName);
          return settersAccumulator;
        }, {});
      }

      createSetFontSize(fontSizeAttributeName, customFontSizeAttributeName) {
        return fontSizeValue => {
          const fontSizeObject = Object(external_lodash_["find"])(this.props.fontSizes, {
            size: Number(fontSizeValue)
          });
          this.props.setAttributes({
            [fontSizeAttributeName]: fontSizeObject && fontSizeObject.slug ? fontSizeObject.slug : undefined,
            [customFontSizeAttributeName]: fontSizeObject && fontSizeObject.slug ? undefined : fontSizeValue
          });
        };
      }

      static getDerivedStateFromProps(_ref, previousState) {
        let {
          attributes,
          fontSizes
        } = _ref;

        const didAttributesChange = (customFontSizeAttributeName, fontSizeAttributeName) => {
          if (previousState[fontSizeAttributeName]) {
            // if new font size is name compare with the previous slug
            if (attributes[fontSizeAttributeName]) {
              return attributes[fontSizeAttributeName] !== previousState[fontSizeAttributeName].slug;
            } // if font size is not named, update when the font size value changes.


            return previousState[fontSizeAttributeName].size !== attributes[customFontSizeAttributeName];
          } // in this case we need to build the font size object


          return true;
        };

        if (!Object(external_lodash_["some"])(fontSizeAttributeNames, didAttributesChange)) {
          return null;
        }

        const newState = Object(external_lodash_["reduce"])(Object(external_lodash_["pickBy"])(fontSizeAttributeNames, didAttributesChange), (newStateAccumulator, customFontSizeAttributeName, fontSizeAttributeName) => {
          const fontSizeAttributeValue = attributes[fontSizeAttributeName];
          const fontSizeObject = Object(utils["a" /* getFontSize */])(fontSizes, fontSizeAttributeValue, attributes[customFontSizeAttributeName]);
          newStateAccumulator[fontSizeAttributeName] = { ...fontSizeObject,
            class: Object(utils["b" /* getFontSizeClass */])(fontSizeAttributeValue)
          };
          return newStateAccumulator;
        }, {});
        return { ...previousState,
          ...newState
        };
      }

      render() {
        return Object(external_wp_element_["createElement"])(WrappedComponent, Object(esm_extends["a" /* default */])({}, this.props, {
          fontSizes: undefined
        }, this.state, this.setters));
      }

    };
  }]), 'withFontSizes');
});

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/font-sizes/index.js





/***/ }),

/***/ "AHN3":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return STORE_NAME; });
const STORE_NAME = 'core/block-editor';


/***/ }),

/***/ "AORF":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("YLtl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("HSyU");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_a11y__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("gdqT");
/* harmony import */ var _wordpress_a11y__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_a11y__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("BhPs");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */


/**
 * @typedef WPInserterConfig
 *
 * @property {string=}   rootClientId   If set, insertion will be into the
 *                                      block with this ID.
 * @property {number=}   insertionIndex If set, insertion will be into this
 *                                      explicit position.
 * @property {string=}   clientId       If set, insertion will be after the
 *                                      block with this ID.
 * @property {boolean=}  isAppender     Whether the inserter is an appender
 *                                      or not.
 * @property {Function=} onSelect       Called after insertion.
 */

/**
 * Returns the insertion point state given the inserter config.
 *
 * @param {WPInserterConfig} config Inserter Config.
 * @return {Array} Insertion Point State (rootClientID, onInsertBlocks and onToggle).
 */

function useInsertionPoint(_ref) {
  let {
    rootClientId = '',
    insertionIndex,
    clientId,
    isAppender,
    onSelect,
    shouldFocusBlock = true
  } = _ref;
  const {
    getSelectedBlock
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["useSelect"])(_store__WEBPACK_IMPORTED_MODULE_6__[/* store */ "a"]);
  const {
    destinationRootClientId,
    destinationIndex
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["useSelect"])(select => {
    const {
      getSelectedBlockClientId,
      getBlockRootClientId,
      getBlockIndex,
      getBlockOrder
    } = select(_store__WEBPACK_IMPORTED_MODULE_6__[/* store */ "a"]);
    const selectedBlockClientId = getSelectedBlockClientId();
    let _destinationRootClientId = rootClientId;

    let _destinationIndex;

    if (insertionIndex !== undefined) {
      // Insert into a specific index.
      _destinationIndex = insertionIndex;
    } else if (clientId) {
      // Insert after a specific client ID.
      _destinationIndex = getBlockIndex(clientId);
    } else if (!isAppender && selectedBlockClientId) {
      _destinationRootClientId = getBlockRootClientId(selectedBlockClientId);
      _destinationIndex = getBlockIndex(selectedBlockClientId) + 1;
    } else {
      // Insert at the end of the list.
      _destinationIndex = getBlockOrder(_destinationRootClientId).length;
    }

    return {
      destinationRootClientId: _destinationRootClientId,
      destinationIndex: _destinationIndex
    };
  }, [rootClientId, insertionIndex, clientId, isAppender]);
  const {
    replaceBlocks,
    insertBlocks,
    showInsertionPoint,
    hideInsertionPoint
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["useDispatch"])(_store__WEBPACK_IMPORTED_MODULE_6__[/* store */ "a"]);
  const onInsertBlocks = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["useCallback"])(function (blocks, meta) {
    let shouldForceFocusBlock = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    const selectedBlock = getSelectedBlock();

    if (!isAppender && selectedBlock && Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__["isUnmodifiedDefaultBlock"])(selectedBlock)) {
      replaceBlocks(selectedBlock.clientId, blocks, null, shouldFocusBlock || shouldForceFocusBlock ? 0 : null, meta);
    } else {
      insertBlocks(blocks, destinationIndex, destinationRootClientId, true, shouldFocusBlock || shouldForceFocusBlock ? 0 : null, meta);
    }

    const message = Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__["sprintf"])( // translators: %d: the name of the block that has been added
    Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__["_n"])('%d block added.', '%d blocks added.', Object(lodash__WEBPACK_IMPORTED_MODULE_0__["castArray"])(blocks).length), Object(lodash__WEBPACK_IMPORTED_MODULE_0__["castArray"])(blocks).length);
    Object(_wordpress_a11y__WEBPACK_IMPORTED_MODULE_4__["speak"])(message);

    if (onSelect) {
      onSelect();
    }
  }, [isAppender, getSelectedBlock, replaceBlocks, insertBlocks, destinationRootClientId, destinationIndex, onSelect, shouldFocusBlock]);
  const onToggleInsertionPoint = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_5__["useCallback"])(show => {
    if (show) {
      showInsertionPoint(destinationRootClientId, destinationIndex);
    } else {
      hideInsertionPoint();
    }
  }, [showInsertionPoint, hideInsertionPoint, destinationRootClientId, destinationIndex]);
  return [destinationRootClientId, onInsertBlocks, onToggleInsertionPoint];
}

/* harmony default export */ __webpack_exports__["a"] = (useInsertionPoint);


/***/ }),

/***/ "B9Az":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external ["wp","primitives"]
var external_wp_primitives_ = __webpack_require__("Tqx9");

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/pencil.js


/**
 * WordPress dependencies
 */

const pencil = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  d: "M20.1 5.1L16.9 2 6.2 12.7l-1.3 4.4 4.5-1.3L20.1 5.1zM4 20.8h8v-1.5H4v1.5z"
}));
/* harmony default export */ var library_pencil = (pencil);

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/edit.js
/**
 * Internal dependencies
 */

/* harmony default export */ var edit = __webpack_exports__["a"] = (library_pencil);


/***/ }),

/***/ "BCrt":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "c", function() { return /* reexport */ transform_styles["a" /* default */]; });
__webpack_require__.d(__webpack_exports__, "d", function() { return /* reexport */ validateThemeColors; });
__webpack_require__.d(__webpack_exports__, "e", function() { return /* reexport */ validateThemeGradients; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* reexport */ block_variation_transforms["a" /* __experimentalGetMatchingVariation */]; });
__webpack_require__.d(__webpack_exports__, "b", function() { return /* reexport */ parse_css_unit_to_px; });

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/transform-styles/index.js + 8 modules
var transform_styles = __webpack_require__("vSu0");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/defaults.js
var defaults = __webpack_require__("lJLt");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/theme.js
/**
 * Internal dependencies
 */

/**
 * Given an array of theme colors checks colors for validity
 *
 * @param {Array} colors The array of theme colors
 *
 * @return {Array} The array of valid theme colors or the default colors
 */

function validateThemeColors(colors) {
  if (colors === undefined) {
    colors = defaults["b" /* SETTINGS_DEFAULTS */].colors;
  } else {
    const validColors = colors.filter(c => c.color);

    if (validColors.length === 0) {
      colors = defaults["b" /* SETTINGS_DEFAULTS */].colors;
    } else if (validColors.length < colors.length) {
      // Filter out invalid colors
      colors = validColors;
    }
  }

  return colors;
}
/**
 * Given an array of theme gradients checks gradients for validity
 *
 * @param {Array} gradients The array of theme gradients
 *
 * @return {Array} The array of valid theme gradients or the default gradients
 */

function validateThemeGradients(gradients) {
  if (gradients === undefined) {
    gradients = defaults["b" /* SETTINGS_DEFAULTS */].gradients;
  } else {
    const validGradients = gradients.filter(c => c.gradient);

    if (validGradients.length === 0) {
      gradients = defaults["b" /* SETTINGS_DEFAULTS */].gradients;
    } else if (validGradients.length < gradients.length) {
      // Filter out invalid gradients
      gradients = validGradients;
    }
  }

  return gradients;
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/block-variation-transforms.js
var block_variation_transforms = __webpack_require__("Btt3");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/parse-css-unit-to-px.js
/**
 * Converts string to object { value, unit }.
 *
 * @param {string} cssUnit
 * @return {Object} parsedUnit
 */
function parseUnit(cssUnit) {
  const match = cssUnit === null || cssUnit === void 0 ? void 0 : cssUnit.trim().match(/^(0?[-.]?\d+)(r?e[m|x]|v[h|w|min|max]+|p[x|t|c]|[c|m]m|%|in|ch|Q|lh)$/);

  if (!isNaN(cssUnit) && !isNaN(parseFloat(cssUnit))) {
    return {
      value: parseFloat(cssUnit),
      unit: 'px'
    };
  }

  return match ? {
    value: parseFloat(match[1]) || match[1],
    unit: match[2]
  } : {
    value: cssUnit,
    unit: undefined
  };
}
/**
 * Evaluate a math expression.
 *
 * @param {string} expression
 * @return {number} evaluated expression.
 */


function calculate(expression) {
  return Function(`'use strict'; return (${expression})`)();
}
/**
 * Calculates the css function value for the supported css functions such as max, min, clamp and calc.
 *
 * @param {string} functionUnitValue string should be in a particular format (for example min(12px,12px) ) no nested loops.
 * @param {Object} options
 * @return {string} unit containing the unit in PX.
 */


function getFunctionUnitValue(functionUnitValue, options) {
  const functionUnit = functionUnitValue.split(/[(),]/g).filter(Boolean);
  const units = functionUnit.slice(1).map(unit => parseUnit(getPxFromCssUnit(unit, options)).value).filter(Boolean);

  switch (functionUnit[0]) {
    case 'min':
      return Math.min(...units) + 'px';

    case 'max':
      return Math.max(...units) + 'px';

    case 'clamp':
      if (units.length !== 3) {
        return null;
      }

      if (units[1] < units[0]) {
        return units[0] + 'px';
      }

      if (units[1] > units[2]) {
        return units[2] + 'px';
      }

      return units[1] + 'px';

    case 'calc':
      return units[0] + 'px';
  }
}
/**
 * Take a css function such as min, max, calc, clamp and returns parsedUnit
 *
 * How this works for the nested function is that it first replaces the inner function call.
 * Then it tackles the outer onces.
 * So for example: min( max(25px, 35px), 40px )
 * in the first pass we would replace max(25px, 35px) with 35px.
 * then we would try to evaluate min( 35px, 40px )
 * and then finally return 35px.
 *
 * @param {string} cssUnit
 * @return {Object} parsedUnit object.
 */


function parseUnitFunction(cssUnit) {
  while (true) {
    const currentCssUnit = cssUnit;
    const regExp = /(max|min|calc|clamp)\(([^()]*)\)/g;
    const matches = regExp.exec(cssUnit) || [];

    if (matches[0]) {
      const functionUnitValue = getFunctionUnitValue(matches[0]);
      cssUnit = cssUnit.replace(matches[0], functionUnitValue);
    } // if the unit hasn't been modified or we have a single value break free.


    if (cssUnit === currentCssUnit || parseFloat(cssUnit)) {
      break;
    }
  }

  return parseUnit(cssUnit);
}
/**
 * Return true if we think this is a math expression.
 *
 * @param {string} cssUnit the cssUnit value being evaluted.
 * @return {boolean} Whether the cssUnit is a math expression.
 */


function isMathExpression(cssUnit) {
  for (let i = 0; i < cssUnit.length; i++) {
    if (['+', '-', '/', '*'].includes(cssUnit[i])) {
      return true;
    }
  }

  return false;
}
/**
 * Evaluates the math expression and return a px value.
 *
 * @param {string} cssUnit the cssUnit value being evaluted.
 * @return {string} return a converfted value to px.
 */


function evalMathExpression(cssUnit) {
  let errorFound = false; // Convert every part of the expression to px values.

  const cssUnitsBits = cssUnit.split(/[+-/*/]/g).filter(Boolean);

  for (const unit of cssUnitsBits) {
    // Standardize the unit to px and extract the value.
    const parsedUnit = parseUnit(getPxFromCssUnit(unit));

    if (!parseFloat(parsedUnit.value)) {
      errorFound = true; // end early since we are dealing with a null value.

      break;
    }

    cssUnit = cssUnit.replace(unit, parsedUnit.value);
  }

  return errorFound ? null : calculate(cssUnit).toFixed(0) + 'px';
}
/**
 * Convert a parsedUnit object to px value.
 *
 * @param {Object} parsedUnit
 * @param {Object} options
 * @return {string} or {null} returns the converted with in a px value format.
 */


function convertParsedUnitToPx(parsedUnit, options) {
  const PIXELS_PER_INCH = 96;
  const ONE_PERCENT = 0.01;
  const defaultProperties = {
    fontSize: 16,
    lineHeight: 16,
    width: 375,
    height: 812,
    type: 'font'
  };
  const setOptions = Object.assign({}, defaultProperties, options);
  const relativeUnits = {
    em: setOptions.fontSize,
    rem: setOptions.fontSize,
    vh: setOptions.height * ONE_PERCENT,
    vw: setOptions.width * ONE_PERCENT,
    vmin: (setOptions.width < setOptions.height ? setOptions.width : setOptions.height) * ONE_PERCENT,
    vmax: (setOptions.width > setOptions.height ? setOptions.width : setOptions.height) * ONE_PERCENT,
    '%': (setOptions.type === 'font' ? setOptions.fontSize : setOptions.width) * ONE_PERCENT,
    ch: 8,
    // The advance measure (width) of the glyph "0" of the element's font. Approximate
    ex: 7.15625,
    // x-height of the element's font. Approximate
    lh: setOptions.lineHeight
  };
  const absoluteUnits = {
    in: PIXELS_PER_INCH,
    cm: PIXELS_PER_INCH / 2.54,
    mm: PIXELS_PER_INCH / 25.4,
    pt: PIXELS_PER_INCH / 72,
    pc: PIXELS_PER_INCH / 6,
    px: 1,
    Q: PIXELS_PER_INCH / 2.54 / 40
  };

  if (relativeUnits[parsedUnit.unit]) {
    return (relativeUnits[parsedUnit.unit] * parsedUnit.value).toFixed(0) + 'px';
  }

  if (absoluteUnits[parsedUnit.unit]) {
    return (absoluteUnits[parsedUnit.unit] * parsedUnit.value).toFixed(0) + 'px';
  }

  return null;
}
/**
 * Returns the px value of a cssUnit.
 *
 * @param {string} cssUnit
 * @param {Object} options
 * @return {string} returns the cssUnit value in a simple px format.
 */


function getPxFromCssUnit(cssUnit) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  if (Number.isFinite(cssUnit)) {
    return cssUnit.toFixed(0) + 'px';
  }

  if (cssUnit === undefined) {
    return null;
  }

  let parsedUnit = parseUnit(cssUnit);

  if (!parsedUnit.unit) {
    parsedUnit = parseUnitFunction(cssUnit, options);
  }

  if (isMathExpression(cssUnit) && !parsedUnit.unit) {
    return evalMathExpression(cssUnit);
  }

  return convertParsedUnitToPx(parsedUnit, options);
} // Use simple cache.

const cache = {};
/**
 * Returns the px value of a cssUnit. The memoized version of getPxFromCssUnit;
 *
 * @param {string} cssUnit
 * @param {Object} options
 * @return {string} returns the cssUnit value in a simple px format.
 */

function memoizedGetPxFromCssUnit(cssUnit) {
  let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  const hash = cssUnit + hashOptions(options);

  if (!cache[hash]) {
    cache[hash] = getPxFromCssUnit(cssUnit, options);
  }

  return cache[hash];
}

function hashOptions(options) {
  let hash = '';

  if (options.hasOwnProperty('fontSize')) {
    hash = ':' + options.width;
  }

  if (options.hasOwnProperty('lineHeight')) {
    hash = ':' + options.lineHeight;
  }

  if (options.hasOwnProperty('width')) {
    hash = ':' + options.width;
  }

  if (options.hasOwnProperty('height')) {
    hash = ':' + options.height;
  }

  if (options.hasOwnProperty('type')) {
    hash = ':' + options.type;
  }

  return hash;
}

/* harmony default export */ var parse_css_unit_to_px = (memoizedGetPxFromCssUnit);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/index.js






/***/ }),

/***/ "BLeD":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["tokenList"]; }());

/***/ }),

/***/ "BhPs":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ storeConfig; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ store; });

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/selectors.js
var selectors_namespaceObject = {};
__webpack_require__.r(selectors_namespaceObject);
__webpack_require__.d(selectors_namespaceObject, "getBlockName", function() { return getBlockName; });
__webpack_require__.d(selectors_namespaceObject, "isBlockValid", function() { return isBlockValid; });
__webpack_require__.d(selectors_namespaceObject, "getBlockAttributes", function() { return getBlockAttributes; });
__webpack_require__.d(selectors_namespaceObject, "getBlock", function() { return getBlock; });
__webpack_require__.d(selectors_namespaceObject, "__unstableGetBlockWithoutInnerBlocks", function() { return __unstableGetBlockWithoutInnerBlocks; });
__webpack_require__.d(selectors_namespaceObject, "getBlocks", function() { return getBlocks; });
__webpack_require__.d(selectors_namespaceObject, "__unstableGetClientIdWithClientIdsTree", function() { return __unstableGetClientIdWithClientIdsTree; });
__webpack_require__.d(selectors_namespaceObject, "__unstableGetClientIdsTree", function() { return __unstableGetClientIdsTree; });
__webpack_require__.d(selectors_namespaceObject, "getClientIdsOfDescendants", function() { return getClientIdsOfDescendants; });
__webpack_require__.d(selectors_namespaceObject, "getClientIdsWithDescendants", function() { return getClientIdsWithDescendants; });
__webpack_require__.d(selectors_namespaceObject, "getGlobalBlockCount", function() { return getGlobalBlockCount; });
__webpack_require__.d(selectors_namespaceObject, "getBlocksByClientId", function() { return getBlocksByClientId; });
__webpack_require__.d(selectors_namespaceObject, "getBlockCount", function() { return getBlockCount; });
__webpack_require__.d(selectors_namespaceObject, "getSelectionStart", function() { return getSelectionStart; });
__webpack_require__.d(selectors_namespaceObject, "getSelectionEnd", function() { return getSelectionEnd; });
__webpack_require__.d(selectors_namespaceObject, "getBlockSelectionStart", function() { return getBlockSelectionStart; });
__webpack_require__.d(selectors_namespaceObject, "getBlockSelectionEnd", function() { return getBlockSelectionEnd; });
__webpack_require__.d(selectors_namespaceObject, "getSelectedBlockCount", function() { return getSelectedBlockCount; });
__webpack_require__.d(selectors_namespaceObject, "hasSelectedBlock", function() { return hasSelectedBlock; });
__webpack_require__.d(selectors_namespaceObject, "getSelectedBlockClientId", function() { return getSelectedBlockClientId; });
__webpack_require__.d(selectors_namespaceObject, "getSelectedBlock", function() { return getSelectedBlock; });
__webpack_require__.d(selectors_namespaceObject, "getBlockRootClientId", function() { return getBlockRootClientId; });
__webpack_require__.d(selectors_namespaceObject, "getBlockParents", function() { return getBlockParents; });
__webpack_require__.d(selectors_namespaceObject, "getBlockParentsByBlockName", function() { return getBlockParentsByBlockName; });
__webpack_require__.d(selectors_namespaceObject, "getBlockHierarchyRootClientId", function() { return getBlockHierarchyRootClientId; });
__webpack_require__.d(selectors_namespaceObject, "getLowestCommonAncestorWithSelectedBlock", function() { return getLowestCommonAncestorWithSelectedBlock; });
__webpack_require__.d(selectors_namespaceObject, "getAdjacentBlockClientId", function() { return getAdjacentBlockClientId; });
__webpack_require__.d(selectors_namespaceObject, "getPreviousBlockClientId", function() { return getPreviousBlockClientId; });
__webpack_require__.d(selectors_namespaceObject, "getNextBlockClientId", function() { return getNextBlockClientId; });
__webpack_require__.d(selectors_namespaceObject, "getSelectedBlocksInitialCaretPosition", function() { return getSelectedBlocksInitialCaretPosition; });
__webpack_require__.d(selectors_namespaceObject, "getSelectedBlockClientIds", function() { return getSelectedBlockClientIds; });
__webpack_require__.d(selectors_namespaceObject, "getMultiSelectedBlockClientIds", function() { return getMultiSelectedBlockClientIds; });
__webpack_require__.d(selectors_namespaceObject, "getMultiSelectedBlocks", function() { return getMultiSelectedBlocks; });
__webpack_require__.d(selectors_namespaceObject, "getFirstMultiSelectedBlockClientId", function() { return getFirstMultiSelectedBlockClientId; });
__webpack_require__.d(selectors_namespaceObject, "getLastMultiSelectedBlockClientId", function() { return getLastMultiSelectedBlockClientId; });
__webpack_require__.d(selectors_namespaceObject, "isFirstMultiSelectedBlock", function() { return isFirstMultiSelectedBlock; });
__webpack_require__.d(selectors_namespaceObject, "isBlockMultiSelected", function() { return isBlockMultiSelected; });
__webpack_require__.d(selectors_namespaceObject, "isAncestorMultiSelected", function() { return isAncestorMultiSelected; });
__webpack_require__.d(selectors_namespaceObject, "getMultiSelectedBlocksStartClientId", function() { return getMultiSelectedBlocksStartClientId; });
__webpack_require__.d(selectors_namespaceObject, "getMultiSelectedBlocksEndClientId", function() { return getMultiSelectedBlocksEndClientId; });
__webpack_require__.d(selectors_namespaceObject, "getBlockOrder", function() { return getBlockOrder; });
__webpack_require__.d(selectors_namespaceObject, "getBlockIndex", function() { return getBlockIndex; });
__webpack_require__.d(selectors_namespaceObject, "isBlockSelected", function() { return isBlockSelected; });
__webpack_require__.d(selectors_namespaceObject, "hasSelectedInnerBlock", function() { return hasSelectedInnerBlock; });
__webpack_require__.d(selectors_namespaceObject, "isBlockWithinSelection", function() { return isBlockWithinSelection; });
__webpack_require__.d(selectors_namespaceObject, "hasMultiSelection", function() { return hasMultiSelection; });
__webpack_require__.d(selectors_namespaceObject, "isMultiSelecting", function() { return selectors_isMultiSelecting; });
__webpack_require__.d(selectors_namespaceObject, "isSelectionEnabled", function() { return selectors_isSelectionEnabled; });
__webpack_require__.d(selectors_namespaceObject, "getBlockMode", function() { return getBlockMode; });
__webpack_require__.d(selectors_namespaceObject, "isTyping", function() { return selectors_isTyping; });
__webpack_require__.d(selectors_namespaceObject, "isDraggingBlocks", function() { return isDraggingBlocks; });
__webpack_require__.d(selectors_namespaceObject, "getDraggedBlockClientIds", function() { return getDraggedBlockClientIds; });
__webpack_require__.d(selectors_namespaceObject, "isBlockBeingDragged", function() { return isBlockBeingDragged; });
__webpack_require__.d(selectors_namespaceObject, "isAncestorBeingDragged", function() { return isAncestorBeingDragged; });
__webpack_require__.d(selectors_namespaceObject, "isCaretWithinFormattedText", function() { return selectors_isCaretWithinFormattedText; });
__webpack_require__.d(selectors_namespaceObject, "getBlockInsertionPoint", function() { return getBlockInsertionPoint; });
__webpack_require__.d(selectors_namespaceObject, "isBlockInsertionPointVisible", function() { return isBlockInsertionPointVisible; });
__webpack_require__.d(selectors_namespaceObject, "isValidTemplate", function() { return selectors_isValidTemplate; });
__webpack_require__.d(selectors_namespaceObject, "getTemplate", function() { return getTemplate; });
__webpack_require__.d(selectors_namespaceObject, "getTemplateLock", function() { return getTemplateLock; });
__webpack_require__.d(selectors_namespaceObject, "canInsertBlockType", function() { return canInsertBlockType; });
__webpack_require__.d(selectors_namespaceObject, "canInsertBlocks", function() { return canInsertBlocks; });
__webpack_require__.d(selectors_namespaceObject, "canRemoveBlock", function() { return canRemoveBlock; });
__webpack_require__.d(selectors_namespaceObject, "canRemoveBlocks", function() { return selectors_canRemoveBlocks; });
__webpack_require__.d(selectors_namespaceObject, "canMoveBlock", function() { return canMoveBlock; });
__webpack_require__.d(selectors_namespaceObject, "canMoveBlocks", function() { return selectors_canMoveBlocks; });
__webpack_require__.d(selectors_namespaceObject, "getInserterItems", function() { return getInserterItems; });
__webpack_require__.d(selectors_namespaceObject, "getBlockTransformItems", function() { return getBlockTransformItems; });
__webpack_require__.d(selectors_namespaceObject, "hasInserterItems", function() { return hasInserterItems; });
__webpack_require__.d(selectors_namespaceObject, "__experimentalGetAllowedBlocks", function() { return __experimentalGetAllowedBlocks; });
__webpack_require__.d(selectors_namespaceObject, "__experimentalGetDirectInsertBlock", function() { return __experimentalGetDirectInsertBlock; });
__webpack_require__.d(selectors_namespaceObject, "__experimentalGetParsedPattern", function() { return __experimentalGetParsedPattern; });
__webpack_require__.d(selectors_namespaceObject, "__experimentalGetAllowedPatterns", function() { return __experimentalGetAllowedPatterns; });
__webpack_require__.d(selectors_namespaceObject, "__experimentalGetPatternsByBlockTypes", function() { return __experimentalGetPatternsByBlockTypes; });
__webpack_require__.d(selectors_namespaceObject, "__experimentalGetPatternTransformItems", function() { return __experimentalGetPatternTransformItems; });
__webpack_require__.d(selectors_namespaceObject, "getBlockListSettings", function() { return getBlockListSettings; });
__webpack_require__.d(selectors_namespaceObject, "getSettings", function() { return getSettings; });
__webpack_require__.d(selectors_namespaceObject, "isLastBlockChangePersistent", function() { return isLastBlockChangePersistent; });
__webpack_require__.d(selectors_namespaceObject, "__experimentalGetBlockListSettingsForBlocks", function() { return __experimentalGetBlockListSettingsForBlocks; });
__webpack_require__.d(selectors_namespaceObject, "__experimentalGetReusableBlockTitle", function() { return __experimentalGetReusableBlockTitle; });
__webpack_require__.d(selectors_namespaceObject, "__unstableIsLastBlockChangeIgnored", function() { return __unstableIsLastBlockChangeIgnored; });
__webpack_require__.d(selectors_namespaceObject, "__experimentalGetLastBlockAttributeChanges", function() { return __experimentalGetLastBlockAttributeChanges; });
__webpack_require__.d(selectors_namespaceObject, "isNavigationMode", function() { return selectors_isNavigationMode; });
__webpack_require__.d(selectors_namespaceObject, "hasBlockMovingClientId", function() { return selectors_hasBlockMovingClientId; });
__webpack_require__.d(selectors_namespaceObject, "didAutomaticChange", function() { return didAutomaticChange; });
__webpack_require__.d(selectors_namespaceObject, "isBlockHighlighted", function() { return isBlockHighlighted; });
__webpack_require__.d(selectors_namespaceObject, "areInnerBlocksControlled", function() { return areInnerBlocksControlled; });
__webpack_require__.d(selectors_namespaceObject, "__experimentalGetActiveBlockIdByBlockNames", function() { return __experimentalGetActiveBlockIdByBlockNames; });
__webpack_require__.d(selectors_namespaceObject, "wasBlockJustInserted", function() { return wasBlockJustInserted; });

// NAMESPACE OBJECT: ./node_modules/@wordpress/block-editor/build-module/store/actions.js
var actions_namespaceObject = {};
__webpack_require__.r(actions_namespaceObject);
__webpack_require__.d(actions_namespaceObject, "resetBlocks", function() { return resetBlocks; });
__webpack_require__.d(actions_namespaceObject, "validateBlocksToTemplate", function() { return validateBlocksToTemplate; });
__webpack_require__.d(actions_namespaceObject, "resetSelection", function() { return resetSelection; });
__webpack_require__.d(actions_namespaceObject, "receiveBlocks", function() { return receiveBlocks; });
__webpack_require__.d(actions_namespaceObject, "updateBlockAttributes", function() { return updateBlockAttributes; });
__webpack_require__.d(actions_namespaceObject, "updateBlock", function() { return updateBlock; });
__webpack_require__.d(actions_namespaceObject, "selectBlock", function() { return selectBlock; });
__webpack_require__.d(actions_namespaceObject, "selectPreviousBlock", function() { return selectPreviousBlock; });
__webpack_require__.d(actions_namespaceObject, "selectNextBlock", function() { return selectNextBlock; });
__webpack_require__.d(actions_namespaceObject, "startMultiSelect", function() { return startMultiSelect; });
__webpack_require__.d(actions_namespaceObject, "stopMultiSelect", function() { return stopMultiSelect; });
__webpack_require__.d(actions_namespaceObject, "multiSelect", function() { return multiSelect; });
__webpack_require__.d(actions_namespaceObject, "clearSelectedBlock", function() { return clearSelectedBlock; });
__webpack_require__.d(actions_namespaceObject, "toggleSelection", function() { return toggleSelection; });
__webpack_require__.d(actions_namespaceObject, "replaceBlocks", function() { return replaceBlocks; });
__webpack_require__.d(actions_namespaceObject, "replaceBlock", function() { return replaceBlock; });
__webpack_require__.d(actions_namespaceObject, "moveBlocksDown", function() { return moveBlocksDown; });
__webpack_require__.d(actions_namespaceObject, "moveBlocksUp", function() { return moveBlocksUp; });
__webpack_require__.d(actions_namespaceObject, "moveBlocksToPosition", function() { return moveBlocksToPosition; });
__webpack_require__.d(actions_namespaceObject, "moveBlockToPosition", function() { return moveBlockToPosition; });
__webpack_require__.d(actions_namespaceObject, "insertBlock", function() { return insertBlock; });
__webpack_require__.d(actions_namespaceObject, "insertBlocks", function() { return insertBlocks; });
__webpack_require__.d(actions_namespaceObject, "showInsertionPoint", function() { return showInsertionPoint; });
__webpack_require__.d(actions_namespaceObject, "hideInsertionPoint", function() { return hideInsertionPoint; });
__webpack_require__.d(actions_namespaceObject, "setTemplateValidity", function() { return setTemplateValidity; });
__webpack_require__.d(actions_namespaceObject, "synchronizeTemplate", function() { return synchronizeTemplate; });
__webpack_require__.d(actions_namespaceObject, "mergeBlocks", function() { return mergeBlocks; });
__webpack_require__.d(actions_namespaceObject, "removeBlocks", function() { return removeBlocks; });
__webpack_require__.d(actions_namespaceObject, "removeBlock", function() { return removeBlock; });
__webpack_require__.d(actions_namespaceObject, "replaceInnerBlocks", function() { return replaceInnerBlocks; });
__webpack_require__.d(actions_namespaceObject, "toggleBlockMode", function() { return toggleBlockMode; });
__webpack_require__.d(actions_namespaceObject, "startTyping", function() { return startTyping; });
__webpack_require__.d(actions_namespaceObject, "stopTyping", function() { return stopTyping; });
__webpack_require__.d(actions_namespaceObject, "startDraggingBlocks", function() { return startDraggingBlocks; });
__webpack_require__.d(actions_namespaceObject, "stopDraggingBlocks", function() { return stopDraggingBlocks; });
__webpack_require__.d(actions_namespaceObject, "enterFormattedText", function() { return enterFormattedText; });
__webpack_require__.d(actions_namespaceObject, "exitFormattedText", function() { return exitFormattedText; });
__webpack_require__.d(actions_namespaceObject, "selectionChange", function() { return selectionChange; });
__webpack_require__.d(actions_namespaceObject, "insertDefaultBlock", function() { return insertDefaultBlock; });
__webpack_require__.d(actions_namespaceObject, "updateBlockListSettings", function() { return updateBlockListSettings; });
__webpack_require__.d(actions_namespaceObject, "updateSettings", function() { return updateSettings; });
__webpack_require__.d(actions_namespaceObject, "__unstableSaveReusableBlock", function() { return __unstableSaveReusableBlock; });
__webpack_require__.d(actions_namespaceObject, "__unstableMarkLastChangeAsPersistent", function() { return __unstableMarkLastChangeAsPersistent; });
__webpack_require__.d(actions_namespaceObject, "__unstableMarkNextChangeAsNotPersistent", function() { return __unstableMarkNextChangeAsNotPersistent; });
__webpack_require__.d(actions_namespaceObject, "__unstableMarkAutomaticChange", function() { return __unstableMarkAutomaticChange; });
__webpack_require__.d(actions_namespaceObject, "setNavigationMode", function() { return setNavigationMode; });
__webpack_require__.d(actions_namespaceObject, "setBlockMovingClientId", function() { return setBlockMovingClientId; });
__webpack_require__.d(actions_namespaceObject, "duplicateBlocks", function() { return duplicateBlocks; });
__webpack_require__.d(actions_namespaceObject, "insertBeforeBlock", function() { return insertBeforeBlock; });
__webpack_require__.d(actions_namespaceObject, "insertAfterBlock", function() { return insertAfterBlock; });
__webpack_require__.d(actions_namespaceObject, "toggleBlockHighlight", function() { return toggleBlockHighlight; });
__webpack_require__.d(actions_namespaceObject, "flashBlock", function() { return flashBlock; });
__webpack_require__.d(actions_namespaceObject, "setHasControlledInnerBlocks", function() { return setHasControlledInnerBlocks; });

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: external ["wp","blocks"]
var external_wp_blocks_ = __webpack_require__("HSyU");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/defaults.js
var defaults = __webpack_require__("lJLt");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/array.js
/**
 * External dependencies
 */

/**
 * Insert one or multiple elements into a given position of an array.
 *
 * @param {Array}  array    Source array.
 * @param {*}      elements Elements to insert.
 * @param {number} index    Insert Position.
 *
 * @return {Array} Result.
 */

function insertAt(array, elements, index) {
  return [...array.slice(0, index), ...Object(external_lodash_["castArray"])(elements), ...array.slice(index)];
}
/**
 * Moves an element in an array.
 *
 * @param {Array}  array Source array.
 * @param {number} from  Source index.
 * @param {number} to    Destination index.
 * @param {number} count Number of elements to move.
 *
 * @return {Array} Result.
 */

function moveTo(array, from, to) {
  let count = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
  const withoutMovedElements = [...array];
  withoutMovedElements.splice(from, count);
  return insertAt(withoutMovedElements, array.slice(from, from + count), to);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/reducer.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/**
 * Given an array of blocks, returns an object where each key is a nesting
 * context, the value of which is an array of block client IDs existing within
 * that nesting context.
 *
 * @param {Array}   blocks       Blocks to map.
 * @param {?string} rootClientId Assumed root client ID.
 *
 * @return {Object} Block order map object.
 */

function mapBlockOrder(blocks) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  const result = {
    [rootClientId]: []
  };
  blocks.forEach(block => {
    const {
      clientId,
      innerBlocks
    } = block;
    result[rootClientId].push(clientId);
    Object.assign(result, mapBlockOrder(innerBlocks, clientId));
  });
  return result;
}
/**
 * Given an array of blocks, returns an object where each key contains
 * the clientId of the block and the value is the parent of the block.
 *
 * @param {Array}   blocks       Blocks to map.
 * @param {?string} rootClientId Assumed root client ID.
 *
 * @return {Object} Block order map object.
 */


function mapBlockParents(blocks) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  return blocks.reduce((result, block) => Object.assign(result, {
    [block.clientId]: rootClientId
  }, mapBlockParents(block.innerBlocks, block.clientId)), {});
}
/**
 * Helper method to iterate through all blocks, recursing into inner blocks,
 * applying a transformation function to each one.
 * Returns a flattened object with the transformed blocks.
 *
 * @param {Array}    blocks    Blocks to flatten.
 * @param {Function} transform Transforming function to be applied to each block.
 *
 * @return {Object} Flattened object.
 */


function flattenBlocks(blocks) {
  let transform = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : external_lodash_["identity"];
  const result = {};
  const stack = [...blocks];

  while (stack.length) {
    const {
      innerBlocks,
      ...block
    } = stack.shift();
    stack.push(...innerBlocks);
    result[block.clientId] = transform(block);
  }

  return result;
}
/**
 * Given an array of blocks, returns an object containing all blocks, without
 * attributes, recursing into inner blocks. Keys correspond to the block client
 * ID, the value of which is the attributes object.
 *
 * @param {Array} blocks Blocks to flatten.
 *
 * @return {Object} Flattened block attributes object.
 */


function getFlattenedBlocksWithoutAttributes(blocks) {
  return flattenBlocks(blocks, block => Object(external_lodash_["omit"])(block, 'attributes'));
}
/**
 * Given an array of blocks, returns an object containing all block attributes,
 * recursing into inner blocks. Keys correspond to the block client ID, the
 * value of which is the attributes object.
 *
 * @param {Array} blocks Blocks to flatten.
 *
 * @return {Object} Flattened block attributes object.
 */


function getFlattenedBlockAttributes(blocks) {
  return flattenBlocks(blocks, block => block.attributes);
}
/**
 * Returns an object against which it is safe to perform mutating operations,
 * given the original object and its current working copy.
 *
 * @param {Object} original Original object.
 * @param {Object} working  Working object.
 *
 * @return {Object} Mutation-safe object.
 */


function getMutateSafeObject(original, working) {
  if (original === working) {
    return { ...original
    };
  }

  return working;
}
/**
 * Returns true if the two object arguments have the same keys, or false
 * otherwise.
 *
 * @param {Object} a First object.
 * @param {Object} b Second object.
 *
 * @return {boolean} Whether the two objects have the same keys.
 */


function hasSameKeys(a, b) {
  return Object(external_lodash_["isEqual"])(Object(external_lodash_["keys"])(a), Object(external_lodash_["keys"])(b));
}
/**
 * Returns true if, given the currently dispatching action and the previously
 * dispatched action, the two actions are updating the same block attribute, or
 * false otherwise.
 *
 * @param {Object} action     Currently dispatching action.
 * @param {Object} lastAction Previously dispatched action.
 *
 * @return {boolean} Whether actions are updating the same block attribute.
 */

function isUpdatingSameBlockAttribute(action, lastAction) {
  return action.type === 'UPDATE_BLOCK_ATTRIBUTES' && lastAction !== undefined && lastAction.type === 'UPDATE_BLOCK_ATTRIBUTES' && Object(external_lodash_["isEqual"])(action.clientIds, lastAction.clientIds) && hasSameKeys(action.attributes, lastAction.attributes);
}

function buildBlockTree(state, blocks) {
  const result = {};
  const stack = [...blocks];
  const flattenedBlocks = [...blocks];

  while (stack.length) {
    const block = stack.shift();
    stack.push(...block.innerBlocks);
    flattenedBlocks.push(...block.innerBlocks);
  } // Create objects before mutating them, that way it's always defined.


  for (const block of flattenedBlocks) {
    result[block.clientId] = {};
  }

  for (const block of flattenedBlocks) {
    result[block.clientId] = Object.assign(result[block.clientId], { ...state.byClientId[block.clientId],
      attributes: state.attributes[block.clientId],
      innerBlocks: block.innerBlocks.map(subBlock => result[subBlock.clientId])
    });
  }

  return result;
}

function updateParentInnerBlocksInTree(state, tree, updatedClientIds) {
  let updateChildrenOfUpdatedClientIds = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  const uncontrolledParents = new Set([]);
  const controlledParents = new Set();

  for (const clientId of updatedClientIds) {
    let current = updateChildrenOfUpdatedClientIds ? clientId : state.parents[clientId];

    do {
      if (state.controlledInnerBlocks[current]) {
        // Should stop on controlled blocks.
        // If we reach a controlled parent, break out of the loop.
        controlledParents.add(current);
        break;
      } else {
        // else continue traversing up through parents.
        uncontrolledParents.add(current);
        current = state.parents[current];
      }
    } while (current !== undefined);
  } // To make sure the order of assignments doesn't matter,
  // we first create empty objects and mutates the inner blocks later.


  for (const clientId of uncontrolledParents) {
    tree[clientId] = { ...tree[clientId]
    };
  }

  for (const clientId of uncontrolledParents) {
    tree[clientId].innerBlocks = (state.order[clientId] || []).map(subClientId => tree[subClientId]);
  } // Controlled parent blocks, need a dedicated key for their inner blocks
  // to be used when doing getBlocks( controlledBlockClientId ).


  for (const clientId of controlledParents) {
    tree['controlled||' + clientId] = {
      innerBlocks: (state.order[clientId] || []).map(subClientId => tree[subClientId])
    };
  }

  return tree;
}
/**
 * Higher-order reducer intended to compute full block objects key for each block in the post.
 * This is a denormalization to optimize the performance of the getBlock selectors and avoid
 * recomputing the block objects and avoid heavy memoization.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withBlockTree = reducer => function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;
  const newState = reducer(state, action);

  if (newState === state) {
    return state;
  }

  newState.tree = state.tree ? state.tree : {};

  switch (action.type) {
    case 'RECEIVE_BLOCKS':
    case 'INSERT_BLOCKS':
      {
        const subTree = buildBlockTree(newState, action.blocks);
        newState.tree = updateParentInnerBlocksInTree(newState, { ...newState.tree,
          ...subTree
        }, action.rootClientId ? [action.rootClientId] : [''], true);
        break;
      }

    case 'UPDATE_BLOCK':
      newState.tree = updateParentInnerBlocksInTree(newState, { ...newState.tree,
        [action.clientId]: { ...newState.tree[action.clientId],
          ...newState.byClientId[action.clientId],
          attributes: newState.attributes[action.clientId]
        }
      }, [action.clientId], false);
      break;

    case 'UPDATE_BLOCK_ATTRIBUTES':
      {
        const newSubTree = action.clientIds.reduce((result, clientId) => {
          result[clientId] = { ...newState.tree[clientId],
            attributes: newState.attributes[clientId]
          };
          return result;
        }, {});
        newState.tree = updateParentInnerBlocksInTree(newState, { ...newState.tree,
          ...newSubTree
        }, action.clientIds, false);
        break;
      }

    case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
      {
        const subTree = buildBlockTree(newState, action.blocks);
        newState.tree = updateParentInnerBlocksInTree(newState, { ...Object(external_lodash_["omit"])(newState.tree, action.replacedClientIds.concat( // Controlled inner blocks are only removed
          // if the block doesn't move to another position
          // otherwise their content will be lost.
          action.replacedClientIds.filter(clientId => !subTree[clientId]).map(clientId => 'controlled||' + clientId))),
          ...subTree
        }, action.blocks.map(b => b.clientId), false); // If there are no replaced blocks, it means we're removing blocks so we need to update their parent.

        const parentsOfRemovedBlocks = [];

        for (const clientId of action.clientIds) {
          if (state.parents[clientId] !== undefined && (state.parents[clientId] === '' || newState.byClientId[state.parents[clientId]])) {
            parentsOfRemovedBlocks.push(state.parents[clientId]);
          }
        }

        newState.tree = updateParentInnerBlocksInTree(newState, newState.tree, parentsOfRemovedBlocks, true);
        break;
      }

    case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
      const parentsOfRemovedBlocks = [];

      for (const clientId of action.clientIds) {
        if (state.parents[clientId] !== undefined && (state.parents[clientId] === '' || newState.byClientId[state.parents[clientId]])) {
          parentsOfRemovedBlocks.push(state.parents[clientId]);
        }
      }

      newState.tree = updateParentInnerBlocksInTree(newState, Object(external_lodash_["omit"])(newState.tree, action.removedClientIds.concat(action.removedClientIds.map(clientId => 'controlled||' + clientId))), parentsOfRemovedBlocks, true);
      break;

    case 'MOVE_BLOCKS_TO_POSITION':
      {
        const updatedBlockUids = [];

        if (action.fromRootClientId) {
          updatedBlockUids.push(action.fromRootClientId);
        }

        if (action.toRootClientId) {
          updatedBlockUids.push(action.toRootClientId);
        }

        if (!action.fromRootClientId || !action.fromRootClientId) {
          updatedBlockUids.push('');
        }

        newState.tree = updateParentInnerBlocksInTree(newState, newState.tree, updatedBlockUids, true);
        break;
      }

    case 'MOVE_BLOCKS_UP':
    case 'MOVE_BLOCKS_DOWN':
      {
        const updatedBlockUids = [action.rootClientId ? action.rootClientId : ''];
        newState.tree = updateParentInnerBlocksInTree(newState, newState.tree, updatedBlockUids, true);
        break;
      }

    case 'SAVE_REUSABLE_BLOCK_SUCCESS':
      {
        const updatedBlockUids = Object(external_lodash_["keys"])(Object(external_lodash_["omitBy"])(newState.attributes, (attributes, clientId) => {
          return newState.byClientId[clientId].name !== 'core/block' || attributes.ref !== action.updatedId;
        }));
        newState.tree = updateParentInnerBlocksInTree(newState, { ...newState.tree,
          ...updatedBlockUids.reduce((result, clientId) => {
            result[clientId] = { ...newState.byClientId[clientId],
              attributes: newState.attributes[clientId],
              innerBlocks: newState.tree[clientId].innerBlocks
            };
            return result;
          }, {})
        }, updatedBlockUids, false);
      }
  }

  return newState;
};
/**
 * Higher-order reducer intended to augment the blocks reducer, assigning an
 * `isPersistentChange` property value corresponding to whether a change in
 * state can be considered as persistent. All changes are considered persistent
 * except when updating the same block attribute as in the previous action.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


function withPersistentBlockChange(reducer) {
  let lastAction;
  let markNextChangeAsNotPersistent = false;
  return (state, action) => {
    let nextState = reducer(state, action);
    const isExplicitPersistentChange = action.type === 'MARK_LAST_CHANGE_AS_PERSISTENT' || markNextChangeAsNotPersistent; // Defer to previous state value (or default) unless changing or
    // explicitly marking as persistent.

    if (state === nextState && !isExplicitPersistentChange) {
      var _state$isPersistentCh;

      markNextChangeAsNotPersistent = action.type === 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT';
      const nextIsPersistentChange = (_state$isPersistentCh = state === null || state === void 0 ? void 0 : state.isPersistentChange) !== null && _state$isPersistentCh !== void 0 ? _state$isPersistentCh : true;

      if (state.isPersistentChange === nextIsPersistentChange) {
        return state;
      }

      return { ...nextState,
        isPersistentChange: nextIsPersistentChange
      };
    }

    nextState = { ...nextState,
      isPersistentChange: isExplicitPersistentChange ? !markNextChangeAsNotPersistent : !isUpdatingSameBlockAttribute(action, lastAction)
    }; // In comparing against the previous action, consider only those which
    // would have qualified as one which would have been ignored or not
    // have resulted in a changed state.

    lastAction = action;
    markNextChangeAsNotPersistent = action.type === 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT';
    return nextState;
  };
}
/**
 * Higher-order reducer intended to augment the blocks reducer, assigning an
 * `isIgnoredChange` property value corresponding to whether a change in state
 * can be considered as ignored. A change is considered ignored when the result
 * of an action not incurred by direct user interaction.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


function withIgnoredBlockChange(reducer) {
  /**
   * Set of action types for which a blocks state change should be ignored.
   *
   * @type {Set}
   */
  const IGNORED_ACTION_TYPES = new Set(['RECEIVE_BLOCKS']);
  return (state, action) => {
    const nextState = reducer(state, action);

    if (nextState !== state) {
      nextState.isIgnoredChange = IGNORED_ACTION_TYPES.has(action.type);
    }

    return nextState;
  };
}
/**
 * Higher-order reducer targeting the combined blocks reducer, augmenting
 * block client IDs in remove action to include cascade of inner blocks.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withInnerBlocksRemoveCascade = reducer => (state, action) => {
  // Gets all children which need to be removed.
  const getAllChildren = clientIds => {
    let result = clientIds;

    for (let i = 0; i < result.length; i++) {
      if (!state.order[result[i]] || action.keepControlledInnerBlocks && action.keepControlledInnerBlocks[result[i]]) {
        continue;
      }

      if (result === clientIds) {
        result = [...result];
      }

      result.push(...state.order[result[i]]);
    }

    return result;
  };

  if (state) {
    switch (action.type) {
      case 'REMOVE_BLOCKS':
        action = { ...action,
          type: 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN',
          removedClientIds: getAllChildren(action.clientIds)
        };
        break;

      case 'REPLACE_BLOCKS':
        action = { ...action,
          type: 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN',
          replacedClientIds: getAllChildren(action.clientIds)
        };
        break;
    }
  }

  return reducer(state, action);
};
/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `RESET_BLOCKS` action. When dispatched, this action will replace all
 * blocks that exist in the post, leaving blocks that exist only in state (e.g.
 * reusable blocks and blocks controlled by inner blocks controllers) alone.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withBlockReset = reducer => (state, action) => {
  if (action.type === 'RESET_BLOCKS') {
    const newState = { ...state,
      byClientId: getFlattenedBlocksWithoutAttributes(action.blocks),
      attributes: getFlattenedBlockAttributes(action.blocks),
      order: mapBlockOrder(action.blocks),
      parents: mapBlockParents(action.blocks),
      controlledInnerBlocks: {}
    };
    const subTree = buildBlockTree(newState, action.blocks);
    newState.tree = { ...subTree,
      // Root
      '': {
        innerBlocks: action.blocks.map(subBlock => subTree[subBlock.clientId])
      }
    };
    return newState;
  }

  return reducer(state, action);
};
/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `REPLACE_INNER_BLOCKS` action. When dispatched, this action the state
 * should become equivalent to the execution of a `REMOVE_BLOCKS` action
 * containing all the child's of the root block followed by the execution of
 * `INSERT_BLOCKS` with the new blocks.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withReplaceInnerBlocks = reducer => (state, action) => {
  if (action.type !== 'REPLACE_INNER_BLOCKS') {
    return reducer(state, action);
  } // Finds every nested inner block controller. We must check the action blocks
  // and not just the block parent state because some inner block controllers
  // should be deleted if specified, whereas others should not be deleted. If
  // a controlled should not be deleted, then we need to avoid deleting its
  // inner blocks from the block state because its inner blocks will not be
  // attached to the block in the action.


  const nestedControllers = {};

  if (Object.keys(state.controlledInnerBlocks).length) {
    const stack = [...action.blocks];

    while (stack.length) {
      const {
        innerBlocks,
        ...block
      } = stack.shift();
      stack.push(...innerBlocks);

      if (!!state.controlledInnerBlocks[block.clientId]) {
        nestedControllers[block.clientId] = true;
      }
    }
  } // The `keepControlledInnerBlocks` prop will keep the inner blocks of the
  // marked block in the block state so that they can be reattached to the
  // marked block when we re-insert everything a few lines below.


  let stateAfterBlocksRemoval = state;

  if (state.order[action.rootClientId]) {
    stateAfterBlocksRemoval = reducer(stateAfterBlocksRemoval, {
      type: 'REMOVE_BLOCKS',
      keepControlledInnerBlocks: nestedControllers,
      clientIds: state.order[action.rootClientId]
    });
  }

  let stateAfterInsert = stateAfterBlocksRemoval;

  if (action.blocks.length) {
    stateAfterInsert = reducer(stateAfterInsert, { ...action,
      type: 'INSERT_BLOCKS',
      index: 0
    }); // We need to re-attach the block order of the controlled inner blocks.
    // Otherwise, an inner block controller's blocks will be deleted entirely
    // from its entity..

    stateAfterInsert.order = { ...stateAfterInsert.order,
      ...Object(external_lodash_["reduce"])(nestedControllers, (result, value, key) => {
        if (state.order[key]) {
          result[key] = state.order[key];
        }

        return result;
      }, {})
    };
  }

  return stateAfterInsert;
};
/**
 * Higher-order reducer which targets the combined blocks reducer and handles
 * the `SAVE_REUSABLE_BLOCK_SUCCESS` action. This action can't be handled by
 * regular reducers and needs a higher-order reducer since it needs access to
 * both `byClientId` and `attributes` simultaneously.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withSaveReusableBlock = reducer => (state, action) => {
  if (state && action.type === 'SAVE_REUSABLE_BLOCK_SUCCESS') {
    const {
      id,
      updatedId
    } = action; // If a temporary reusable block is saved, we swap the temporary id with the final one

    if (id === updatedId) {
      return state;
    }

    state = { ...state
    };
    state.attributes = Object(external_lodash_["mapValues"])(state.attributes, (attributes, clientId) => {
      const {
        name
      } = state.byClientId[clientId];

      if (name === 'core/block' && attributes.ref === id) {
        return { ...attributes,
          ref: updatedId
        };
      }

      return attributes;
    });
  }

  return reducer(state, action);
};
/**
 * Higher-order reducer which removes blocks from state when switching parent block controlled state.
 *
 * @param {Function} reducer Original reducer function.
 *
 * @return {Function} Enhanced reducer function.
 */


const withResetControlledBlocks = reducer => (state, action) => {
  if (action.type === 'SET_HAS_CONTROLLED_INNER_BLOCKS') {
    // when switching a block from controlled to uncontrolled or inverse,
    // we need to remove its content first.
    const tempState = reducer(state, {
      type: 'REPLACE_INNER_BLOCKS',
      rootClientId: action.clientId,
      blocks: []
    });
    return reducer(tempState, action);
  }

  return reducer(state, action);
};
/**
 * Reducer returning the blocks state.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */


const reducer_blocks = Object(external_lodash_["flow"])(external_wp_data_["combineReducers"], withSaveReusableBlock, // needs to be before withBlockCache
withBlockTree, // needs to be before withInnerBlocksRemoveCascade
withInnerBlocksRemoveCascade, withReplaceInnerBlocks, // needs to be after withInnerBlocksRemoveCascade
withBlockReset, withPersistentBlockChange, withIgnoredBlockChange, withResetControlledBlocks)({
  byClientId() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
      case 'INSERT_BLOCKS':
        return { ...state,
          ...getFlattenedBlocksWithoutAttributes(action.blocks)
        };

      case 'UPDATE_BLOCK':
        // Ignore updates if block isn't known
        if (!state[action.clientId]) {
          return state;
        } // Do nothing if only attributes change.


        const changes = Object(external_lodash_["omit"])(action.updates, 'attributes');

        if (Object(external_lodash_["isEmpty"])(changes)) {
          return state;
        }

        return { ...state,
          [action.clientId]: { ...state[action.clientId],
            ...changes
          }
        };

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        if (!action.blocks) {
          return state;
        }

        return { ...Object(external_lodash_["omit"])(state, action.replacedClientIds),
          ...getFlattenedBlocksWithoutAttributes(action.blocks)
        };

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        return Object(external_lodash_["omit"])(state, action.removedClientIds);
    }

    return state;
  },

  attributes() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
      case 'INSERT_BLOCKS':
        return { ...state,
          ...getFlattenedBlockAttributes(action.blocks)
        };

      case 'UPDATE_BLOCK':
        // Ignore updates if block isn't known or there are no attribute changes.
        if (!state[action.clientId] || !action.updates.attributes) {
          return state;
        }

        return { ...state,
          [action.clientId]: { ...state[action.clientId],
            ...action.updates.attributes
          }
        };

      case 'UPDATE_BLOCK_ATTRIBUTES':
        {
          // Avoid a state change if none of the block IDs are known.
          if (action.clientIds.every(id => !state[id])) {
            return state;
          }

          const next = action.clientIds.reduce((accumulator, id) => ({ ...accumulator,
            [id]: Object(external_lodash_["reduce"])(action.uniqueByBlock ? action.attributes[id] : action.attributes, (result, value, key) => {
              // Consider as updates only changed values.
              if (value !== result[key]) {
                result = getMutateSafeObject(state[id], result);
                result[key] = value;
              }

              return result;
            }, state[id])
          }), {});

          if (action.clientIds.every(id => next[id] === state[id])) {
            return state;
          }

          return { ...state,
            ...next
          };
        }

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        if (!action.blocks) {
          return state;
        }

        return { ...Object(external_lodash_["omit"])(state, action.replacedClientIds),
          ...getFlattenedBlockAttributes(action.blocks)
        };

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        return Object(external_lodash_["omit"])(state, action.removedClientIds);
    }

    return state;
  },

  order() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
        {
          const blockOrder = mapBlockOrder(action.blocks);
          return { ...state,
            ...Object(external_lodash_["omit"])(blockOrder, ''),
            '': ((state === null || state === void 0 ? void 0 : state['']) || []).concat(blockOrder[''])
          };
        }

      case 'INSERT_BLOCKS':
        {
          const {
            rootClientId = ''
          } = action;
          const subState = state[rootClientId] || [];
          const mappedBlocks = mapBlockOrder(action.blocks, rootClientId);
          const {
            index = subState.length
          } = action;
          return { ...state,
            ...mappedBlocks,
            [rootClientId]: insertAt(subState, mappedBlocks[rootClientId], index)
          };
        }

      case 'MOVE_BLOCKS_TO_POSITION':
        {
          const {
            fromRootClientId = '',
            toRootClientId = '',
            clientIds
          } = action;
          const {
            index = state[toRootClientId].length
          } = action; // Moving inside the same parent block

          if (fromRootClientId === toRootClientId) {
            const subState = state[toRootClientId];
            const fromIndex = subState.indexOf(clientIds[0]);
            return { ...state,
              [toRootClientId]: moveTo(state[toRootClientId], fromIndex, index, clientIds.length)
            };
          } // Moving from a parent block to another


          return { ...state,
            [fromRootClientId]: Object(external_lodash_["without"])(state[fromRootClientId], ...clientIds),
            [toRootClientId]: insertAt(state[toRootClientId], clientIds, index)
          };
        }

      case 'MOVE_BLOCKS_UP':
        {
          const {
            clientIds,
            rootClientId = ''
          } = action;
          const firstClientId = Object(external_lodash_["first"])(clientIds);
          const subState = state[rootClientId];

          if (!subState.length || firstClientId === Object(external_lodash_["first"])(subState)) {
            return state;
          }

          const firstIndex = subState.indexOf(firstClientId);
          return { ...state,
            [rootClientId]: moveTo(subState, firstIndex, firstIndex - 1, clientIds.length)
          };
        }

      case 'MOVE_BLOCKS_DOWN':
        {
          const {
            clientIds,
            rootClientId = ''
          } = action;
          const firstClientId = Object(external_lodash_["first"])(clientIds);
          const lastClientId = Object(external_lodash_["last"])(clientIds);
          const subState = state[rootClientId];

          if (!subState.length || lastClientId === Object(external_lodash_["last"])(subState)) {
            return state;
          }

          const firstIndex = subState.indexOf(firstClientId);
          return { ...state,
            [rootClientId]: moveTo(subState, firstIndex, firstIndex + 1, clientIds.length)
          };
        }

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        {
          const {
            clientIds
          } = action;

          if (!action.blocks) {
            return state;
          }

          const mappedBlocks = mapBlockOrder(action.blocks);
          return Object(external_lodash_["flow"])([nextState => Object(external_lodash_["omit"])(nextState, action.replacedClientIds), nextState => ({ ...nextState,
            ...Object(external_lodash_["omit"])(mappedBlocks, '')
          }), nextState => Object(external_lodash_["mapValues"])(nextState, subState => Object(external_lodash_["reduce"])(subState, (result, clientId) => {
            if (clientId === clientIds[0]) {
              return [...result, ...mappedBlocks['']];
            }

            if (clientIds.indexOf(clientId) === -1) {
              result.push(clientId);
            }

            return result;
          }, []))])(state);
        }

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        return Object(external_lodash_["flow"])([// Remove inner block ordering for removed blocks
        nextState => Object(external_lodash_["omit"])(nextState, action.removedClientIds), // Remove deleted blocks from other blocks' orderings
        nextState => Object(external_lodash_["mapValues"])(nextState, subState => Object(external_lodash_["without"])(subState, ...action.removedClientIds))])(state);
    }

    return state;
  },

  // While technically redundant data as the inverse of `order`, it serves as
  // an optimization for the selectors which derive the ancestry of a block.
  parents() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let action = arguments.length > 1 ? arguments[1] : undefined;

    switch (action.type) {
      case 'RECEIVE_BLOCKS':
        return { ...state,
          ...mapBlockParents(action.blocks)
        };

      case 'INSERT_BLOCKS':
        return { ...state,
          ...mapBlockParents(action.blocks, action.rootClientId || '')
        };

      case 'MOVE_BLOCKS_TO_POSITION':
        {
          return { ...state,
            ...action.clientIds.reduce((accumulator, id) => {
              accumulator[id] = action.toRootClientId || '';
              return accumulator;
            }, {})
          };
        }

      case 'REPLACE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        return { ...Object(external_lodash_["omit"])(state, action.replacedClientIds),
          ...mapBlockParents(action.blocks, state[action.clientIds[0]])
        };

      case 'REMOVE_BLOCKS_AUGMENTED_WITH_CHILDREN':
        return Object(external_lodash_["omit"])(state, action.removedClientIds);
    }

    return state;
  },

  controlledInnerBlocks() {
    let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let {
      type,
      clientId,
      hasControlledInnerBlocks
    } = arguments.length > 1 ? arguments[1] : undefined;

    if (type === 'SET_HAS_CONTROLLED_INNER_BLOCKS') {
      return { ...state,
        [clientId]: hasControlledInnerBlocks
      };
    }

    return state;
  }

});
/**
 * Reducer returning typing state.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isTyping() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'START_TYPING':
      return true;

    case 'STOP_TYPING':
      return false;
  }

  return state;
}
/**
 * Reducer returning dragged block client id.
 *
 * @param {string[]} state  Current state.
 * @param {Object}   action Dispatched action.
 *
 * @return {string[]} Updated state.
 */

function draggedBlocks() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'START_DRAGGING_BLOCKS':
      return action.clientIds;

    case 'STOP_DRAGGING_BLOCKS':
      return [];
  }

  return state;
}
/**
 * Reducer returning whether the caret is within formatted text.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isCaretWithinFormattedText() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'ENTER_FORMATTED_TEXT':
      return true;

    case 'EXIT_FORMATTED_TEXT':
      return false;
  }

  return state;
}
/**
 * Internal helper reducer for selectionStart and selectionEnd. Can hold a block
 * selection, represented by an object with property clientId.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function selectionHelper() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'CLEAR_SELECTED_BLOCK':
      {
        if (state.clientId) {
          return {};
        }

        return state;
      }

    case 'SELECT_BLOCK':
      if (action.clientId === state.clientId) {
        return state;
      }

      return {
        clientId: action.clientId
      };

    case 'REPLACE_INNER_BLOCKS':
    case 'INSERT_BLOCKS':
      {
        if (!action.updateSelection || !action.blocks.length) {
          return state;
        }

        return {
          clientId: action.blocks[0].clientId
        };
      }

    case 'REMOVE_BLOCKS':
      if (!action.clientIds || !action.clientIds.length || action.clientIds.indexOf(state.clientId) === -1) {
        return state;
      }

      return {};

    case 'REPLACE_BLOCKS':
      {
        if (action.clientIds.indexOf(state.clientId) === -1) {
          return state;
        }

        const blockToSelect = action.blocks[action.indexToSelect] || action.blocks[action.blocks.length - 1];

        if (!blockToSelect) {
          return {};
        }

        if (blockToSelect.clientId === state.clientId) {
          return state;
        }

        return {
          clientId: blockToSelect.clientId
        };
      }
  }

  return state;
}
/**
 * Reducer returning the selection state.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */


function selection() {
  var _state$selectionStart, _state$selectionEnd;

  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'SELECTION_CHANGE':
      return {
        selectionStart: {
          clientId: action.clientId,
          attributeKey: action.attributeKey,
          offset: action.startOffset
        },
        selectionEnd: {
          clientId: action.clientId,
          attributeKey: action.attributeKey,
          offset: action.endOffset
        }
      };

    case 'RESET_SELECTION':
      const {
        selectionStart,
        selectionEnd
      } = action;
      return {
        selectionStart,
        selectionEnd
      };

    case 'MULTI_SELECT':
      const {
        start,
        end
      } = action;
      return {
        selectionStart: {
          clientId: start
        },
        selectionEnd: {
          clientId: end
        }
      };

    case 'RESET_BLOCKS':
      const startClientId = state === null || state === void 0 ? void 0 : (_state$selectionStart = state.selectionStart) === null || _state$selectionStart === void 0 ? void 0 : _state$selectionStart.clientId;
      const endClientId = state === null || state === void 0 ? void 0 : (_state$selectionEnd = state.selectionEnd) === null || _state$selectionEnd === void 0 ? void 0 : _state$selectionEnd.clientId; // Do nothing if there's no selected block.

      if (!startClientId && !endClientId) {
        return state;
      } // If the start of the selection won't exist after reset, remove selection.


      if (!action.blocks.some(block => block.clientId === startClientId)) {
        return {
          selectionStart: {},
          selectionEnd: {}
        };
      } // If the end of the selection won't exist after reset, collapse selection.


      if (!action.blocks.some(block => block.clientId === endClientId)) {
        return { ...state,
          selectionEnd: state.selectionStart
        };
      }

  }

  return {
    selectionStart: selectionHelper(state.selectionStart, action),
    selectionEnd: selectionHelper(state.selectionEnd, action)
  };
}
/**
 * Reducer returning whether the user is multi-selecting.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isMultiSelecting() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'START_MULTI_SELECT':
      return true;

    case 'STOP_MULTI_SELECT':
      return false;
  }

  return state;
}
/**
 * Reducer returning whether selection is enabled.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function isSelectionEnabled() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'TOGGLE_SELECTION':
      return action.isSelectionEnabled;
  }

  return state;
}
/**
 * Reducer returning the intial block selection.
 *
 * Currently this in only used to restore the selection after block deletion and
 * pasting new content.This reducer should eventually be removed in favour of setting
 * selection directly.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {number|null} Initial position: 0, -1 or null.
 */

function reducer_initialPosition() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  if (action.type === 'REPLACE_BLOCKS' && action.initialPosition !== undefined) {
    return action.initialPosition;
  } else if (['SELECT_BLOCK', 'RESET_SELECTION', 'INSERT_BLOCKS', 'REPLACE_INNER_BLOCKS'].includes(action.type)) {
    return action.initialPosition;
  }

  return state;
}
function blocksMode() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  if (action.type === 'TOGGLE_BLOCK_MODE') {
    const {
      clientId
    } = action;
    return { ...state,
      [clientId]: state[clientId] && state[clientId] === 'html' ? 'visual' : 'html'
    };
  }

  return state;
}
/**
 * Reducer returning the block insertion point visibility, either null if there
 * is not an explicit insertion point assigned, or an object of its `index` and
 * `rootClientId`.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function insertionPoint() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'SHOW_INSERTION_POINT':
      const {
        rootClientId,
        index,
        __unstableWithInserter
      } = action;
      return {
        rootClientId,
        index,
        __unstableWithInserter
      };

    case 'HIDE_INSERTION_POINT':
      return null;
  }

  return state;
}
/**
 * Reducer returning whether the post blocks match the defined template or not.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {boolean} Updated state.
 */

function reducer_template() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
    isValid: true
  };
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'SET_TEMPLATE_VALIDITY':
      return { ...state,
        isValid: action.isValid
      };
  }

  return state;
}
/**
 * Reducer returning the editor setting.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function settings() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaults["b" /* SETTINGS_DEFAULTS */];
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'UPDATE_SETTINGS':
      return { ...state,
        ...action.settings
      };
  }

  return state;
}
/**
 * Reducer returning the user preferences.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {string} Updated state.
 */

function preferences() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : defaults["a" /* PREFERENCES_DEFAULTS */];
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'INSERT_BLOCKS':
    case 'REPLACE_BLOCKS':
      return action.blocks.reduce((prevState, block) => {
        const {
          attributes,
          name: blockName
        } = block;
        const match = Object(external_wp_data_["select"])(external_wp_blocks_["store"]).getActiveBlockVariation(blockName, attributes); // If a block variation match is found change the name to be the same with the
        // one that is used for block variations in the Inserter (`getItemFromVariation`).

        let id = match !== null && match !== void 0 && match.name ? `${blockName}/${match.name}` : blockName;
        const insert = {
          name: id
        };

        if (blockName === 'core/block') {
          insert.ref = attributes.ref;
          id += '/' + attributes.ref;
        }

        return { ...prevState,
          insertUsage: { ...prevState.insertUsage,
            [id]: {
              time: action.time,
              count: prevState.insertUsage[id] ? prevState.insertUsage[id].count + 1 : 1,
              insert
            }
          }
        };
      }, state);
  }

  return state;
}
/**
 * Reducer returning an object where each key is a block client ID, its value
 * representing the settings for its nested blocks.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

const blockListSettings = function () {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    // Even if the replaced blocks have the same client ID, our logic
    // should correct the state.
    case 'REPLACE_BLOCKS':
    case 'REMOVE_BLOCKS':
      {
        return Object(external_lodash_["omit"])(state, action.clientIds);
      }

    case 'UPDATE_BLOCK_LIST_SETTINGS':
      {
        const {
          clientId
        } = action;

        if (!action.settings) {
          if (state.hasOwnProperty(clientId)) {
            return Object(external_lodash_["omit"])(state, clientId);
          }

          return state;
        }

        if (Object(external_lodash_["isEqual"])(state[clientId], action.settings)) {
          return state;
        }

        return { ...state,
          [clientId]: action.settings
        };
      }
  }

  return state;
};
/**
 * Reducer returning whether the navigation mode is enabled or not.
 *
 * @param {string} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {string} Updated state.
 */

function reducer_isNavigationMode() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  // Let inserting block always trigger Edit mode.
  if (action.type === 'INSERT_BLOCKS') {
    return false;
  }

  if (action.type === 'SET_NAVIGATION_MODE') {
    return action.isNavigationMode;
  }

  return state;
}
/**
 * Reducer returning whether the block moving mode is enabled or not.
 *
 * @param {string|null} state  Current state.
 * @param {Object}      action Dispatched action.
 *
 * @return {string|null} Updated state.
 */

function reducer_hasBlockMovingClientId() {
  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  let action = arguments.length > 1 ? arguments[1] : undefined;

  // Let inserting block always trigger Edit mode.
  if (action.type === 'SET_BLOCK_MOVING_MODE') {
    return action.hasBlockMovingClientId;
  }

  if (action.type === 'SET_NAVIGATION_MODE') {
    return null;
  }

  return state;
}
/**
 * Reducer return an updated state representing the most recent block attribute
 * update. The state is structured as an object where the keys represent the
 * client IDs of blocks, the values a subset of attributes from the most recent
 * block update. The state is always reset to null if the last action is
 * anything other than an attributes update.
 *
 * @param {Object<string,Object>} state  Current state.
 * @param {Object}                action Action object.
 *
 * @return {[string,Object]} Updated state.
 */

function lastBlockAttributesChange(state, action) {
  switch (action.type) {
    case 'UPDATE_BLOCK':
      if (!action.updates.attributes) {
        break;
      }

      return {
        [action.clientId]: action.updates.attributes
      };

    case 'UPDATE_BLOCK_ATTRIBUTES':
      return action.clientIds.reduce((accumulator, id) => ({ ...accumulator,
        [id]: action.uniqueByBlock ? action.attributes[id] : action.attributes
      }), {});
  }

  return null;
}
/**
 * Reducer returning automatic change state.
 *
 * @param {boolean} state  Current state.
 * @param {Object}  action Dispatched action.
 *
 * @return {string} Updated state.
 */

function automaticChangeStatus(state, action) {
  switch (action.type) {
    case 'MARK_AUTOMATIC_CHANGE':
      return 'pending';

    case 'MARK_AUTOMATIC_CHANGE_FINAL':
      if (state === 'pending') {
        return 'final';
      }

      return;

    case 'SELECTION_CHANGE':
      // As long as the state is not final, ignore any selection changes.
      if (state !== 'final') {
        return state;
      }

      return;
    // Undoing an automatic change should still be possible after mouse
    // move.

    case 'START_TYPING':
    case 'STOP_TYPING':
      return state;
  } // Reset the state by default (for any action not handled).

}
/**
 * Reducer returning current highlighted block.
 *
 * @param {boolean} state  Current highlighted block.
 * @param {Object}  action Dispatched action.
 *
 * @return {string} Updated state.
 */

function highlightedBlock(state, action) {
  switch (action.type) {
    case 'TOGGLE_BLOCK_HIGHLIGHT':
      const {
        clientId,
        isHighlighted
      } = action;

      if (isHighlighted) {
        return clientId;
      } else if (state === clientId) {
        return null;
      }

      return state;

    case 'SELECT_BLOCK':
      if (action.clientId !== state) {
        return null;
      }

  }

  return state;
}
/**
 * Reducer returning the block insertion event list state.
 *
 * @param {Object} state  Current state.
 * @param {Object} action Dispatched action.
 *
 * @return {Object} Updated state.
 */

function lastBlockInserted() {
  var _action$meta;

  let state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  let action = arguments.length > 1 ? arguments[1] : undefined;

  switch (action.type) {
    case 'INSERT_BLOCKS':
      if (!action.blocks.length) {
        return state;
      }

      const clientId = action.blocks[0].clientId;
      const source = (_action$meta = action.meta) === null || _action$meta === void 0 ? void 0 : _action$meta.source;
      return {
        clientId,
        source
      };

    case 'RESET_BLOCKS':
      return {};
  }

  return state;
}
/* harmony default export */ var store_reducer = (Object(external_wp_data_["combineReducers"])({
  blocks: reducer_blocks,
  isTyping,
  draggedBlocks,
  isCaretWithinFormattedText,
  selection,
  isMultiSelecting,
  isSelectionEnabled,
  initialPosition: reducer_initialPosition,
  blocksMode,
  blockListSettings,
  insertionPoint,
  template: reducer_template,
  settings,
  preferences,
  lastBlockAttributesChange,
  isNavigationMode: reducer_isNavigationMode,
  hasBlockMovingClientId: reducer_hasBlockMovingClientId,
  automaticChangeStatus,
  highlightedBlock,
  lastBlockInserted
}));

// EXTERNAL MODULE: ./node_modules/rememo/es/rememo.js
var rememo = __webpack_require__("pPDe");

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external ["wp","hooks"]
var external_wp_hooks_ = __webpack_require__("g56x");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/symbol.js
var symbol = __webpack_require__("+WrK");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/selectors.js
/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */





/**
 * A block selection object.
 *
 * @typedef {Object} WPBlockSelection
 *
 * @property {string} clientId     A block client ID.
 * @property {string} attributeKey A block attribute key.
 * @property {number} offset       An attribute value offset, based on the rich
 *                                 text value. See `wp.richText.create`.
 */
// Module constants

const MILLISECONDS_PER_HOUR = 3600 * 1000;
const MILLISECONDS_PER_DAY = 24 * 3600 * 1000;
const MILLISECONDS_PER_WEEK = 7 * 24 * 3600 * 1000;
/**
 * Shared reference to an empty array for cases where it is important to avoid
 * returning a new array reference on every invocation, as in a connected or
 * other pure component which performs `shouldComponentUpdate` check on props.
 * This should be used as a last resort, since the normalized data should be
 * maintained by the reducer result in state.
 *
 * @type {Array}
 */

const EMPTY_ARRAY = [];
/**
 * Returns a block's name given its client ID, or null if no block exists with
 * the client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {string} Block name.
 */

function getBlockName(state, clientId) {
  const block = state.blocks.byClientId[clientId];
  const socialLinkName = 'core/social-link';

  if (external_wp_element_["Platform"].OS !== 'web' && (block === null || block === void 0 ? void 0 : block.name) === socialLinkName) {
    const attributes = state.blocks.attributes[clientId];
    const {
      service
    } = attributes;
    return service ? `${socialLinkName}-${service}` : socialLinkName;
  }

  return block ? block.name : null;
}
/**
 * Returns whether a block is valid or not.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Is Valid.
 */

function isBlockValid(state, clientId) {
  const block = state.blocks.byClientId[clientId];
  return !!block && block.isValid;
}
/**
 * Returns a block's attributes given its client ID, or null if no block exists with
 * the client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object?} Block attributes.
 */

function getBlockAttributes(state, clientId) {
  const block = state.blocks.byClientId[clientId];

  if (!block) {
    return null;
  }

  return state.blocks.attributes[clientId];
}
/**
 * Returns a block given its client ID. This is a parsed copy of the block,
 * containing its `blockName`, `clientId`, and current `attributes` state. This
 * is not the block's registration settings, which must be retrieved from the
 * blocks module registration store.
 *
 * getBlock recurses through its inner blocks until all its children blocks have
 * been retrieved. Note that getBlock will not return the child inner blocks of
 * an inner block controller. This is because an inner block controller syncs
 * itself with its own entity, and should therefore not be included with the
 * blocks of a different entity. For example, say you call `getBlocks( TP )` to
 * get the blocks of a template part. If another template part is a child of TP,
 * then the nested template part's child blocks will not be returned. This way,
 * the template block itself is considered part of the parent, but the children
 * are not.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Parsed block object.
 */

function getBlock(state, clientId) {
  const block = state.blocks.byClientId[clientId];

  if (!block) {
    return null;
  }

  return state.blocks.tree[clientId];
}
const __unstableGetBlockWithoutInnerBlocks = Object(rememo["a" /* default */])((state, clientId) => {
  const block = state.blocks.byClientId[clientId];

  if (!block) {
    return null;
  }

  return { ...block,
    attributes: getBlockAttributes(state, clientId)
  };
}, (state, clientId) => [state.blocks.byClientId[clientId], state.blocks.attributes[clientId]]);
/**
 * Returns all block objects for the current post being edited as an array in
 * the order they appear in the post. Note that this will exclude child blocks
 * of nested inner block controllers.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Object[]} Post blocks.
 */

function getBlocks(state, rootClientId) {
  var _state$blocks$tree$tr;

  const treeKey = !rootClientId || !areInnerBlocksControlled(state, rootClientId) ? rootClientId || '' : 'controlled||' + rootClientId;
  return ((_state$blocks$tree$tr = state.blocks.tree[treeKey]) === null || _state$blocks$tree$tr === void 0 ? void 0 : _state$blocks$tree$tr.innerBlocks) || EMPTY_ARRAY;
}
/**
 * Returns a stripped down block object containing only its client ID,
 * and its inner blocks' client IDs.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Client ID of the block to get.
 *
 * @return {Object} Client IDs of the post blocks.
 */

const __unstableGetClientIdWithClientIdsTree = Object(rememo["a" /* default */])((state, clientId) => ({
  clientId,
  innerBlocks: __unstableGetClientIdsTree(state, clientId)
}), state => [state.blocks.order]);
/**
 * Returns the block tree represented in the block-editor store from the
 * given root, consisting of stripped down block objects containing only
 * their client IDs, and their inner blocks' client IDs.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Object[]} Client IDs of the post blocks.
 */

const __unstableGetClientIdsTree = Object(rememo["a" /* default */])(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  return Object(external_lodash_["map"])(getBlockOrder(state, rootClientId), clientId => __unstableGetClientIdWithClientIdsTree(state, clientId));
}, state => [state.blocks.order]);
/**
 * Returns an array containing the clientIds of all descendants
 * of the blocks given.
 *
 * @param {Object} state     Global application state.
 * @param {Array}  clientIds Array of blocks to inspect.
 *
 * @return {Array} ids of descendants.
 */

const getClientIdsOfDescendants = (state, clientIds) => Object(external_lodash_["flatMap"])(clientIds, clientId => {
  const descendants = getBlockOrder(state, clientId);
  return [...descendants, ...getClientIdsOfDescendants(state, descendants)];
});
/**
 * Returns an array containing the clientIds of the top-level blocks
 * and their descendants of any depth (for nested blocks).
 *
 * @param {Object} state Global application state.
 *
 * @return {Array} ids of top-level and descendant blocks.
 */

const getClientIdsWithDescendants = Object(rememo["a" /* default */])(state => {
  const topLevelIds = getBlockOrder(state);
  return [...topLevelIds, ...getClientIdsOfDescendants(state, topLevelIds)];
}, state => [state.blocks.order]);
/**
 * Returns the total number of blocks, or the total number of blocks with a specific name in a post.
 * The number returned includes nested blocks.
 *
 * @param {Object}  state     Global application state.
 * @param {?string} blockName Optional block name, if specified only blocks of that type will be counted.
 *
 * @return {number} Number of blocks in the post, or number of blocks with name equal to blockName.
 */

const getGlobalBlockCount = Object(rememo["a" /* default */])((state, blockName) => {
  const clientIds = getClientIdsWithDescendants(state);

  if (!blockName) {
    return clientIds.length;
  }

  return Object(external_lodash_["reduce"])(clientIds, (accumulator, clientId) => {
    const block = state.blocks.byClientId[clientId];
    return block.name === blockName ? accumulator + 1 : accumulator;
  }, 0);
}, state => [state.blocks.order, state.blocks.byClientId]);
/**
 * Given an array of block client IDs, returns the corresponding array of block
 * objects.
 *
 * @param {Object}   state     Editor state.
 * @param {string[]} clientIds Client IDs for which blocks are to be returned.
 *
 * @return {WPBlock[]} Block objects.
 */

const getBlocksByClientId = Object(rememo["a" /* default */])((state, clientIds) => Object(external_lodash_["map"])(Object(external_lodash_["castArray"])(clientIds), clientId => getBlock(state, clientId)), (state, clientIds) => Object(external_lodash_["map"])(Object(external_lodash_["castArray"])(clientIds), clientId => state.blocks.tree[clientId]));
/**
 * Returns the number of blocks currently present in the post.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {number} Number of blocks in the post.
 */

function getBlockCount(state, rootClientId) {
  return getBlockOrder(state, rootClientId).length;
}
/**
 * Returns the current selection start block client ID, attribute key and text
 * offset.
 *
 * @param {Object} state Block editor state.
 *
 * @return {WPBlockSelection} Selection start information.
 */

function getSelectionStart(state) {
  return state.selection.selectionStart;
}
/**
 * Returns the current selection end block client ID, attribute key and text
 * offset.
 *
 * @param {Object} state Block editor state.
 *
 * @return {WPBlockSelection} Selection end information.
 */

function getSelectionEnd(state) {
  return state.selection.selectionEnd;
}
/**
 * Returns the current block selection start. This value may be null, and it
 * may represent either a singular block selection or multi-selection start.
 * A selection is singular if its start and end match.
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} Client ID of block selection start.
 */

function getBlockSelectionStart(state) {
  return state.selection.selectionStart.clientId;
}
/**
 * Returns the current block selection end. This value may be null, and it
 * may represent either a singular block selection or multi-selection end.
 * A selection is singular if its start and end match.
 *
 * @param {Object} state Global application state.
 *
 * @return {?string} Client ID of block selection end.
 */

function getBlockSelectionEnd(state) {
  return state.selection.selectionEnd.clientId;
}
/**
 * Returns the number of blocks currently selected in the post.
 *
 * @param {Object} state Global application state.
 *
 * @return {number} Number of blocks selected in the post.
 */

function getSelectedBlockCount(state) {
  const multiSelectedBlockCount = getMultiSelectedBlockClientIds(state).length;

  if (multiSelectedBlockCount) {
    return multiSelectedBlockCount;
  }

  return state.selection.selectionStart.clientId ? 1 : 0;
}
/**
 * Returns true if there is a single selected block, or false otherwise.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether a single block is selected.
 */

function hasSelectedBlock(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  return !!selectionStart.clientId && selectionStart.clientId === selectionEnd.clientId;
}
/**
 * Returns the currently selected block client ID, or null if there is no
 * selected block.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Selected block client ID.
 */

function getSelectedBlockClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  const {
    clientId
  } = selectionStart;

  if (!clientId || clientId !== selectionEnd.clientId) {
    return null;
  }

  return clientId;
}
/**
 * Returns the currently selected block, or null if there is no selected block.
 *
 * @param {Object} state Global application state.
 *
 * @return {?Object} Selected block.
 */

function getSelectedBlock(state) {
  const clientId = getSelectedBlockClientId(state);
  return clientId ? getBlock(state, clientId) : null;
}
/**
 * Given a block client ID, returns the root block from which the block is
 * nested, an empty string for top-level blocks, or null if the block does not
 * exist.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find root client ID.
 *
 * @return {?string} Root client ID, if exists
 */

function getBlockRootClientId(state, clientId) {
  return state.blocks.parents[clientId] !== undefined ? state.blocks.parents[clientId] : null;
}
/**
 * Given a block client ID, returns the list of all its parents from top to bottom.
 *
 * @param {Object}  state     Editor state.
 * @param {string}  clientId  Block from which to find root client ID.
 * @param {boolean} ascending Order results from bottom to top (true) or top to bottom (false).
 *
 * @return {Array} ClientIDs of the parent blocks.
 */

const getBlockParents = Object(rememo["a" /* default */])(function (state, clientId) {
  let ascending = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  const parents = [];
  let current = clientId;

  while (!!state.blocks.parents[current]) {
    current = state.blocks.parents[current];
    parents.push(current);
  }

  return ascending ? parents : parents.reverse();
}, state => [state.blocks.parents]);
/**
 * Given a block client ID and a block name, returns the list of all its parents
 * from top to bottom, filtered by the given name(s). For example, if passed
 * 'core/group' as the blockName, it will only return parents which are group
 * blocks. If passed `[ 'core/group', 'core/cover']`, as the blockName, it will
 * return parents which are group blocks and parents which are cover blocks.
 *
 * @param {Object}          state     Editor state.
 * @param {string}          clientId  Block from which to find root client ID.
 * @param {string|string[]} blockName Block name(s) to filter.
 * @param {boolean}         ascending Order results from bottom to top (true) or top to bottom (false).
 *
 * @return {Array} ClientIDs of the parent blocks.
 */

const getBlockParentsByBlockName = Object(rememo["a" /* default */])(function (state, clientId, blockName) {
  let ascending = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  const parents = getBlockParents(state, clientId, ascending);
  return Object(external_lodash_["map"])(Object(external_lodash_["filter"])(Object(external_lodash_["map"])(parents, id => ({
    id,
    name: getBlockName(state, id)
  })), _ref => {
    let {
      name
    } = _ref;

    if (Array.isArray(blockName)) {
      return blockName.includes(name);
    }

    return name === blockName;
  }), _ref2 => {
    let {
      id
    } = _ref2;
    return id;
  });
}, state => [state.blocks.parents]);
/**
 * Given a block client ID, returns the root of the hierarchy from which the block is nested, return the block itself for root level blocks.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find root client ID.
 *
 * @return {string} Root client ID
 */

function getBlockHierarchyRootClientId(state, clientId) {
  let current = clientId;
  let parent;

  do {
    parent = current;
    current = state.blocks.parents[current];
  } while (current);

  return parent;
}
/**
 * Given a block client ID, returns the lowest common ancestor with selected client ID.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block from which to find common ancestor client ID.
 *
 * @return {string} Common ancestor client ID or undefined
 */

function getLowestCommonAncestorWithSelectedBlock(state, clientId) {
  const selectedId = getSelectedBlockClientId(state);
  const clientParents = [...getBlockParents(state, clientId), clientId];
  const selectedParents = [...getBlockParents(state, selectedId), selectedId];
  let lowestCommonAncestor;
  const maxDepth = Math.min(clientParents.length, selectedParents.length);

  for (let index = 0; index < maxDepth; index++) {
    if (clientParents[index] === selectedParents[index]) {
      lowestCommonAncestor = clientParents[index];
    } else {
      break;
    }
  }

  return lowestCommonAncestor;
}
/**
 * Returns the client ID of the block adjacent one at the given reference
 * startClientId and modifier directionality. Defaults start startClientId to
 * the selected block, and direction as next block. Returns null if there is no
 * adjacent block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 * @param {?number} modifier      Directionality multiplier (1 next, -1
 *                                previous).
 *
 * @return {?string} Return the client ID of the block, or null if none exists.
 */

function getAdjacentBlockClientId(state, startClientId) {
  let modifier = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;

  // Default to selected block.
  if (startClientId === undefined) {
    startClientId = getSelectedBlockClientId(state);
  } // Try multi-selection starting at extent based on modifier.


  if (startClientId === undefined) {
    if (modifier < 0) {
      startClientId = getFirstMultiSelectedBlockClientId(state);
    } else {
      startClientId = getLastMultiSelectedBlockClientId(state);
    }
  } // Validate working start client ID.


  if (!startClientId) {
    return null;
  } // Retrieve start block root client ID, being careful to allow the falsey
  // empty string top-level root by explicitly testing against null.


  const rootClientId = getBlockRootClientId(state, startClientId);

  if (rootClientId === null) {
    return null;
  }

  const {
    order
  } = state.blocks;
  const orderSet = order[rootClientId];
  const index = orderSet.indexOf(startClientId);
  const nextIndex = index + 1 * modifier; // Block was first in set and we're attempting to get previous.

  if (nextIndex < 0) {
    return null;
  } // Block was last in set and we're attempting to get next.


  if (nextIndex === orderSet.length) {
    return null;
  } // Assume incremented index is within the set.


  return orderSet[nextIndex];
}
/**
 * Returns the previous block's client ID from the given reference start ID.
 * Defaults start to the selected block. Returns null if there is no previous
 * block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 *
 * @return {?string} Adjacent block's client ID, or null if none exists.
 */

function getPreviousBlockClientId(state, startClientId) {
  return getAdjacentBlockClientId(state, startClientId, -1);
}
/**
 * Returns the next block's client ID from the given reference start ID.
 * Defaults start to the selected block. Returns null if there is no next
 * block.
 *
 * @param {Object}  state         Editor state.
 * @param {?string} startClientId Optional client ID of block from which to
 *                                search.
 *
 * @return {?string} Adjacent block's client ID, or null if none exists.
 */

function getNextBlockClientId(state, startClientId) {
  return getAdjacentBlockClientId(state, startClientId, 1);
}
/* eslint-disable jsdoc/valid-types */

/**
 * Returns the initial caret position for the selected block.
 * This position is to used to position the caret properly when the selected block changes.
 * If the current block is not a RichText, having initial position set to 0 means "focus block"
 *
 * @param {Object} state Global application state.
 *
 * @return {0|-1|null} Initial position.
 */

function getSelectedBlocksInitialCaretPosition(state) {
  /* eslint-enable jsdoc/valid-types */
  return state.initialPosition;
}
/**
 * Returns the current selection set of block client IDs (multiselection or single selection).
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block client IDs.
 */

const getSelectedBlockClientIds = Object(rememo["a" /* default */])(state => {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === undefined || selectionEnd.clientId === undefined) {
    return EMPTY_ARRAY;
  }

  if (selectionStart.clientId === selectionEnd.clientId) {
    return [selectionStart.clientId];
  } // Retrieve root client ID to aid in retrieving relevant nested block
  // order, being careful to allow the falsey empty string top-level root
  // by explicitly testing against null.


  const rootClientId = getBlockRootClientId(state, selectionStart.clientId);

  if (rootClientId === null) {
    return EMPTY_ARRAY;
  }

  const blockOrder = getBlockOrder(state, rootClientId);
  const startIndex = blockOrder.indexOf(selectionStart.clientId);
  const endIndex = blockOrder.indexOf(selectionEnd.clientId);

  if (startIndex > endIndex) {
    return blockOrder.slice(endIndex, startIndex + 1);
  }

  return blockOrder.slice(startIndex, endIndex + 1);
}, state => [state.blocks.order, state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId]);
/**
 * Returns the current multi-selection set of block client IDs, or an empty
 * array if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block client IDs.
 */

function getMultiSelectedBlockClientIds(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === selectionEnd.clientId) {
    return EMPTY_ARRAY;
  }

  return getSelectedBlockClientIds(state);
}
/**
 * Returns the current multi-selection set of blocks, or an empty array if
 * there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {Array} Multi-selected block objects.
 */

const getMultiSelectedBlocks = Object(rememo["a" /* default */])(state => {
  const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds(state);

  if (!multiSelectedBlockClientIds.length) {
    return EMPTY_ARRAY;
  }

  return multiSelectedBlockClientIds.map(clientId => getBlock(state, clientId));
}, state => [...getSelectedBlockClientIds.getDependants(state), state.blocks.byClientId, state.blocks.order, state.blocks.attributes]);
/**
 * Returns the client ID of the first block in the multi-selection set, or null
 * if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} First block client ID in the multi-selection set.
 */

function getFirstMultiSelectedBlockClientId(state) {
  return Object(external_lodash_["first"])(getMultiSelectedBlockClientIds(state)) || null;
}
/**
 * Returns the client ID of the last block in the multi-selection set, or null
 * if there is no multi-selection.
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Last block client ID in the multi-selection set.
 */

function getLastMultiSelectedBlockClientId(state) {
  return Object(external_lodash_["last"])(getMultiSelectedBlockClientIds(state)) || null;
}
/**
 * Returns true if a multi-selection exists, and the block corresponding to the
 * specified client ID is the first block of the multi-selection set, or false
 * otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is first in multi-selection.
 */

function isFirstMultiSelectedBlock(state, clientId) {
  return getFirstMultiSelectedBlockClientId(state) === clientId;
}
/**
 * Returns true if the client ID occurs within the block multi-selection, or
 * false otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is in multi-selection set.
 */

function isBlockMultiSelected(state, clientId) {
  return getMultiSelectedBlockClientIds(state).indexOf(clientId) !== -1;
}
/**
 * Returns true if an ancestor of the block is multi-selected, or false
 * otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether an ancestor of the block is in multi-selection
 *                   set.
 */

const isAncestorMultiSelected = Object(rememo["a" /* default */])((state, clientId) => {
  let ancestorClientId = clientId;
  let isMultiSelected = false;

  while (ancestorClientId && !isMultiSelected) {
    ancestorClientId = getBlockRootClientId(state, ancestorClientId);
    isMultiSelected = isBlockMultiSelected(state, ancestorClientId);
  }

  return isMultiSelected;
}, state => [state.blocks.order, state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId]);
/**
 * Returns the client ID of the block which begins the multi-selection set, or
 * null if there is no multi-selection.
 *
 * This is not necessarily the first client ID in the selection.
 *
 * @see getFirstMultiSelectedBlockClientId
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Client ID of block beginning multi-selection.
 */

function getMultiSelectedBlocksStartClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === selectionEnd.clientId) {
    return null;
  }

  return selectionStart.clientId || null;
}
/**
 * Returns the client ID of the block which ends the multi-selection set, or
 * null if there is no multi-selection.
 *
 * This is not necessarily the last client ID in the selection.
 *
 * @see getLastMultiSelectedBlockClientId
 *
 * @param {Object} state Editor state.
 *
 * @return {?string} Client ID of block ending multi-selection.
 */

function getMultiSelectedBlocksEndClientId(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId === selectionEnd.clientId) {
    return null;
  }

  return selectionEnd.clientId || null;
}
/**
 * Returns an array containing all block client IDs in the editor in the order
 * they appear. Optionally accepts a root client ID of the block list for which
 * the order should be returned, defaulting to the top-level block order.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Array} Ordered client IDs of editor blocks.
 */

function getBlockOrder(state, rootClientId) {
  return state.blocks.order[rootClientId || ''] || EMPTY_ARRAY;
}
/**
 * Returns the index at which the block corresponding to the specified client
 * ID occurs within the block order, or `-1` if the block does not exist.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientId     Block client ID.
 *
 * @return {number} Index at which block exists in order.
 */

function getBlockIndex(state, clientId) {
  const rootClientId = getBlockRootClientId(state, clientId);
  return getBlockOrder(state, rootClientId).indexOf(clientId);
}
/**
 * Returns true if the block corresponding to the specified client ID is
 * currently selected and no multi-selection exists, or false otherwise.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is selected and multi-selection exists.
 */

function isBlockSelected(state, clientId) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;

  if (selectionStart.clientId !== selectionEnd.clientId) {
    return false;
  }

  return selectionStart.clientId === clientId;
}
/**
 * Returns true if one of the block's inner blocks is selected.
 *
 * @param {Object}  state    Editor state.
 * @param {string}  clientId Block client ID.
 * @param {boolean} deep     Perform a deep check.
 *
 * @return {boolean} Whether the block as an inner block selected
 */

function hasSelectedInnerBlock(state, clientId) {
  let deep = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return Object(external_lodash_["some"])(getBlockOrder(state, clientId), innerClientId => isBlockSelected(state, innerClientId) || isBlockMultiSelected(state, innerClientId) || deep && hasSelectedInnerBlock(state, innerClientId, deep));
}
/**
 * Returns true if the block corresponding to the specified client ID is
 * currently selected but isn't the last of the selected blocks. Here "last"
 * refers to the block sequence in the document, _not_ the sequence of
 * multi-selection, which is why `state.selectionEnd` isn't used.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {boolean} Whether block is selected and not the last in the
 *                   selection.
 */

function isBlockWithinSelection(state, clientId) {
  if (!clientId) {
    return false;
  }

  const clientIds = getMultiSelectedBlockClientIds(state);
  const index = clientIds.indexOf(clientId);
  return index > -1 && index < clientIds.length - 1;
}
/**
 * Returns true if a multi-selection has been made, or false otherwise.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Whether multi-selection has been made.
 */

function hasMultiSelection(state) {
  const {
    selectionStart,
    selectionEnd
  } = state.selection;
  return selectionStart.clientId !== selectionEnd.clientId;
}
/**
 * Whether in the process of multi-selecting or not. This flag is only true
 * while the multi-selection is being selected (by mouse move), and is false
 * once the multi-selection has been settled.
 *
 * @see hasMultiSelection
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} True if multi-selecting, false if not.
 */

function selectors_isMultiSelecting(state) {
  return state.isMultiSelecting;
}
/**
 * Selector that returns if multi-selection is enabled or not.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} True if it should be possible to multi-select blocks, false if multi-selection is disabled.
 */

function selectors_isSelectionEnabled(state) {
  return state.isSelectionEnabled;
}
/**
 * Returns the block's editing mode, defaulting to "visual" if not explicitly
 * assigned.
 *
 * @param {Object} state    Editor state.
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Block editing mode.
 */

function getBlockMode(state, clientId) {
  return state.blocksMode[clientId] || 'visual';
}
/**
 * Returns true if the user is typing, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether user is typing.
 */

function selectors_isTyping(state) {
  return state.isTyping;
}
/**
 * Returns true if the user is dragging blocks, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether user is dragging blocks.
 */

function isDraggingBlocks(state) {
  return !!state.draggedBlocks.length;
}
/**
 * Returns the client ids of any blocks being directly dragged.
 *
 * This does not include children of a parent being dragged.
 *
 * @param {Object} state Global application state.
 *
 * @return {string[]} Array of dragged block client ids.
 */

function getDraggedBlockClientIds(state) {
  return state.draggedBlocks;
}
/**
 * Returns whether the block is being dragged.
 *
 * Only returns true if the block is being directly dragged,
 * not if the block is a child of a parent being dragged.
 * See `isAncestorBeingDragged` for child blocks.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId Client id for block to check.
 *
 * @return {boolean} Whether the block is being dragged.
 */

function isBlockBeingDragged(state, clientId) {
  return state.draggedBlocks.includes(clientId);
}
/**
 * Returns whether a parent/ancestor of the block is being dragged.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId Client id for block to check.
 *
 * @return {boolean} Whether the block's ancestor is being dragged.
 */

function isAncestorBeingDragged(state, clientId) {
  // Return early if no blocks are being dragged rather than
  // the more expensive check for parents.
  if (!isDraggingBlocks(state)) {
    return false;
  }

  const parents = getBlockParents(state, clientId);
  return Object(external_lodash_["some"])(parents, parentClientId => isBlockBeingDragged(state, parentClientId));
}
/**
 * Returns true if the caret is within formatted text, or false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the caret is within formatted text.
 */

function selectors_isCaretWithinFormattedText(state) {
  return state.isCaretWithinFormattedText;
}
/**
 * Returns the insertion point, the index at which the new inserted block would
 * be placed. Defaults to the last index.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object} Insertion point object with `rootClientId`, `index`.
 */

function getBlockInsertionPoint(state) {
  let rootClientId, index;
  const {
    insertionPoint,
    selection: {
      selectionEnd
    }
  } = state;

  if (insertionPoint !== null) {
    return insertionPoint;
  }

  const {
    clientId
  } = selectionEnd;

  if (clientId) {
    rootClientId = getBlockRootClientId(state, clientId) || undefined;
    index = getBlockIndex(state, selectionEnd.clientId, rootClientId) + 1;
  } else {
    index = getBlockOrder(state).length;
  }

  return {
    rootClientId,
    index
  };
}
/**
 * Returns true if we should show the block insertion point.
 *
 * @param {Object} state Global application state.
 *
 * @return {?boolean} Whether the insertion point is visible or not.
 */

function isBlockInsertionPointVisible(state) {
  return state.insertionPoint !== null;
}
/**
 * Returns whether the blocks matches the template or not.
 *
 * @param {boolean} state
 * @return {?boolean} Whether the template is valid or not.
 */

function selectors_isValidTemplate(state) {
  return state.template.isValid;
}
/**
 * Returns the defined block template
 *
 * @param {boolean} state
 *
 * @return {?Array} Block Template.
 */

function getTemplate(state) {
  return state.settings.template;
}
/**
 * Returns the defined block template lock. Optionally accepts a root block
 * client ID as context, otherwise defaulting to the global context.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional block root client ID.
 *
 * @return {?string} Block Template Lock
 */

function getTemplateLock(state, rootClientId) {
  if (!rootClientId) {
    return state.settings.templateLock;
  }

  const blockListSettings = getBlockListSettings(state, rootClientId);

  if (!blockListSettings) {
    return null;
  }

  return blockListSettings.templateLock;
}

const checkAllowList = function (list, item) {
  let defaultResult = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

  if (Object(external_lodash_["isBoolean"])(list)) {
    return list;
  }

  if (Object(external_lodash_["isArray"])(list)) {
    // TODO: when there is a canonical way to detect that we are editing a post
    // the following check should be changed to something like:
    // if ( list.includes( 'core/post-content' ) && getEditorMode() === 'post-content' && item === null )
    if (list.includes('core/post-content') && item === null) {
      return true;
    }

    return list.includes(item);
  }

  return defaultResult;
};
/**
 * Determines if the given block type is allowed to be inserted into the block list.
 * This function is not exported and not memoized because using a memoized selector
 * inside another memoized selector is just a waste of time.
 *
 * @param {Object}        state        Editor state.
 * @param {string|Object} blockName    The block type object, e.g., the response
 *                                     from the block directory; or a string name of
 *                                     an installed block type, e.g.' core/paragraph'.
 * @param {?string}       rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be inserted.
 */


const canInsertBlockTypeUnmemoized = function (state, blockName) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  let blockType;

  if (blockName && 'object' === typeof blockName) {
    blockType = blockName;
    blockName = blockType.name;
  } else {
    blockType = Object(external_wp_blocks_["getBlockType"])(blockName);
  }

  if (!blockType) {
    return false;
  }

  const {
    allowedBlockTypes
  } = getSettings(state);
  const isBlockAllowedInEditor = checkAllowList(allowedBlockTypes, blockName, true);

  if (!isBlockAllowedInEditor) {
    return false;
  }

  const isLocked = !!getTemplateLock(state, rootClientId);

  if (isLocked) {
    return false;
  }

  const parentBlockListSettings = getBlockListSettings(state, rootClientId); // The parent block doesn't have settings indicating it doesn't support
  // inner blocks, return false.

  if (rootClientId && parentBlockListSettings === undefined) {
    return false;
  }

  const parentAllowedBlocks = parentBlockListSettings === null || parentBlockListSettings === void 0 ? void 0 : parentBlockListSettings.allowedBlocks;
  const hasParentAllowedBlock = checkAllowList(parentAllowedBlocks, blockName);
  const blockAllowedParentBlocks = blockType.parent;
  const parentName = getBlockName(state, rootClientId);
  const hasBlockAllowedParent = checkAllowList(blockAllowedParentBlocks, parentName);
  const canInsert = hasParentAllowedBlock === null && hasBlockAllowedParent === null || hasParentAllowedBlock === true || hasBlockAllowedParent === true;

  if (!canInsert) {
    return canInsert;
  }
  /**
   * This filter is an ad-hoc solution to prevent adding template parts inside post content.
   * Conceptually, having a filter inside a selector is bad pattern so this code will be
   * replaced by a declarative API that doesn't the following drawbacks:
   *
   * Filters are not reactive: Upon switching between "template mode" and non "template mode",
   * the filter and selector won't necessarily be executed again. For now, it doesn't matter much
   * because you can't switch between the two modes while the inserter stays open.
   *
   * Filters are global: Once they're defined, they will affect all editor instances and all registries.
   * An ideal API would only affect specific editor instances.
   */


  return Object(external_wp_hooks_["applyFilters"])('blockEditor.__unstableCanInsertBlockType', canInsert, blockType, rootClientId, {
    // Pass bound selectors of the current registry. If we're in a nested
    // context, the data will differ from the one selected from the root
    // registry.
    getBlock: getBlock.bind(null, state),
    getBlockParentsByBlockName: getBlockParentsByBlockName.bind(null, state)
  });
};
/**
 * Determines if the given block type is allowed to be inserted into the block list.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  blockName    The name of the block type, e.g.' core/paragraph'.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be inserted.
 */


const canInsertBlockType = Object(rememo["a" /* default */])(canInsertBlockTypeUnmemoized, (state, blockName, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId[rootClientId], state.settings.allowedBlockTypes, state.settings.templateLock]);
/**
 * Determines if the given blocks are allowed to be inserted into the block
 * list.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be inserted.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be inserted.
 */

function canInsertBlocks(state, clientIds) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return clientIds.every(id => canInsertBlockType(state, getBlockName(state, id), rootClientId));
}
/**
 * Determines if the given block is allowed to be deleted.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientId     The block client Id.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block is allowed to be removed.
 */

function canRemoveBlock(state, clientId) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  const attributes = getBlockAttributes(state, clientId); // attributes can be null if the block is already deleted.

  if (attributes === null) {
    return true;
  }

  const {
    lock
  } = attributes;
  const parentIsLocked = !!getTemplateLock(state, rootClientId); // If we don't have a lock on the blockType level, we differ to the parent templateLock.

  if (lock === undefined || (lock === null || lock === void 0 ? void 0 : lock.remove) === undefined) {
    return !parentIsLocked;
  } // when remove is true, it means we cannot remove it.


  return !(lock !== null && lock !== void 0 && lock.remove);
}
/**
 * Determines if the given blocks are allowed to be removed.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be removed.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be removed.
 */

function selectors_canRemoveBlocks(state, clientIds) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return clientIds.every(clientId => canRemoveBlock(state, clientId, rootClientId));
}
/**
 * Determines if the given block is allowed to be moved.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientId     The block client Id.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block is allowed to be moved.
 */

function canMoveBlock(state, clientId) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  const attributes = getBlockAttributes(state, clientId);

  if (attributes === null) {
    return;
  }

  const {
    lock
  } = attributes;
  const parentIsLocked = getTemplateLock(state, rootClientId) === 'all'; // If we don't have a lock on the blockType level, we differ to the parent templateLock.

  if (lock === undefined || (lock === null || lock === void 0 ? void 0 : lock.move) === undefined) {
    return !parentIsLocked;
  } // when move is true, it means we cannot move it.


  return !(lock !== null && lock !== void 0 && lock.move);
}
/**
 * Determines if the given blocks are allowed to be moved.
 *
 * @param {Object}  state        Editor state.
 * @param {string}  clientIds    The block client IDs to be moved.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given blocks are allowed to be moved.
 */

function selectors_canMoveBlocks(state, clientIds) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  return clientIds.every(clientId => canMoveBlock(state, clientId, rootClientId));
}
/**
 * Returns information about how recently and frequently a block has been inserted.
 *
 * @param {Object} state Global application state.
 * @param {string} id    A string which identifies the insert, e.g. 'core/block/12'
 *
 * @return {?{ time: number, count: number }} An object containing `time` which is when the last
 *                                            insert occurred as a UNIX epoch, and `count` which is
 *                                            the number of inserts that have occurred.
 */

function getInsertUsage(state, id) {
  var _state$preferences$in, _state$preferences$in2;

  return (_state$preferences$in = (_state$preferences$in2 = state.preferences.insertUsage) === null || _state$preferences$in2 === void 0 ? void 0 : _state$preferences$in2[id]) !== null && _state$preferences$in !== void 0 ? _state$preferences$in : null;
}
/**
 * Returns whether we can show a block type in the inserter
 *
 * @param {Object}  state        Global State
 * @param {Object}  blockType    BlockType
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Whether the given block type is allowed to be shown in the inserter.
 */


const canIncludeBlockTypeInInserter = (state, blockType, rootClientId) => {
  if (!Object(external_wp_blocks_["hasBlockSupport"])(blockType, 'inserter', true)) {
    return false;
  }

  return canInsertBlockTypeUnmemoized(state, blockType.name, rootClientId);
};
/**
 * Return a function to be used to tranform a block variation to an inserter item
 *
 * @param {Object} state Global State
 * @param {Object} item  Denormalized inserter item
 * @return {Function} Function to transform a block variation to inserter item
 */


const getItemFromVariation = (state, item) => variation => {
  const variationId = `${item.id}/${variation.name}`;
  const {
    time,
    count = 0
  } = getInsertUsage(state, variationId) || {};
  return { ...item,
    id: variationId,
    icon: variation.icon || item.icon,
    title: variation.title || item.title,
    description: variation.description || item.description,
    category: variation.category || item.category,
    // If `example` is explicitly undefined for the variation, the preview will not be shown.
    example: variation.hasOwnProperty('example') ? variation.example : item.example,
    initialAttributes: { ...item.initialAttributes,
      ...variation.attributes
    },
    innerBlocks: variation.innerBlocks,
    keywords: variation.keywords || item.keywords,
    frecency: calculateFrecency(time, count)
  };
};
/**
 * Returns the calculated frecency.
 *
 * 'frecency' is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * @param {number} time  When the last insert occurred as a UNIX epoch
 * @param {number} count The number of inserts that have occurred.
 *
 * @return {number} The calculated frecency.
 */


const calculateFrecency = (time, count) => {
  if (!time) {
    return count;
  } // The selector is cached, which means Date.now() is the last time that the
  // relevant state changed. This suits our needs.


  const duration = Date.now() - time;

  switch (true) {
    case duration < MILLISECONDS_PER_HOUR:
      return count * 4;

    case duration < MILLISECONDS_PER_DAY:
      return count * 2;

    case duration < MILLISECONDS_PER_WEEK:
      return count / 2;

    default:
      return count / 4;
  }
};
/**
 * Returns a function that accepts a block type and builds an item to be shown
 * in a specific context. It's used for building items for Inserter and available
 * block Transfroms list.
 *
 * @param {Object} state              Editor state.
 * @param {Object} options            Options object for handling the building of a block type.
 * @param {string} options.buildScope The scope for which the item is going to be used.
 * @return {Function} Function returns an item to be shown in a specific context (Inserter|Transforms list).
 */


const buildBlockTypeItem = (state, _ref3) => {
  let {
    buildScope = 'inserter'
  } = _ref3;
  return blockType => {
    const id = blockType.name;
    let isDisabled = false;

    if (!Object(external_wp_blocks_["hasBlockSupport"])(blockType.name, 'multiple', true)) {
      isDisabled = Object(external_lodash_["some"])(getBlocksByClientId(state, getClientIdsWithDescendants(state)), {
        name: blockType.name
      });
    }

    const {
      time,
      count = 0
    } = getInsertUsage(state, id) || {};
    const blockItemBase = {
      id,
      name: blockType.name,
      title: blockType.title,
      icon: blockType.icon,
      isDisabled,
      frecency: calculateFrecency(time, count)
    };
    if (buildScope === 'transform') return blockItemBase;
    const inserterVariations = Object(external_wp_blocks_["getBlockVariations"])(blockType.name, 'inserter');
    return { ...blockItemBase,
      initialAttributes: {},
      description: blockType.description,
      category: blockType.category,
      keywords: blockType.keywords,
      variations: inserterVariations,
      example: blockType.example,
      utility: 1 // deprecated

    };
  };
};
/**
 * Determines the items that appear in the inserter. Includes both static
 * items (e.g. a regular block type) and dynamic items (e.g. a reusable block).
 *
 * Each item object contains what's necessary to display a button in the
 * inserter and handle its selection.
 *
 * The 'frecency' property is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * Items are returned ordered descendingly by their 'utility' and 'frecency'.
 *
 * @param    {Object}   state             Editor state.
 * @param    {?string}  rootClientId      Optional root client ID of block list.
 *
 * @return {WPEditorInserterItem[]} Items that appear in inserter.
 *
 * @typedef {Object} WPEditorInserterItem
 * @property {string}   id                Unique identifier for the item.
 * @property {string}   name              The type of block to create.
 * @property {Object}   initialAttributes Attributes to pass to the newly created block.
 * @property {string}   title             Title of the item, as it appears in the inserter.
 * @property {string}   icon              Dashicon for the item, as it appears in the inserter.
 * @property {string}   category          Block category that the item is associated with.
 * @property {string[]} keywords          Keywords that can be searched to find this item.
 * @property {boolean}  isDisabled        Whether or not the user should be prevented from inserting
 *                                        this item.
 * @property {number}   frecency          Heuristic that combines frequency and recency.
 */


const getInserterItems = Object(rememo["a" /* default */])(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  const buildBlockTypeInserterItem = buildBlockTypeItem(state, {
    buildScope: 'inserter'
  });
  /*
   * Matches block comment delimiters amid serialized content.
   *
   * @see `tokenizer` in `@wordpress/block-serialization-default-parser`
   * package
   *
   * blockParserTokenizer differs from the original tokenizer in the
   * following ways:
   *
   * - removed global flag (/g)
   * - prepended ^\s*
   *
   */

  const blockParserTokenizer = /^\s*<!--\s+(\/)?wp:([a-z][a-z0-9_-]*\/)?([a-z][a-z0-9_-]*)\s+({(?:(?=([^}]+|}+(?=})|(?!}\s+\/?-->)[^])*)\5|[^]*?)}\s+)?(\/)?-->/;

  const buildReusableBlockInserterItem = reusableBlock => {
    let icon = symbol["a" /* default */];
    /*
     * Instead of always displaying a generic "symbol" icon for every
     * reusable block, try to use an icon that represents the first
     * outermost block contained in the reusable block. This requires
     * scanning the serialized form of the reusable block to find its
     * first block delimiter, then looking up the corresponding block
     * type, if available.
     */

    if (external_wp_element_["Platform"].OS === 'web') {
      const content = typeof reusableBlock.content.raw === 'string' ? reusableBlock.content.raw : reusableBlock.content;
      const rawBlockMatch = content.match(blockParserTokenizer);

      if (rawBlockMatch) {
        const [,, namespace = 'core/', blockName] = rawBlockMatch;
        const referencedBlockType = Object(external_wp_blocks_["getBlockType"])(namespace + blockName);

        if (referencedBlockType) {
          icon = referencedBlockType.icon;
        }
      }
    }

    const id = `core/block/${reusableBlock.id}`;
    const {
      time,
      count = 0
    } = getInsertUsage(state, id) || {};
    const frecency = calculateFrecency(time, count);
    return {
      id,
      name: 'core/block',
      initialAttributes: {
        ref: reusableBlock.id
      },
      title: reusableBlock.title.raw,
      icon,
      category: 'reusable',
      keywords: [],
      isDisabled: false,
      utility: 1,
      // deprecated
      frecency
    };
  };

  const blockTypeInserterItems = Object(external_wp_blocks_["getBlockTypes"])().filter(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId)).map(buildBlockTypeInserterItem);
  const reusableBlockInserterItems = canInsertBlockTypeUnmemoized(state, 'core/block', rootClientId) ? getReusableBlocks(state).map(buildReusableBlockInserterItem) : [];
  const items = blockTypeInserterItems.reduce((accumulator, item) => {
    const {
      variations = []
    } = item; // Exclude any block type item that is to be replaced by a default variation

    if (!variations.some(_ref4 => {
      let {
        isDefault
      } = _ref4;
      return isDefault;
    })) {
      accumulator.push(item);
    }

    if (variations.length) {
      const variationMapper = getItemFromVariation(state, item);
      accumulator.push(...variations.map(variationMapper));
    }

    return accumulator;
  }, []); // Ensure core blocks are prioritized in the returned results,
  // because third party blocks can be registered earlier than
  // the core blocks (usually by using the `init` action),
  // thus affecting the display order.
  // We don't sort reusable blocks as they are handled differently.

  const groupByType = (blocks, block) => {
    const {
      core,
      noncore
    } = blocks;
    const type = block.name.startsWith('core/') ? core : noncore;
    type.push(block);
    return blocks;
  };

  const {
    core: coreItems,
    noncore: nonCoreItems
  } = items.reduce(groupByType, {
    core: [],
    noncore: []
  });
  const sortedBlockTypes = [...coreItems, ...nonCoreItems];
  return [...sortedBlockTypes, ...reusableBlockInserterItems];
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.blocks.order, state.preferences.insertUsage, state.settings.allowedBlockTypes, state.settings.templateLock, getReusableBlocks(state), Object(external_wp_blocks_["getBlockTypes"])()]);
/**
 * Determines the items that appear in the available block transforms list.
 *
 * Each item object contains what's necessary to display a menu item in the
 * transform list and handle its selection.
 *
 * The 'frecency' property is a heuristic (https://en.wikipedia.org/wiki/Frecency)
 * that combines block usage frequenty and recency.
 *
 * Items are returned ordered descendingly by their 'frecency'.
 *
 * @param    {Object}  state        Editor state.
 * @param    {?string} rootClientId Optional root client ID of block list.
 *
 * @return {WPEditorTransformItem[]} Items that appear in inserter.
 *
 * @typedef {Object} WPEditorTransformItem
 * @property {string}  id           Unique identifier for the item.
 * @property {string}  name         The type of block to create.
 * @property {string}  title        Title of the item, as it appears in the inserter.
 * @property {string}  icon         Dashicon for the item, as it appears in the inserter.
 * @property {boolean} isDisabled   Whether or not the user should be prevented from inserting
 *                                  this item.
 * @property {number}  frecency     Heuristic that combines frequency and recency.
 */

const getBlockTransformItems = Object(rememo["a" /* default */])(function (state, blocks) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  const buildBlockTypeTransformItem = buildBlockTypeItem(state, {
    buildScope: 'transform'
  });
  const blockTypeTransformItems = Object(external_wp_blocks_["getBlockTypes"])().filter(blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId)).map(buildBlockTypeTransformItem);
  const itemsByName = Object(external_lodash_["mapKeys"])(blockTypeTransformItems, _ref5 => {
    let {
      name
    } = _ref5;
    return name;
  });
  const possibleTransforms = Object(external_wp_blocks_["getPossibleBlockTransformations"])(blocks).reduce((accumulator, block) => {
    if (itemsByName[block === null || block === void 0 ? void 0 : block.name]) {
      accumulator.push(itemsByName[block.name]);
    }

    return accumulator;
  }, []);
  const possibleBlockTransformations = Object(external_lodash_["orderBy"])(possibleTransforms, block => itemsByName[block.name].frecency, 'desc');
  return possibleBlockTransformations;
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.preferences.insertUsage, state.settings.allowedBlockTypes, state.settings.templateLock, Object(external_wp_blocks_["getBlockTypes"])()]);
/**
 * Determines whether there are items to show in the inserter.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {boolean} Items that appear in inserter.
 */

const hasInserterItems = Object(rememo["a" /* default */])(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  const hasBlockType = Object(external_lodash_["some"])(Object(external_wp_blocks_["getBlockTypes"])(), blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId));

  if (hasBlockType) {
    return true;
  }

  const hasReusableBlock = canInsertBlockTypeUnmemoized(state, 'core/block', rootClientId) && getReusableBlocks(state).length > 0;
  return hasReusableBlock;
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.settings.allowedBlockTypes, state.settings.templateLock, getReusableBlocks(state), Object(external_wp_blocks_["getBlockTypes"])()]);
/**
 * Returns the list of allowed inserter blocks for inner blocks children
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {Array?} The list of allowed block types.
 */

const __experimentalGetAllowedBlocks = Object(rememo["a" /* default */])(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

  if (!rootClientId) {
    return;
  }

  return Object(external_lodash_["filter"])(Object(external_wp_blocks_["getBlockTypes"])(), blockType => canIncludeBlockTypeInInserter(state, blockType, rootClientId));
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.byClientId, state.settings.allowedBlockTypes, state.settings.templateLock, Object(external_wp_blocks_["getBlockTypes"])()]);
/**
 * Returns the block to be directly inserted by the block appender.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional root client ID of block list.
 *
 * @return {?Array} The block type to be directly inserted.
 */

const __experimentalGetDirectInsertBlock = Object(rememo["a" /* default */])(function (state) {
  var _state$blockListSetti, _state$blockListSetti2;

  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

  if (!rootClientId) {
    return;
  }

  const defaultBlock = (_state$blockListSetti = state.blockListSettings[rootClientId]) === null || _state$blockListSetti === void 0 ? void 0 : _state$blockListSetti.__experimentalDefaultBlock;
  const directInsert = (_state$blockListSetti2 = state.blockListSettings[rootClientId]) === null || _state$blockListSetti2 === void 0 ? void 0 : _state$blockListSetti2.__experimentalDirectInsert;

  if (!defaultBlock || !directInsert) {
    return;
  }

  if (typeof directInsert === 'function') {
    return directInsert(getBlock(state, rootClientId)) ? defaultBlock : null;
  }

  return defaultBlock;
}, (state, rootClientId) => [state.blockListSettings[rootClientId], state.blocks.tree[rootClientId]]);

const checkAllowListRecursive = (blocks, allowedBlockTypes) => {
  if (Object(external_lodash_["isBoolean"])(allowedBlockTypes)) {
    return allowedBlockTypes;
  }

  const blocksQueue = [...blocks];

  while (blocksQueue.length > 0) {
    var _block$innerBlocks;

    const block = blocksQueue.shift();
    const isAllowed = checkAllowList(allowedBlockTypes, block.name || block.blockName, true);

    if (!isAllowed) {
      return false;
    }

    (_block$innerBlocks = block.innerBlocks) === null || _block$innerBlocks === void 0 ? void 0 : _block$innerBlocks.forEach(innerBlock => {
      blocksQueue.push(innerBlock);
    });
  }

  return true;
};

const __experimentalGetParsedPattern = Object(rememo["a" /* default */])((state, patternName) => {
  const patterns = state.settings.__experimentalBlockPatterns;
  const pattern = patterns.find(_ref6 => {
    let {
      name
    } = _ref6;
    return name === patternName;
  });

  if (!pattern) {
    return null;
  }

  return { ...pattern,
    blocks: Object(external_wp_blocks_["parse"])(pattern.content)
  };
}, state => [state.settings.__experimentalBlockPatterns]);
const getAllAllowedPatterns = Object(rememo["a" /* default */])(state => {
  const patterns = state.settings.__experimentalBlockPatterns;
  const {
    allowedBlockTypes
  } = getSettings(state);
  const parsedPatterns = patterns.filter(_ref7 => {
    let {
      inserter = true
    } = _ref7;
    return !!inserter;
  }).map(_ref8 => {
    let {
      name
    } = _ref8;
    return __experimentalGetParsedPattern(state, name);
  });
  const allowedPatterns = parsedPatterns.filter(_ref9 => {
    let {
      blocks
    } = _ref9;
    return checkAllowListRecursive(blocks, allowedBlockTypes);
  });
  return allowedPatterns;
}, state => [state.settings.__experimentalBlockPatterns, state.settings.allowedBlockTypes]);
/**
 * Returns the list of allowed patterns for inner blocks children.
 *
 * @param {Object}  state        Editor state.
 * @param {?string} rootClientId Optional target root client ID.
 *
 * @return {Array?} The list of allowed patterns.
 */

const __experimentalGetAllowedPatterns = Object(rememo["a" /* default */])(function (state) {
  let rootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  const availableParsedPatterns = getAllAllowedPatterns(state);
  const patternsAllowed = Object(external_lodash_["filter"])(availableParsedPatterns, _ref10 => {
    let {
      blocks
    } = _ref10;
    return blocks.every(_ref11 => {
      let {
        name
      } = _ref11;
      return canInsertBlockType(state, name, rootClientId);
    });
  });
  return patternsAllowed;
}, (state, rootClientId) => [state.settings.__experimentalBlockPatterns, state.settings.allowedBlockTypes, state.settings.templateLock, state.blockListSettings[rootClientId], state.blocks.byClientId[rootClientId]]);
/**
 * Returns the list of patterns based on their declared `blockTypes`
 * and a block's name.
 * Patterns can use `blockTypes` to integrate in work flows like
 * suggesting appropriate patterns in a Placeholder state(during insertion)
 * or blocks transformations.
 *
 * @param {Object}          state        Editor state.
 * @param {string|string[]} blockNames   Block's name or array of block names to find matching pattens.
 * @param {?string}         rootClientId Optional target root client ID.
 *
 * @return {Array} The list of matched block patterns based on declared `blockTypes` and block name.
 */

const __experimentalGetPatternsByBlockTypes = Object(rememo["a" /* default */])(function (state, blockNames) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  if (!blockNames) return EMPTY_ARRAY;

  const patterns = __experimentalGetAllowedPatterns(state, rootClientId);

  const normalizedBlockNames = Array.isArray(blockNames) ? blockNames : [blockNames];
  return patterns.filter(pattern => {
    var _pattern$blockTypes, _pattern$blockTypes$s;

    return pattern === null || pattern === void 0 ? void 0 : (_pattern$blockTypes = pattern.blockTypes) === null || _pattern$blockTypes === void 0 ? void 0 : (_pattern$blockTypes$s = _pattern$blockTypes.some) === null || _pattern$blockTypes$s === void 0 ? void 0 : _pattern$blockTypes$s.call(_pattern$blockTypes, blockName => normalizedBlockNames.includes(blockName));
  });
}, (state, rootClientId) => [...__experimentalGetAllowedPatterns.getDependants(state, rootClientId)]);
/**
 * Determines the items that appear in the available pattern transforms list.
 *
 * For now we only handle blocks without InnerBlocks and take into account
 * the `__experimentalRole` property of blocks' attributes for the transformation.
 *
 * We return the first set of possible eligible block patterns,
 * by checking the `blockTypes` property. We still have to recurse through
 * block pattern's blocks and try to find matches from the selected blocks.
 * Now this happens in the consumer to avoid heavy operations in the selector.
 *
 * @param {Object}   state        Editor state.
 * @param {Object[]} blocks       The selected blocks.
 * @param {?string}  rootClientId Optional root client ID of block list.
 *
 * @return {WPBlockPattern[]} Items that are eligible for a pattern transformation.
 */

const __experimentalGetPatternTransformItems = Object(rememo["a" /* default */])(function (state, blocks) {
  let rootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
  if (!blocks) return EMPTY_ARRAY;
  /**
   * For now we only handle blocks without InnerBlocks and take into account
   * the `__experimentalRole` property of blocks' attributes for the transformation.
   * Note that the blocks have been retrieved through `getBlock`, which doesn't
   * return the inner blocks of an inner block controller, so we still need
   * to check for this case too.
   */

  if (blocks.some(_ref12 => {
    let {
      clientId,
      innerBlocks
    } = _ref12;
    return innerBlocks.length || areInnerBlocksControlled(state, clientId);
  })) {
    return EMPTY_ARRAY;
  } // Create a Set of the selected block names that is used in patterns filtering.


  const selectedBlockNames = Array.from(new Set(blocks.map(_ref13 => {
    let {
      name
    } = _ref13;
    return name;
  })));
  /**
   * Here we will return first set of possible eligible block patterns,
   * by checking the `blockTypes` property. We still have to recurse through
   * block pattern's blocks and try to find matches from the selected blocks.
   * Now this happens in the consumer to avoid heavy operations in the selector.
   */

  return __experimentalGetPatternsByBlockTypes(state, selectedBlockNames, rootClientId);
}, (state, rootClientId) => [...__experimentalGetPatternsByBlockTypes.getDependants(state, rootClientId)]);
/**
 * Returns the Block List settings of a block, if any exist.
 *
 * @param {Object}  state    Editor state.
 * @param {?string} clientId Block client ID.
 *
 * @return {?Object} Block settings of the block if set.
 */

function getBlockListSettings(state, clientId) {
  return state.blockListSettings[clientId];
}
/**
 * Returns the editor settings.
 *
 * @param {Object} state Editor state.
 *
 * @return {Object} The editor settings object.
 */

function getSettings(state) {
  return state.settings;
}
/**
 * Returns true if the most recent block change is be considered persistent, or
 * false otherwise. A persistent change is one committed by BlockEditorProvider
 * via its `onChange` callback, in addition to `onInput`.
 *
 * @param {Object} state Block editor state.
 *
 * @return {boolean} Whether the most recent block change was persistent.
 */

function isLastBlockChangePersistent(state) {
  return state.blocks.isPersistentChange;
}
/**
 * Returns the block list settings for an array of blocks, if any exist.
 *
 * @param {Object} state     Editor state.
 * @param {Array}  clientIds Block client IDs.
 *
 * @return {Object} An object where the keys are client ids and the values are
 *                  a block list setting object.
 */

const __experimentalGetBlockListSettingsForBlocks = Object(rememo["a" /* default */])(function (state) {
  let clientIds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  return clientIds.reduce((blockListSettingsForBlocks, clientId) => {
    if (!state.blockListSettings[clientId]) {
      return blockListSettingsForBlocks;
    }

    return { ...blockListSettingsForBlocks,
      [clientId]: state.blockListSettings[clientId]
    };
  }, {});
}, state => [state.blockListSettings]);
/**
 * Returns the title of a given reusable block
 *
 * @param {Object}        state Global application state.
 * @param {number|string} ref   The shared block's ID.
 *
 * @return {string} The reusable block saved title.
 */

const __experimentalGetReusableBlockTitle = Object(rememo["a" /* default */])((state, ref) => {
  var _reusableBlock$title;

  const reusableBlock = Object(external_lodash_["find"])(getReusableBlocks(state), block => block.id === ref);

  if (!reusableBlock) {
    return null;
  }

  return (_reusableBlock$title = reusableBlock.title) === null || _reusableBlock$title === void 0 ? void 0 : _reusableBlock$title.raw;
}, state => [getReusableBlocks(state)]);
/**
 * Returns true if the most recent block change is be considered ignored, or
 * false otherwise. An ignored change is one not to be committed by
 * BlockEditorProvider, neither via `onChange` nor `onInput`.
 *
 * @param {Object} state Block editor state.
 *
 * @return {boolean} Whether the most recent block change was ignored.
 */

function __unstableIsLastBlockChangeIgnored(state) {
  // TODO: Removal Plan: Changes incurred by RECEIVE_BLOCKS should not be
  // ignored if in-fact they result in a change in blocks state. The current
  // need to ignore changes not a result of user interaction should be
  // accounted for in the refactoring of reusable blocks as occurring within
  // their own separate block editor / state (#7119).
  return state.blocks.isIgnoredChange;
}
/**
 * Returns the block attributes changed as a result of the last dispatched
 * action.
 *
 * @param {Object} state Block editor state.
 *
 * @return {Object<string,Object>} Subsets of block attributes changed, keyed
 *                                 by block client ID.
 */

function __experimentalGetLastBlockAttributeChanges(state) {
  return state.lastBlockAttributesChange;
}
/**
 * Returns the available reusable blocks
 *
 * @param {Object} state Global application state.
 *
 * @return {Array} Reusable blocks
 */

function getReusableBlocks(state) {
  var _state$settings$__exp, _state$settings;

  return (_state$settings$__exp = state === null || state === void 0 ? void 0 : (_state$settings = state.settings) === null || _state$settings === void 0 ? void 0 : _state$settings.__experimentalReusableBlocks) !== null && _state$settings$__exp !== void 0 ? _state$settings$__exp : EMPTY_ARRAY;
}
/**
 * Returns whether the navigation mode is enabled.
 *
 * @param {Object} state Editor state.
 *
 * @return {boolean} Is navigation mode enabled.
 */


function selectors_isNavigationMode(state) {
  return state.isNavigationMode;
}
/**
 * Returns whether block moving mode is enabled.
 *
 * @param {Object} state Editor state.
 *
 * @return {string} Client Id of moving block.
 */

function selectors_hasBlockMovingClientId(state) {
  return state.hasBlockMovingClientId;
}
/**
 * Returns true if the last change was an automatic change, false otherwise.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the last change was automatic.
 */

function didAutomaticChange(state) {
  return !!state.automaticChangeStatus;
}
/**
 * Returns true if the current highlighted block matches the block clientId.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId The block to check.
 *
 * @return {boolean} Whether the block is currently highlighted.
 */

function isBlockHighlighted(state, clientId) {
  return state.highlightedBlock === clientId;
}
/**
 * Checks if a given block has controlled inner blocks.
 *
 * @param {Object} state    Global application state.
 * @param {string} clientId The block to check.
 *
 * @return {boolean} True if the block has controlled inner blocks.
 */

function areInnerBlocksControlled(state, clientId) {
  return !!state.blocks.controlledInnerBlocks[clientId];
}
/**
 * Returns the clientId for the first 'active' block of a given array of block names.
 * A block is 'active' if it (or a child) is the selected block.
 * Returns the first match moving up the DOM from the selected block.
 *
 * @param {Object}   state            Global application state.
 * @param {string[]} validBlocksNames The names of block types to check for.
 *
 * @return {string} The matching block's clientId.
 */

const __experimentalGetActiveBlockIdByBlockNames = Object(rememo["a" /* default */])((state, validBlockNames) => {
  if (!validBlockNames.length) {
    return null;
  } // Check if selected block is a valid entity area.


  const selectedBlockClientId = getSelectedBlockClientId(state);

  if (validBlockNames.includes(getBlockName(state, selectedBlockClientId))) {
    return selectedBlockClientId;
  } // Check if first selected block is a child of a valid entity area.


  const multiSelectedBlockClientIds = getMultiSelectedBlockClientIds(state);
  const entityAreaParents = getBlockParentsByBlockName(state, selectedBlockClientId || multiSelectedBlockClientIds[0], validBlockNames);

  if (entityAreaParents) {
    // Last parent closest/most interior.
    return Object(external_lodash_["last"])(entityAreaParents);
  }

  return null;
}, (state, validBlockNames) => [state.selection.selectionStart.clientId, state.selection.selectionEnd.clientId, validBlockNames]);
/**
 * Tells if the block with the passed clientId was just inserted.
 *
 * @param {Object}  state    Global application state.
 * @param {Object}  clientId Client Id of the block.
 * @param {?string} source   Optional insertion source of the block.
 * @return {boolean} True if the block matches the last block inserted from the specified source.
 */

function wasBlockJustInserted(state, clientId, source) {
  const {
    lastBlockInserted
  } = state;
  return lastBlockInserted.clientId === clientId && lastBlockInserted.source === source;
}

// EXTERNAL MODULE: external ["wp","a11y"]
var external_wp_a11y_ = __webpack_require__("gdqT");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: external ["wp","richText"]
var external_wp_richText_ = __webpack_require__("qRz9");

// EXTERNAL MODULE: external ["wp","deprecated"]
var external_wp_deprecated_ = __webpack_require__("NMb1");
var external_wp_deprecated_default = /*#__PURE__*/__webpack_require__.n(external_wp_deprecated_);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/actions.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Action which will insert a default block insert action if there
 * are no other blocks at the root of the editor. This action should be used
 * in actions which may result in no blocks remaining in the editor (removal,
 * replacement, etc).
 */

const ensureDefaultBlock = () => _ref => {
  let {
    select,
    dispatch
  } = _ref;
  // To avoid a focus loss when removing the last block, assure there is
  // always a default block if the last of the blocks have been removed.
  const count = select.getBlockCount();

  if (count > 0) {
    return;
  } // If there's an custom appender, don't insert default block.
  // We have to remember to manually move the focus elsewhere to
  // prevent it from being lost though.


  const {
    __unstableHasCustomAppender
  } = select.getSettings();

  if (__unstableHasCustomAppender) {
    return;
  }

  dispatch.insertDefaultBlock();
};
/**
 * Action that resets blocks state to the specified array of blocks, taking precedence
 * over any other content reflected as an edit in state.
 *
 * @param {Array} blocks Array of blocks.
 */


const resetBlocks = blocks => _ref2 => {
  let {
    dispatch
  } = _ref2;
  dispatch({
    type: 'RESET_BLOCKS',
    blocks
  });
  dispatch(validateBlocksToTemplate(blocks));
};
/**
 * Block validity is a function of blocks state (at the point of a
 * reset) and the template setting. As a compromise to its placement
 * across distinct parts of state, it is implemented here as a side-
 * effect of the block reset action.
 *
 * @param {Array} blocks Array of blocks.
 */

const validateBlocksToTemplate = blocks => _ref3 => {
  let {
    select,
    dispatch
  } = _ref3;
  const template = select.getTemplate();
  const templateLock = select.getTemplateLock(); // Unlocked templates are considered always valid because they act
  // as default values only.

  const isBlocksValidToTemplate = !template || templateLock !== 'all' || Object(external_wp_blocks_["doBlocksMatchTemplate"])(blocks, template); // Update if validity has changed.

  const isValidTemplate = select.isValidTemplate();

  if (isBlocksValidToTemplate !== isValidTemplate) {
    dispatch.setTemplateValidity(isBlocksValidToTemplate);
    return isBlocksValidToTemplate;
  }
};
/**
 * A block selection object.
 *
 * @typedef {Object} WPBlockSelection
 *
 * @property {string} clientId     A block client ID.
 * @property {string} attributeKey A block attribute key.
 * @property {number} offset       An attribute value offset, based on the rich
 *                                 text value. See `wp.richText.create`.
 */

/* eslint-disable jsdoc/valid-types */

/**
 * Returns an action object used in signalling that selection state should be
 * reset to the specified selection.
 *
 * @param {WPBlockSelection} selectionStart  The selection start.
 * @param {WPBlockSelection} selectionEnd    The selection end.
 * @param {0|-1|null}        initialPosition Initial block position.
 *
 * @return {Object} Action object.
 */

function resetSelection(selectionStart, selectionEnd, initialPosition) {
  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'RESET_SELECTION',
    selectionStart,
    selectionEnd,
    initialPosition
  };
}
/**
 * Returns an action object used in signalling that blocks have been received.
 * Unlike resetBlocks, these should be appended to the existing known set, not
 * replacing.
 *
 * @deprecated
 *
 * @param {Object[]} blocks Array of block objects.
 *
 * @return {Object} Action object.
 */

function receiveBlocks(blocks) {
  external_wp_deprecated_default()('wp.data.dispatch( "core/block-editor" ).receiveBlocks', {
    since: '5.9',
    alternative: 'resetBlocks or insertBlocks'
  });
  return {
    type: 'RECEIVE_BLOCKS',
    blocks
  };
}
/**
 * Action that updates attributes of multiple blocks with the specified client IDs.
 *
 * @param {string|string[]} clientIds     Block client IDs.
 * @param {Object}          attributes    Block attributes to be merged. Should be keyed by clientIds if
 *                                        uniqueByBlock is true.
 * @param {boolean}         uniqueByBlock true if each block in clientIds array has a unique set of attributes
 * @return {Object} Action object.
 */

function updateBlockAttributes(clientIds, attributes) {
  let uniqueByBlock = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return {
    type: 'UPDATE_BLOCK_ATTRIBUTES',
    clientIds: Object(external_lodash_["castArray"])(clientIds),
    attributes,
    uniqueByBlock
  };
}
/**
 * Action that updates the block with the specified client ID.
 *
 * @param {string} clientId Block client ID.
 * @param {Object} updates  Block attributes to be merged.
 *
 * @return {Object} Action object.
 */

function updateBlock(clientId, updates) {
  return {
    type: 'UPDATE_BLOCK',
    clientId,
    updates
  };
}
/* eslint-disable jsdoc/valid-types */

/**
 * Returns an action object used in signalling that the block with the
 * specified client ID has been selected, optionally accepting a position
 * value reflecting its selection directionality. An initialPosition of -1
 * reflects a reverse selection.
 *
 * @param {string}    clientId        Block client ID.
 * @param {0|-1|null} initialPosition Optional initial position. Pass as -1 to
 *                                    reflect reverse selection.
 *
 * @return {Object} Action object.
 */

function selectBlock(clientId) {
  let initialPosition = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'SELECT_BLOCK',
    initialPosition,
    clientId
  };
}
/**
 * Yields action objects used in signalling that the block preceding the given
 * clientId should be selected.
 *
 * @param {string} clientId Block client ID.
 */

const selectPreviousBlock = clientId => _ref4 => {
  let {
    select,
    dispatch
  } = _ref4;
  const previousBlockClientId = select.getPreviousBlockClientId(clientId);

  if (previousBlockClientId) {
    dispatch.selectBlock(previousBlockClientId, -1);
  }
};
/**
 * Yields action objects used in signalling that the block following the given
 * clientId should be selected.
 *
 * @param {string} clientId Block client ID.
 */

const selectNextBlock = clientId => _ref5 => {
  let {
    select,
    dispatch
  } = _ref5;
  const nextBlockClientId = select.getNextBlockClientId(clientId);

  if (nextBlockClientId) {
    dispatch.selectBlock(nextBlockClientId);
  }
};
/**
 * Action that starts block multi-selection.
 *
 * @return {Object} Action object.
 */

function startMultiSelect() {
  return {
    type: 'START_MULTI_SELECT'
  };
}
/**
 * Action that stops block multi-selection.
 *
 * @return {Object} Action object.
 */

function stopMultiSelect() {
  return {
    type: 'STOP_MULTI_SELECT'
  };
}
/**
 * Action that changes block multi-selection.
 *
 * @param {string} start First block of the multi selection.
 * @param {string} end   Last block of the multiselection.
 */

const multiSelect = (start, end) => _ref6 => {
  let {
    select,
    dispatch
  } = _ref6;
  const startBlockRootClientId = select.getBlockRootClientId(start);
  const endBlockRootClientId = select.getBlockRootClientId(end); // Only allow block multi-selections at the same level.

  if (startBlockRootClientId !== endBlockRootClientId) {
    return;
  }

  dispatch({
    type: 'MULTI_SELECT',
    start,
    end
  });
  const blockCount = select.getSelectedBlockCount();
  Object(external_wp_a11y_["speak"])(Object(external_wp_i18n_["sprintf"])(
  /* translators: %s: number of selected blocks */
  Object(external_wp_i18n_["_n"])('%s block selected.', '%s blocks selected.', blockCount), blockCount), 'assertive');
};
/**
 * Action that clears the block selection.
 *
 * @return {Object} Action object.
 */

function clearSelectedBlock() {
  return {
    type: 'CLEAR_SELECTED_BLOCK'
  };
}
/**
 * Action that enables or disables block selection.
 *
 * @param {boolean} [isSelectionEnabled=true] Whether block selection should
 *                                            be enabled.
 *
 * @return {Object} Action object.
 */

function toggleSelection() {
  let isSelectionEnabled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  return {
    type: 'TOGGLE_SELECTION',
    isSelectionEnabled
  };
}

function getBlocksWithDefaultStylesApplied(blocks, blockEditorSettings) {
  var _blockEditorSettings$, _blockEditorSettings$2;

  const preferredStyleVariations = (_blockEditorSettings$ = blockEditorSettings === null || blockEditorSettings === void 0 ? void 0 : (_blockEditorSettings$2 = blockEditorSettings.__experimentalPreferredStyleVariations) === null || _blockEditorSettings$2 === void 0 ? void 0 : _blockEditorSettings$2.value) !== null && _blockEditorSettings$ !== void 0 ? _blockEditorSettings$ : {};
  return blocks.map(block => {
    var _block$attributes;

    const blockName = block.name;

    if (!Object(external_wp_blocks_["hasBlockSupport"])(blockName, 'defaultStylePicker', true)) {
      return block;
    }

    if (!preferredStyleVariations[blockName]) {
      return block;
    }

    const className = (_block$attributes = block.attributes) === null || _block$attributes === void 0 ? void 0 : _block$attributes.className;

    if (className !== null && className !== void 0 && className.includes('is-style-')) {
      return block;
    }

    const {
      attributes = {}
    } = block;
    const blockStyle = preferredStyleVariations[blockName];
    return { ...block,
      attributes: { ...attributes,
        className: `${className || ''} is-style-${blockStyle}`.trim()
      }
    };
  });
}
/* eslint-disable jsdoc/valid-types */

/**
 * Action that replaces given blocks with one or more replacement blocks.
 *
 * @param {(string|string[])} clientIds       Block client ID(s) to replace.
 * @param {(Object|Object[])} blocks          Replacement block(s).
 * @param {number}            indexToSelect   Index of replacement block to select.
 * @param {0|-1|null}         initialPosition Index of caret after in the selected block after the operation.
 * @param {?Object}           meta            Optional Meta values to be passed to the action object.
 *
 * @return {Object} Action object.
 */


const replaceBlocks = function (clientIds, blocks, indexToSelect) {
  let initialPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
  let meta = arguments.length > 4 ? arguments[4] : undefined;
  return _ref7 => {
    let {
      select,
      dispatch
    } = _ref7;

    /* eslint-enable jsdoc/valid-types */
    clientIds = Object(external_lodash_["castArray"])(clientIds);
    blocks = getBlocksWithDefaultStylesApplied(Object(external_lodash_["castArray"])(blocks), select.getSettings());
    const rootClientId = select.getBlockRootClientId(Object(external_lodash_["first"])(clientIds)); // Replace is valid if the new blocks can be inserted in the root block.

    for (let index = 0; index < blocks.length; index++) {
      const block = blocks[index];
      const canInsertBlock = select.canInsertBlockType(block.name, rootClientId);

      if (!canInsertBlock) {
        return;
      }
    }

    dispatch({
      type: 'REPLACE_BLOCKS',
      clientIds,
      blocks,
      time: Date.now(),
      indexToSelect,
      initialPosition,
      meta
    });
    dispatch(ensureDefaultBlock());
  };
};
/**
 * Action that replaces a single block with one or more replacement blocks.
 *
 * @param {(string|string[])} clientId Block client ID to replace.
 * @param {(Object|Object[])} block    Replacement block(s).
 *
 * @return {Object} Action object.
 */

function replaceBlock(clientId, block) {
  return replaceBlocks(clientId, block);
}
/**
 * Higher-order action creator which, given the action type to dispatch creates
 * an action creator for managing block movement.
 *
 * @param {string} type Action type to dispatch.
 *
 * @return {Function} Action creator.
 */

const createOnMove = type => (clientIds, rootClientId) => _ref8 => {
  let {
    select,
    dispatch
  } = _ref8;
  // If one of the blocks is locked or the parent is locked, we cannot move any block.
  const canMoveBlocks = select.canMoveBlocks(clientIds, rootClientId);

  if (!canMoveBlocks) {
    return;
  }

  dispatch({
    type,
    clientIds: Object(external_lodash_["castArray"])(clientIds),
    rootClientId
  });
};

const moveBlocksDown = createOnMove('MOVE_BLOCKS_DOWN');
const moveBlocksUp = createOnMove('MOVE_BLOCKS_UP');
/**
 * Action that moves given blocks to a new position.
 *
 * @param {?string} clientIds        The client IDs of the blocks.
 * @param {?string} fromRootClientId Root client ID source.
 * @param {?string} toRootClientId   Root client ID destination.
 * @param {number}  index            The index to move the blocks to.
 */

const moveBlocksToPosition = function (clientIds) {
  let fromRootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  let toRootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  let index = arguments.length > 3 ? arguments[3] : undefined;
  return _ref9 => {
    let {
      select,
      dispatch
    } = _ref9;
    const canMoveBlocks = select.canMoveBlocks(clientIds, fromRootClientId); // If one of the blocks is locked or the parent is locked, we cannot move any block.

    if (!canMoveBlocks) {
      return;
    } // If moving inside the same root block the move is always possible.


    if (fromRootClientId !== toRootClientId) {
      const canRemoveBlocks = select.canRemoveBlocks(clientIds, fromRootClientId); // If we're moving to another block, it means we're deleting blocks from
      // the original block, so we need to check if removing is possible.

      if (!canRemoveBlocks) {
        return;
      }

      const canInsertBlocks = select.canInsertBlocks(clientIds, toRootClientId); // If moving to other parent block, the move is possible if we can insert a block of the same type inside the new parent block.

      if (!canInsertBlocks) {
        return;
      }
    }

    dispatch({
      type: 'MOVE_BLOCKS_TO_POSITION',
      fromRootClientId,
      toRootClientId,
      clientIds,
      index
    });
  };
};
/**
 * Action that moves given block to a new position.
 *
 * @param {?string} clientId         The client ID of the block.
 * @param {?string} fromRootClientId Root client ID source.
 * @param {?string} toRootClientId   Root client ID destination.
 * @param {number}  index            The index to move the block to.
 */

function moveBlockToPosition(clientId) {
  let fromRootClientId = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  let toRootClientId = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  let index = arguments.length > 3 ? arguments[3] : undefined;
  return moveBlocksToPosition([clientId], fromRootClientId, toRootClientId, index);
}
/**
 * Action that inserts a single block, optionally at a specific index respective a root block list.
 *
 * @param {Object}   block           Block object to insert.
 * @param {?number}  index           Index at which block should be inserted.
 * @param {?string}  rootClientId    Optional root client ID of block list on which to insert.
 * @param {?boolean} updateSelection If true block selection will be updated. If false, block selection will not change. Defaults to true.
 * @param {?Object}  meta            Optional Meta values to be passed to the action object.
 *
 * @return {Object} Action object.
 */

function insertBlock(block, index, rootClientId, updateSelection, meta) {
  return insertBlocks([block], index, rootClientId, updateSelection, 0, meta);
}
/* eslint-disable jsdoc/valid-types */

/**
 * Action that inserts an array of blocks, optionally at a specific index respective a root block list.
 *
 * @param {Object[]}  blocks          Block objects to insert.
 * @param {?number}   index           Index at which block should be inserted.
 * @param {?string}   rootClientId    Optional root client ID of block list on which to insert.
 * @param {?boolean}  updateSelection If true block selection will be updated.  If false, block selection will not change. Defaults to true.
 * @param {0|-1|null} initialPosition Initial focus position. Setting it to null prevent focusing the inserted block.
 * @param {?Object}   meta            Optional Meta values to be passed to the action object.
 * @return {Object} Action object.
 */

const insertBlocks = function (blocks, index, rootClientId) {
  let updateSelection = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
  let initialPosition = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
  let meta = arguments.length > 5 ? arguments[5] : undefined;
  return _ref10 => {
    let {
      select,
      dispatch
    } = _ref10;

    /* eslint-enable jsdoc/valid-types */
    if (Object(external_lodash_["isObject"])(initialPosition)) {
      meta = initialPosition;
      initialPosition = 0;
      external_wp_deprecated_default()("meta argument in wp.data.dispatch('core/block-editor')", {
        since: '10.1',
        plugin: 'Gutenberg',
        hint: 'The meta argument is now the 6th argument of the function'
      });
    }

    blocks = getBlocksWithDefaultStylesApplied(Object(external_lodash_["castArray"])(blocks), select.getSettings());
    const allowedBlocks = [];

    for (const block of blocks) {
      const isValid = select.canInsertBlockType(block.name, rootClientId);

      if (isValid) {
        allowedBlocks.push(block);
      }
    }

    if (allowedBlocks.length) {
      dispatch({
        type: 'INSERT_BLOCKS',
        blocks: allowedBlocks,
        index,
        rootClientId,
        time: Date.now(),
        updateSelection,
        initialPosition: updateSelection ? initialPosition : null,
        meta
      });
    }
  };
};
/**
 * Action that shows the insertion point.
 *
 * @param {?string} rootClientId      Optional root client ID of block list on
 *                                    which to insert.
 * @param {?number} index             Index at which block should be inserted.
 * @param {Object}  __unstableOptions Wether or not to show an inserter button.
 *
 * @return {Object} Action object.
 */

function showInsertionPoint(rootClientId, index) {
  let __unstableOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  const {
    __unstableWithInserter
  } = __unstableOptions;
  return {
    type: 'SHOW_INSERTION_POINT',
    rootClientId,
    index,
    __unstableWithInserter
  };
}
/**
 * Action that hides the insertion point.
 *
 * @return {Object} Action object.
 */

function hideInsertionPoint() {
  return {
    type: 'HIDE_INSERTION_POINT'
  };
}
/**
 * Action that resets the template validity.
 *
 * @param {boolean} isValid template validity flag.
 *
 * @return {Object} Action object.
 */

function setTemplateValidity(isValid) {
  return {
    type: 'SET_TEMPLATE_VALIDITY',
    isValid
  };
}
/**
 * Action that synchronizes the template with the list of blocks.
 *
 * @return {Object} Action object.
 */

const synchronizeTemplate = () => _ref11 => {
  let {
    select,
    dispatch
  } = _ref11;
  dispatch({
    type: 'SYNCHRONIZE_TEMPLATE'
  });
  const blocks = select.getBlocks();
  const template = select.getTemplate();
  const updatedBlockList = Object(external_wp_blocks_["synchronizeBlocksWithTemplate"])(blocks, template);
  dispatch.resetBlocks(updatedBlockList);
};
/**
 * Action that merges two blocks.
 *
 * @param {string} firstBlockClientId  Client ID of the first block to merge.
 * @param {string} secondBlockClientId Client ID of the second block to merge.
 */

const mergeBlocks = (firstBlockClientId, secondBlockClientId) => _ref12 => {
  let {
    select,
    dispatch
  } = _ref12;
  const blocks = [firstBlockClientId, secondBlockClientId];
  dispatch({
    type: 'MERGE_BLOCKS',
    blocks
  });
  const [clientIdA, clientIdB] = blocks;
  const blockA = select.getBlock(clientIdA);
  const blockAType = Object(external_wp_blocks_["getBlockType"])(blockA.name); // Only focus the previous block if it's not mergeable

  if (blockAType && !blockAType.merge) {
    dispatch.selectBlock(blockA.clientId);
    return;
  }

  const blockB = select.getBlock(clientIdB);
  const blockBType = Object(external_wp_blocks_["getBlockType"])(blockB.name);
  const {
    clientId,
    attributeKey,
    offset
  } = select.getSelectionStart();
  const selectedBlockType = clientId === clientIdA ? blockAType : blockBType;
  const attributeDefinition = selectedBlockType.attributes[attributeKey];
  const canRestoreTextSelection = (clientId === clientIdA || clientId === clientIdB) && attributeKey !== undefined && offset !== undefined && // We cannot restore text selection if the RichText identifier
  // is not a defined block attribute key. This can be the case if the
  // fallback intance ID is used to store selection (and no RichText
  // identifier is set), or when the identifier is wrong.
  !!attributeDefinition;

  if (!attributeDefinition) {
    if (typeof attributeKey === 'number') {
      window.console.error(`RichText needs an identifier prop that is the block attribute key of the attribute it controls. Its type is expected to be a string, but was ${typeof attributeKey}`);
    } else {
      window.console.error('The RichText identifier prop does not match any attributes defined by the block.');
    }
  } // A robust way to retain selection position through various transforms
  // is to insert a special character at the position and then recover it.


  const START_OF_SELECTED_AREA = '\u0086'; // Clone the blocks so we don't insert the character in a "live" block.

  const cloneA = Object(external_wp_blocks_["cloneBlock"])(blockA);
  const cloneB = Object(external_wp_blocks_["cloneBlock"])(blockB);

  if (canRestoreTextSelection) {
    const selectedBlock = clientId === clientIdA ? cloneA : cloneB;
    const html = selectedBlock.attributes[attributeKey];
    const {
      multiline: multilineTag,
      __unstableMultilineWrapperTags: multilineWrapperTags,
      __unstablePreserveWhiteSpace: preserveWhiteSpace
    } = attributeDefinition;
    const value = Object(external_wp_richText_["insert"])(Object(external_wp_richText_["create"])({
      html,
      multilineTag,
      multilineWrapperTags,
      preserveWhiteSpace
    }), START_OF_SELECTED_AREA, offset, offset);
    selectedBlock.attributes[attributeKey] = Object(external_wp_richText_["toHTMLString"])({
      value,
      multilineTag,
      preserveWhiteSpace
    });
  } // We can only merge blocks with similar types
  // thus, we transform the block to merge first


  const blocksWithTheSameType = blockA.name === blockB.name ? [cloneB] : Object(external_wp_blocks_["switchToBlockType"])(cloneB, blockA.name); // If the block types can not match, do nothing

  if (!blocksWithTheSameType || !blocksWithTheSameType.length) {
    return;
  } // Calling the merge to update the attributes and remove the block to be merged


  const updatedAttributes = blockAType.merge(cloneA.attributes, blocksWithTheSameType[0].attributes);

  if (canRestoreTextSelection) {
    const newAttributeKey = Object(external_lodash_["findKey"])(updatedAttributes, v => typeof v === 'string' && v.indexOf(START_OF_SELECTED_AREA) !== -1);
    const convertedHtml = updatedAttributes[newAttributeKey];
    const {
      multiline: multilineTag,
      __unstableMultilineWrapperTags: multilineWrapperTags,
      __unstablePreserveWhiteSpace: preserveWhiteSpace
    } = blockAType.attributes[newAttributeKey];
    const convertedValue = Object(external_wp_richText_["create"])({
      html: convertedHtml,
      multilineTag,
      multilineWrapperTags,
      preserveWhiteSpace
    });
    const newOffset = convertedValue.text.indexOf(START_OF_SELECTED_AREA);
    const newValue = Object(external_wp_richText_["remove"])(convertedValue, newOffset, newOffset + 1);
    const newHtml = Object(external_wp_richText_["toHTMLString"])({
      value: newValue,
      multilineTag,
      preserveWhiteSpace
    });
    updatedAttributes[newAttributeKey] = newHtml;
    dispatch.selectionChange(blockA.clientId, newAttributeKey, newOffset, newOffset);
  }

  dispatch.replaceBlocks([blockA.clientId, blockB.clientId], [{ ...blockA,
    attributes: { ...blockA.attributes,
      ...updatedAttributes
    }
  }, ...blocksWithTheSameType.slice(1)], 0 // If we don't pass the `indexToSelect` it will default to the last block.
  );
};
/**
 * Yields action objects used in signalling that the blocks corresponding to
 * the set of specified client IDs are to be removed.
 *
 * @param {string|string[]} clientIds      Client IDs of blocks to remove.
 * @param {boolean}         selectPrevious True if the previous block should be
 *                                         selected when a block is removed.
 */

const removeBlocks = function (clientIds) {
  let selectPrevious = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  return _ref13 => {
    let {
      select,
      dispatch
    } = _ref13;

    if (!clientIds || !clientIds.length) {
      return;
    }

    clientIds = Object(external_lodash_["castArray"])(clientIds);
    const rootClientId = select.getBlockRootClientId(clientIds[0]);
    const canRemoveBlocks = select.canRemoveBlocks(clientIds, rootClientId);

    if (!canRemoveBlocks) {
      return;
    }

    if (selectPrevious) {
      dispatch.selectPreviousBlock(clientIds[0]);
    }

    dispatch({
      type: 'REMOVE_BLOCKS',
      clientIds
    }); // To avoid a focus loss when removing the last block, assure there is
    // always a default block if the last of the blocks have been removed.

    dispatch(ensureDefaultBlock());
  };
};
/**
 * Returns an action object used in signalling that the block with the
 * specified client ID is to be removed.
 *
 * @param {string}  clientId       Client ID of block to remove.
 * @param {boolean} selectPrevious True if the previous block should be
 *                                 selected when a block is removed.
 *
 * @return {Object} Action object.
 */

function removeBlock(clientId, selectPrevious) {
  return removeBlocks([clientId], selectPrevious);
}
/* eslint-disable jsdoc/valid-types */

/**
 * Returns an action object used in signalling that the inner blocks with the
 * specified client ID should be replaced.
 *
 * @param {string}    rootClientId    Client ID of the block whose InnerBlocks will re replaced.
 * @param {Object[]}  blocks          Block objects to insert as new InnerBlocks
 * @param {?boolean}  updateSelection If true block selection will be updated. If false, block selection will not change. Defaults to false.
 * @param {0|-1|null} initialPosition Initial block position.
 * @return {Object} Action object.
 */

function replaceInnerBlocks(rootClientId, blocks) {
  let updateSelection = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  let initialPosition = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

  /* eslint-enable jsdoc/valid-types */
  return {
    type: 'REPLACE_INNER_BLOCKS',
    rootClientId,
    blocks,
    updateSelection,
    initialPosition: updateSelection ? initialPosition : null,
    time: Date.now()
  };
}
/**
 * Returns an action object used to toggle the block editing mode between
 * visual and HTML modes.
 *
 * @param {string} clientId Block client ID.
 *
 * @return {Object} Action object.
 */

function toggleBlockMode(clientId) {
  return {
    type: 'TOGGLE_BLOCK_MODE',
    clientId
  };
}
/**
 * Returns an action object used in signalling that the user has begun to type.
 *
 * @return {Object} Action object.
 */

function startTyping() {
  return {
    type: 'START_TYPING'
  };
}
/**
 * Returns an action object used in signalling that the user has stopped typing.
 *
 * @return {Object} Action object.
 */

function stopTyping() {
  return {
    type: 'STOP_TYPING'
  };
}
/**
 * Returns an action object used in signalling that the user has begun to drag blocks.
 *
 * @param {string[]} clientIds An array of client ids being dragged
 *
 * @return {Object} Action object.
 */

function startDraggingBlocks() {
  let clientIds = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  return {
    type: 'START_DRAGGING_BLOCKS',
    clientIds
  };
}
/**
 * Returns an action object used in signalling that the user has stopped dragging blocks.
 *
 * @return {Object} Action object.
 */

function stopDraggingBlocks() {
  return {
    type: 'STOP_DRAGGING_BLOCKS'
  };
}
/**
 * Returns an action object used in signalling that the caret has entered formatted text.
 *
 * @return {Object} Action object.
 */

function enterFormattedText() {
  return {
    type: 'ENTER_FORMATTED_TEXT'
  };
}
/**
 * Returns an action object used in signalling that the user caret has exited formatted text.
 *
 * @return {Object} Action object.
 */

function exitFormattedText() {
  return {
    type: 'EXIT_FORMATTED_TEXT'
  };
}
/**
 * Action that changes the position of the user caret.
 *
 * @param {string} clientId     The selected block client ID.
 * @param {string} attributeKey The selected block attribute key.
 * @param {number} startOffset  The start offset.
 * @param {number} endOffset    The end offset.
 *
 * @return {Object} Action object.
 */

function selectionChange(clientId, attributeKey, startOffset, endOffset) {
  return {
    type: 'SELECTION_CHANGE',
    clientId,
    attributeKey,
    startOffset,
    endOffset
  };
}
/**
 * Action that adds a new block of the default type to the block list.
 *
 * @param {?Object} attributes   Optional attributes of the block to assign.
 * @param {?string} rootClientId Optional root client ID of block list on which
 *                               to append.
 * @param {?number} index        Optional index where to insert the default block
 *
 * @return {Object} Action object
 */

function insertDefaultBlock(attributes, rootClientId, index) {
  // Abort if there is no default block type (if it has been unregistered).
  const defaultBlockName = Object(external_wp_blocks_["getDefaultBlockName"])();

  if (!defaultBlockName) {
    return;
  }

  const block = Object(external_wp_blocks_["createBlock"])(defaultBlockName, attributes);
  return insertBlock(block, index, rootClientId);
}
/**
 * Action that changes the nested settings of a given block.
 *
 * @param {string} clientId Client ID of the block whose nested setting are
 *                          being received.
 * @param {Object} settings Object with the new settings for the nested block.
 *
 * @return {Object} Action object
 */

function updateBlockListSettings(clientId, settings) {
  return {
    type: 'UPDATE_BLOCK_LIST_SETTINGS',
    clientId,
    settings
  };
}
/**
 * Action that updates the block editor settings.
 *
 * @param {Object} settings Updated settings
 *
 * @return {Object} Action object
 */

function updateSettings(settings) {
  return {
    type: 'UPDATE_SETTINGS',
    settings
  };
}
/**
 * Action that signals that a temporary reusable block has been saved
 * in order to switch its temporary id with the real id.
 *
 * @param {string} id        Reusable block's id.
 * @param {string} updatedId Updated block's id.
 *
 * @return {Object} Action object.
 */

function __unstableSaveReusableBlock(id, updatedId) {
  return {
    type: 'SAVE_REUSABLE_BLOCK_SUCCESS',
    id,
    updatedId
  };
}
/**
 * Action that marks the last block change explicitly as persistent.
 *
 * @return {Object} Action object.
 */

function __unstableMarkLastChangeAsPersistent() {
  return {
    type: 'MARK_LAST_CHANGE_AS_PERSISTENT'
  };
}
/**
 * Action that signals that the next block change should be marked explicitly as not persistent.
 *
 * @return {Object} Action object.
 */

function __unstableMarkNextChangeAsNotPersistent() {
  return {
    type: 'MARK_NEXT_CHANGE_AS_NOT_PERSISTENT'
  };
}
/**
 * Action that marks the last block change as an automatic change, meaning it was not
 * performed by the user, and can be undone using the `Escape` and `Backspace` keys.
 * This action must be called after the change was made, and any actions that are a
 * consequence of it, so it is recommended to be called at the next idle period to ensure all
 * selection changes have been recorded.
 */

const __unstableMarkAutomaticChange = () => _ref14 => {
  let {
    dispatch
  } = _ref14;
  dispatch({
    type: 'MARK_AUTOMATIC_CHANGE'
  });
  const {
    requestIdleCallback = cb => setTimeout(cb, 100)
  } = window;
  requestIdleCallback(() => {
    dispatch({
      type: 'MARK_AUTOMATIC_CHANGE_FINAL'
    });
  });
};
/**
 * Action that enables or disables the navigation mode.
 *
 * @param {string} isNavigationMode Enable/Disable navigation mode.
 */

const setNavigationMode = function () {
  let isNavigationMode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
  return _ref15 => {
    let {
      dispatch
    } = _ref15;
    dispatch({
      type: 'SET_NAVIGATION_MODE',
      isNavigationMode
    });

    if (isNavigationMode) {
      Object(external_wp_a11y_["speak"])(Object(external_wp_i18n_["__"])('You are currently in navigation mode. Navigate blocks using the Tab key and Arrow keys. Use Left and Right Arrow keys to move between nesting levels. To exit navigation mode and edit the selected block, press Enter.'));
    } else {
      Object(external_wp_a11y_["speak"])(Object(external_wp_i18n_["__"])('You are currently in edit mode. To return to the navigation mode, press Escape.'));
    }
  };
};
/**
 * Action that enables or disables the block moving mode.
 *
 * @param {string|null} hasBlockMovingClientId Enable/Disable block moving mode.
 */

const setBlockMovingClientId = function () {
  let hasBlockMovingClientId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  return _ref16 => {
    let {
      dispatch
    } = _ref16;
    dispatch({
      type: 'SET_BLOCK_MOVING_MODE',
      hasBlockMovingClientId
    });

    if (hasBlockMovingClientId) {
      Object(external_wp_a11y_["speak"])(Object(external_wp_i18n_["__"])('Use the Tab key and Arrow keys to choose new block location. Use Left and Right Arrow keys to move between nesting levels. Once location is selected press Enter or Space to move the block.'));
    }
  };
};
/**
 * Action that duplicates a list of blocks.
 *
 * @param {string[]} clientIds
 * @param {boolean}  updateSelection
 */

const duplicateBlocks = function (clientIds) {
  let updateSelection = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  return _ref17 => {
    let {
      select,
      dispatch
    } = _ref17;

    if (!clientIds || !clientIds.length) {
      return;
    } // Return early if blocks don't exist.


    const blocks = select.getBlocksByClientId(clientIds);

    if (Object(external_lodash_["some"])(blocks, block => !block)) {
      return;
    } // Return early if blocks don't support multiple usage.


    const blockNames = blocks.map(block => block.name);

    if (blockNames.some(blockName => !Object(external_wp_blocks_["hasBlockSupport"])(blockName, 'multiple', true))) {
      return;
    }

    const rootClientId = select.getBlockRootClientId(clientIds[0]);
    const lastSelectedIndex = select.getBlockIndex(Object(external_lodash_["last"])(Object(external_lodash_["castArray"])(clientIds)));
    const clonedBlocks = blocks.map(block => Object(external_wp_blocks_["__experimentalCloneSanitizedBlock"])(block));
    dispatch.insertBlocks(clonedBlocks, lastSelectedIndex + 1, rootClientId, updateSelection);

    if (clonedBlocks.length > 1 && updateSelection) {
      dispatch.multiSelect(Object(external_lodash_["first"])(clonedBlocks).clientId, Object(external_lodash_["last"])(clonedBlocks).clientId);
    }

    return clonedBlocks.map(block => block.clientId);
  };
};
/**
 * Action that inserts an empty block before a given block.
 *
 * @param {string} clientId
 */

const insertBeforeBlock = clientId => _ref18 => {
  let {
    select,
    dispatch
  } = _ref18;

  if (!clientId) {
    return;
  }

  const rootClientId = select.getBlockRootClientId(clientId);
  const isLocked = select.getTemplateLock(rootClientId);

  if (isLocked) {
    return;
  }

  const firstSelectedIndex = select.getBlockIndex(clientId);
  return dispatch.insertDefaultBlock({}, rootClientId, firstSelectedIndex);
};
/**
 * Action that inserts an empty block after a given block.
 *
 * @param {string} clientId
 */

const insertAfterBlock = clientId => _ref19 => {
  let {
    select,
    dispatch
  } = _ref19;

  if (!clientId) {
    return;
  }

  const rootClientId = select.getBlockRootClientId(clientId);
  const isLocked = select.getTemplateLock(rootClientId);

  if (isLocked) {
    return;
  }

  const firstSelectedIndex = select.getBlockIndex(clientId);
  return dispatch.insertDefaultBlock({}, rootClientId, firstSelectedIndex + 1);
};
/**
 * Action that toggles the highlighted block state.
 *
 * @param {string}  clientId      The block's clientId.
 * @param {boolean} isHighlighted The highlight state.
 */

function toggleBlockHighlight(clientId, isHighlighted) {
  return {
    type: 'TOGGLE_BLOCK_HIGHLIGHT',
    clientId,
    isHighlighted
  };
}
/**
 * Action that "flashes" the block with a given `clientId` by rhythmically highlighting it.
 *
 * @param {string} clientId Target block client ID.
 */

const flashBlock = clientId => async _ref20 => {
  let {
    dispatch
  } = _ref20;
  dispatch(toggleBlockHighlight(clientId, true));
  await new Promise(resolve => setTimeout(resolve, 150));
  dispatch(toggleBlockHighlight(clientId, false));
};
/**
 * Action that sets whether a block has controlled inner blocks.
 *
 * @param {string}  clientId                 The block's clientId.
 * @param {boolean} hasControlledInnerBlocks True if the block's inner blocks are controlled.
 */

function setHasControlledInnerBlocks(clientId, hasControlledInnerBlocks) {
  return {
    type: 'SET_HAS_CONTROLLED_INNER_BLOCKS',
    hasControlledInnerBlocks,
    clientId
  };
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/constants.js
var constants = __webpack_require__("AHN3");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */





/**
 * Block editor data store configuration.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#registerStore
 *
 * @type {Object}
 */

const storeConfig = {
  reducer: store_reducer,
  selectors: selectors_namespaceObject,
  actions: actions_namespaceObject,
  __experimentalUseThunks: true
};
/**
 * Store definition for the block editor namespace.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/data/README.md#createReduxStore
 *
 * @type {Object}
 */

const store = Object(external_wp_data_["createReduxStore"])(constants["a" /* STORE_NAME */], { ...storeConfig,
  persist: ['preferences']
}); // Ideally we'd use register instead of register stores.

Object(external_wp_data_["registerStore"])(constants["a" /* STORE_NAME */], { ...storeConfig,
  persist: ['preferences']
});


/***/ }),

/***/ "Bo0k":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return getFontAppearanceLabel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return FontAppearanceControl; });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__);


/**
 * WordPress dependencies
 */



const FONT_STYLES = [{
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Regular', 'font style'),
  value: 'normal'
}, {
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Italic', 'font style'),
  value: 'italic'
}];
const FONT_WEIGHTS = [{
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Thin', 'font weight'),
  value: '100'
}, {
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Extra Light', 'font weight'),
  value: '200'
}, {
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Light', 'font weight'),
  value: '300'
}, {
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Regular', 'font weight'),
  value: '400'
}, {
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Medium', 'font weight'),
  value: '500'
}, {
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Semi Bold', 'font weight'),
  value: '600'
}, {
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Bold', 'font weight'),
  value: '700'
}, {
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Extra Bold', 'font weight'),
  value: '800'
}, {
  name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["_x"])('Black', 'font weight'),
  value: '900'
}];
/**
 * Adjusts font appearance field label in case either font styles or weights
 * are disabled.
 *
 * @param {boolean} hasFontStyles  Whether font styles are enabled and present.
 * @param {boolean} hasFontWeights Whether font weights are enabled and present.
 * @return {string} A label representing what font appearance is being edited.
 */

const getFontAppearanceLabel = (hasFontStyles, hasFontWeights) => {
  if (!hasFontStyles) {
    return Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Font weight');
  }

  if (!hasFontWeights) {
    return Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Font style');
  }

  return Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Appearance');
};
/**
 * Control to display unified font style and weight options.
 *
 * @param {Object} props Component props.
 *
 * @return {WPElement} Font appearance control.
 */

function FontAppearanceControl(props) {
  const {
    onChange,
    hasFontStyles = true,
    hasFontWeights = true,
    value: {
      fontStyle,
      fontWeight
    }
  } = props;
  const hasStylesOrWeights = hasFontStyles || hasFontWeights;
  const label = getFontAppearanceLabel(hasFontStyles, hasFontWeights);
  const defaultOption = {
    key: 'default',
    name: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Default'),
    style: {
      fontStyle: undefined,
      fontWeight: undefined
    }
  }; // Combines both font style and weight options into a single dropdown.

  const combineOptions = () => {
    const combinedOptions = [defaultOption];
    FONT_STYLES.forEach(_ref => {
      let {
        name: styleName,
        value: styleValue
      } = _ref;
      FONT_WEIGHTS.forEach(_ref2 => {
        let {
          name: weightName,
          value: weightValue
        } = _ref2;
        const optionName = styleValue === 'normal' ? weightName : Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["sprintf"])(
        /* translators: 1: Font weight name. 2: Font style name. */
        Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('%1$s %2$s'), weightName, styleName);
        combinedOptions.push({
          key: `${styleValue}-${weightValue}`,
          name: optionName,
          style: {
            fontStyle: styleValue,
            fontWeight: weightValue
          }
        });
      });
    });
    return combinedOptions;
  }; // Generates select options for font styles only.


  const styleOptions = () => {
    const combinedOptions = [defaultOption];
    FONT_STYLES.forEach(_ref3 => {
      let {
        name,
        value
      } = _ref3;
      combinedOptions.push({
        key: value,
        name,
        style: {
          fontStyle: value,
          fontWeight: undefined
        }
      });
    });
    return combinedOptions;
  }; // Generates select options for font weights only.


  const weightOptions = () => {
    const combinedOptions = [defaultOption];
    FONT_WEIGHTS.forEach(_ref4 => {
      let {
        name,
        value
      } = _ref4;
      combinedOptions.push({
        key: value,
        name,
        style: {
          fontStyle: undefined,
          fontWeight: value
        }
      });
    });
    return combinedOptions;
  }; // Map font styles and weights to select options.


  const selectOptions = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(() => {
    if (hasFontStyles && hasFontWeights) {
      return combineOptions();
    }

    return hasFontStyles ? styleOptions() : weightOptions();
  }, [props.options]); // Find current selection by comparing font style & weight against options,
  // and fall back to the Default option if there is no matching option.

  const currentSelection = selectOptions.find(option => option.style.fontStyle === fontStyle && option.style.fontWeight === fontWeight) || selectOptions[0]; // Adjusts screen reader description based on styles or weights.

  const getDescribedBy = () => {
    if (!currentSelection) {
      return Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('No selected font appearance');
    }

    if (!hasFontStyles) {
      return Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["sprintf"])( // translators: %s: Currently selected font weight.
      Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Currently selected font weight: %s'), currentSelection.name);
    }

    if (!hasFontWeights) {
      return Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["sprintf"])( // translators: %s: Currently selected font style.
      Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Currently selected font style: %s'), currentSelection.name);
    }

    return Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["sprintf"])( // translators: %s: Currently selected font appearance.
    Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_2__["__"])('Currently selected font appearance: %s'), currentSelection.name);
  };

  return hasStylesOrWeights && Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_1__["CustomSelectControl"], {
    className: "components-font-appearance-control",
    label: label,
    describedBy: getDescribedBy(),
    options: selectOptions,
    value: currentSelection,
    onChange: _ref5 => {
      let {
        selectedItem
      } = _ref5;
      return onChange(selectedItem.style);
    }
  });
}


/***/ }),

/***/ "Bpkj":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const link = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M15.6 7.2H14v1.5h1.6c2 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7H14v1.5h1.6c2.8 0 5.2-2.3 5.2-5.2 0-2.9-2.3-5.2-5.2-5.2zM4.7 12.4c0-2 1.7-3.7 3.7-3.7H10V7.2H8.4c-2.9 0-5.2 2.3-5.2 5.2 0 2.9 2.3 5.2 5.2 5.2H10v-1.5H8.4c-2 0-3.7-1.7-3.7-3.7zm4.6.9h5.3v-1.5H9.3v1.5z"
}));
/* harmony default export */ __webpack_exports__["a"] = (link);


/***/ }),

/***/ "Btt3":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __experimentalGetMatchingVariation; });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("YLtl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

/** @typedef {import('@wordpress/blocks').WPBlockVariation} WPBlockVariation */

/**
 * Matches the provided block variations with a block's attributes. If no match
 * or more than one matches are found it returns `undefined`. If a single match is
 * found it returns it.
 *
 * This is a simple implementation for now as it takes into account only the attributes
 * of a block variation and not `InnerBlocks`.
 *
 * @param {Object}             blockAttributes - The block attributes to try to find a match.
 * @param {WPBlockVariation[]} variations      - A list of block variations to test for a match.
 * @return {?WPBlockVariation} - If a match is found returns it. If not or more than one matches are found returns `undefined`.
 */

const __experimentalGetMatchingVariation = (blockAttributes, variations) => {
  if (!variations || !blockAttributes) return;
  const matches = variations.filter(_ref => {
    let {
      attributes
    } = _ref;
    if (!attributes || !Object.keys(attributes).length) return false;
    return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isMatch"])(blockAttributes, attributes);
  });
  if (matches.length !== 1) return;
  return matches[0];
};


/***/ }),

/***/ "CNgt":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
exports.__esModule = true;
var React = __webpack_require__("cDcd");
var PropTypes = __webpack_require__("17x9");
var autosize = __webpack_require__("GemG");
var _getLineHeight = __webpack_require__("Rk8H");
var getLineHeight = _getLineHeight;
var RESIZED = "autosize:resized";
/**
 * A light replacement for built-in textarea component
 * which automaticaly adjusts its height to match the content
 */
var TextareaAutosizeClass = /** @class */ (function (_super) {
    __extends(TextareaAutosizeClass, _super);
    function TextareaAutosizeClass() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            lineHeight: null
        };
        _this.textarea = null;
        _this.onResize = function (e) {
            if (_this.props.onResize) {
                _this.props.onResize(e);
            }
        };
        _this.updateLineHeight = function () {
            if (_this.textarea) {
                _this.setState({
                    lineHeight: getLineHeight(_this.textarea)
                });
            }
        };
        _this.onChange = function (e) {
            var onChange = _this.props.onChange;
            _this.currentValue = e.currentTarget.value;
            onChange && onChange(e);
        };
        return _this;
    }
    TextareaAutosizeClass.prototype.componentDidMount = function () {
        var _this = this;
        var _a = this.props, maxRows = _a.maxRows, async = _a.async;
        if (typeof maxRows === "number") {
            this.updateLineHeight();
        }
        if (typeof maxRows === "number" || async) {
            /*
              the defer is needed to:
                - force "autosize" to activate the scrollbar when this.props.maxRows is passed
                - support StyledComponents (see #71)
            */
            setTimeout(function () { return _this.textarea && autosize(_this.textarea); });
        }
        else {
            this.textarea && autosize(this.textarea);
        }
        if (this.textarea) {
            this.textarea.addEventListener(RESIZED, this.onResize);
        }
    };
    TextareaAutosizeClass.prototype.componentWillUnmount = function () {
        if (this.textarea) {
            this.textarea.removeEventListener(RESIZED, this.onResize);
            autosize.destroy(this.textarea);
        }
    };
    TextareaAutosizeClass.prototype.render = function () {
        var _this = this;
        var _a = this, _b = _a.props, onResize = _b.onResize, maxRows = _b.maxRows, onChange = _b.onChange, style = _b.style, innerRef = _b.innerRef, children = _b.children, props = __rest(_b, ["onResize", "maxRows", "onChange", "style", "innerRef", "children"]), lineHeight = _a.state.lineHeight;
        var maxHeight = maxRows && lineHeight ? lineHeight * maxRows : null;
        return (React.createElement("textarea", __assign({}, props, { onChange: this.onChange, style: maxHeight ? __assign({}, style, { maxHeight: maxHeight }) : style, ref: function (element) {
                _this.textarea = element;
                if (typeof _this.props.innerRef === 'function') {
                    _this.props.innerRef(element);
                }
                else if (_this.props.innerRef) {
                    _this.props.innerRef.current = element;
                }
            } }), children));
    };
    TextareaAutosizeClass.prototype.componentDidUpdate = function () {
        this.textarea && autosize.update(this.textarea);
    };
    TextareaAutosizeClass.defaultProps = {
        rows: 1,
        async: false
    };
    TextareaAutosizeClass.propTypes = {
        rows: PropTypes.number,
        maxRows: PropTypes.number,
        onResize: PropTypes.func,
        innerRef: PropTypes.any,
        async: PropTypes.bool
    };
    return TextareaAutosizeClass;
}(React.Component));
exports.TextareaAutosize = React.forwardRef(function (props, ref) {
    return React.createElement(TextareaAutosizeClass, __assign({}, props, { innerRef: ref }));
});


/***/ }),

/***/ "Civd":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const layout = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M18 5.5H6a.5.5 0 00-.5.5v3h13V6a.5.5 0 00-.5-.5zm.5 5H10v8h8a.5.5 0 00.5-.5v-7.5zm-10 0h-3V18a.5.5 0 00.5.5h2.5v-8zM6 4h12a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V6a2 2 0 012-2z"
}));
/* harmony default export */ __webpack_exports__["a"] = (layout);


/***/ }),

/***/ "Cn0l":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __experimentalGetGradientClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return getGradientValueBySlug; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __experimentalGetGradientObjectByGradientValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return getGradientSlugByValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return __experimentalUseGradient; });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("YLtl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _block_edit__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("ur0x");
/* harmony import */ var _use_setting__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("v5LD");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("BhPs");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function __experimentalGetGradientClass(gradientSlug) {
  if (!gradientSlug) {
    return undefined;
  }

  return `has-${gradientSlug}-gradient-background`;
}
/**
 * Retrieves the gradient value per slug.
 *
 * @param {Array}  gradients Gradient Palette
 * @param {string} slug      Gradient slug
 *
 * @return {string} Gradient value.
 */

function getGradientValueBySlug(gradients, slug) {
  const gradient = Object(lodash__WEBPACK_IMPORTED_MODULE_0__["find"])(gradients, ['slug', slug]);
  return gradient && gradient.gradient;
}
function __experimentalGetGradientObjectByGradientValue(gradients, value) {
  const gradient = Object(lodash__WEBPACK_IMPORTED_MODULE_0__["find"])(gradients, ['gradient', value]);
  return gradient;
}
/**
 * Retrieves the gradient slug per slug.
 *
 * @param {Array}  gradients Gradient Palette
 * @param {string} value     Gradient value
 * @return {string} Gradient slug.
 */

function getGradientSlugByValue(gradients, value) {
  const gradient = __experimentalGetGradientObjectByGradientValue(gradients, value);

  return gradient && gradient.slug;
}
function __experimentalUseGradient() {
  let {
    gradientAttribute = 'gradient',
    customGradientAttribute = 'customGradient'
  } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const {
    clientId
  } = Object(_block_edit__WEBPACK_IMPORTED_MODULE_3__[/* useBlockEditContext */ "c"])();
  const userGradientPalette = Object(_use_setting__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"])('color.gradients.custom');
  const themeGradientPalette = Object(_use_setting__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"])('color.gradients.theme');
  const defaultGradientPalette = Object(_use_setting__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"])('color.gradients.default');
  const allGradients = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(() => [...(userGradientPalette || []), ...(themeGradientPalette || []), ...(defaultGradientPalette || [])], [userGradientPalette, themeGradientPalette, defaultGradientPalette]);
  const {
    gradient,
    customGradient
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__["useSelect"])(select => {
    const {
      getBlockAttributes
    } = select(_store__WEBPACK_IMPORTED_MODULE_5__[/* store */ "a"]);
    const attributes = getBlockAttributes(clientId) || {};
    return {
      customGradient: attributes[customGradientAttribute],
      gradient: attributes[gradientAttribute]
    };
  }, [clientId, gradientAttribute, customGradientAttribute]);
  const {
    updateBlockAttributes
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__["useDispatch"])(_store__WEBPACK_IMPORTED_MODULE_5__[/* store */ "a"]);
  const setGradient = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(newGradientValue => {
    const slug = getGradientSlugByValue(allGradients, newGradientValue);

    if (slug) {
      updateBlockAttributes(clientId, {
        [gradientAttribute]: slug,
        [customGradientAttribute]: undefined
      });
      return;
    }

    updateBlockAttributes(clientId, {
      [gradientAttribute]: undefined,
      [customGradientAttribute]: newGradientValue
    });
  }, [allGradients, clientId, updateBlockAttributes]);

  const gradientClass = __experimentalGetGradientClass(gradient);

  let gradientValue;

  if (gradient) {
    gradientValue = getGradientValueBySlug(allGradients, gradient);
  } else {
    gradientValue = customGradient;
  }

  return {
    gradientClass,
    gradientValue,
    setGradient
  };
}


/***/ }),

/***/ "Crq9":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const formatStrikethrough = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M9.1 9v-.5c0-.6.2-1.1.7-1.4.5-.3 1.2-.5 2-.5.7 0 1.4.1 2.1.3.7.2 1.4.5 2.1.9l.2-1.9c-.6-.3-1.2-.5-1.9-.7-.8-.1-1.6-.2-2.4-.2-1.5 0-2.7.3-3.6 1-.8.7-1.2 1.5-1.2 2.6V9h2zM20 12H4v1h8.3c.3.1.6.2.8.3.5.2.9.5 1.1.8.3.3.4.7.4 1.2 0 .7-.2 1.1-.8 1.5-.5.3-1.2.5-2.1.5-.8 0-1.6-.1-2.4-.3-.8-.2-1.5-.5-2.2-.8L7 18.1c.5.2 1.2.4 2 .6.8.2 1.6.3 2.4.3 1.7 0 3-.3 3.9-1 .9-.7 1.3-1.6 1.3-2.8 0-.9-.2-1.7-.7-2.2H20v-1z"
}));
/* harmony default export */ __webpack_exports__["a"] = (formatStrikethrough);


/***/ }),

/***/ "DmX/":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const justifyCenter = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M20 9h-7.2V4h-1.6v5H4v6h7.2v5h1.6v-5H20z"
}));
/* harmony default export */ __webpack_exports__["a"] = (justifyCenter);


/***/ }),

/***/ "ERVc":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useBlockCustomClassName; });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("HSyU");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("BhPs");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Returns the custom class name if the block is a light block.
 *
 * @param {string} clientId The block client ID.
 *
 * @return {string} The custom class name.
 */

function useBlockCustomClassName(clientId) {
  // It's good for this to be a separate selector because it will be executed
  // on every attribute change, while the other selectors are not re-evaluated
  // as much.
  return Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__["useSelect"])(select => {
    const {
      getBlockName,
      getBlockAttributes
    } = select(_store__WEBPACK_IMPORTED_MODULE_2__[/* store */ "a"]);
    const attributes = getBlockAttributes(clientId);

    if (!(attributes !== null && attributes !== void 0 && attributes.className)) {
      return;
    }

    const blockType = Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_1__["getBlockType"])(getBlockName(clientId));
    const hasLightBlockWrapper = (blockType === null || blockType === void 0 ? void 0 : blockType.apiVersion) > 1;

    if (!hasLightBlockWrapper) {
      return;
    }

    return attributes.className;
  }, [clientId]);
}


/***/ }),

/***/ "EpZT":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const positionCenter = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M7 9v6h10V9H7zM5 19.8h14v-1.5H5v1.5zM5 4.3v1.5h14V4.3H5z"
}));
/* harmony default export */ __webpack_exports__["a"] = (positionCenter);


/***/ }),

/***/ "Fmc1":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wx14");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("K9lf");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _block_preview__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("REKd");
/* harmony import */ var _inserter_draggable_blocks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("j6zP");



/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function BlockPattern(_ref) {
  let {
    isDraggable,
    pattern,
    onClick,
    composite
  } = _ref;
  const {
    blocks,
    viewportWidth
  } = pattern;
  const instanceId = Object(_wordpress_compose__WEBPACK_IMPORTED_MODULE_3__["useInstanceId"])(BlockPattern);
  const descriptionId = `block-editor-block-patterns-list__item-description-${instanceId}`;
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_inserter_draggable_blocks__WEBPACK_IMPORTED_MODULE_6__[/* default */ "a"], {
    isEnabled: isDraggable,
    blocks: blocks
  }, _ref2 => {
    let {
      draggable,
      onDragStart,
      onDragEnd
    } = _ref2;
    return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])("div", {
      className: "block-editor-block-patterns-list__list-item",
      "aria-label": pattern.title,
      "aria-describedby": pattern.description ? descriptionId : undefined,
      draggable: draggable,
      onDragStart: onDragStart,
      onDragEnd: onDragEnd
    }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["__unstableCompositeItem"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
      role: "option",
      as: "div"
    }, composite, {
      className: "block-editor-block-patterns-list__item",
      onClick: () => onClick(pattern, blocks)
    }), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_block_preview__WEBPACK_IMPORTED_MODULE_5__[/* default */ "a"], {
      blocks: blocks,
      viewportWidth: viewportWidth
    }), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])("div", {
      className: "block-editor-block-patterns-list__item-title"
    }, pattern.title), !!pattern.description && Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["VisuallyHidden"], {
      id: descriptionId
    }, pattern.description)));
  });
}

function BlockPatternPlaceholder() {
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])("div", {
    className: "block-editor-block-patterns-list__item is-placeholder"
  });
}

function BlockPatternList(_ref3) {
  let {
    isDraggable,
    blockPatterns,
    shownPatterns,
    onClickPattern,
    orientation,
    label = Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__["__"])('Block Patterns')
  } = _ref3;
  const composite = Object(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["__unstableUseCompositeState"])({
    orientation
  });
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["__unstableComposite"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({}, composite, {
    role: "listbox",
    className: "block-editor-block-patterns-list",
    "aria-label": label
  }), blockPatterns.map(pattern => {
    const isShown = shownPatterns.includes(pattern);
    return isShown ? Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(BlockPattern, {
      key: pattern.name,
      pattern: pattern,
      onClick: onClickPattern,
      isDraggable: isDraggable,
      composite: composite
    }) : Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(BlockPatternPlaceholder, {
      key: pattern.name
    });
  }));
}

/* harmony default export */ __webpack_exports__["a"] = (BlockPatternList);


/***/ }),

/***/ "FnAh":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const info = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M12 3.2c-4.8 0-8.8 3.9-8.8 8.8 0 4.8 3.9 8.8 8.8 8.8 4.8 0 8.8-3.9 8.8-8.8 0-4.8-4-8.8-8.8-8.8zm0 16c-4 0-7.2-3.3-7.2-7.2C4.8 8 8 4.8 12 4.8s7.2 3.3 7.2 7.2c0 4-3.2 7.2-7.2 7.2zM11 17h2v-6h-2v6zm0-8h2V7h-2v2z"
}));
/* harmony default export */ __webpack_exports__["a"] = (info);


/***/ }),

/***/ "G4zt":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useScrollIntoView; });
/* harmony import */ var dom_scroll_into_view__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("9Do8");
/* harmony import */ var dom_scroll_into_view__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(dom_scroll_into_view__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("1CF3");
/* harmony import */ var _wordpress_dom__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_dom__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("BhPs");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


function useScrollIntoView(clientId) {
  const ref = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useRef"])();
  const isSelectionEnd = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__["useSelect"])(select => {
    const {
      isBlockSelected,
      getBlockSelectionEnd
    } = select(_store__WEBPACK_IMPORTED_MODULE_4__[/* store */ "a"]);
    return isBlockSelected(clientId) || getBlockSelectionEnd() === clientId;
  }, [clientId]); // Note that we can't use `useRefEffect` here, since an element change does
  // not mean we can scroll. `isSelectionEnd` should be the sole dependency,
  // while with `useRefEffect`, the element is a dependency as well.

  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(() => {
    if (!isSelectionEnd) {
      return;
    }

    const extentNode = ref.current;

    if (!extentNode) {
      return;
    } // If the block is focused, the browser will already have scrolled into
    // view if necessary.


    if (extentNode.contains(extentNode.ownerDocument.activeElement)) {
      return;
    }

    const scrollContainer = Object(_wordpress_dom__WEBPACK_IMPORTED_MODULE_3__["getScrollContainer"])(extentNode) || extentNode.ownerDocument.defaultView; // If there's no scroll container, it follows that there's no scrollbar
    // and thus there's no need to try to scroll into view.

    if (!scrollContainer) {
      return;
    }

    dom_scroll_into_view__WEBPACK_IMPORTED_MODULE_0___default()(extentNode, scrollContainer, {
      onlyScrollIfNeeded: true
    });
  }, [isSelectionEnd]);
  return ref;
}


/***/ }),

/***/ "GKUk":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return FontFamilyControl; });
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wx14");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("YLtl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _use_setting__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("v5LD");



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


function FontFamilyControl(_ref) {
  let {
    value = '',
    onChange,
    fontFamilies,
    ...props
  } = _ref;
  const blockLevelFontFamilies = Object(_use_setting__WEBPACK_IMPORTED_MODULE_5__[/* default */ "a"])('typography.fontFamilies');

  if (!fontFamilies) {
    fontFamilies = blockLevelFontFamilies;
  }

  if (Object(lodash__WEBPACK_IMPORTED_MODULE_2__["isEmpty"])(fontFamilies)) {
    return null;
  }

  const options = [{
    value: '',
    label: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__["__"])('Default')
  }, ...fontFamilies.map(_ref2 => {
    let {
      fontFamily,
      name
    } = _ref2;
    return {
      value: fontFamily,
      label: name || fontFamily
    };
  })];
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__["SelectControl"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
    label: Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_4__["__"])('Font family'),
    options: options,
    value: value,
    onChange: onChange,
    labelPosition: "top"
  }, props));
}


/***/ }),

/***/ "GOly":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */

const InserterListboxContext = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createContext"])();
/* harmony default export */ __webpack_exports__["a"] = (InserterListboxContext);


/***/ }),

/***/ "GRId":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["element"]; }());

/***/ }),

/***/ "GemG":
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
	autosize 4.0.4
	license: MIT
	http://www.jacklmoore.com/autosize
*/
(function (global, factory) {
	if (true) {
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [module, exports], __WEBPACK_AMD_DEFINE_FACTORY__ = (factory),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__)) : __WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else { var mod; }
})(this, function (module, exports) {
	'use strict';

	var map = typeof Map === "function" ? new Map() : function () {
		var keys = [];
		var values = [];

		return {
			has: function has(key) {
				return keys.indexOf(key) > -1;
			},
			get: function get(key) {
				return values[keys.indexOf(key)];
			},
			set: function set(key, value) {
				if (keys.indexOf(key) === -1) {
					keys.push(key);
					values.push(value);
				}
			},
			delete: function _delete(key) {
				var index = keys.indexOf(key);
				if (index > -1) {
					keys.splice(index, 1);
					values.splice(index, 1);
				}
			}
		};
	}();

	var createEvent = function createEvent(name) {
		return new Event(name, { bubbles: true });
	};
	try {
		new Event('test');
	} catch (e) {
		// IE does not support `new Event()`
		createEvent = function createEvent(name) {
			var evt = document.createEvent('Event');
			evt.initEvent(name, true, false);
			return evt;
		};
	}

	function assign(ta) {
		if (!ta || !ta.nodeName || ta.nodeName !== 'TEXTAREA' || map.has(ta)) return;

		var heightOffset = null;
		var clientWidth = null;
		var cachedHeight = null;

		function init() {
			var style = window.getComputedStyle(ta, null);

			if (style.resize === 'vertical') {
				ta.style.resize = 'none';
			} else if (style.resize === 'both') {
				ta.style.resize = 'horizontal';
			}

			if (style.boxSizing === 'content-box') {
				heightOffset = -(parseFloat(style.paddingTop) + parseFloat(style.paddingBottom));
			} else {
				heightOffset = parseFloat(style.borderTopWidth) + parseFloat(style.borderBottomWidth);
			}
			// Fix when a textarea is not on document body and heightOffset is Not a Number
			if (isNaN(heightOffset)) {
				heightOffset = 0;
			}

			update();
		}

		function changeOverflow(value) {
			{
				// Chrome/Safari-specific fix:
				// When the textarea y-overflow is hidden, Chrome/Safari do not reflow the text to account for the space
				// made available by removing the scrollbar. The following forces the necessary text reflow.
				var width = ta.style.width;
				ta.style.width = '0px';
				// Force reflow:
				/* jshint ignore:start */
				ta.offsetWidth;
				/* jshint ignore:end */
				ta.style.width = width;
			}

			ta.style.overflowY = value;
		}

		function getParentOverflows(el) {
			var arr = [];

			while (el && el.parentNode && el.parentNode instanceof Element) {
				if (el.parentNode.scrollTop) {
					arr.push({
						node: el.parentNode,
						scrollTop: el.parentNode.scrollTop
					});
				}
				el = el.parentNode;
			}

			return arr;
		}

		function resize() {
			if (ta.scrollHeight === 0) {
				// If the scrollHeight is 0, then the element probably has display:none or is detached from the DOM.
				return;
			}

			var overflows = getParentOverflows(ta);
			var docTop = document.documentElement && document.documentElement.scrollTop; // Needed for Mobile IE (ticket #240)

			ta.style.height = '';
			ta.style.height = ta.scrollHeight + heightOffset + 'px';

			// used to check if an update is actually necessary on window.resize
			clientWidth = ta.clientWidth;

			// prevents scroll-position jumping
			overflows.forEach(function (el) {
				el.node.scrollTop = el.scrollTop;
			});

			if (docTop) {
				document.documentElement.scrollTop = docTop;
			}
		}

		function update() {
			resize();

			var styleHeight = Math.round(parseFloat(ta.style.height));
			var computed = window.getComputedStyle(ta, null);

			// Using offsetHeight as a replacement for computed.height in IE, because IE does not account use of border-box
			var actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(computed.height)) : ta.offsetHeight;

			// The actual height not matching the style height (set via the resize method) indicates that 
			// the max-height has been exceeded, in which case the overflow should be allowed.
			if (actualHeight < styleHeight) {
				if (computed.overflowY === 'hidden') {
					changeOverflow('scroll');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			} else {
				// Normally keep overflow set to hidden, to avoid flash of scrollbar as the textarea expands.
				if (computed.overflowY !== 'hidden') {
					changeOverflow('hidden');
					resize();
					actualHeight = computed.boxSizing === 'content-box' ? Math.round(parseFloat(window.getComputedStyle(ta, null).height)) : ta.offsetHeight;
				}
			}

			if (cachedHeight !== actualHeight) {
				cachedHeight = actualHeight;
				var evt = createEvent('autosize:resized');
				try {
					ta.dispatchEvent(evt);
				} catch (err) {
					// Firefox will throw an error on dispatchEvent for a detached element
					// https://bugzilla.mozilla.org/show_bug.cgi?id=889376
				}
			}
		}

		var pageResize = function pageResize() {
			if (ta.clientWidth !== clientWidth) {
				update();
			}
		};

		var destroy = function (style) {
			window.removeEventListener('resize', pageResize, false);
			ta.removeEventListener('input', update, false);
			ta.removeEventListener('keyup', update, false);
			ta.removeEventListener('autosize:destroy', destroy, false);
			ta.removeEventListener('autosize:update', update, false);

			Object.keys(style).forEach(function (key) {
				ta.style[key] = style[key];
			});

			map.delete(ta);
		}.bind(ta, {
			height: ta.style.height,
			resize: ta.style.resize,
			overflowY: ta.style.overflowY,
			overflowX: ta.style.overflowX,
			wordWrap: ta.style.wordWrap
		});

		ta.addEventListener('autosize:destroy', destroy, false);

		// IE9 does not fire onpropertychange or oninput for deletions,
		// so binding to onkeyup to catch most of those events.
		// There is no way that I know of to detect something like 'cut' in IE9.
		if ('onpropertychange' in ta && 'oninput' in ta) {
			ta.addEventListener('keyup', update, false);
		}

		window.addEventListener('resize', pageResize, false);
		ta.addEventListener('input', update, false);
		ta.addEventListener('autosize:update', update, false);
		ta.style.overflowX = 'hidden';
		ta.style.wordWrap = 'break-word';

		map.set(ta, {
			destroy: destroy,
			update: update
		});

		init();
	}

	function destroy(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.destroy();
		}
	}

	function update(ta) {
		var methods = map.get(ta);
		if (methods) {
			methods.update();
		}
	}

	var autosize = null;

	// Do nothing in Node.js environment and IE8 (or lower)
	if (typeof window === 'undefined' || typeof window.getComputedStyle !== 'function') {
		autosize = function autosize(el) {
			return el;
		};
		autosize.destroy = function (el) {
			return el;
		};
		autosize.update = function (el) {
			return el;
		};
	} else {
		autosize = function autosize(el, options) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], function (x) {
					return assign(x, options);
				});
			}
			return el;
		};
		autosize.destroy = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], destroy);
			}
			return el;
		};
		autosize.update = function (el) {
			if (el) {
				Array.prototype.forEach.call(el.length ? el : [el], update);
			}
			return el;
		};
	}

	exports.default = autosize;
	module.exports = exports['default'];
});

/***/ }),

/***/ "GkEL":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wx14");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("NMb1");
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_dom__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("1CF3");
/* harmony import */ var _wordpress_dom__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_dom__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_keyboard_shortcuts__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("hF7m");
/* harmony import */ var _wordpress_keyboard_shortcuts__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_keyboard_shortcuts__WEBPACK_IMPORTED_MODULE_5__);



/**
 * WordPress dependencies
 */






function hasOnlyToolbarItem(elements) {
  const dataProp = 'toolbarItem';
  return !elements.some(element => !(dataProp in element.dataset));
}

function getAllToolbarItemsIn(container) {
  return Array.from(container.querySelectorAll('[data-toolbar-item]'));
}

function hasFocusWithin(container) {
  return container.contains(container.ownerDocument.activeElement);
}

function focusFirstTabbableIn(container) {
  const [firstTabbable] = _wordpress_dom__WEBPACK_IMPORTED_MODULE_4__["focus"].tabbable.find(container);

  if (firstTabbable) {
    firstTabbable.focus();
  }
}

function useIsAccessibleToolbar(ref) {
  /*
   * By default, we'll assume the starting accessible state of the Toolbar
   * is true, as it seems to be the most common case.
   *
   * Transitioning from an (initial) false to true state causes the
   * <Toolbar /> component to mount twice, which is causing undesired
   * side-effects. These side-effects appear to only affect certain
   * E2E tests.
   *
   * This was initial discovered in this pull-request:
   * https://github.com/WordPress/gutenberg/pull/23425
   */
  const initialAccessibleToolbarState = true; // By default, it's gonna render NavigableMenu. If all the tabbable elements
  // inside the toolbar are ToolbarItem components (or derived components like
  // ToolbarButton), then we can wrap them with the accessible Toolbar
  // component.

  const [isAccessibleToolbar, setIsAccessibleToolbar] = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useState"])(initialAccessibleToolbarState);
  const determineIsAccessibleToolbar = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(() => {
    const tabbables = _wordpress_dom__WEBPACK_IMPORTED_MODULE_4__["focus"].tabbable.find(ref.current);
    const onlyToolbarItem = hasOnlyToolbarItem(tabbables);

    if (!onlyToolbarItem) {
      _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_3___default()('Using custom components as toolbar controls', {
        since: '5.6',
        alternative: 'ToolbarItem, ToolbarButton or ToolbarDropdownMenu components',
        link: 'https://developer.wordpress.org/block-editor/components/toolbar-button/#inside-blockcontrols'
      });
    }

    setIsAccessibleToolbar(onlyToolbarItem);
  }, []);
  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useLayoutEffect"])(() => {
    // Toolbar buttons may be rendered asynchronously, so we use
    // MutationObserver to check if the toolbar subtree has been modified
    const observer = new window.MutationObserver(determineIsAccessibleToolbar);
    observer.observe(ref.current, {
      childList: true,
      subtree: true
    });
    return () => observer.disconnect();
  }, [isAccessibleToolbar]);
  return isAccessibleToolbar;
}

function useToolbarFocus(ref, focusOnMount, isAccessibleToolbar, defaultIndex, onIndexChange) {
  // Make sure we don't use modified versions of this prop
  const [initialFocusOnMount] = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useState"])(focusOnMount);
  const [initialIndex] = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useState"])(defaultIndex);
  const focusToolbar = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(() => {
    focusFirstTabbableIn(ref.current);
  }, []); // Focus on toolbar when pressing alt+F10 when the toolbar is visible

  Object(_wordpress_keyboard_shortcuts__WEBPACK_IMPORTED_MODULE_5__["useShortcut"])('core/block-editor/focus-toolbar', focusToolbar);
  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(() => {
    if (initialFocusOnMount) {
      focusToolbar();
    }
  }, [isAccessibleToolbar, initialFocusOnMount, focusToolbar]);
  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(() => {
    // If initialIndex is passed, we focus on that toolbar item when the
    // toolbar gets mounted and initial focus is not forced.
    // We have to wait for the next browser paint because block controls aren't
    // rendered right away when the toolbar gets mounted.
    let raf = 0;

    if (initialIndex && !initialFocusOnMount) {
      raf = window.requestAnimationFrame(() => {
        const items = getAllToolbarItemsIn(ref.current);
        const index = initialIndex || 0;

        if (items[index] && hasFocusWithin(ref.current)) {
          items[index].focus();
        }
      });
    }

    return () => {
      window.cancelAnimationFrame(raf);
      if (!onIndexChange || !ref.current) return; // When the toolbar element is unmounted and onIndexChange is passed, we
      // pass the focused toolbar item index so it can be hydrated later.

      const items = getAllToolbarItemsIn(ref.current);
      const index = items.findIndex(item => item.tabIndex === 0);
      onIndexChange(index);
    };
  }, [initialIndex, initialFocusOnMount]);
}

function NavigableToolbar(_ref) {
  let {
    children,
    focusOnMount,
    __experimentalInitialIndex: initialIndex,
    __experimentalOnIndexChange: onIndexChange,
    ...props
  } = _ref;
  const ref = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useRef"])();
  const isAccessibleToolbar = useIsAccessibleToolbar(ref);
  useToolbarFocus(ref, focusOnMount, isAccessibleToolbar, initialIndex, onIndexChange);

  if (isAccessibleToolbar) {
    return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["Toolbar"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
      label: props['aria-label'],
      ref: ref
    }, props), children);
  }

  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["NavigableMenu"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
    orientation: "horizontal",
    role: "toolbar",
    ref: ref
  }, props), children);
}

/* harmony default export */ __webpack_exports__["a"] = (NavigableToolbar);


/***/ }),

/***/ "GvwK":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("NMb1");
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _block_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("7SSY");


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



function BlockCard(_ref) {
  let {
    title,
    icon,
    description,
    blockType
  } = _ref;

  if (blockType) {
    _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_1___default()('`blockType` property in `BlockCard component`', {
      since: '5.7',
      alternative: '`title, icon and description` properties'
    });
    ({
      title,
      icon,
      description
    } = blockType);
  }

  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("div", {
    className: "block-editor-block-card"
  }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_block_icon__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"], {
    icon: icon,
    showColors: true
  }), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("div", {
    className: "block-editor-block-card__content"
  }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("h2", {
    className: "block-editor-block-card__title"
  }, title), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("span", {
    className: "block-editor-block-card__description"
  }, description)));
}

/* harmony default export */ __webpack_exports__["a"] = (BlockCard);


/***/ }),

/***/ "HC45":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wx14");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("GOly");



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function InserterListboxRow(props, ref) {
  const state = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_context__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"]);
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["__unstableCompositeGroup"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
    state: state,
    role: "presentation",
    ref: ref
  }, props));
}

/* harmony default export */ __webpack_exports__["a"] = (Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["forwardRef"])(InserterListboxRow));


/***/ }),

/***/ "HSyU":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["blocks"]; }());

/***/ }),

/***/ "HgtZ":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useDisplayBlockControls; });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _block_edit_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("ur0x");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("BhPs");
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



function useDisplayBlockControls() {
  const {
    isSelected,
    clientId,
    name
  } = Object(_block_edit_context__WEBPACK_IMPORTED_MODULE_1__[/* useBlockEditContext */ "c"])();
  return Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__["useSelect"])(select => {
    if (isSelected) {
      return true;
    }

    const {
      getBlockName,
      isFirstMultiSelectedBlock,
      getMultiSelectedBlockClientIds
    } = select(_store__WEBPACK_IMPORTED_MODULE_2__[/* store */ "a"]);

    if (isFirstMultiSelectedBlock(clientId)) {
      return getMultiSelectedBlockClientIds().every(id => getBlockName(id) === name);
    }

    return false;
  }, [clientId, isSelected, name]);
}


/***/ }),

/***/ "I5Hl":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ButtonBlockerAppender; });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("TSYQ");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("iClF");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("Q4Sy");
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("NMb1");
/* harmony import */ var _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_deprecated__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _inserter__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("qrxh");


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */



function ButtonBlockAppender(_ref, ref) {
  let {
    rootClientId,
    className,
    onFocus,
    tabIndex
  } = _ref;
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_inserter__WEBPACK_IMPORTED_MODULE_7__[/* default */ "a"], {
    position: "bottom center",
    rootClientId: rootClientId,
    __experimentalIsQuick: true,
    renderToggle: _ref2 => {
      let {
        onToggle,
        disabled,
        isOpen,
        blockTitle,
        hasSingleBlockType
      } = _ref2;
      let label;

      if (hasSingleBlockType) {
        label = Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__["sprintf"])( // translators: %s: the name of the block when there is only one
        Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__["_x"])('Add %s', 'directly add the only allowed block'), blockTitle);
      } else {
        label = Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__["_x"])('Add block', 'Generic label for block inserter button');
      }

      const isToggleButton = !hasSingleBlockType;
      let inserterButton = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["Button"], {
        ref: ref,
        onFocus: onFocus,
        tabIndex: tabIndex,
        className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(className, 'block-editor-button-block-appender'),
        onClick: onToggle,
        "aria-haspopup": isToggleButton ? 'true' : undefined,
        "aria-expanded": isToggleButton ? isOpen : undefined,
        disabled: disabled,
        label: label
      }, !hasSingleBlockType && Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["VisuallyHidden"], {
        as: "span"
      }, label), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_icons__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"], {
        icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_5__[/* default */ "a"]
      }));

      if (isToggleButton || hasSingleBlockType) {
        inserterButton = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["Tooltip"], {
          text: label
        }, inserterButton);
      }

      return inserterButton;
    },
    isAppender: true
  });
}
/**
 * Use `ButtonBlockAppender` instead.
 *
 * @deprecated
 */


const ButtonBlockerAppender = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["forwardRef"])((props, ref) => {
  _wordpress_deprecated__WEBPACK_IMPORTED_MODULE_6___default()(`wp.blockEditor.ButtonBlockerAppender`, {
    alternative: 'wp.blockEditor.ButtonBlockAppender'
  });
  return ButtonBlockAppender(props, ref);
});
/**
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/button-block-appender/README.md
 */

/* harmony default export */ __webpack_exports__["b"] = (Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["forwardRef"])(ButtonBlockAppender));


/***/ }),

/***/ "JDWi":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useNavModeExit; });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("K9lf");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("BhPs");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/**
 * Allows navigation mode to be exited by clicking in the selected block.
 *
 * @param {string} clientId Block client ID.
 */

function useNavModeExit(clientId) {
  const {
    isNavigationMode,
    isBlockSelected
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__["useSelect"])(_store__WEBPACK_IMPORTED_MODULE_2__[/* store */ "a"]);
  const {
    setNavigationMode,
    selectBlock
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__["useDispatch"])(_store__WEBPACK_IMPORTED_MODULE_2__[/* store */ "a"]);
  return Object(_wordpress_compose__WEBPACK_IMPORTED_MODULE_1__["useRefEffect"])(node => {
    function onMouseDown(event) {
      // Don't select a block if it's already handled by a child
      // block.
      if (isNavigationMode() && !event.defaultPrevented) {
        // Prevent focus from moving to the block.
        event.preventDefault(); // When clicking on a selected block, exit navigation mode.

        if (isBlockSelected(clientId)) {
          setNavigationMode(false);
        } else {
          selectBlock(clientId);
        }
      }
    }

    node.addEventListener('mousedown', onMouseDown);
    return () => {
      node.addEventListener('mousedown', onMouseDown);
    };
  }, [clientId, isNavigationMode, isBlockSelected, setNavigationMode]);
}


/***/ }),

/***/ "JGYp":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useBlockSync; });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("YLtl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("HSyU");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("BhPs");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * A function to call when the block value has been updated in the block-editor
 * store.
 *
 * @callback onBlockUpdate
 * @param {Object[]} blocks  The updated blocks.
 * @param {Object}   options The updated block options, such as selectionStart
 *                           and selectionEnd.
 */

/**
 * useBlockSync is a side effect which handles bidirectional sync between the
 * block-editor store and a controlling data source which provides blocks. This
 * is most commonly used by the BlockEditorProvider to synchronize the contents
 * of the block-editor store with the root entity, like a post.
 *
 * Another example would be the template part block, which provides blocks from
 * a separate entity data source than a root entity. This hook syncs edits to
 * the template part in the block editor back to the entity and vice-versa.
 *
 * Here are some of its basic functions:
 * - Initalizes the block-editor store for the given clientID to the blocks
 *   given via props.
 * - Adds incoming changes (like undo) to the block-editor store.
 * - Adds outgoing changes (like editing content) to the controlling entity,
 *   determining if a change should be considered persistent or not.
 * - Handles edge cases and race conditions which occur in those operations.
 * - Ignores changes which happen to other entities (like nested inner block
 *   controllers.
 * - Passes selection state from the block-editor store to the controlling entity.
 *
 * @param {Object}        props           Props for the block sync hook
 * @param {string}        props.clientId  The client ID of the inner block controller.
 *                                        If none is passed, then it is assumed to be a
 *                                        root controller rather than an inner block
 *                                        controller.
 * @param {Object[]}      props.value     The control value for the blocks. This value
 *                                        is used to initalize the block-editor store
 *                                        and for resetting the blocks to incoming
 *                                        changes like undo.
 * @param {Object}        props.selection The selection state responsible to restore the selection on undo/redo.
 * @param {onBlockUpdate} props.onChange  Function to call when a persistent
 *                                        change has been made in the block-editor blocks
 *                                        for the given clientId. For example, after
 *                                        this function is called, an entity is marked
 *                                        dirty because it has changes to save.
 * @param {onBlockUpdate} props.onInput   Function to call when a non-persistent
 *                                        change has been made in the block-editor blocks
 *                                        for the given clientId. When this is called,
 *                                        controlling sources do not become dirty.
 */

function useBlockSync(_ref) {
  let {
    clientId = null,
    value: controlledBlocks,
    selection: controlledSelection,
    onChange = lodash__WEBPACK_IMPORTED_MODULE_0__["noop"],
    onInput = lodash__WEBPACK_IMPORTED_MODULE_0__["noop"]
  } = _ref;
  const registry = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__["useRegistry"])();
  const {
    resetBlocks,
    resetSelection,
    replaceInnerBlocks,
    setHasControlledInnerBlocks,
    __unstableMarkNextChangeAsNotPersistent
  } = registry.dispatch(_store__WEBPACK_IMPORTED_MODULE_4__[/* store */ "a"]);
  const {
    getBlockName,
    getBlocks
  } = registry.select(_store__WEBPACK_IMPORTED_MODULE_4__[/* store */ "a"]);
  const isControlled = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__["useSelect"])(select => {
    return !clientId || select(_store__WEBPACK_IMPORTED_MODULE_4__[/* store */ "a"]).areInnerBlocksControlled(clientId);
  }, [clientId]);
  const pendingChanges = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useRef"])({
    incoming: null,
    outgoing: []
  });
  const subscribed = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useRef"])(false);

  const setControlledBlocks = () => {
    if (!controlledBlocks) {
      return;
    } // We don't need to persist this change because we only replace
    // controlled inner blocks when the change was caused by an entity,
    // and so it would already be persisted.


    __unstableMarkNextChangeAsNotPersistent();

    if (clientId) {
      // It is important to batch here because otherwise,
      // as soon as `setHasControlledInnerBlocks` is called
      // the effect to restore might be triggered
      // before the actual blocks get set properly in state.
      registry.batch(() => {
        setHasControlledInnerBlocks(clientId, true);
        const storeBlocks = controlledBlocks.map(block => Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_3__["cloneBlock"])(block));

        if (subscribed.current) {
          pendingChanges.current.incoming = storeBlocks;
        }

        __unstableMarkNextChangeAsNotPersistent();

        replaceInnerBlocks(clientId, storeBlocks);
      });
    } else {
      if (subscribed.current) {
        pendingChanges.current.incoming = controlledBlocks;
      }

      resetBlocks(controlledBlocks);
    }
  }; // Add a subscription to the block-editor registry to detect when changes
  // have been made. This lets us inform the data source of changes. This
  // is an effect so that the subscriber can run synchronously without
  // waiting for React renders for changes.


  const onInputRef = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useRef"])(onInput);
  const onChangeRef = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useRef"])(onChange);
  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(() => {
    onInputRef.current = onInput;
    onChangeRef.current = onChange;
  }, [onInput, onChange]); // Determine if blocks need to be reset when they change.

  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(() => {
    if (pendingChanges.current.outgoing.includes(controlledBlocks)) {
      // Skip block reset if the value matches expected outbound sync
      // triggered by this component by a preceding change detection.
      // Only skip if the value matches expectation, since a reset should
      // still occur if the value is modified (not equal by reference),
      // to allow that the consumer may apply modifications to reflect
      // back on the editor.
      if (Object(lodash__WEBPACK_IMPORTED_MODULE_0__["last"])(pendingChanges.current.outgoing) === controlledBlocks) {
        pendingChanges.current.outgoing = [];
      }
    } else if (getBlocks(clientId) !== controlledBlocks) {
      // Reset changing value in all other cases than the sync described
      // above. Since this can be reached in an update following an out-
      // bound sync, unset the outbound value to avoid considering it in
      // subsequent renders.
      pendingChanges.current.outgoing = [];
      setControlledBlocks();

      if (controlledSelection) {
        resetSelection(controlledSelection.selectionStart, controlledSelection.selectionEnd, controlledSelection.initialPosition);
      }
    }
  }, [controlledBlocks, clientId]);
  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(() => {
    // When the block becomes uncontrolled, it means its inner state has been reset
    // we need to take the blocks again from the external value property.
    if (!isControlled) {
      pendingChanges.current.outgoing = [];
      setControlledBlocks();
    }
  }, [isControlled]);
  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(() => {
    const {
      getSelectionStart,
      getSelectionEnd,
      getSelectedBlocksInitialCaretPosition,
      isLastBlockChangePersistent,
      __unstableIsLastBlockChangeIgnored,
      areInnerBlocksControlled
    } = registry.select(_store__WEBPACK_IMPORTED_MODULE_4__[/* store */ "a"]);
    let blocks = getBlocks(clientId);
    let isPersistent = isLastBlockChangePersistent();
    let previousAreBlocksDifferent = false;
    subscribed.current = true;
    const unsubscribe = registry.subscribe(() => {
      // Sometimes, when changing block lists, lingering subscriptions
      // might trigger before they are cleaned up. If the block for which
      // the subscription runs is no longer in the store, this would clear
      // its parent entity's block list. To avoid this, we bail out if
      // the subscription is triggering for a block (`clientId !== null`)
      // and its block name can't be found because it's not on the list.
      // (`getBlockName( clientId ) === null`).
      if (clientId !== null && getBlockName(clientId) === null) return; // When RESET_BLOCKS on parent blocks get called, the controlled blocks
      // can reset to uncontrolled, in these situations, it means we need to populate
      // the blocks again from the external blocks (the value property here)
      // and we should stop triggering onChange

      const isStillControlled = !clientId || areInnerBlocksControlled(clientId);

      if (!isStillControlled) {
        return;
      }

      const newIsPersistent = isLastBlockChangePersistent();
      const newBlocks = getBlocks(clientId);
      const areBlocksDifferent = newBlocks !== blocks;
      blocks = newBlocks;

      if (areBlocksDifferent && (pendingChanges.current.incoming || __unstableIsLastBlockChangeIgnored())) {
        pendingChanges.current.incoming = null;
        isPersistent = newIsPersistent;
        return;
      } // Since we often dispatch an action to mark the previous action as
      // persistent, we need to make sure that the blocks changed on the
      // previous action before committing the change.


      const didPersistenceChange = previousAreBlocksDifferent && !areBlocksDifferent && newIsPersistent && !isPersistent;

      if (areBlocksDifferent || didPersistenceChange) {
        isPersistent = newIsPersistent; // We know that onChange/onInput will update controlledBlocks.
        // We need to be aware that it was caused by an outgoing change
        // so that we do not treat it as an incoming change later on,
        // which would cause a block reset.

        pendingChanges.current.outgoing.push(blocks); // Inform the controlling entity that changes have been made to
        // the block-editor store they should be aware about.

        const updateParent = isPersistent ? onChangeRef.current : onInputRef.current;
        updateParent(blocks, {
          selection: {
            selectionStart: getSelectionStart(),
            selectionEnd: getSelectionEnd(),
            initialPosition: getSelectedBlocksInitialCaretPosition()
          }
        });
      }

      previousAreBlocksDifferent = areBlocksDifferent;
    });
    return () => unsubscribe();
  }, [registry, clientId]);
}


/***/ }),

/***/ "JRTi":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ BlockEdit; });

// UNUSED EXPORTS: useBlockEditContext

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__("TSYQ");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: external ["wp","components"]
var external_wp_components_ = __webpack_require__("tI+e");

// EXTERNAL MODULE: external ["wp","blocks"]
var external_wp_blocks_ = __webpack_require__("HSyU");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-context/index.js
var block_context = __webpack_require__("uoCR");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-edit/edit.js



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */


/**
 * Default value used for blocks which do not define their own context needs,
 * used to guarantee that a block's `context` prop will always be an object. It
 * is assigned as a constant since it is always expected to be an empty object,
 * and in order to avoid unnecessary React reconciliations of a changing object.
 *
 * @type {{}}
 */

const DEFAULT_BLOCK_CONTEXT = {};
const Edit = props => {
  const {
    attributes = {},
    name
  } = props;
  const blockType = Object(external_wp_blocks_["getBlockType"])(name);
  const blockContext = Object(external_wp_element_["useContext"])(block_context["b" /* default */]); // Assign context values using the block type's declared context needs.

  const context = Object(external_wp_element_["useMemo"])(() => {
    return blockType && blockType.usesContext ? Object(external_lodash_["pick"])(blockContext, blockType.usesContext) : DEFAULT_BLOCK_CONTEXT;
  }, [blockType, blockContext]);

  if (!blockType) {
    return null;
  } // `edit` and `save` are functions or components describing the markup
  // with which a block is displayed. If `blockType` is valid, assign
  // them preferentially as the render value for the block.


  const Component = blockType.edit || blockType.save;

  if (blockType.apiVersion > 1) {
    return Object(external_wp_element_["createElement"])(Component, Object(esm_extends["a" /* default */])({}, props, {
      context: context
    }));
  } // Generate a class name for the block's editable form


  const generatedClassName = Object(external_wp_blocks_["hasBlockSupport"])(blockType, 'className', true) ? Object(external_wp_blocks_["getBlockDefaultClassName"])(name) : null;
  const className = classnames_default()(generatedClassName, attributes.className);
  return Object(external_wp_element_["createElement"])(Component, Object(esm_extends["a" /* default */])({}, props, {
    context: context,
    className: className
  }));
};
/* harmony default export */ var edit = (Object(external_wp_components_["withFilters"])('editor.BlockEdit')(Edit));

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-edit/context.js
var block_edit_context = __webpack_require__("ur0x");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-edit/index.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




function BlockEdit(props) {
  const {
    name,
    isSelected,
    clientId
  } = props;
  const context = {
    name,
    isSelected,
    clientId
  };
  return Object(external_wp_element_["createElement"])(block_edit_context["a" /* BlockEditContextProvider */] // It is important to return the same object if props haven't
  // changed to avoid  unnecessary rerenders.
  // See https://reactjs.org/docs/context.html#caveats.
  , {
    value: Object(external_wp_element_["useMemo"])(() => context, Object.values(context))
  }, Object(external_wp_element_["createElement"])(edit, props));
}


/***/ }),

/***/ "JUfZ":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wx14");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("TSYQ");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("HSyU");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _navigable_toolbar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("GkEL");
/* harmony import */ var _block_toolbar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("+gtr");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("BhPs");



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */





function BlockContextualToolbar(_ref) {
  let {
    focusOnMount,
    isFixed,
    ...props
  } = _ref;
  const {
    blockType,
    hasParents,
    showParentSelector
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_5__["useSelect"])(select => {
    const {
      getBlockName,
      getBlockParents,
      getSelectedBlockClientIds
    } = select(_store__WEBPACK_IMPORTED_MODULE_8__[/* store */ "a"]);
    const {
      getBlockType
    } = select(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__["store"]);
    const selectedBlockClientIds = getSelectedBlockClientIds();
    const selectedBlockClientId = selectedBlockClientIds[0];
    const parents = getBlockParents(selectedBlockClientId);
    const firstParentClientId = parents[parents.length - 1];
    const parentBlockName = getBlockName(firstParentClientId);
    const parentBlockType = getBlockType(parentBlockName);
    return {
      blockType: selectedBlockClientId && getBlockType(getBlockName(selectedBlockClientId)),
      hasParents: parents.length,
      showParentSelector: Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__["hasBlockSupport"])(parentBlockType, '__experimentalParentSelector', true) && selectedBlockClientIds.length <= 1
    };
  }, []);

  if (blockType) {
    if (!Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_4__["hasBlockSupport"])(blockType, '__experimentalToolbar', true)) {
      return null;
    }
  } // Shifts the toolbar to make room for the parent block selector.


  const classes = classnames__WEBPACK_IMPORTED_MODULE_2___default()('block-editor-block-contextual-toolbar', {
    'has-parent': hasParents && showParentSelector,
    'is-fixed': isFixed
  });
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_navigable_toolbar__WEBPACK_IMPORTED_MODULE_6__[/* default */ "a"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
    focusOnMount: focusOnMount,
    className: classes
    /* translators: accessibility text for the block toolbar */
    ,
    "aria-label": Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_3__["__"])('Block tools')
  }, props), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_block_toolbar__WEBPACK_IMPORTED_MODULE_7__[/* default */ "a"], {
    hideDragHandle: isFixed
  }));
}

/* harmony default export */ __webpack_exports__["a"] = (BlockContextualToolbar);


/***/ }),

/***/ "JygI":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wx14");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("YLtl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("TSYQ");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("xN+R");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("HSyU");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var _block_draggable__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("ZAjO");
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__("9Ma0");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__("BhPs");



/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */







/**
 * Internal dependencies
 */





function BlockMover(_ref) {
  let {
    isFirst,
    isLast,
    clientIds,
    canMove,
    isHidden,
    rootClientId,
    orientation,
    hideDragHandle
  } = _ref;
  const [isFocused, setIsFocused] = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useState"])(false);

  const onFocus = () => setIsFocused(true);

  const onBlur = () => setIsFocused(false);

  if (!canMove || isFirst && isLast && !rootClientId) {
    return null;
  }

  const dragHandleLabel = Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_8__["__"])('Drag'); // We emulate a disabled state because forcefully applying the `disabled`
  // attribute on the buttons while it has focus causes the screen to change
  // to an unfocused state (body as active element) without firing blur on,
  // the rendering parent, leaving it unable to react to focus out.


  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])("div", {
    className: classnames__WEBPACK_IMPORTED_MODULE_3___default()('block-editor-block-mover', {
      'is-visible': isFocused || !isHidden,
      'is-horizontal': orientation === 'horizontal'
    })
  }, !hideDragHandle && Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_block_draggable__WEBPACK_IMPORTED_MODULE_9__[/* default */ "a"], {
    clientIds: clientIds,
    cloneClassname: "block-editor-block-mover__drag-clone"
  }, draggableProps => Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__["Button"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"],
    className: "block-editor-block-mover__drag-handle",
    "aria-hidden": "true",
    label: dragHandleLabel // Should not be able to tab to drag handle as this
    // button can only be used with a pointer device.
    ,
    tabIndex: "-1"
  }, draggableProps))), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__["ToolbarGroup"], {
    className: "block-editor-block-mover__move-button-container"
  }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__["ToolbarItem"], {
    onFocus: onFocus,
    onBlur: onBlur
  }, itemProps => Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_button__WEBPACK_IMPORTED_MODULE_10__[/* BlockMoverUpButton */ "b"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
    clientIds: clientIds
  }, itemProps))), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_5__["ToolbarItem"], {
    onFocus: onFocus,
    onBlur: onBlur
  }, itemProps => Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_button__WEBPACK_IMPORTED_MODULE_10__[/* BlockMoverDownButton */ "a"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
    clientIds: clientIds
  }, itemProps)))));
}

/* harmony default export */ __webpack_exports__["a"] = (Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_7__["withSelect"])((select, _ref2) => {
  var _getBlockListSettings;

  let {
    clientIds
  } = _ref2;
  const {
    getBlock,
    getBlockIndex,
    getBlockListSettings,
    canMoveBlocks,
    getBlockOrder,
    getBlockRootClientId
  } = select(_store__WEBPACK_IMPORTED_MODULE_11__[/* store */ "a"]);
  const normalizedClientIds = Object(lodash__WEBPACK_IMPORTED_MODULE_2__["castArray"])(clientIds);
  const firstClientId = Object(lodash__WEBPACK_IMPORTED_MODULE_2__["first"])(normalizedClientIds);
  const block = getBlock(firstClientId);
  const rootClientId = getBlockRootClientId(Object(lodash__WEBPACK_IMPORTED_MODULE_2__["first"])(normalizedClientIds));
  const firstIndex = getBlockIndex(firstClientId);
  const lastIndex = getBlockIndex(Object(lodash__WEBPACK_IMPORTED_MODULE_2__["last"])(normalizedClientIds));
  const blockOrder = getBlockOrder(rootClientId);
  const isFirst = firstIndex === 0;
  const isLast = lastIndex === blockOrder.length - 1;
  return {
    blockType: block ? Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_6__["getBlockType"])(block.name) : null,
    canMove: canMoveBlocks(clientIds, rootClientId),
    rootClientId,
    firstIndex,
    isFirst,
    isLast,
    orientation: (_getBlockListSettings = getBlockListSettings(rootClientId)) === null || _getBlockListSettings === void 0 ? void 0 : _getBlockListSettings.orientation
  };
})(BlockMover));


/***/ }),

/***/ "Jyyd":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */

const {
  Fill: __unstableBlockSettingsMenuFirstItem,
  Slot
} = Object(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__["createSlotFill"])('__unstableBlockSettingsMenuFirstItem');
__unstableBlockSettingsMenuFirstItem.Slot = Slot;
/* harmony default export */ __webpack_exports__["a"] = (__unstableBlockSettingsMenuFirstItem);


/***/ }),

/***/ "K/rC":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useAvailableAlignments; });
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _block_list_layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("w8sn");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("BhPs");
/* harmony import */ var _layouts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("PPMp");
/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */




const DEFAULT_CONTROLS = ['none', 'left', 'center', 'right', 'wide', 'full'];
const WIDE_CONTROLS = ['wide', 'full'];
function useAvailableAlignments() {
  let controls = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : DEFAULT_CONTROLS;

  // Always add the `none` option if not exists.
  if (!controls.includes('none')) {
    controls = ['none', ...controls];
  }

  const {
    wideControlsEnabled = false,
    themeSupportsLayout
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_0__["useSelect"])(select => {
    const {
      getSettings
    } = select(_store__WEBPACK_IMPORTED_MODULE_2__[/* store */ "a"]);
    const settings = getSettings();
    return {
      wideControlsEnabled: settings.alignWide,
      themeSupportsLayout: settings.supportsLayout
    };
  }, []);
  const layout = Object(_block_list_layout__WEBPACK_IMPORTED_MODULE_1__[/* useLayout */ "d"])();
  const layoutType = Object(_layouts__WEBPACK_IMPORTED_MODULE_3__[/* getLayoutType */ "a"])(layout === null || layout === void 0 ? void 0 : layout.type);
  const layoutAlignments = layoutType.getAlignments(layout);

  if (themeSupportsLayout) {
    const alignments = layoutAlignments.filter(_ref => {
      let {
        name: alignmentName
      } = _ref;
      return controls.includes(alignmentName);
    }); // While we treat `none` as an alignment, we shouldn't return it if no
    // other alignments exist.

    if (alignments.length === 1 && alignments[0].name === 'none') {
      return [];
    }

    return alignments;
  } // Starting here, it's the fallback for themes not supporting the layout config.


  if (layoutType.name !== 'default') {
    return [];
  }

  const {
    alignments: availableAlignments = DEFAULT_CONTROLS
  } = layout;
  const enabledControls = controls.filter(control => (layout.alignments || // Ignore the global wideAlignment check if the layout explicitely defines alignments.
  wideControlsEnabled || !WIDE_CONTROLS.includes(control)) && availableAlignments.includes(control)).map(enabledControl => ({
    name: enabledControl
  })); // While we treat `none` as an alignment, we shouldn't return it if no
  // other alignments exist.

  if (enabledControls.length === 1 && enabledControls[0].name === 'none') {
    return [];
  }

  return enabledControls;
}


/***/ }),

/***/ "K8zD":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const globe = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M12 3.3c-4.8 0-8.8 3.9-8.8 8.8 0 4.8 3.9 8.8 8.8 8.8 4.8 0 8.8-3.9 8.8-8.8s-4-8.8-8.8-8.8zm6.5 5.5h-2.6C15.4 7.3 14.8 6 14 5c2 .6 3.6 2 4.5 3.8zm.7 3.2c0 .6-.1 1.2-.2 1.8h-2.9c.1-.6.1-1.2.1-1.8s-.1-1.2-.1-1.8H19c.2.6.2 1.2.2 1.8zM12 18.7c-1-.7-1.8-1.9-2.3-3.5h4.6c-.5 1.6-1.3 2.9-2.3 3.5zm-2.6-4.9c-.1-.6-.1-1.1-.1-1.8 0-.6.1-1.2.1-1.8h5.2c.1.6.1 1.1.1 1.8s-.1 1.2-.1 1.8H9.4zM4.8 12c0-.6.1-1.2.2-1.8h2.9c-.1.6-.1 1.2-.1 1.8 0 .6.1 1.2.1 1.8H5c-.2-.6-.2-1.2-.2-1.8zM12 5.3c1 .7 1.8 1.9 2.3 3.5H9.7c.5-1.6 1.3-2.9 2.3-3.5zM10 5c-.8 1-1.4 2.3-1.8 3.8H5.5C6.4 7 8 5.6 10 5zM5.5 15.3h2.6c.4 1.5 1 2.8 1.8 3.7-1.8-.6-3.5-2-4.4-3.7zM14 19c.8-1 1.4-2.2 1.8-3.7h2.6C17.6 17 16 18.4 14 19z"
}));
/* harmony default export */ __webpack_exports__["a"] = (globe);


/***/ }),

/***/ "K9lf":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["compose"]; }());

/***/ }),

/***/ "KyyN":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return EditorStyles; });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var colord__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("fHnH");
/* harmony import */ var colord_plugins_names__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("abaT");
/* harmony import */ var colord_plugins_a11y__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("7bKH");
/* harmony import */ var _utils_transform_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("vSu0");


/**
 * External dependencies
 */



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


const EDITOR_STYLES_SELECTOR = '.editor-styles-wrapper';
Object(colord__WEBPACK_IMPORTED_MODULE_1__[/* extend */ "b"])([colord_plugins_names__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"], colord_plugins_a11y__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"]]);

function useDarkThemeBodyClassName(styles) {
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(node => {
    if (!node) {
      return;
    }

    const {
      ownerDocument
    } = node;
    const {
      defaultView,
      body
    } = ownerDocument;
    const canvas = ownerDocument.querySelector(EDITOR_STYLES_SELECTOR);
    let backgroundColor;

    if (!canvas) {
      // The real .editor-styles-wrapper element might not exist in the
      // DOM, so calculate the background color by creating a fake
      // wrapper.
      const tempCanvas = ownerDocument.createElement('div');
      tempCanvas.classList.add('editor-styles-wrapper');
      body.appendChild(tempCanvas);
      backgroundColor = defaultView.getComputedStyle(tempCanvas, null).getPropertyValue('background-color');
      body.removeChild(tempCanvas);
    } else {
      backgroundColor = defaultView.getComputedStyle(canvas, null).getPropertyValue('background-color');
    }

    const colordBackgroundColor = Object(colord__WEBPACK_IMPORTED_MODULE_1__[/* colord */ "a"])(backgroundColor); // If background is transparent, it should be treated as light color.

    if (colordBackgroundColor.luminance() > 0.5 || colordBackgroundColor.alpha() === 0) {
      body.classList.remove('is-dark-theme');
    } else {
      body.classList.add('is-dark-theme');
    }
  }, [styles]);
}

function EditorStyles(_ref) {
  let {
    styles
  } = _ref;
  const transformedStyles = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(() => Object(_utils_transform_styles__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"])(styles, EDITOR_STYLES_SELECTOR), [styles]);
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["Fragment"], null, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("style", {
    ref: useDarkThemeBodyClassName(styles)
  }), transformedStyles.map((css, index) => Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("style", {
    key: index
  }, css)));
}


/***/ }),

/***/ "LolH":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("iClF");
/* harmony import */ var _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("//Lo");


/**
 * WordPress dependencies
 */



function InserterNoResults() {
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("div", {
    className: "block-editor-inserter__no-results"
  }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_icons__WEBPACK_IMPORTED_MODULE_2__[/* default */ "a"], {
    className: "block-editor-inserter__no-results-icon",
    icon: _wordpress_icons__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"]
  }), Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])("p", null, Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_1__["__"])('No results found.')));
}

/* harmony default export */ __webpack_exports__["a"] = (InserterNoResults);


/***/ }),

/***/ "M+co":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wx14");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("GOly");



/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */



function InserterListboxItem(_ref, ref) {
  let {
    isFirst,
    as: Component,
    children,
    ...props
  } = _ref;
  const state = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_context__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"]);
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["__unstableCompositeItem"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
    ref: ref,
    state: state,
    role: "option" // Use the CompositeItem `focusable` prop over Button's
    // isFocusable. The latter was shown to cause an issue
    // with tab order in the inserter list.
    ,
    focusable: true
  }, props), htmlProps => {
    const propsWithTabIndex = { ...htmlProps,
      tabIndex: isFirst ? 0 : htmlProps.tabIndex
    };

    if (Component) {
      return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(Component, propsWithTabIndex, children);
    }

    if (typeof children === 'function') {
      return children(propsWithTabIndex);
    }

    return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["Button"], propsWithTabIndex, children);
  });
}

/* harmony default export */ __webpack_exports__["a"] = (Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["forwardRef"])(InserterListboxItem));


/***/ }),

/***/ "Mmq9":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["url"]; }());

/***/ }),

/***/ "Mp0b":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const linkOff = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M15.6 7.3h-.7l1.6-3.5-.9-.4-3.9 8.5H9v1.5h2l-1.3 2.8H8.4c-2 0-3.7-1.7-3.7-3.7s1.7-3.7 3.7-3.7H10V7.3H8.4c-2.9 0-5.2 2.3-5.2 5.2 0 2.9 2.3 5.2 5.2 5.2H9l-1.4 3.2.9.4 5.7-12.5h1.4c2 0 3.7 1.7 3.7 3.7s-1.7 3.7-3.7 3.7H14v1.5h1.6c2.9 0 5.2-2.3 5.2-5.2 0-2.9-2.4-5.2-5.2-5.2z"
}));
/* harmony default export */ __webpack_exports__["a"] = (linkOff);


/***/ }),

/***/ "NMUH":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return getFontSize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return getFontSizeObjectByValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return getFontSizeClass; });
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("YLtl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);
/**
 * External dependencies
 */

/**
 *  Returns the font size object based on an array of named font sizes and the namedFontSize and customFontSize values.
 * 	If namedFontSize is undefined or not found in fontSizes an object with just the size value based on customFontSize is returned.
 *
 * @param {Array}   fontSizes               Array of font size objects containing at least the "name" and "size" values as properties.
 * @param {?string} fontSizeAttribute       Content of the font size attribute (slug).
 * @param {?number} customFontSizeAttribute Contents of the custom font size attribute (value).
 *
 * @return {?Object} If fontSizeAttribute is set and an equal slug is found in fontSizes it returns the font size object for that slug.
 * 					 Otherwise, an object with just the size value based on customFontSize is returned.
 */

const getFontSize = (fontSizes, fontSizeAttribute, customFontSizeAttribute) => {
  if (fontSizeAttribute) {
    const fontSizeObject = Object(lodash__WEBPACK_IMPORTED_MODULE_0__["find"])(fontSizes, {
      slug: fontSizeAttribute
    });

    if (fontSizeObject) {
      return fontSizeObject;
    }
  }

  return {
    size: customFontSizeAttribute
  };
};
/**
 * Returns the corresponding font size object for a given value.
 *
 * @param {Array}  fontSizes Array of font size objects.
 * @param {number} value     Font size value.
 *
 * @return {Object} Font size object.
 */

function getFontSizeObjectByValue(fontSizes, value) {
  const fontSizeObject = Object(lodash__WEBPACK_IMPORTED_MODULE_0__["find"])(fontSizes, {
    size: value
  });

  if (fontSizeObject) {
    return fontSizeObject;
  }

  return {
    size: value
  };
}
/**
 * Returns a class based on fontSizeName.
 *
 * @param {string} fontSizeSlug Slug of the fontSize.
 *
 * @return {string} String with the class corresponding to the fontSize passed.
 *                  The class is generated by appending 'has-' followed by fontSizeSlug in kebabCase and ending with '-font-size'.
 */

function getFontSizeClass(fontSizeSlug) {
  if (!fontSizeSlug) {
    return;
  }

  return `has-${Object(lodash__WEBPACK_IMPORTED_MODULE_0__["kebabCase"])(fontSizeSlug)}-font-size`;
}


/***/ }),

/***/ "NMb1":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["deprecated"]; }());

/***/ }),

/***/ "NTP4":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const upload = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M18.5 15v3.5H13V6.7l4.5 4.1 1-1.1-6.2-5.8-5.8 5.8 1 1.1 4-4v11.7h-6V15H4v5h16v-5z"
}));
/* harmony default export */ __webpack_exports__["a"] = (upload);


/***/ }),

/***/ "NWDH":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const chevronDown = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M17.5 11.6L12 16l-5.5-4.4.9-1.2L12 14l4.5-3.6 1 1.2z"
}));
/* harmony default export */ __webpack_exports__["a"] = (chevronDown);


/***/ }),

/***/ "NtoT":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return InspectorControlsFill; });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("YLtl");
/* harmony import */ var lodash__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_warning__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("Z23Y");
/* harmony import */ var _wordpress_warning__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_warning__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _use_display_block_controls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("HgtZ");
/* harmony import */ var _groups__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("VrEk");


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



function InspectorControlsFill(_ref) {
  var _groups$group;

  let {
    __experimentalGroup: group = 'default',
    children
  } = _ref;
  const isDisplayed = Object(_use_display_block_controls__WEBPACK_IMPORTED_MODULE_4__[/* default */ "a"])();
  const Fill = (_groups$group = _groups__WEBPACK_IMPORTED_MODULE_5__[/* default */ "a"][group]) === null || _groups$group === void 0 ? void 0 : _groups$group.Fill;

  if (!Fill) {
    typeof process !== "undefined" && process.env && "production" !== "production" ? _wordpress_warning__WEBPACK_IMPORTED_MODULE_3___default()(`Unknown InspectorControl group "${group}" provided.`) : void 0;
    return null;
  }

  if (!isDisplayed) {
    return null;
  }

  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["__experimentalStyleProvider"], {
    document: document
  }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(Fill, null, fillProps => {
    // Children passed to InspectorControlsFill will not have
    // access to any React Context whose Provider is part of
    // the InspectorControlsSlot tree. So we re-create the
    // Provider in this subtree.
    const value = !Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])(fillProps) ? fillProps : null;
    return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["__experimentalToolsPanelContext"].Provider, {
      value: value
    }, children);
  }));
}

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__("8oxB")))

/***/ }),

/***/ "O6Fj":
/***/ (function(module, exports, __webpack_require__) {

"use strict";

exports.__esModule = true;
var TextareaAutosize_1 = __webpack_require__("CNgt");
exports["default"] = TextareaAutosize_1.TextareaAutosize;


/***/ }),

/***/ "OL6h":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return isInSameBlock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return isInsideRootBlock; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return getBlockClientId; });
const BLOCK_SELECTOR = '.block-editor-block-list__block';
const APPENDER_SELECTOR = '.block-list-appender';
/**
 * Returns true if two elements are contained within the same block.
 *
 * @param {Element} a First element.
 * @param {Element} b Second element.
 *
 * @return {boolean} Whether elements are in the same block.
 */

function isInSameBlock(a, b) {
  return a.closest(BLOCK_SELECTOR) === b.closest(BLOCK_SELECTOR);
}
/**
 * Returns true if an element is considered part of the block and not its inner
 * blocks or appender.
 *
 * @param {Element} blockElement Block container element.
 * @param {Element} element      Element.
 *
 * @return {boolean} Whether an element is considered part of the block and not
 *                   its inner blocks or appender.
 */

function isInsideRootBlock(blockElement, element) {
  const parentBlock = element.closest([BLOCK_SELECTOR, APPENDER_SELECTOR].join(','));
  return parentBlock === blockElement;
}
/**
 * Finds the block client ID given any DOM node inside the block.
 *
 * @param {Node?} node DOM node.
 *
 * @return {string|undefined} Client ID or undefined if the node is not part of
 *                            a block.
 */

function getBlockClientId(node) {
  while (node && node.nodeType !== node.ELEMENT_NODE) {
    node = node.parentNode;
  }

  if (!node) {
    return;
  }

  const elementNode =
  /** @type {Element} */
  node;
  const blockNode = elementNode.closest(BLOCK_SELECTOR);

  if (!blockNode) {
    return;
  }

  return blockNode.id.slice('block-'.length);
}


/***/ }),

/***/ "OzlF":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const listView = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  viewBox: "0 0 24 24",
  xmlns: "http://www.w3.org/2000/svg"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M13.8 5.2H3v1.5h10.8V5.2zm-3.6 12v1.5H21v-1.5H10.2zm7.2-6H6.6v1.5h10.8v-1.5z"
}));
/* harmony default export */ __webpack_exports__["a"] = (listView);


/***/ }),

/***/ "P7XM":
/***/ (function(module, exports) {

if (typeof Object.create === 'function') {
  // implementation from standard node.js 'util' module
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      ctor.prototype = Object.create(superCtor.prototype, {
        constructor: {
          value: ctor,
          enumerable: false,
          writable: true,
          configurable: true
        }
      })
    }
  };
} else {
  // old school shim for old browsers
  module.exports = function inherits(ctor, superCtor) {
    if (superCtor) {
      ctor.super_ = superCtor
      var TempCtor = function () {}
      TempCtor.prototype = superCtor.prototype
      ctor.prototype = new TempCtor()
      ctor.prototype.constructor = ctor
    }
  }
}


/***/ }),

/***/ "PKbb":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return useBlockRefProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return useBlockRef; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useBlockElement; });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("K9lf");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _provider_block_refs_provider__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("cDhi");
/**
 * WordPress dependencies
 */


/**
 * Internal dependencies
 */


/** @typedef {import('@wordpress/element').RefCallback} RefCallback */

/** @typedef {import('@wordpress/element').RefObject} RefObject */

/**
 * Provides a ref to the BlockRefs context.
 *
 * @param {string} clientId The client ID of the element ref.
 *
 * @return {RefCallback} Ref callback.
 */

function useBlockRefProvider(clientId) {
  const {
    refs,
    callbacks
  } = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useContext"])(_provider_block_refs_provider__WEBPACK_IMPORTED_MODULE_2__[/* BlockRefs */ "a"]);
  const ref = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useRef"])();
  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useLayoutEffect"])(() => {
    refs.set(ref, clientId);
    return () => {
      refs.delete(ref);
    };
  }, [clientId]);
  return Object(_wordpress_compose__WEBPACK_IMPORTED_MODULE_1__["useRefEffect"])(element => {
    // Update the ref in the provider.
    ref.current = element; // Call any update functions.

    callbacks.forEach((id, setElement) => {
      if (clientId === id) {
        setElement(element);
      }
    });
  }, [clientId]);
}
/**
 * Gets a ref pointing to the current block element. Continues to return a
 * stable ref even if the block client ID changes.
 *
 * @param {string} clientId The client ID to get a ref for.
 *
 * @return {RefObject} A ref containing the element.
 */

function useBlockRef(clientId) {
  const {
    refs
  } = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useContext"])(_provider_block_refs_provider__WEBPACK_IMPORTED_MODULE_2__[/* BlockRefs */ "a"]);
  const freshClientId = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useRef"])();
  freshClientId.current = clientId; // Always return an object, even if no ref exists for a given client ID, so
  // that `current` works at a later point.

  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(() => ({
    get current() {
      let element = null; // Multiple refs may be created for a single block. Find the
      // first that has an element set.

      for (const [ref, id] of refs.entries()) {
        if (id === freshClientId.current && ref.current) {
          element = ref.current;
        }
      }

      return element;
    }

  }), []);
}
/**
 * Return the element for a given client ID. Updates whenever the element
 * changes, becomes available, or disappears.
 *
 * @param {string} clientId The client ID to an element for.
 *
 * @return {Element|null} The block's wrapper element.
 */


function useBlockElement(clientId) {
  const {
    callbacks
  } = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useContext"])(_provider_block_refs_provider__WEBPACK_IMPORTED_MODULE_2__[/* BlockRefs */ "a"]);
  const ref = useBlockRef(clientId);
  const [element, setElement] = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useState"])(null);
  Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useLayoutEffect"])(() => {
    if (!clientId) {
      return;
    }

    callbacks.set(setElement, clientId);
    return () => {
      callbacks.delete(setElement);
    };
  }, [clientId]);
  return ref.current || element;
}





/***/ }),

/***/ "PPMp":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ getLayoutType; });
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ getLayoutTypes; });

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-left.js
var justify_left = __webpack_require__("kWXm");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-center.js
var justify_center = __webpack_require__("DmX/");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-right.js
var justify_right = __webpack_require__("suLj");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/justify-space-between.js
var justify_space_between = __webpack_require__("bTSr");

// EXTERNAL MODULE: external ["wp","primitives"]
var external_wp_primitives_ = __webpack_require__("Tqx9");

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/arrow-right.js


/**
 * WordPress dependencies
 */

const arrowRight = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  d: "M14.3 6.7l-1.1 1.1 4 4H4v1.5h13.3l-4.1 4.4 1.1 1.1 5.8-6.3z"
}));
/* harmony default export */ var arrow_right = (arrowRight);

// CONCATENATED MODULE: ./node_modules/@wordpress/icons/build-module/library/arrow-down.js


/**
 * WordPress dependencies
 */

const arrowDown = Object(external_wp_element_["createElement"])(external_wp_primitives_["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(external_wp_element_["createElement"])(external_wp_primitives_["Path"], {
  d: "M16.2 13.2l-4 4V4h-1.5v13.3l-4.5-4.1-1 1.1 6.2 5.8 5.8-5.8-1-1.1z"
}));
/* harmony default export */ var arrow_down = (arrowDown);

// EXTERNAL MODULE: external ["wp","components"]
var external_wp_components_ = __webpack_require__("tI+e");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/utils.js
/**
 * Utility to generate the proper CSS selector for layout styles.
 *
 * @param {string|string[]} selectors - CSS selectors
 * @param {boolean}         append    - string to append.
 *
 * @return {string} - CSS selector.
 */
function appendSelectors(selectors) {
  let append = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  // Ideally we shouldn't need the `.editor-styles-wrapper` increased specificity here
  // The problem though is that we have a `.editor-styles-wrapper p { margin: reset; }` style
  // it's used to reset the default margin added by wp-admin to paragraphs
  // so we need this to be higher speficity otherwise, it won't be applied to paragraphs inside containers
  // When the post editor is fully iframed, this extra classname could be removed.
  return selectors.split(',').map(subselector => `.editor-styles-wrapper ${subselector} ${append}`).join(',');
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/use-setting/index.js
var use_setting = __webpack_require__("v5LD");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-controls/index.js + 4 modules
var block_controls = __webpack_require__("fOYa");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/justify-content-control/index.js + 1 modules
var justify_content_control = __webpack_require__("0E5u");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/flex.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



 // Used with the default, horizontal flex orientation.

const justifyContentMap = {
  left: 'flex-start',
  right: 'flex-end',
  center: 'center',
  'space-between': 'space-between'
}; // Used with the vertical (column) flex orientation.

const alignItemsMap = {
  left: 'flex-start',
  right: 'flex-end',
  center: 'center'
};
const flexWrapOptions = ['wrap', 'nowrap'];
/* harmony default export */ var flex = ({
  name: 'flex',
  label: Object(external_wp_i18n_["__"])('Flex'),
  inspectorControls: function FlexLayoutInspectorControls(_ref) {
    let {
      layout = {},
      onChange
    } = _ref;
    const {
      allowOrientation = true
    } = layout;
    return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])(external_wp_components_["Flex"], null, Object(external_wp_element_["createElement"])(external_wp_components_["FlexItem"], null, Object(external_wp_element_["createElement"])(FlexLayoutJustifyContentControl, {
      layout: layout,
      onChange: onChange
    })), Object(external_wp_element_["createElement"])(external_wp_components_["FlexItem"], null, allowOrientation && Object(external_wp_element_["createElement"])(OrientationControl, {
      layout: layout,
      onChange: onChange
    }))), Object(external_wp_element_["createElement"])(FlexWrapControl, {
      layout: layout,
      onChange: onChange
    }));
  },
  toolBarControls: function FlexLayoutToolbarControls(_ref2) {
    let {
      layout = {},
      onChange,
      layoutBlockSupport
    } = _ref2;

    if (layoutBlockSupport !== null && layoutBlockSupport !== void 0 && layoutBlockSupport.allowSwitching) {
      return null;
    }

    return Object(external_wp_element_["createElement"])(block_controls["b" /* default */], {
      group: "block",
      __experimentalShareWithChildBlocks: true
    }, Object(external_wp_element_["createElement"])(FlexLayoutJustifyContentControl, {
      layout: layout,
      onChange: onChange,
      isToolbar: true
    }));
  },
  save: function FlexLayoutStyle(_ref3) {
    var _style$spacing$blockG, _style$spacing;

    let {
      selector,
      layout,
      style
    } = _ref3;
    const {
      orientation = 'horizontal'
    } = layout;
    const blockGapSupport = Object(use_setting["a" /* default */])('spacing.blockGap');
    const hasBlockGapStylesSupport = blockGapSupport !== null;
    const blockGapValue = (_style$spacing$blockG = style === null || style === void 0 ? void 0 : (_style$spacing = style.spacing) === null || _style$spacing === void 0 ? void 0 : _style$spacing.blockGap) !== null && _style$spacing$blockG !== void 0 ? _style$spacing$blockG : 'var( --wp--style--block-gap, 0.5em )';
    const justifyContent = justifyContentMap[layout.justifyContent] || justifyContentMap.left;
    const flexWrap = flexWrapOptions.includes(layout.flexWrap) ? layout.flexWrap : 'wrap';
    const rowOrientation = `
		flex-direction: row;
		align-items: center;
		justify-content: ${justifyContent};
		`;
    const alignItems = alignItemsMap[layout.justifyContent] || alignItemsMap.left;
    const columnOrientation = `
		flex-direction: column;
		align-items: ${alignItems};
		`;
    return Object(external_wp_element_["createElement"])("style", null, `
				${appendSelectors(selector)} {
					display: flex;
					gap: ${hasBlockGapStylesSupport ? blockGapValue : '0.5em'};
					flex-wrap: ${flexWrap};
					${orientation === 'horizontal' ? rowOrientation : columnOrientation}
				}

				${appendSelectors(selector, '> *')} {
					margin: 0;
				}
			`);
  },

  getOrientation(layout) {
    const {
      orientation = 'horizontal'
    } = layout;
    return orientation;
  },

  getAlignments() {
    return [];
  }

});

function FlexLayoutJustifyContentControl(_ref4) {
  let {
    layout,
    onChange,
    isToolbar = false
  } = _ref4;
  const {
    justifyContent = 'left',
    orientation = 'horizontal'
  } = layout;

  const onJustificationChange = value => {
    onChange({ ...layout,
      justifyContent: value
    });
  };

  const allowedControls = ['left', 'center', 'right'];

  if (orientation === 'horizontal') {
    allowedControls.push('space-between');
  }

  if (isToolbar) {
    return Object(external_wp_element_["createElement"])(justify_content_control["a" /* JustifyContentControl */], {
      allowedControls: allowedControls,
      value: justifyContent,
      onChange: onJustificationChange,
      popoverProps: {
        position: 'bottom right',
        isAlternate: true
      }
    });
  }

  const justificationOptions = [{
    value: 'left',
    icon: justify_left["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Justify items left')
  }, {
    value: 'center',
    icon: justify_center["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Justify items center')
  }, {
    value: 'right',
    icon: justify_right["a" /* default */],
    label: Object(external_wp_i18n_["__"])('Justify items right')
  }];

  if (orientation === 'horizontal') {
    justificationOptions.push({
      value: 'space-between',
      icon: justify_space_between["a" /* default */],
      label: Object(external_wp_i18n_["__"])('Space between items')
    });
  }

  return Object(external_wp_element_["createElement"])("fieldset", {
    className: "block-editor-hooks__flex-layout-justification-controls"
  }, Object(external_wp_element_["createElement"])("legend", null, Object(external_wp_i18n_["__"])('Justification')), Object(external_wp_element_["createElement"])("div", null, justificationOptions.map(_ref5 => {
    let {
      value,
      icon,
      label
    } = _ref5;
    return Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
      key: value,
      label: label,
      icon: icon,
      isPressed: justifyContent === value,
      onClick: () => onJustificationChange(value)
    });
  })));
}

function FlexWrapControl(_ref6) {
  let {
    layout,
    onChange
  } = _ref6;
  const {
    flexWrap = 'wrap'
  } = layout;
  return Object(external_wp_element_["createElement"])(external_wp_components_["ToggleControl"], {
    label: Object(external_wp_i18n_["__"])('Allow to wrap to multiple lines'),
    onChange: value => {
      onChange({ ...layout,
        flexWrap: value ? 'wrap' : 'nowrap'
      });
    },
    checked: flexWrap === 'wrap'
  });
}

function OrientationControl(_ref7) {
  let {
    layout,
    onChange
  } = _ref7;
  const {
    orientation = 'horizontal'
  } = layout;
  return Object(external_wp_element_["createElement"])("fieldset", {
    className: "block-editor-hooks__flex-layout-orientation-controls"
  }, Object(external_wp_element_["createElement"])("legend", null, Object(external_wp_i18n_["__"])('Orientation')), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    label: 'horizontal',
    icon: arrow_right,
    isPressed: orientation === 'horizontal',
    onClick: () => onChange({ ...layout,
      orientation: 'horizontal'
    })
  }), Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
    label: 'vertical',
    icon: arrow_down,
    isPressed: orientation === 'vertical',
    onClick: () => onChange({ ...layout,
      orientation: 'vertical'
    })
  }));
}

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/icon/index.js
var build_module_icon = __webpack_require__("iClF");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/position-center.js
var position_center = __webpack_require__("EpZT");

// EXTERNAL MODULE: ./node_modules/@wordpress/icons/build-module/library/stretch-wide.js
var stretch_wide = __webpack_require__("beZb");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/flow.js


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */



/* harmony default export */ var flow = ({
  name: 'default',
  label: Object(external_wp_i18n_["__"])('Flow'),
  inspectorControls: function DefaultLayoutInspectorControls(_ref) {
    let {
      layout,
      onChange
    } = _ref;
    const {
      wideSize,
      contentSize
    } = layout;
    const units = Object(external_wp_components_["__experimentalUseCustomUnits"])({
      availableUnits: Object(use_setting["a" /* default */])('spacing.units') || ['%', 'px', 'em', 'rem', 'vw']
    });
    return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-hooks__layout-controls"
    }, Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-hooks__layout-controls-unit"
    }, Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalUnitControl"], {
      label: Object(external_wp_i18n_["__"])('Content'),
      labelPosition: "top",
      __unstableInputWidth: "80px",
      value: contentSize || wideSize || '',
      onChange: nextWidth => {
        nextWidth = 0 > parseFloat(nextWidth) ? '0' : nextWidth;
        onChange({ ...layout,
          contentSize: nextWidth
        });
      },
      units: units
    }), Object(external_wp_element_["createElement"])(build_module_icon["a" /* default */], {
      icon: position_center["a" /* default */]
    })), Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-hooks__layout-controls-unit"
    }, Object(external_wp_element_["createElement"])(external_wp_components_["__experimentalUnitControl"], {
      label: Object(external_wp_i18n_["__"])('Wide'),
      labelPosition: "top",
      __unstableInputWidth: "80px",
      value: wideSize || contentSize || '',
      onChange: nextWidth => {
        nextWidth = 0 > parseFloat(nextWidth) ? '0' : nextWidth;
        onChange({ ...layout,
          wideSize: nextWidth
        });
      },
      units: units
    }), Object(external_wp_element_["createElement"])(build_module_icon["a" /* default */], {
      icon: stretch_wide["a" /* default */]
    }))), Object(external_wp_element_["createElement"])("div", {
      className: "block-editor-hooks__layout-controls-reset"
    }, Object(external_wp_element_["createElement"])(external_wp_components_["Button"], {
      variant: "secondary",
      isSmall: true,
      disabled: !contentSize && !wideSize,
      onClick: () => onChange({
        contentSize: undefined,
        wideSize: undefined,
        inherit: false
      })
    }, Object(external_wp_i18n_["__"])('Reset'))), Object(external_wp_element_["createElement"])("p", {
      className: "block-editor-hooks__layout-controls-helptext"
    }, Object(external_wp_i18n_["__"])('Customize the width for all elements that are assigned to the center or wide columns.')));
  },
  toolBarControls: function DefaultLayoutToolbarControls() {
    return null;
  },
  save: function DefaultLayoutStyle(_ref2) {
    var _style$spacing$blockG, _style$spacing;

    let {
      selector,
      layout = {},
      style
    } = _ref2;
    const {
      contentSize,
      wideSize
    } = layout;
    const blockGapSupport = Object(use_setting["a" /* default */])('spacing.blockGap');
    const hasBlockGapStylesSupport = blockGapSupport !== null;
    const blockGapValue = (_style$spacing$blockG = style === null || style === void 0 ? void 0 : (_style$spacing = style.spacing) === null || _style$spacing === void 0 ? void 0 : _style$spacing.blockGap) !== null && _style$spacing$blockG !== void 0 ? _style$spacing$blockG : 'var( --wp--style--block-gap )';
    let output = !!contentSize || !!wideSize ? `
					${appendSelectors(selector, '> *')} {
						max-width: ${contentSize !== null && contentSize !== void 0 ? contentSize : wideSize};
						margin-left: auto !important;
						margin-right: auto !important;
					}

					${appendSelectors(selector, '> [data-align="wide"]')}  {
						max-width: ${wideSize !== null && wideSize !== void 0 ? wideSize : contentSize};
					}

					${appendSelectors(selector, '> [data-align="full"]')} {
						max-width: none;
					}
				` : '';
    output += `
			${appendSelectors(selector, '> [data-align="left"]')} {
				float: left;
				margin-right: 2em;
			}

			${appendSelectors(selector, '> [data-align="right"]')} {
				float: right;
				margin-left: 2em;
			}

		`;

    if (hasBlockGapStylesSupport) {
      output += `
				${appendSelectors(selector, '> *')} {
					margin-top: 0;
					margin-bottom: 0;
				}
				${appendSelectors(selector, '> * + *')} {
					margin-top: ${blockGapValue};
				}
			`;
    }

    return Object(external_wp_element_["createElement"])("style", null, output);
  },

  getOrientation() {
    return 'vertical';
  },

  getAlignments(layout) {
    const alignmentInfo = getAlignmentsInfo(layout);

    if (layout.alignments !== undefined) {
      if (!layout.alignments.includes('none')) {
        layout.alignments.unshift('none');
      }

      return layout.alignments.map(alignment => ({
        name: alignment,
        info: alignmentInfo[alignment]
      }));
    }

    const {
      contentSize,
      wideSize
    } = layout;
    const alignments = [{
      name: 'left'
    }, {
      name: 'center'
    }, {
      name: 'right'
    }];

    if (contentSize) {
      alignments.unshift({
        name: 'full'
      });
    }

    if (wideSize) {
      alignments.unshift({
        name: 'wide',
        info: alignmentInfo.wide
      });
    }

    alignments.unshift({
      name: 'none',
      info: alignmentInfo.none
    });
    return alignments;
  }

});
/**
 * Helper method to assign contextual info to clarify
 * alignment settings.
 *
 * Besides checking if `contentSize` and `wideSize` have a
 * value, we now show this information only if their values
 * are not a `css var`. This needs to change when parsing
 * css variables land.
 *
 * @see https://github.com/WordPress/gutenberg/pull/34710#issuecomment-918000752
 *
 * @param {Object} layout The layout object.
 * @return {Object} An object with contextual info per alignment.
 */

function getAlignmentsInfo(layout) {
  const {
    contentSize,
    wideSize
  } = layout;
  const alignmentInfo = {};
  const sizeRegex = /^(?!0)\d+(px|em|rem|vw|vh|%)?$/i;

  if (sizeRegex.test(contentSize)) {
    // translators: %s: container size (i.e. 600px etc)
    alignmentInfo.none = Object(external_wp_i18n_["sprintf"])(Object(external_wp_i18n_["__"])('Max %s wide'), contentSize);
  }

  if (sizeRegex.test(wideSize)) {
    // translators: %s: container size (i.e. 600px etc)
    alignmentInfo.wide = Object(external_wp_i18n_["sprintf"])(Object(external_wp_i18n_["__"])('Max %s wide'), wideSize);
  }

  return alignmentInfo;
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/layouts/index.js
/**
 * Internal dependencies
 */


const layoutTypes = [flow, flex];
/**
 * Retrieves a layout type by name.
 *
 * @param {string} name - The name of the layout type.
 * @return {Object} Layout type.
 */

function getLayoutType() {
  let name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'default';
  return layoutTypes.find(layoutType => layoutType.name === name);
}
/**
 * Retrieves the available layout types.
 *
 * @return {Array} Layout types.
 */

function getLayoutTypes() {
  return layoutTypes;
}


/***/ }),

/***/ "PS/H":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return InsertionPointOpenRef; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return InsertionPoint; });
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("TSYQ");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__("K9lf");
/* harmony import */ var _wordpress_compose__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__("l3Sj");
/* harmony import */ var _wordpress_i18n__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _inserter__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__("qrxh");
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__("BhPs");
/* harmony import */ var _block_list_use_block_props_use_block_refs__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__("PKbb");
/* harmony import */ var _use_popover_scroll__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__("2z9l");


/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */






/**
 * Internal dependencies
 */





const InsertionPointOpenRef = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createContext"])();

function InsertionPointPopover(_ref) {
  let {
    __unstablePopoverSlot,
    __unstableContentRef
  } = _ref;
  const {
    selectBlock
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__["useDispatch"])(_store__WEBPACK_IMPORTED_MODULE_7__[/* store */ "a"]);
  const openRef = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useContext"])(InsertionPointOpenRef);
  const ref = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useRef"])();
  const {
    orientation,
    previousClientId,
    nextClientId,
    rootClientId,
    isInserterShown
  } = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__["useSelect"])(select => {
    var _getBlockListSettings;

    const {
      getBlockOrder,
      getBlockListSettings,
      getBlockInsertionPoint,
      isBlockBeingDragged,
      getPreviousBlockClientId,
      getNextBlockClientId
    } = select(_store__WEBPACK_IMPORTED_MODULE_7__[/* store */ "a"]);
    const insertionPoint = getBlockInsertionPoint();
    const order = getBlockOrder(insertionPoint.rootClientId);

    if (!order.length) {
      return {};
    }

    let _previousClientId = order[insertionPoint.index - 1];
    let _nextClientId = order[insertionPoint.index];

    while (isBlockBeingDragged(_previousClientId)) {
      _previousClientId = getPreviousBlockClientId(_previousClientId);
    }

    while (isBlockBeingDragged(_nextClientId)) {
      _nextClientId = getNextBlockClientId(_nextClientId);
    }

    return {
      previousClientId: _previousClientId,
      nextClientId: _nextClientId,
      orientation: ((_getBlockListSettings = getBlockListSettings(insertionPoint.rootClientId)) === null || _getBlockListSettings === void 0 ? void 0 : _getBlockListSettings.orientation) || 'vertical',
      rootClientId: insertionPoint.rootClientId,
      isInserterShown: insertionPoint === null || insertionPoint === void 0 ? void 0 : insertionPoint.__unstableWithInserter
    };
  }, []);
  const previousElement = Object(_block_list_use_block_props_use_block_refs__WEBPACK_IMPORTED_MODULE_8__[/* __unstableUseBlockElement */ "a"])(previousClientId);
  const nextElement = Object(_block_list_use_block_props_use_block_refs__WEBPACK_IMPORTED_MODULE_8__[/* __unstableUseBlockElement */ "a"])(nextClientId);
  const isVertical = orientation === 'vertical';
  const style = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(() => {
    if (!previousElement && !nextElement) {
      return {};
    }

    const previousRect = previousElement ? previousElement.getBoundingClientRect() : null;
    const nextRect = nextElement ? nextElement.getBoundingClientRect() : null;

    if (isVertical) {
      return {
        width: previousElement ? previousElement.offsetWidth : nextElement.offsetWidth,
        height: nextRect && previousRect ? nextRect.top - previousRect.bottom : 0
      };
    }

    let width = 0;

    if (previousRect && nextRect) {
      width = Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__["isRTL"])() ? previousRect.left - nextRect.right : nextRect.left - previousRect.right;
    }

    return {
      width,
      height: previousElement ? previousElement.offsetHeight : nextElement.offsetHeight
    };
  }, [previousElement, nextElement]);
  const getAnchorRect = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(() => {
    if (!previousElement && !nextElement) {
      return {};
    }

    const {
      ownerDocument
    } = previousElement || nextElement;
    const previousRect = previousElement ? previousElement.getBoundingClientRect() : null;
    const nextRect = nextElement ? nextElement.getBoundingClientRect() : null;

    if (isVertical) {
      if (Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__["isRTL"])()) {
        return {
          top: previousRect ? previousRect.bottom : nextRect.top,
          left: previousRect ? previousRect.right : nextRect.right,
          right: previousRect ? previousRect.left : nextRect.left,
          bottom: nextRect ? nextRect.top : previousRect.bottom,
          ownerDocument
        };
      }

      return {
        top: previousRect ? previousRect.bottom : nextRect.top,
        left: previousRect ? previousRect.left : nextRect.left,
        right: previousRect ? previousRect.right : nextRect.right,
        bottom: nextRect ? nextRect.top : previousRect.bottom,
        ownerDocument
      };
    }

    if (Object(_wordpress_i18n__WEBPACK_IMPORTED_MODULE_5__["isRTL"])()) {
      return {
        top: previousRect ? previousRect.top : nextRect.top,
        left: previousRect ? previousRect.left : nextRect.right,
        right: nextRect ? nextRect.right : previousRect.left,
        bottom: previousRect ? previousRect.bottom : nextRect.bottom,
        ownerDocument
      };
    }

    return {
      top: previousRect ? previousRect.top : nextRect.top,
      left: previousRect ? previousRect.right : nextRect.left,
      right: nextRect ? nextRect.left : previousRect.right,
      bottom: previousRect ? previousRect.bottom : nextRect.bottom,
      ownerDocument
    };
  }, [previousElement, nextElement]);
  const popoverScrollRef = Object(_use_popover_scroll__WEBPACK_IMPORTED_MODULE_9__[/* usePopoverScroll */ "a"])(__unstableContentRef);
  const disableMotion = Object(_wordpress_compose__WEBPACK_IMPORTED_MODULE_4__["useReducedMotion"])();
  const className = classnames__WEBPACK_IMPORTED_MODULE_1___default()('block-editor-block-list__insertion-point', 'is-' + orientation);

  function onClick(event) {
    if (event.target === ref.current && nextClientId) {
      selectBlock(nextClientId, -1);
    }
  }

  function onFocus(event) {
    // Only handle click on the wrapper specifically, and not an event
    // bubbled from the inserter itself.
    if (event.target !== ref.current) {
      openRef.current = true;
    }
  } // Only show the in-between inserter between blocks, so when there's a
  // previous and a next element.


  const showInsertionPointInserter = previousElement && nextElement && isInserterShown; // Define animation variants for the line element.

  const horizontalLine = {
    start: {
      width: 0,
      top: '50%',
      bottom: '50%',
      x: 0
    },
    rest: {
      width: 4,
      top: 0,
      bottom: 0,
      x: -2
    },
    hover: {
      width: 4,
      top: 0,
      bottom: 0,
      x: -2
    }
  };
  const verticalLine = {
    start: {
      height: 0,
      left: '50%',
      right: '50%',
      y: 0
    },
    rest: {
      height: 4,
      left: 0,
      right: 0,
      y: -2
    },
    hover: {
      height: 4,
      left: 0,
      right: 0,
      y: -2
    }
  };
  const lineVariants = {
    // Initial position starts from the center and invisible.
    start: { ...(!isVertical ? horizontalLine.start : verticalLine.start),
      opacity: 0
    },
    // The line expands to fill the container. If the inserter is visible it
    // is delayed so it appears orchestrated.
    rest: { ...(!isVertical ? horizontalLine.rest : verticalLine.rest),
      opacity: 1,
      borderRadius: '2px',
      transition: {
        delay: showInsertionPointInserter ? 0.4 : 0
      }
    },
    hover: { ...(!isVertical ? horizontalLine.hover : verticalLine.hover),
      opacity: 1,
      borderRadius: '2px',
      transition: {
        delay: 0.4
      }
    }
  };
  const inserterVariants = {
    start: {
      scale: disableMotion ? 1 : 0
    },
    rest: {
      scale: 1,
      transition: {
        delay: 0.2
      }
    }
  };
  /* eslint-disable jsx-a11y/no-static-element-interactions, jsx-a11y/click-events-have-key-events */
  // While ideally it would be enough to capture the
  // bubbling focus event from the Inserter, due to the
  // characteristics of click focusing of `button`s in
  // Firefox and Safari, it is not reliable.
  //
  // See: https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#Clicking_and_focus

  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__["Popover"], {
    ref: popoverScrollRef,
    noArrow: true,
    animate: false,
    getAnchorRect: getAnchorRect,
    focusOnMount: false,
    className: "block-editor-block-list__insertion-point-popover" // Render in the old slot if needed for backward compatibility,
    // otherwise render in place (not in the the default popover slot).
    ,
    __unstableSlotName: __unstablePopoverSlot || null // Forces a remount of the popover when its position changes
    // This makes sure the popover doesn't animate from its previous position.
    ,
    key: nextClientId + '--' + rootClientId
  }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__["__unstableMotion"].div, {
    layout: !disableMotion,
    initial: disableMotion ? 'rest' : 'start',
    animate: "rest",
    whileHover: "hover",
    whileTap: "pressed",
    exit: "start",
    ref: ref,
    tabIndex: -1,
    onClick: onClick,
    onFocus: onFocus,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()(className, {
      'is-with-inserter': showInsertionPointInserter
    }),
    style: style
  }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__["__unstableMotion"].div, {
    variants: lineVariants,
    className: "block-editor-block-list__insertion-point-indicator"
  }), showInsertionPointInserter && Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_3__["__unstableMotion"].div, {
    variants: inserterVariants,
    className: classnames__WEBPACK_IMPORTED_MODULE_1___default()('block-editor-block-list__insertion-point-inserter')
  }, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_inserter__WEBPACK_IMPORTED_MODULE_6__[/* default */ "a"], {
    position: "bottom center",
    clientId: nextClientId,
    rootClientId: rootClientId,
    __experimentalIsQuick: true,
    onToggle: isOpen => {
      openRef.current = isOpen;
    },
    onSelectOrClose: () => {
      openRef.current = false;
    }
  }))));
  /* eslint-enable jsx-a11y/no-static-element-interactions, jsx-a11y/click-events-have-key-events */
}

function InsertionPoint(_ref2) {
  let {
    children,
    __unstablePopoverSlot,
    __unstableContentRef
  } = _ref2;
  const isVisible = Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_2__["useSelect"])(select => {
    return select(_store__WEBPACK_IMPORTED_MODULE_7__[/* store */ "a"]).isBlockInsertionPointVisible();
  }, []);
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(InsertionPointOpenRef.Provider, {
    value: Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["useRef"])(false)
  }, isVisible && Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(InsertionPointPopover, {
    __unstablePopoverSlot: __unstablePopoverSlot,
    __unstableContentRef: __unstableContentRef
  }), children);
}


/***/ }),

/***/ "Q2Xw":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return useBlockClassNames; });
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("TSYQ");
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("1ZqX");
/* harmony import */ var _wordpress_data__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("HSyU");
/* harmony import */ var _wordpress_blocks__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("BhPs");
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */


/**
 * Returns the class names used for the different states of the block.
 *
 * @param {string} clientId The block client ID.
 *
 * @return {string} The class names.
 */

function useBlockClassNames(clientId) {
  return Object(_wordpress_data__WEBPACK_IMPORTED_MODULE_1__["useSelect"])(select => {
    const {
      isBlockBeingDragged,
      isBlockHighlighted,
      isBlockSelected,
      isBlockMultiSelected,
      getBlockName,
      getSettings,
      hasSelectedInnerBlock,
      isTyping,
      __experimentalGetActiveBlockIdByBlockNames: getActiveBlockIdByBlockNames
    } = select(_store__WEBPACK_IMPORTED_MODULE_3__[/* store */ "a"]);
    const {
      __experimentalSpotlightEntityBlocks: spotlightEntityBlocks,
      outlineMode
    } = getSettings();
    const isDragging = isBlockBeingDragged(clientId);
    const isSelected = isBlockSelected(clientId);
    const name = getBlockName(clientId);
    const checkDeep = true; // "ancestor" is the more appropriate label due to "deep" check

    const isAncestorOfSelectedBlock = hasSelectedInnerBlock(clientId, checkDeep);
    const activeEntityBlockId = getActiveBlockIdByBlockNames(spotlightEntityBlocks);
    return classnames__WEBPACK_IMPORTED_MODULE_0___default()({
      'is-selected': isSelected,
      'is-highlighted': isBlockHighlighted(clientId),
      'is-multi-selected': isBlockMultiSelected(clientId),
      'is-reusable': Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__["isReusableBlock"])(Object(_wordpress_blocks__WEBPACK_IMPORTED_MODULE_2__["getBlockType"])(name)),
      'is-dragging': isDragging,
      'has-child-selected': isAncestorOfSelectedBlock,
      'has-active-entity': activeEntityBlockId,
      // Determine if there is an active entity area to spotlight.
      'is-active-entity': activeEntityBlockId === clientId,
      'remove-outline': isSelected && outlineMode && isTyping()
    });
  }, [clientId]);
}


/***/ }),

/***/ "Q4Sy":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const plus = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M18 11.2h-5.2V6h-1.6v5.2H6v1.6h5.2V18h1.6v-5.2H18z"
}));
/* harmony default export */ __webpack_exports__["a"] = (plus);


/***/ }),

/***/ "QP/w":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wx14");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _use_setting__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("v5LD");



/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */



function FontSizePicker(props) {
  const fontSizes = Object(_use_setting__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"])('typography.fontSizes');
  const disableCustomFontSizes = !Object(_use_setting__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"])('typography.customFontSize');
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["FontSizePicker"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({}, props, {
    fontSizes: fontSizes,
    disableCustomFontSizes: disableCustomFontSizes
  }));
}

/* harmony default export */ __webpack_exports__["a"] = (FontSizePicker);


/***/ }),

/***/ "REKd":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ useBlockPreview; });

// UNUSED EXPORTS: BlockPreview

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__("TSYQ");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/provider/index.js + 1 modules
var provider = __webpack_require__("/QNa");

// EXTERNAL MODULE: external ["wp","components"]
var external_wp_components_ = __webpack_require__("tI+e");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/index.js + 4 modules
var block_list = __webpack_require__("VyCT");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-preview/live.js


/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function LiveBlockPreview(_ref) {
  let {
    onClick
  } = _ref;
  return Object(external_wp_element_["createElement"])("div", {
    tabIndex: 0,
    role: "button",
    onClick: onClick,
    onKeyPress: onClick
  }, Object(external_wp_element_["createElement"])(external_wp_components_["Disabled"], null, Object(external_wp_element_["createElement"])(block_list["c" /* default */], null)));
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/iframe/index.js
var iframe = __webpack_require__("hHnB");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/editor-styles/index.js
var editor_styles = __webpack_require__("KyyN");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js + 4 modules
var store = __webpack_require__("BhPs");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-preview/auto.js


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */




 // This is used to avoid rendering the block list if the sizes change.

let MemoizedBlockList;
const MAX_HEIGHT = 2000;

function AutoBlockPreview(_ref) {
  let {
    viewportWidth,
    __experimentalPadding
  } = _ref;
  const [containerResizeListener, {
    width: containerWidth
  }] = Object(external_wp_compose_["useResizeObserver"])();
  const [contentResizeListener, {
    height: contentHeight
  }] = Object(external_wp_compose_["useResizeObserver"])();
  const styles = Object(external_wp_data_["useSelect"])(select => {
    return select(store["a" /* store */]).getSettings().styles;
  }, []); // Avoid scrollbars for pattern previews.

  const editorStyles = Object(external_wp_element_["useMemo"])(() => {
    if (styles) {
      return [...styles, {
        css: 'body{height:auto;overflow:hidden;}',
        __unstableType: 'presets'
      }];
    }

    return styles;
  }, [styles]); // Initialize on render instead of module top level, to avoid circular dependency issues.

  MemoizedBlockList = MemoizedBlockList || Object(external_wp_compose_["pure"])(block_list["c" /* default */]);
  const scale = containerWidth / viewportWidth;
  return Object(external_wp_element_["createElement"])("div", {
    className: "block-editor-block-preview__container"
  }, containerResizeListener, Object(external_wp_element_["createElement"])(external_wp_components_["Disabled"], {
    className: "block-editor-block-preview__content",
    style: {
      transform: `scale(${scale})`,
      height: contentHeight * scale,
      maxHeight: contentHeight > MAX_HEIGHT ? MAX_HEIGHT * scale : undefined
    }
  }, Object(external_wp_element_["createElement"])(iframe["a" /* default */], {
    head: Object(external_wp_element_["createElement"])(editor_styles["a" /* default */], {
      styles: editorStyles
    }),
    contentRef: Object(external_wp_compose_["useRefEffect"])(bodyElement => {
      const {
        ownerDocument: {
          documentElement
        }
      } = bodyElement;
      documentElement.classList.add('block-editor-block-preview__content-iframe');
      documentElement.style.position = 'absolute';
      documentElement.style.width = '100%';
      bodyElement.style.padding = __experimentalPadding + 'px'; // necessary for contentResizeListener to work.

      bodyElement.style.position = 'relative';
    }, []),
    "aria-hidden": true,
    tabIndex: -1,
    style: {
      position: 'absolute',
      width: viewportWidth,
      height: contentHeight,
      pointerEvents: 'none',
      // This is a catch-all max-height for patterns.
      // See: https://github.com/WordPress/gutenberg/pull/38175.
      maxHeight: MAX_HEIGHT
    }
  }, contentResizeListener, Object(external_wp_element_["createElement"])(MemoizedBlockList, {
    renderAppender: false
  }))));
}

/* harmony default export */ var auto = (AutoBlockPreview);

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-preview/index.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */




/**
 * Internal dependencies
 */






function BlockPreview(_ref) {
  let {
    blocks,
    __experimentalPadding = 0,
    viewportWidth = 1200,
    __experimentalLive = false,
    __experimentalOnClick
  } = _ref;
  const originalSettings = Object(external_wp_data_["useSelect"])(select => select(store["a" /* store */]).getSettings(), []);
  const settings = Object(external_wp_element_["useMemo"])(() => {
    const _settings = { ...originalSettings
    };
    _settings.__experimentalBlockPatterns = [];
    return _settings;
  }, [originalSettings]);
  const renderedBlocks = Object(external_wp_element_["useMemo"])(() => Object(external_lodash_["castArray"])(blocks), [blocks]);

  if (!blocks || blocks.length === 0) {
    return null;
  }

  return Object(external_wp_element_["createElement"])(provider["a" /* default */], {
    value: renderedBlocks,
    settings: settings
  }, __experimentalLive ? Object(external_wp_element_["createElement"])(LiveBlockPreview, {
    onClick: __experimentalOnClick
  }) : Object(external_wp_element_["createElement"])(auto, {
    viewportWidth: viewportWidth,
    __experimentalPadding: __experimentalPadding
  }));
}
/**
 * BlockPreview renders a preview of a block or array of blocks.
 *
 * @see https://github.com/WordPress/gutenberg/blob/HEAD/packages/block-editor/src/components/block-preview/README.md
 *
 * @param {Object}       preview               options for how the preview should be shown
 * @param {Array|Object} preview.blocks        A block instance (object) or an array of blocks to be previewed.
 * @param {number}       preview.viewportWidth Width of the preview container in pixels. Controls at what size the blocks will be rendered inside the preview. Default: 700.
 *
 * @return {WPComponent} The component to be rendered.
 */

/* harmony default export */ var block_preview = __webpack_exports__["a"] = (Object(external_wp_element_["memo"])(BlockPreview));
/**
 * This hook is used to lightly mark an element as a block preview wrapper
 * element. Call this hook and pass the returned props to the element to mark as
 * a block preview wrapper, automatically rendering inner blocks as children. If
 * you define a ref for the element, it is important to pass the ref to this
 * hook, which the hook in turn will pass to the component through the props it
 * returns. Optionally, you can also pass any other props through this hook, and
 * they will be merged and returned.
 *
 * @param {Object}    options                      Preview options.
 * @param {WPBlock[]} options.blocks               Block objects.
 * @param {Object}    options.props                Optional. Props to pass to the element. Must contain
 *                                                 the ref if one is defined.
 * @param {Object}    options.__experimentalLayout Layout settings to be used in the preview.
 *
 */

function useBlockPreview(_ref2) {
  let {
    blocks,
    props = {},
    __experimentalLayout
  } = _ref2;
  const originalSettings = Object(external_wp_data_["useSelect"])(select => select(store["a" /* store */]).getSettings(), []);
  const disabledRef = Object(external_wp_compose_["__experimentalUseDisabled"])();
  const ref = Object(external_wp_compose_["useMergeRefs"])([props.ref, disabledRef]);
  const settings = Object(external_wp_element_["useMemo"])(() => ({ ...originalSettings,
    __experimentalBlockPatterns: []
  }), [originalSettings]);
  const renderedBlocks = Object(external_wp_element_["useMemo"])(() => Object(external_lodash_["castArray"])(blocks), [blocks]);
  const children = Object(external_wp_element_["createElement"])(provider["a" /* default */], {
    value: renderedBlocks,
    settings: settings
  }, Object(external_wp_element_["createElement"])(block_list["a" /* BlockListItems */], {
    renderAppender: false,
    __experimentalLayout: __experimentalLayout
  }));
  return { ...props,
    ref,
    className: classnames_default()(props.className, 'block-editor-block-preview__live-content', 'components-disabled'),
    children: blocks !== null && blocks !== void 0 && blocks.length ? children : null
  };
}


/***/ }),

/***/ "RMJe":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const check = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M16.7 7.1l-6.3 8.5-3.3-2.5-.9 1.2 4.5 3.4L17.9 8z"
}));
/* harmony default export */ __webpack_exports__["a"] = (check);


/***/ }),

/***/ "Rk8H":
/***/ (function(module, exports, __webpack_require__) {

// Load in dependencies
var computedStyle = __webpack_require__("jTPX");

/**
 * Calculate the `line-height` of a given node
 * @param {HTMLElement} node Element to calculate line height of. Must be in the DOM.
 * @returns {Number} `line-height` of the element in pixels
 */
function lineHeight(node) {
  // Grab the line-height via style
  var lnHeightStr = computedStyle(node, 'line-height');
  var lnHeight = parseFloat(lnHeightStr, 10);

  // If the lineHeight did not contain a unit (i.e. it was numeric), convert it to ems (e.g. '2.3' === '2.3em')
  if (lnHeightStr === lnHeight + '') {
    // Save the old lineHeight style and update the em unit to the element
    var _lnHeightStyle = node.style.lineHeight;
    node.style.lineHeight = lnHeightStr + 'em';

    // Calculate the em based height
    lnHeightStr = computedStyle(node, 'line-height');
    lnHeight = parseFloat(lnHeightStr, 10);

    // Revert the lineHeight style
    if (_lnHeightStyle) {
      node.style.lineHeight = _lnHeightStyle;
    } else {
      delete node.style.lineHeight;
    }
  }

  // If the lineHeight is in `pt`, convert it to pixels (4px for 3pt)
  // DEV: `em` units are converted to `pt` in IE6
  // Conversion ratio from https://developer.mozilla.org/en-US/docs/Web/CSS/length
  if (lnHeightStr.indexOf('pt') !== -1) {
    lnHeight *= 4;
    lnHeight /= 3;
  // Otherwise, if the lineHeight is in `mm`, convert it to pixels (96px for 25.4mm)
  } else if (lnHeightStr.indexOf('mm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 25.4;
  // Otherwise, if the lineHeight is in `cm`, convert it to pixels (96px for 2.54cm)
  } else if (lnHeightStr.indexOf('cm') !== -1) {
    lnHeight *= 96;
    lnHeight /= 2.54;
  // Otherwise, if the lineHeight is in `in`, convert it to pixels (96px for 1in)
  } else if (lnHeightStr.indexOf('in') !== -1) {
    lnHeight *= 96;
  // Otherwise, if the lineHeight is in `pc`, convert it to pixels (12pt for 1pc)
  } else if (lnHeightStr.indexOf('pc') !== -1) {
    lnHeight *= 16;
  }

  // Continue our computation
  lnHeight = Math.round(lnHeight);

  // If the line-height is "normal", calculate by font-size
  if (lnHeightStr === 'normal') {
    // Create a temporary node
    var nodeName = node.nodeName;
    var _node = document.createElement(nodeName);
    _node.innerHTML = '&nbsp;';

    // If we have a text area, reset it to only 1 row
    // https://github.com/twolfson/line-height/issues/4
    if (nodeName.toUpperCase() === 'TEXTAREA') {
      _node.setAttribute('rows', '1');
    }

    // Set the font-size of the element
    var fontSizeStr = computedStyle(node, 'font-size');
    _node.style.fontSize = fontSizeStr;

    // Remove default padding/border which can affect offset height
    // https://github.com/twolfson/line-height/issues/4
    // https://developer.mozilla.org/en-US/docs/Web/API/HTMLElement/offsetHeight
    _node.style.padding = '0px';
    _node.style.border = '0px';

    // Append it to the body
    var body = document.body;
    body.appendChild(_node);

    // Assume the line height of the element is the height
    var height = _node.offsetHeight;
    lnHeight = height;

    // Remove our child from the DOM
    body.removeChild(_node);
  }

  // Return the calculated height
  return lnHeight;
}

// Export lineHeight
module.exports = lineHeight;


/***/ }),

/***/ "RxS6":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["keycodes"]; }());

/***/ }),

/***/ "SVSp":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["shortcode"]; }());

/***/ }),

/***/ "TSYQ":
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
  Copyright (c) 2018 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/
/* global define */

(function () {
	'use strict';

	var hasOwn = {}.hasOwnProperty;

	function classNames() {
		var classes = [];

		for (var i = 0; i < arguments.length; i++) {
			var arg = arguments[i];
			if (!arg) continue;

			var argType = typeof arg;

			if (argType === 'string' || argType === 'number') {
				classes.push(arg);
			} else if (Array.isArray(arg)) {
				if (arg.length) {
					var inner = classNames.apply(null, arg);
					if (inner) {
						classes.push(inner);
					}
				}
			} else if (argType === 'object') {
				if (arg.toString === Object.prototype.toString) {
					for (var key in arg) {
						if (hasOwn.call(arg, key) && arg[key]) {
							classes.push(key);
						}
					}
				} else {
					classes.push(arg.toString());
				}
			}
		}

		return classes.join(' ');
	}

	if ( true && module.exports) {
		classNames.default = classNames;
		module.exports = classNames;
	} else if (true) {
		// register as 'classnames', consistent with npm package name
		!(__WEBPACK_AMD_DEFINE_ARRAY__ = [], __WEBPACK_AMD_DEFINE_RESULT__ = (function () {
			return classNames;
		}).apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
	} else {}
}());


/***/ }),

/***/ "TVFh":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ useWritingFlow; });

// EXTERNAL MODULE: ./node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__("wx14");

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__("TSYQ");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: external ["wp","i18n"]
var external_wp_i18n_ = __webpack_require__("l3Sj");

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js + 4 modules
var store = __webpack_require__("BhPs");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/use-block-props/use-block-refs.js
var use_block_refs = __webpack_require__("PKbb");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/writing-flow/use-multi-selection.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */




function toggleRichText(container, toggle) {
  Array.from(container.querySelectorAll('.rich-text')).forEach(node => {
    if (toggle) {
      node.setAttribute('contenteditable', true);
    } else {
      node.removeAttribute('contenteditable');
    }
  });
}
/**
 * Returns for the deepest node at the start or end of a container node. Ignores
 * any text nodes that only contain HTML formatting whitespace.
 *
 * @param {Element} node Container to search.
 * @param {string}  type 'start' or 'end'.
 */


function getDeepestNode(node, type) {
  const child = type === 'start' ? 'firstChild' : 'lastChild';
  const sibling = type === 'start' ? 'nextSibling' : 'previousSibling';

  while (node[child]) {
    node = node[child];

    while (node.nodeType === node.TEXT_NODE && /^[ \t\n]*$/.test(node.data) && node[sibling]) {
      node = node[sibling];
    }
  }

  return node;
}

function selector(select) {
  const {
    isMultiSelecting,
    getMultiSelectedBlockClientIds,
    hasMultiSelection,
    getSelectedBlockClientId
  } = select(store["a" /* store */]);
  return {
    isMultiSelecting: isMultiSelecting(),
    multiSelectedBlockClientIds: getMultiSelectedBlockClientIds(),
    hasMultiSelection: hasMultiSelection(),
    selectedBlockClientId: getSelectedBlockClientId()
  };
}

function useMultiSelection() {
  const {
    isMultiSelecting,
    multiSelectedBlockClientIds,
    hasMultiSelection,
    selectedBlockClientId
  } = Object(external_wp_data_["useSelect"])(selector, []);
  const selectedRef = Object(use_block_refs["b" /* __unstableUseBlockRef */])(selectedBlockClientId); // These must be in the right DOM order.

  const startRef = Object(use_block_refs["b" /* __unstableUseBlockRef */])(Object(external_lodash_["first"])(multiSelectedBlockClientIds));
  const endRef = Object(use_block_refs["b" /* __unstableUseBlockRef */])(Object(external_lodash_["last"])(multiSelectedBlockClientIds));
  /**
   * When the component updates, and there is multi selection, we need to
   * select the entire block contents.
   */

  return Object(external_wp_compose_["useRefEffect"])(node => {
    const {
      ownerDocument
    } = node;
    const {
      defaultView
    } = ownerDocument;

    if (!hasMultiSelection || isMultiSelecting) {
      if (!selectedBlockClientId || isMultiSelecting) {
        return;
      }

      const selection = defaultView.getSelection();

      if (selection.rangeCount && !selection.isCollapsed) {
        const blockNode = selectedRef.current;
        const {
          startContainer,
          endContainer
        } = selection.getRangeAt(0);

        if (!!blockNode && (!blockNode.contains(startContainer) || !blockNode.contains(endContainer))) {
          selection.removeAllRanges();
        }
      }

      return;
    }

    const {
      length
    } = multiSelectedBlockClientIds;

    if (length < 2) {
      return;
    } // The block refs might not be immediately available
    // when dragging blocks into another block.


    if (!startRef.current || !endRef.current) {
      return;
    } // For some browsers, like Safari, it is important that focus happens
    // BEFORE selection.


    node.focus();
    const selection = defaultView.getSelection();
    const range = ownerDocument.createRange(); // These must be in the right DOM order.
    // The most stable way to select the whole block contents is to start
    // and end at the deepest points.

    const startNode = getDeepestNode(startRef.current, 'start');
    const endNode = getDeepestNode(endRef.current, 'end'); // While rich text will be disabled with a delay when there is a multi
    // selection, we must do it immediately because it's not possible to set
    // selection across editable hosts.

    toggleRichText(node, false);
    range.setStartBefore(startNode);
    range.setEndAfter(endNode);
    selection.removeAllRanges();
    selection.addRange(range);
  }, [hasMultiSelection, isMultiSelecting, multiSelectedBlockClientIds, selectedBlockClientId]);
}

// EXTERNAL MODULE: external ["wp","dom"]
var external_wp_dom_ = __webpack_require__("1CF3");

// EXTERNAL MODULE: external ["wp","keycodes"]
var external_wp_keycodes_ = __webpack_require__("RxS6");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/writing-flow/use-tab-nav.js


/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



function isFormElement(element) {
  const {
    tagName
  } = element;
  return tagName === 'INPUT' || tagName === 'BUTTON' || tagName === 'SELECT' || tagName === 'TEXTAREA';
}

function useTabNav() {
  const container = Object(external_wp_element_["useRef"])();
  const focusCaptureBeforeRef = Object(external_wp_element_["useRef"])();
  const focusCaptureAfterRef = Object(external_wp_element_["useRef"])();
  const lastFocus = Object(external_wp_element_["useRef"])();
  const {
    hasMultiSelection,
    getSelectedBlockClientId,
    getBlockCount
  } = Object(external_wp_data_["useSelect"])(store["a" /* store */]);
  const {
    setNavigationMode
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const isNavigationMode = Object(external_wp_data_["useSelect"])(select => select(store["a" /* store */]).isNavigationMode(), []); // Don't allow tabbing to this element in Navigation mode.

  const focusCaptureTabIndex = !isNavigationMode ? '0' : undefined; // Reference that holds the a flag for enabling or disabling
  // capturing on the focus capture elements.

  const noCapture = Object(external_wp_element_["useRef"])();

  function onFocusCapture(event) {
    // Do not capture incoming focus if set by us in WritingFlow.
    if (noCapture.current) {
      noCapture.current = null;
    } else if (hasMultiSelection()) {
      container.current.focus();
    } else if (getSelectedBlockClientId()) {
      lastFocus.current.focus();
    } else {
      setNavigationMode(true);
      const isBefore = // eslint-disable-next-line no-bitwise
      event.target.compareDocumentPosition(container.current) & event.target.DOCUMENT_POSITION_FOLLOWING;
      const action = isBefore ? 'findNext' : 'findPrevious';
      external_wp_dom_["focus"].tabbable[action](event.target).focus();
    }
  }

  const before = Object(external_wp_element_["createElement"])("div", {
    ref: focusCaptureBeforeRef,
    tabIndex: focusCaptureTabIndex,
    onFocus: onFocusCapture
  });
  const after = Object(external_wp_element_["createElement"])("div", {
    ref: focusCaptureAfterRef,
    tabIndex: focusCaptureTabIndex,
    onFocus: onFocusCapture
  });
  const ref = Object(external_wp_compose_["useRefEffect"])(node => {
    function onKeyDown(event) {
      if (event.defaultPrevented) {
        return;
      }

      if (event.keyCode === external_wp_keycodes_["ESCAPE"] && !hasMultiSelection()) {
        event.preventDefault();
        setNavigationMode(true);
        return;
      } // In Edit mode, Tab should focus the first tabbable element after
      // the content, which is normally the sidebar (with block controls)
      // and Shift+Tab should focus the first tabbable element before the
      // content, which is normally the block toolbar.
      // Arrow keys can be used, and Tab and arrow keys can be used in
      // Navigation mode (press Esc), to navigate through blocks.


      if (event.keyCode !== external_wp_keycodes_["TAB"]) {
        return;
      }

      const isShift = event.shiftKey;
      const direction = isShift ? 'findPrevious' : 'findNext';

      if (!hasMultiSelection() && !getSelectedBlockClientId()) {
        // Preserve the behaviour of entering navigation mode when
        // tabbing into the content without a block selection.
        // `onFocusCapture` already did this previously, but we need to
        // do it again here because after clearing block selection,
        // focus land on the writing flow container and pressing Tab
        // will no longer send focus through the focus capture element.
        if (event.target === node) setNavigationMode(true);
        return;
      } // Allow tabbing between form elements rendered in a block,
      // such as inside a placeholder. Form elements are generally
      // meant to be UI rather than part of the content. Ideally
      // these are not rendered in the content and perhaps in the
      // future they can be rendered in an iframe or shadow DOM.


      if (isFormElement(event.target) && isFormElement(external_wp_dom_["focus"].tabbable[direction](event.target))) {
        return;
      }

      const next = isShift ? focusCaptureBeforeRef : focusCaptureAfterRef; // Disable focus capturing on the focus capture element, so it
      // doesn't refocus this block and so it allows default behaviour
      // (moving focus to the next tabbable element).

      noCapture.current = true; // Focusing the focus capture element, which is located above and
      // below the editor, should not scroll the page all the way up or
      // down.

      next.current.focus({
        preventScroll: true
      });
    }

    function onFocusOut(event) {
      lastFocus.current = event.target;
      const {
        ownerDocument
      } = node; // If focus disappears due to there being no blocks, move focus to
      // the writing flow wrapper.

      if (!event.relatedTarget && ownerDocument.activeElement === ownerDocument.body && getBlockCount() === 0) {
        node.focus();
      }
    } // When tabbing back to an element in block list, this event handler prevents scrolling if the
    // focus capture divs (before/after) are outside of the viewport. (For example shift+tab back to a paragraph
    // when focus is on a sidebar element. This prevents the scrollable writing area from jumping either to the
    // top or bottom of the document.
    //
    // Note that it isn't possible to disable scrolling in the onFocus event. We need to intercept this
    // earlier in the keypress handler, and call focus( { preventScroll: true } ) instead.
    // https://developer.mozilla.org/en-US/docs/Web/API/HTMLOrForeignElement/focus#parameters


    function preventScrollOnTab(event) {
      var _event$target;

      if (event.keyCode !== external_wp_keycodes_["TAB"]) {
        return;
      }

      if (((_event$target = event.target) === null || _event$target === void 0 ? void 0 : _event$target.getAttribute('role')) === 'region') {
        return;
      }

      if (container.current === event.target) {
        return;
      }

      const isShift = event.shiftKey;
      const direction = isShift ? 'findPrevious' : 'findNext';
      const target = external_wp_dom_["focus"].tabbable[direction](event.target); // only do something when the next tabbable is a focus capture div (before/after)

      if (target === focusCaptureBeforeRef.current || target === focusCaptureAfterRef.current) {
        event.preventDefault();
        target.focus({
          preventScroll: true
        });
      }
    }

    const {
      ownerDocument
    } = node;
    const {
      defaultView
    } = ownerDocument;
    defaultView.addEventListener('keydown', preventScrollOnTab);
    node.addEventListener('keydown', onKeyDown);
    node.addEventListener('focusout', onFocusOut);
    return () => {
      defaultView.removeEventListener('keydown', preventScrollOnTab);
      node.removeEventListener('keydown', onKeyDown);
      node.removeEventListener('focusout', onFocusOut);
    };
  }, []);
  const mergedRefs = Object(external_wp_compose_["useMergeRefs"])([container, ref]);
  return [before, mergedRefs, after];
}

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/utils/dom.js
var dom = __webpack_require__("OL6h");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/writing-flow/use-arrow-nav.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */



/**
 * Returns true if the element should consider edge navigation upon a keyboard
 * event of the given directional key code, or false otherwise.
 *
 * @param {Element} element     HTML element to test.
 * @param {number}  keyCode     KeyboardEvent keyCode to test.
 * @param {boolean} hasModifier Whether a modifier is pressed.
 *
 * @return {boolean} Whether element should consider edge navigation.
 */

function isNavigationCandidate(element, keyCode, hasModifier) {
  const isVertical = keyCode === external_wp_keycodes_["UP"] || keyCode === external_wp_keycodes_["DOWN"]; // Currently, all elements support unmodified vertical navigation.

  if (isVertical && !hasModifier) {
    return true;
  } // Native inputs should not navigate horizontally.


  const {
    tagName
  } = element;
  return tagName !== 'INPUT' && tagName !== 'TEXTAREA';
}
/**
 * Returns the optimal tab target from the given focused element in the desired
 * direction. A preference is made toward text fields, falling back to the block
 * focus stop if no other candidates exist for the block.
 *
 * @param {Element} target           Currently focused text field.
 * @param {boolean} isReverse        True if considering as the first field.
 * @param {Element} containerElement Element containing all blocks.
 * @param {boolean} onlyVertical     Whether to only consider tabbable elements
 *                                   that are visually above or under the
 *                                   target.
 *
 * @return {?Element} Optimal tab target, if one exists.
 */

function getClosestTabbable(target, isReverse, containerElement, onlyVertical) {
  // Since the current focus target is not guaranteed to be a text field, find
  // all focusables. Tabbability is considered later.
  let focusableNodes = external_wp_dom_["focus"].focusable.find(containerElement);

  if (isReverse) {
    focusableNodes = Object(external_lodash_["reverse"])(focusableNodes);
  } // Consider as candidates those focusables after the current target. It's
  // assumed this can only be reached if the target is focusable (on its
  // keydown event), so no need to verify it exists in the set.


  focusableNodes = focusableNodes.slice(focusableNodes.indexOf(target) + 1);
  let targetRect;

  if (onlyVertical) {
    targetRect = target.getBoundingClientRect();
  }

  function isTabCandidate(node) {
    // Not a candidate if the node is not tabbable.
    if (!external_wp_dom_["focus"].tabbable.isTabbableIndex(node)) {
      return false;
    } // Skip focusable elements such as links within content editable nodes.


    if (node.isContentEditable && node.contentEditable !== 'true') {
      return false;
    }

    if (onlyVertical) {
      const nodeRect = node.getBoundingClientRect();

      if (nodeRect.left >= targetRect.right || nodeRect.right <= targetRect.left) {
        return false;
      }
    }

    return true;
  }

  return Object(external_lodash_["find"])(focusableNodes, isTabCandidate);
}
function useArrowNav() {
  const {
    getSelectedBlockClientId,
    getMultiSelectedBlocksStartClientId,
    getMultiSelectedBlocksEndClientId,
    getPreviousBlockClientId,
    getNextBlockClientId,
    getFirstMultiSelectedBlockClientId,
    getLastMultiSelectedBlockClientId,
    getSettings,
    hasMultiSelection
  } = Object(external_wp_data_["useSelect"])(store["a" /* store */]);
  const {
    multiSelect,
    selectBlock
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  return Object(external_wp_compose_["useRefEffect"])(node => {
    // Here a DOMRect is stored while moving the caret vertically so
    // vertical position of the start position can be restored. This is to
    // recreate browser behaviour across blocks.
    let verticalRect;

    function onMouseDown() {
      verticalRect = null;
    }

    function expandSelection(isReverse) {
      const selectedBlockClientId = getSelectedBlockClientId();
      const selectionStartClientId = getMultiSelectedBlocksStartClientId();
      const selectionEndClientId = getMultiSelectedBlocksEndClientId();
      const selectionBeforeEndClientId = getPreviousBlockClientId(selectionEndClientId || selectedBlockClientId);
      const selectionAfterEndClientId = getNextBlockClientId(selectionEndClientId || selectedBlockClientId);
      const nextSelectionEndClientId = isReverse ? selectionBeforeEndClientId : selectionAfterEndClientId;

      if (nextSelectionEndClientId) {
        if (selectionStartClientId === nextSelectionEndClientId) {
          selectBlock(nextSelectionEndClientId);
        } else {
          multiSelect(selectionStartClientId || selectedBlockClientId, nextSelectionEndClientId);
        }
      }
    }

    function moveSelection(isReverse) {
      const selectedFirstClientId = getFirstMultiSelectedBlockClientId();
      const selectedLastClientId = getLastMultiSelectedBlockClientId();
      const focusedBlockClientId = isReverse ? selectedFirstClientId : selectedLastClientId;

      if (focusedBlockClientId) {
        selectBlock(focusedBlockClientId);
      }
    }
    /**
     * Returns true if the given target field is the last in its block which
     * can be considered for tab transition. For example, in a block with
     * two text fields, this would return true when reversing from the first
     * of the two fields, but false when reversing from the second.
     *
     * @param {Element} target    Currently focused text field.
     * @param {boolean} isReverse True if considering as the first field.
     *
     * @return {boolean} Whether field is at edge for tab transition.
     */


    function isTabbableEdge(target, isReverse) {
      const closestTabbable = getClosestTabbable(target, isReverse, node);
      return !closestTabbable || !Object(dom["b" /* isInSameBlock */])(target, closestTabbable);
    }

    function onKeyDown(event) {
      const {
        keyCode,
        target
      } = event;
      const isUp = keyCode === external_wp_keycodes_["UP"];
      const isDown = keyCode === external_wp_keycodes_["DOWN"];
      const isLeft = keyCode === external_wp_keycodes_["LEFT"];
      const isRight = keyCode === external_wp_keycodes_["RIGHT"];
      const isReverse = isUp || isLeft;
      const isHorizontal = isLeft || isRight;
      const isVertical = isUp || isDown;
      const isNav = isHorizontal || isVertical;
      const isShift = event.shiftKey;
      const hasModifier = isShift || event.ctrlKey || event.altKey || event.metaKey;
      const isNavEdge = isVertical ? external_wp_dom_["isVerticalEdge"] : external_wp_dom_["isHorizontalEdge"];
      const {
        ownerDocument
      } = node;
      const {
        defaultView
      } = ownerDocument;

      if (hasMultiSelection()) {
        if (isNav) {
          const action = isShift ? expandSelection : moveSelection;
          action(isReverse);
          event.preventDefault();
        }

        return;
      } // When presing any key other than up or down, the initial vertical
      // position must ALWAYS be reset. The vertical position is saved so
      // it can be restored as well as possible on sebsequent vertical
      // arrow key presses. It may not always be possible to restore the
      // exact same position (such as at an empty line), so it wouldn't be
      // good to compute the position right before any vertical arrow key
      // press.


      if (!isVertical) {
        verticalRect = null;
      } else if (!verticalRect) {
        verticalRect = Object(external_wp_dom_["computeCaretRect"])(defaultView);
      } // Abort if navigation has already been handled (e.g. RichText
      // inline boundaries).


      if (event.defaultPrevented) {
        return;
      }

      if (!isNav) {
        return;
      } // Abort if our current target is not a candidate for navigation
      // (e.g. preserve native input behaviors).


      if (!isNavigationCandidate(target, keyCode, hasModifier)) {
        return;
      } // In the case of RTL scripts, right means previous and left means
      // next, which is the exact reverse of LTR.


      const isReverseDir = Object(external_wp_dom_["isRTL"])(target) ? !isReverse : isReverse;
      const {
        keepCaretInsideBlock
      } = getSettings();
      const selectedBlockClientId = getSelectedBlockClientId();

      if (isShift) {
        const selectionEndClientId = getMultiSelectedBlocksEndClientId();
        const selectionBeforeEndClientId = getPreviousBlockClientId(selectionEndClientId || selectedBlockClientId);
        const selectionAfterEndClientId = getNextBlockClientId(selectionEndClientId || selectedBlockClientId);

        if ( // Ensure that there is a target block.
        (isReverse && selectionBeforeEndClientId || !isReverse && selectionAfterEndClientId) && isTabbableEdge(target, isReverse) && isNavEdge(target, isReverse)) {
          // Shift key is down, and there is multi selection or we're
          // at the end of the current block.
          expandSelection(isReverse);
          event.preventDefault();
        }
      } else if (isVertical && Object(external_wp_dom_["isVerticalEdge"])(target, isReverse) && !keepCaretInsideBlock) {
        const closestTabbable = getClosestTabbable(target, isReverse, node, true);

        if (closestTabbable) {
          Object(external_wp_dom_["placeCaretAtVerticalEdge"])(closestTabbable, isReverse, verticalRect);
          event.preventDefault();
        }
      } else if (isHorizontal && defaultView.getSelection().isCollapsed && Object(external_wp_dom_["isHorizontalEdge"])(target, isReverseDir) && !keepCaretInsideBlock) {
        const closestTabbable = getClosestTabbable(target, isReverseDir, node);
        Object(external_wp_dom_["placeCaretAtHorizontalEdge"])(closestTabbable, isReverse);
        event.preventDefault();
      }
    }

    node.addEventListener('mousedown', onMouseDown);
    node.addEventListener('keydown', onKeyDown);
    return () => {
      node.removeEventListener('mousedown', onMouseDown);
      node.removeEventListener('keydown', onKeyDown);
    };
  }, []);
}

// EXTERNAL MODULE: external ["wp","keyboardShortcuts"]
var external_wp_keyboardShortcuts_ = __webpack_require__("hF7m");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/writing-flow/use-select-all.js
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */


function useSelectAll() {
  const {
    getBlockOrder,
    getSelectedBlockClientIds,
    getBlockRootClientId
  } = Object(external_wp_data_["useSelect"])(store["a" /* store */]);
  const {
    multiSelect
  } = Object(external_wp_data_["useDispatch"])(store["a" /* store */]);
  const isMatch = Object(external_wp_keyboardShortcuts_["__unstableUseShortcutEventMatch"])();
  return Object(external_wp_compose_["useRefEffect"])(node => {
    function onKeyDown(event) {
      if (!isMatch('core/block-editor/select-all', event)) {
        return;
      }

      if (!Object(external_wp_dom_["isEntirelySelected"])(event.target)) {
        return;
      }

      const selectedClientIds = getSelectedBlockClientIds();
      const [firstSelectedClientId] = selectedClientIds;
      const rootClientId = getBlockRootClientId(firstSelectedClientId);
      let blockClientIds = getBlockOrder(rootClientId); // If we have selected all sibling nested blocks, try selecting up a
      // level. See: https://github.com/WordPress/gutenberg/pull/31859/

      if (selectedClientIds.length === blockClientIds.length) {
        blockClientIds = getBlockOrder(getBlockRootClientId(rootClientId));
      }

      const firstClientId = Object(external_lodash_["first"])(blockClientIds);
      const lastClientId = Object(external_lodash_["last"])(blockClientIds);

      if (firstClientId === lastClientId) {
        return;
      }

      multiSelect(firstClientId, lastClientId);
      event.preventDefault();
    }

    node.addEventListener('keydown', onKeyDown);
    return () => {
      node.removeEventListener('keydown', onKeyDown);
    };
  }, []);
}

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/writing-flow/index.js



/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */





/**
 * Internal dependencies
 */






function useWritingFlow() {
  const [before, ref, after] = useTabNav();
  const hasMultiSelection = Object(external_wp_data_["useSelect"])(select => select(store["a" /* store */]).hasMultiSelection(), []);
  return [before, Object(external_wp_compose_["useMergeRefs"])([ref, useMultiSelection(), useSelectAll(), useArrowNav(), Object(external_wp_compose_["useRefEffect"])(node => {
    node.tabIndex = -1;

    if (!hasMultiSelection) {
      return;
    }

    node.setAttribute('aria-label', Object(external_wp_i18n_["__"])('Multiple selected blocks'));
    return () => {
      node.removeAttribute('aria-label');
    };
  }, [hasMultiSelection])]), after];
}

function WritingFlow(_ref, forwardedRef) {
  let {
    children,
    ...props
  } = _ref;
  const [before, ref, after] = useWritingFlow();
  return Object(external_wp_element_["createElement"])(external_wp_element_["Fragment"], null, before, Object(external_wp_element_["createElement"])("div", Object(esm_extends["a" /* default */])({}, props, {
    ref: Object(external_wp_compose_["useMergeRefs"])([ref, forwardedRef]),
    className: classnames_default()(props.className, 'block-editor-writing-flow')
  }), children), after);
}
/**
 * Handles selection and navigation across blocks. This component should be
 * wrapped around BlockList.
 *
 * @param {Object}    props          Component properties.
 * @param {WPElement} props.children Children to be rendered.
 */


/* harmony default export */ var writing_flow = __webpack_exports__["a"] = (Object(external_wp_element_["forwardRef"])(WritingFlow));


/***/ }),

/***/ "Tqx9":
/***/ (function(module, exports) {

(function() { module.exports = window["wp"]["primitives"]; }());

/***/ }),

/***/ "U1WI":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export BlockSettingsMenu */
/* harmony import */ var _babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("wx14");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _block_settings_dropdown__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__("1eGn");



/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */


function BlockSettingsMenu(_ref) {
  let {
    clientIds,
    ...props
  } = _ref;
  return Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["ToolbarGroup"], null, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_wordpress_components__WEBPACK_IMPORTED_MODULE_2__["ToolbarItem"], null, toggleProps => Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_1__["createElement"])(_block_settings_dropdown__WEBPACK_IMPORTED_MODULE_3__[/* default */ "a"], Object(_babel_runtime_helpers_esm_extends__WEBPACK_IMPORTED_MODULE_0__[/* default */ "a"])({
    clientIds: clientIds,
    toggleProps: toggleProps
  }, props))));
}
/* harmony default export */ __webpack_exports__["a"] = (BlockSettingsMenu);


/***/ }),

/***/ "VKE3":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("GRId");
/* harmony import */ var _wordpress_element__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__("Tqx9");
/* harmony import */ var _wordpress_primitives__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__);


/**
 * WordPress dependencies
 */

const moreVertical = Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["SVG"], {
  xmlns: "http://www.w3.org/2000/svg",
  viewBox: "0 0 24 24"
}, Object(_wordpress_element__WEBPACK_IMPORTED_MODULE_0__["createElement"])(_wordpress_primitives__WEBPACK_IMPORTED_MODULE_1__["Path"], {
  d: "M13 19h-2v-2h2v2zm0-6h-2v-2h2v2zm0-6h-2V5h2v2z"
}));
/* harmony default export */ __webpack_exports__["a"] = (moreVertical);


/***/ }),

/***/ "VrEk":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__("tI+e");
/* harmony import */ var _wordpress_components__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__);
/**
 * WordPress dependencies
 */

const InspectorControlsDefault = Object(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__["createSlotFill"])('InspectorControls');
const InspectorControlsAdvanced = Object(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__["createSlotFill"])('InspectorAdvancedControls');
const InspectorControlsDimensions = Object(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__["createSlotFill"])('InspectorControlsDimensions');
const InspectorControlsTypography = Object(_wordpress_components__WEBPACK_IMPORTED_MODULE_0__["createSlotFill"])('InspectorControlsTypography');
const groups = {
  default: InspectorControlsDefault,
  advanced: InspectorControlsAdvanced,
  dimensions: InspectorControlsDimensions,
  typography: InspectorControlsTypography
};
/* harmony default export */ __webpack_exports__["a"] = (groups);


/***/ }),

/***/ "VyCT":
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, "b", function() { return /* binding */ IntersectionObserver; });
__webpack_require__.d(__webpack_exports__, "c", function() { return /* binding */ BlockList; });
__webpack_require__.d(__webpack_exports__, "a", function() { return /* binding */ BlockListItems; });

// EXTERNAL MODULE: external ["wp","element"]
var external_wp_element_ = __webpack_require__("GRId");

// EXTERNAL MODULE: ./node_modules/classnames/index.js
var classnames = __webpack_require__("TSYQ");
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);

// EXTERNAL MODULE: external ["wp","data"]
var external_wp_data_ = __webpack_require__("1ZqX");

// EXTERNAL MODULE: external ["wp","compose"]
var external_wp_compose_ = __webpack_require__("K9lf");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list/block.js + 6 modules
var block = __webpack_require__("jBNB");

// EXTERNAL MODULE: external "lodash"
var external_lodash_ = __webpack_require__("YLtl");

// EXTERNAL MODULE: external ["wp","blocks"]
var external_wp_blocks_ = __webpack_require__("HSyU");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/default-block-appender/index.js
var default_block_appender = __webpack_require__("5L8O");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/components/button-block-appender/index.js
var button_block_appender = __webpack_require__("I5Hl");

// EXTERNAL MODULE: ./node_modules/@wordpress/block-editor/build-module/store/index.js + 4 modules
var store = __webpack_require__("BhPs");

// CONCATENATED MODULE: ./node_modules/@wordpress/block-editor/build-module/components/block-list-appender/index.js


/**
 * External dependencies
 */


/**
 * WordPress dependencies
 */



/**
 * Internal dependencies
 */





function BlockListAppender(_ref) {
  let {
    blockClientIds,
    rootClientId,
    canInsertDefaultBlock,
    isLocked,
    renderAppender: CustomAppender,
    className,
    selectedBlockClientId,
    tagName: TagName = 'div'
  } = _ref;

  if (isLocked || CustomAppender === false) {
    return null;
  }

  let appender;

  if (CustomAppender) {
    // Prefer custom render prop if provided.
    appender = Object(external_wp_element_["createElement"])(CustomAppender, null);
  } else {
    const isDocumentAppender = !rootClientId;
    const isParentSelected = selectedBlockClientId === rootClientId;
    const isAnotherDefaultAppenderAlreadyDisplayed = selectedBlockClientId && !blockClientIds.includes(selectedBlockClientId);

    if (!isDocumentAppender && !isParentSelected && (!selectedBlockClientId || isAnotherDefaultAppenderAlreadyDisplayed)) {
      return null;
    }

    if (canInsertDefaultBlock) {
      // Render the default block appender when renderAppender has not been
      // provided and the context supports use of the default appender.
      appender = Object(external_wp_element_["createElement"])(default_block_appender["a" /* default */], {
        rootClientId: rootClientId,
        lastBlockClientId: Object(external_lodash_["last"])(blockClientIds)
      });
    } else {
      // Fallback in the case no renderAppender has been provided and the
      // default block can't be inserted.
      appender = Object(external_wp_element_["createElement"])(button_block_appender["b" /* default */], {
        rootClientId: rootClientId,
        className: "block-list-appender__toggle"
      });
    }
  }

  return Object(external_wp_element_["createElement"])(TagName // A `tabIndex` is used on the wrapping `div` element in order to
  // force a focus event to occur when an appender `button` element
  // is clicked. In some browsers (Firefox, Safari), button clicks do
  // not emit a focus event, which could cause this event to propagate
  // unexpectedly. The `tabIndex` ensures that the interaction is
  // captured as a focus, without also adding an extra tab stop.
  //
  // See: https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#Clicking_and_focus
  , {
    tabIndex: -1,
    className: classnames_default()('block-list-appender wp-block', className) // The appender exists to let you add the first Paragraph before
    // any is inserted. To that end, this appender should visually be
    // presented as a block. That means theme CSS should style it as if
    // it were an empty paragraph block. That means a `wp-block` class to
    // ensure the width is correct, and a [data-block] attribute to ensure
    // the correct margin is applied, especially for classic themes which
    // have commonly targeted that attribute for margins.
    ,
    "data-block": true
  }, appender);
}

/* harmony default e